/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api;

import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.xbill.DNS.Record;
import reactivemongo.api.AuthenticationMode;
import reactivemongo.api.Compressor;
import reactivemongo.api.FailoverStrategy;
import reactivemongo.api.FailoverStrategy$;
import reactivemongo.api.MongoConnection;
import reactivemongo.api.MongoConnection$Compressors$;
import reactivemongo.api.MongoConnection$ParseState$;
import reactivemongo.api.MongoConnection$URIBuilder$;
import reactivemongo.api.MongoConnectionOptions;
import reactivemongo.api.MongoConnectionOptions$;
import reactivemongo.api.MongoConnectionOptions$Credential$;
import reactivemongo.api.MongoConnectionOptions$KeyStore$;
import reactivemongo.api.ReadConcern;
import reactivemongo.api.ReadConcern$;
import reactivemongo.api.ReadPreference;
import reactivemongo.api.ReadPreference$;
import reactivemongo.api.ReadPreference$Primary$;
import reactivemongo.api.ScramSha1Authentication$;
import reactivemongo.api.ScramSha256Authentication$;
import reactivemongo.api.WriteConcern;
import reactivemongo.api.WriteConcern$;
import reactivemongo.api.WriteConcern$Majority$;
import reactivemongo.api.WriteConcern$TagSet$;
import reactivemongo.api.WriteConcern$WaitForAcknowledgments$;
import reactivemongo.api.X509Authentication$;
import reactivemongo.util.LazyLogger;
import reactivemongo.util.LazyLogger$;
import reactivemongo.util.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class MongoConnection$ {
    public static final MongoConnection$ MODULE$ = new MongoConnection$();
    private static final String DefaultHost = "localhost";
    private static final int DefaultPort = 27017;
    private static final LazyLogger.LazyLogger logger = LazyLogger$.MODULE$.apply("reactivemongo.api.MongoConnection");
    private static final Regex UnsignedInt = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([0-9]+)$"));
    private static final Regex IntRe = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([-]?[0-9]+)$"));
    private static final Regex FailoverRe = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([^:]+):([0-9]+)x([0-9.]+)$"));

    public String DefaultHost() {
        return DefaultHost;
    }

    public int DefaultPort() {
        return DefaultPort;
    }

    public LazyLogger.LazyLogger logger() {
        return logger;
    }

    public Future<MongoConnection.URI<Option<String>>> fromString(String uri, ExecutionContext ec) {
        return this.parse(uri, package$.MODULE$.dnsResolve(package$.MODULE$.dnsResolve$default$1(), package$.MODULE$.dnsResolve$default$2()), package$.MODULE$.txtRecords(package$.MODULE$.txtRecords$default$1(), ec), ec, MongoConnection$URIBuilder$.MODULE$.default());
    }

    public Future<MongoConnection.URI<String>> fromStringWithDB(String uri, ExecutionContext ec) {
        return this.parse(uri, package$.MODULE$.dnsResolve(package$.MODULE$.dnsResolve$default$1(), package$.MODULE$.dnsResolve$default$2()), package$.MODULE$.txtRecords(package$.MODULE$.txtRecords$default$1(), ec), ec, MongoConnection$URIBuilder$.MODULE$.requiredDB());
    }

    public <T> Future<MongoConnection.URI<T>> parse(String uri, Function1<ExecutionContext, Function1<String, Future<Record[]>>> srvRecResolver, Function1<String, Future<ListSet<String>>> txtResolver, ExecutionContext ec, MongoConnection.URIBuilder<T> uriBuilder) {
        boolean seedList = uri.startsWith("mongodb+srv://");
        Function4 & Serializable createUri = (Function4 & Serializable)(hosts, options, ignoredOptions, db) -> uriBuilder.apply((ListSet<Tuple2<String, Object>>)hosts, (MongoConnectionOptions)options, (List<String>)ignoredOptions, (Option<String>)db).recoverWith((PartialFunction)new Serializable(uri){
            private static final long serialVersionUID = 0L;
            private final String uri$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IllegalArgumentException) {
                    IllegalArgumentException illegalArgumentException = (IllegalArgumentException)A1;
                    object = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(2).append(illegalArgumentException.getMessage()).append(": ").append(this.uri$1).toString()));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof IllegalArgumentException;
                return bl;
            }
            {
                this.uri$1 = uri$1;
            }
        }, ec);
        return (uri.startsWith("mongodb://") ? Future$.MODULE$.successful((Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(uri), 10)) : (seedList ? Future$.MODULE$.successful((Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(uri), 14)) : Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(16).append("Invalid scheme: ").append(uri).toString())))).map((Function1 & Serializable)useful -> {
            String setSpec = StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(useful), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parse$3(BoxesRunTime.unboxToChar((Object)x$4))));
            int credentialEnd = setSpec.indexOf("@");
            return new Tuple3(useful, (Object)setSpec, (Object)BoxesRunTime.boxToInteger((int)credentialEnd));
        }, ec).flatMap((Function1 & Serializable)x$8 -> {
            MongoConnectionOptions mongoConnectionOptions;
            int credentialEnd;
            String setSpec;
            String useful;
            Tuple3 tuple3 = x$8;
            if (tuple3 != null) {
                useful = (String)tuple3._1();
                setSpec = (String)tuple3._2();
                credentialEnd = BoxesRunTime.unboxToInt((Object)tuple3._3());
                MongoConnectionOptions empty = MongoConnectionOptions$.MODULE$.default();
                if (!seedList) {
                    mongoConnectionOptions = empty;
                } else {
                    boolean x$1 = true;
                    int x$2 = empty.copy$default$1();
                    Option<String> x$3 = empty.copy$default$2();
                    boolean x$4 = empty.copy$default$4();
                    AuthenticationMode x$5 = empty.copy$default$5();
                    boolean x$6 = empty.copy$default$6();
                    boolean x$72 = empty.copy$default$7();
                    int x$82 = empty.copy$default$8();
                    Option<Object> x$9 = empty.copy$default$9();
                    int x$10 = empty.copy$default$10();
                    int x$11 = empty.copy$default$11();
                    WriteConcern x$12 = empty.copy$default$12();
                    ReadPreference x$13 = empty.copy$default$13();
                    FailoverStrategy x$14 = empty.copy$default$14();
                    int x$15 = empty.copy$default$15();
                    int x$16 = empty.copy$default$16();
                    int x$17 = empty.copy$default$17();
                    scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$18 = empty.copy$default$18();
                    Option<MongoConnectionOptions.KeyStore> x$19 = empty.copy$default$19();
                    ReadConcern x$20 = empty.copy$default$20();
                    Option<String> x$21 = empty.copy$default$21();
                    mongoConnectionOptions = empty.copy(x$2, x$3, true, x$4, x$5, x$6, x$72, x$82, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
                }
            } else {
                throw new MatchError((Object)tuple3);
            }
            MongoConnectionOptions initial = mongoConnectionOptions;
            Future future = MongoConnection$.txtOptions$1(seedList, setSpec, credentialEnd, txtResolver, ec).flatMap((Function1 & Serializable)txt -> MODULE$.parseOptions(MongoConnection$.optionStr$1(useful, setSpec)).map((Function1 & Serializable)os -> {
                Tuple2<List<String>, MongoConnectionOptions> opts = MODULE$.makeOptions((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)txt.$plus$plus((IterableOnce)os)), initial);
                return new Tuple2(os, opts);
            }, ec).flatMap((Function1 & Serializable)x$6 -> {
                Tuple2 tuple2 = x$6;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 opts = (Tuple2)tuple2._2();
                Future future = (((MongoConnectionOptions)opts._2()).maxIdleTimeMS() != 0 && ((MongoConnectionOptions)opts._2()).maxIdleTimeMS() < ((MongoConnectionOptions)opts._2()).heartbeatFrequencyMS() ? Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(61).append("Invalid URI options: maxIdleTimeMS(").append(((MongoConnectionOptions)opts._2()).maxIdleTimeMS()).append(") < heartbeatFrequencyMS(").append(((MongoConnectionOptions)opts._2()).heartbeatFrequencyMS()).append(")").toString())) : Future$.MODULE$.successful((Object)opts)).map((Function1 & Serializable)res -> res, ec);
                return future;
            }, ec), ec).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parse$15(check$ifrefutable$1)), ec).flatMap((Function1 & Serializable)x$7 -> {
                Future future;
                Tuple2 tuple2 = x$7;
                if (tuple2 != null) {
                    List unsupportedKeys = (List)tuple2._1();
                    MongoConnectionOptions options = (MongoConnectionOptions)tuple2._2();
                    if (credentialEnd == -1) {
                        future = MODULE$.parseHostsAndDB(seedList, setSpec, srvRecResolver, ec).flatMap((Function1 & Serializable)x0$1 -> {
                            Future future;
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 != null) {
                                Option db = (Option)tuple2._1();
                                ListSet hosts = (ListSet)tuple2._2();
                                AuthenticationMode authenticationMode = options.authenticationMechanism();
                                if (X509Authentication$.MODULE$.equals(authenticationMode)) {
                                    Future future2;
                                    Option option = db;
                                    if (option instanceof Some) {
                                        Some some = (Some)option;
                                        String dbName = (String)some.value();
                                        scala.collection.immutable.Map x$22 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)dbName), (Object)MongoConnectionOptions$Credential$.MODULE$.apply("", (Option<String>)None$.MODULE$))}));
                                        int x$23 = options.copy$default$1();
                                        Option<String> x$24 = options.copy$default$2();
                                        boolean x$25 = options.copy$default$3();
                                        boolean x$26 = options.copy$default$4();
                                        AuthenticationMode x$27 = options.copy$default$5();
                                        boolean x$28 = options.copy$default$6();
                                        boolean x$29 = options.copy$default$7();
                                        int x$30 = options.copy$default$8();
                                        Option<Object> x$31 = options.copy$default$9();
                                        int x$32 = options.copy$default$10();
                                        int x$33 = options.copy$default$11();
                                        WriteConcern x$34 = options.copy$default$12();
                                        ReadPreference x$35 = options.copy$default$13();
                                        FailoverStrategy x$36 = options.copy$default$14();
                                        int x$37 = options.copy$default$15();
                                        int x$38 = options.copy$default$16();
                                        int x$39 = options.copy$default$17();
                                        Option<MongoConnectionOptions.KeyStore> x$40 = options.copy$default$19();
                                        ReadConcern x$41 = options.copy$default$20();
                                        Option<String> x$42 = options.copy$default$21();
                                        MongoConnectionOptions optsWithX509 = options.copy(x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, (scala.collection.immutable.Map<String, MongoConnectionOptions.Credential>)x$22, x$40, x$41, x$42);
                                        future2 = (Future)createUri.apply((Object)hosts, (Object)optsWithX509, (Object)unsupportedKeys, (Object)db);
                                    } else {
                                        future2 = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(84).append("Could not parse URI '").append(uri).append("': authentication information found but no database name in URI").toString()));
                                    }
                                    future = future2;
                                } else {
                                    future = (Future)createUri.apply((Object)hosts, (Object)options, (Object)unsupportedKeys, (Object)db);
                                }
                            } else {
                                throw new MatchError((Object)tuple2);
                            }
                            Future future3 = future;
                            return future3;
                        }, ec);
                    } else {
                        Future future2;
                        Option option;
                        Regex WithAuth = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([^:]+)(|:[^@]*)@(.+)"));
                        String string = setSpec;
                        if (string != null && !(option = WithAuth.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(3) == 0) {
                            String user = (String)((LinearSeqOps)option.get()).apply(0);
                            String p = (String)((LinearSeqOps)option.get()).apply(1);
                            String hostsPortsAndDB = (String)((LinearSeqOps)option.get()).apply(2);
                            String pass = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(p), ":");
                            future2 = MODULE$.parseHostsAndDB(seedList, hostsPortsAndDB, srvRecResolver, ec).flatMap((Function1 & Serializable)x0$2 -> {
                                Future future;
                                Tuple2 tuple2 = x0$2;
                                if (tuple2 == null) return Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(84).append("Could not parse URI '").append(uri).append("': authentication information found but no database name in URI").toString()));
                                Option option = (Option)tuple2._1();
                                ListSet hosts = (ListSet)tuple2._2();
                                if (!(option instanceof Some)) return Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(84).append("Could not parse URI '").append(uri).append("': authentication information found but no database name in URI").toString()));
                                Some some = (Some)option;
                                String database = (String)some.value();
                                AuthenticationMode authenticationMode = options.authenticationMechanism();
                                X509Authentication$ x509Authentication$ = X509Authentication$.MODULE$;
                                if (!(authenticationMode != null ? !authenticationMode.equals(x509Authentication$) : x509Authentication$ != null) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(pass))) {
                                    future = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException("You should not provide a password when authenticating with X509 authentication"));
                                    return future;
                                } else {
                                    AuthenticationMode authenticationMode2 = options.authenticationMechanism();
                                    X509Authentication$ x509Authentication$2 = X509Authentication$.MODULE$;
                                    Option password = (authenticationMode2 == null ? x509Authentication$2 != null : !authenticationMode2.equals(x509Authentication$2)) ? Option$.MODULE$.apply((Object)pass) : Option$.MODULE$.empty();
                                    String authDb = (String)options.authenticationDatabase().getOrElse((Function0 & Serializable)() -> database);
                                    scala.collection.immutable.Map x$43 = (scala.collection.immutable.Map)options.credentials().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)authDb), (Object)MongoConnectionOptions$Credential$.MODULE$.apply(user, (Option<String>)password)));
                                    int x$44 = options.copy$default$1();
                                    Option<String> x$45 = options.copy$default$2();
                                    boolean x$46 = options.copy$default$3();
                                    boolean x$47 = options.copy$default$4();
                                    AuthenticationMode x$48 = options.copy$default$5();
                                    boolean x$49 = options.copy$default$6();
                                    boolean x$50 = options.copy$default$7();
                                    int x$51 = options.copy$default$8();
                                    Option<Object> x$52 = options.copy$default$9();
                                    int x$53 = options.copy$default$10();
                                    int x$54 = options.copy$default$11();
                                    WriteConcern x$55 = options.copy$default$12();
                                    ReadPreference x$56 = options.copy$default$13();
                                    FailoverStrategy x$57 = options.copy$default$14();
                                    int x$58 = options.copy$default$15();
                                    int x$59 = options.copy$default$16();
                                    int x$60 = options.copy$default$17();
                                    Option<MongoConnectionOptions.KeyStore> x$61 = options.copy$default$19();
                                    ReadConcern x$62 = options.copy$default$20();
                                    Option<String> x$63 = options.copy$default$21();
                                    MongoConnectionOptions optsWithCred = options.copy(x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60, (scala.collection.immutable.Map<String, MongoConnectionOptions.Credential>)x$43, x$61, x$62, x$63);
                                    future = (Future)createUri.apply((Object)hosts, (Object)optsWithCred, (Object)unsupportedKeys, (Object)new Some((Object)database));
                                }
                                return future;
                            }, ec);
                        } else {
                            future2 = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(22).append("Could not parse URI '").append(uri).append("'").toString()));
                        }
                        future = future2;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Future future3 = future.map((Function1 & Serializable)parsedUri -> parsedUri, ec);
                return future3;
            }, ec);
            return future;
        }, ec);
    }

    private Future<ListSet<Tuple2<String, Object>>> parseHosts(boolean seedList, String hosts, Function1<ExecutionContext, Function1<String, Future<Record[]>>> srvRecResolver, ExecutionContext ec) {
        Future future;
        if (seedList) {
            future = ((Future)Await$.MODULE$.ready(package$.MODULE$.srvRecords(hosts, srvRecResolver, ec), (Duration)package$.MODULE$.dnsTimeout())).map((Function1 & Serializable)x$9 -> (ListSet)ListSet$.MODULE$.empty().$plus$plus((IterableOnce)x$9), ec);
        } else {
            Builder buf = ListSet$.MODULE$.newBuilder();
            future = this.parse$1((Iterable)Predef$.MODULE$.wrapRefArray((Object[])hosts.split(",")), buf);
        }
        return future;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<Tuple2<Option<String>, ListSet<Tuple2<String, Object>>>> parseHostsAndDB(boolean seedList, String input, Function1<ExecutionContext, Function1<String, Future<Record[]>>> srvRecResolver, ExecutionContext ec) {
        Tuple2 tuple2 = StringOps$.MODULE$.span$extension(Predef$.MODULE$.augmentString(input), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parseHostsAndDB$1(BoxesRunTime.unboxToChar((Object)x$11))));
        if (tuple2 != null) {
            String hosts = (String)tuple2._1();
            String string = (String)tuple2._2();
            if ("".equals(string)) {
                return this.parseHosts(seedList, hosts, srvRecResolver, ec).map((Function1 & Serializable)x$12 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), x$12), ec);
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String hosts = (String)tuple2._1();
        String dbName = (String)tuple2._2();
        return this.parseHosts(seedList, hosts, srvRecResolver, ec).map((Function1 & Serializable)x$13 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(dbName), 1))), x$13), ec);
    }

    private Future<scala.collection.immutable.Map<String, String>> parseOptions(String options) {
        Future future;
        if (options.isEmpty()) {
            future = Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().empty());
        } else {
            Map buf = (Map)Map$.MODULE$.empty();
            future = this.parse$2((Iterable)Predef$.MODULE$.wrapRefArray((Object[])options.split("&")), options, buf);
        }
        return future;
    }

    private Regex UnsignedInt() {
        return UnsignedInt;
    }

    private Regex IntRe() {
        return IntRe;
    }

    private Regex FailoverRe() {
        return FailoverRe;
    }

    private Tuple2<List<String>, MongoConnectionOptions> makeOptions(scala.collection.immutable.Map<String, String> opts, MongoConnectionOptions initial) {
        MongoConnection.ParseState parsed1 = (MongoConnection.ParseState)opts.iterator().foldLeft((Object)new MongoConnection.ParseState(initial, MongoConnection$ParseState$.MODULE$.apply$default$2()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                String string;
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null && "replicaSet".equals(string = (String)tuple22._1())) {
                    MODULE$.logger().info((Function0<String>)(Function0 & Serializable)() -> "Connection option 'replicaSet' is ignored: determined from servers response");
                    return state;
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple23 != null) {
                    String string = (String)tuple23._1();
                    String string2 = (String)tuple23._2();
                    if ("authenticationMechanism".equals(string) && "x509".equals(string2)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$15 -> {
                            X509Authentication$ x$1 = X509Authentication$.MODULE$;
                            int x$2 = x$15.copy$default$1();
                            Option<String> x$3 = x$15.copy$default$2();
                            boolean x$4 = x$15.copy$default$3();
                            boolean x$5 = x$15.copy$default$4();
                            boolean x$6 = x$15.copy$default$6();
                            boolean x$7 = x$15.copy$default$7();
                            int x$8 = x$15.copy$default$8();
                            Option<Object> x$9 = x$15.copy$default$9();
                            int x$10 = x$15.copy$default$10();
                            int x$11 = x$15.copy$default$11();
                            WriteConcern x$12 = x$15.copy$default$12();
                            ReadPreference x$13 = x$15.copy$default$13();
                            FailoverStrategy x$14 = x$15.copy$default$14();
                            int x$152 = x$15.copy$default$15();
                            int x$16 = x$15.copy$default$16();
                            int x$17 = x$15.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$18 = x$15.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$19 = x$15.copy$default$19();
                            ReadConcern x$20 = x$15.copy$default$20();
                            Option<String> x$21 = x$15.copy$default$21();
                            return x$15.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$152, x$16, x$17, x$18, x$19, x$20, x$21);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple24 = (Tuple2)tuple2._2();
                if (tuple24 != null) {
                    String string = (String)tuple24._1();
                    String string3 = (String)tuple24._2();
                    if ("authenticationMechanism".equals(string) && "scram-sha256".equals(string3)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$16 -> {
                            ScramSha256Authentication$ x$22 = ScramSha256Authentication$.MODULE$;
                            int x$23 = x$16.copy$default$1();
                            Option<String> x$24 = x$16.copy$default$2();
                            boolean x$25 = x$16.copy$default$3();
                            boolean x$26 = x$16.copy$default$4();
                            boolean x$27 = x$16.copy$default$6();
                            boolean x$28 = x$16.copy$default$7();
                            int x$29 = x$16.copy$default$8();
                            Option<Object> x$30 = x$16.copy$default$9();
                            int x$31 = x$16.copy$default$10();
                            int x$32 = x$16.copy$default$11();
                            WriteConcern x$33 = x$16.copy$default$12();
                            ReadPreference x$34 = x$16.copy$default$13();
                            FailoverStrategy x$35 = x$16.copy$default$14();
                            int x$36 = x$16.copy$default$15();
                            int x$37 = x$16.copy$default$16();
                            int x$38 = x$16.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$39 = x$16.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$40 = x$16.copy$default$19();
                            ReadConcern x$41 = x$16.copy$default$20();
                            Option<String> x$42 = x$16.copy$default$21();
                            return x$16.copy(x$23, x$24, x$25, x$26, x$22, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                String string;
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple25 = (Tuple2)tuple2._2();
                if (tuple25 != null && "authenticationMechanism".equals(string = (String)tuple25._1())) {
                    return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$17 -> {
                        ScramSha1Authentication$ x$43 = ScramSha1Authentication$.MODULE$;
                        int x$44 = x$17.copy$default$1();
                        Option<String> x$45 = x$17.copy$default$2();
                        boolean x$46 = x$17.copy$default$3();
                        boolean x$47 = x$17.copy$default$4();
                        boolean x$48 = x$17.copy$default$6();
                        boolean x$49 = x$17.copy$default$7();
                        int x$50 = x$17.copy$default$8();
                        Option<Object> x$51 = x$17.copy$default$9();
                        int x$52 = x$17.copy$default$10();
                        int x$53 = x$17.copy$default$11();
                        WriteConcern x$54 = x$17.copy$default$12();
                        ReadPreference x$55 = x$17.copy$default$13();
                        FailoverStrategy x$56 = x$17.copy$default$14();
                        int x$57 = x$17.copy$default$15();
                        int x$58 = x$17.copy$default$16();
                        int x$59 = x$17.copy$default$17();
                        scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$60 = x$17.copy$default$18();
                        Option<MongoConnectionOptions.KeyStore> x$61 = x$17.copy$default$19();
                        ReadConcern x$62 = x$17.copy$default$20();
                        Option<String> x$63 = x$17.copy$default$21();
                        return x$17.copy(x$44, x$45, x$46, x$47, x$43, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63);
                    });
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple26 = (Tuple2)tuple2._2();
                if (tuple26 != null) {
                    String n = (String)tuple26._1();
                    String v2 = (String)tuple26._2();
                    boolean bl = "authenticationDatabase".equals(n) ? true : "authSource".equals(n);
                    if (bl) {
                        this.deprecated$1(n, "authenticationDatabase");
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$18 -> {
                            Some x$64 = new Some((Object)v2);
                            int x$65 = x$18.copy$default$1();
                            boolean x$66 = x$18.copy$default$3();
                            boolean x$67 = x$18.copy$default$4();
                            AuthenticationMode x$68 = x$18.copy$default$5();
                            boolean x$69 = x$18.copy$default$6();
                            boolean x$70 = x$18.copy$default$7();
                            int x$71 = x$18.copy$default$8();
                            Option<Object> x$72 = x$18.copy$default$9();
                            int x$73 = x$18.copy$default$10();
                            int x$74 = x$18.copy$default$11();
                            WriteConcern x$75 = x$18.copy$default$12();
                            ReadPreference x$76 = x$18.copy$default$13();
                            FailoverStrategy x$77 = x$18.copy$default$14();
                            int x$78 = x$18.copy$default$15();
                            int x$79 = x$18.copy$default$16();
                            int x$80 = x$18.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$81 = x$18.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$82 = x$18.copy$default$19();
                            ReadConcern x$83 = x$18.copy$default$20();
                            Option<String> x$84 = x$18.copy$default$21();
                            return x$18.copy(x$65, (Option<String>)x$64, x$66, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$80, x$81, x$82, x$83, x$84);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple27 = (Tuple2)tuple2._2();
                if (tuple27 != null) {
                    String string = (String)tuple27._1();
                    String v3 = (String)tuple27._2();
                    if ("connectTimeoutMS".equals(string)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$19 -> x$19.copy(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(v3)), x$19.copy$default$2(), x$19.copy$default$3(), x$19.copy$default$4(), x$19.copy$default$5(), x$19.copy$default$6(), x$19.copy$default$7(), x$19.copy$default$8(), x$19.copy$default$9(), x$19.copy$default$10(), x$19.copy$default$11(), x$19.copy$default$12(), x$19.copy$default$13(), x$19.copy$default$14(), x$19.copy$default$15(), x$19.copy$default$16(), x$19.copy$default$17(), x$19.copy$default$18(), x$19.copy$default$19(), x$19.copy$default$20(), x$19.copy$default$21()));
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple28 = (Tuple2)tuple2._2();
                if (tuple28 != null) {
                    String string = (String)tuple28._1();
                    String v4 = (String)tuple28._2();
                    if ("maxIdleTimeMS".equals(string)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$20 -> {
                            int x$85 = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(v4));
                            int x$86 = x$20.copy$default$1();
                            Option<String> x$87 = x$20.copy$default$2();
                            boolean x$88 = x$20.copy$default$3();
                            boolean x$89 = x$20.copy$default$4();
                            AuthenticationMode x$90 = x$20.copy$default$5();
                            boolean x$91 = x$20.copy$default$6();
                            boolean x$92 = x$20.copy$default$7();
                            int x$93 = x$20.copy$default$8();
                            Option<Object> x$94 = x$20.copy$default$9();
                            int x$95 = x$20.copy$default$10();
                            int x$96 = x$20.copy$default$11();
                            WriteConcern x$97 = x$20.copy$default$12();
                            ReadPreference x$98 = x$20.copy$default$13();
                            FailoverStrategy x$99 = x$20.copy$default$14();
                            int x$100 = x$20.copy$default$15();
                            int x$101 = x$20.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$102 = x$20.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$103 = x$20.copy$default$19();
                            ReadConcern x$104 = x$20.copy$default$20();
                            Option<String> x$105 = x$20.copy$default$21();
                            return x$20.copy(x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100, x$85, x$101, x$102, x$103, x$104, x$105);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple29 = (Tuple2)tuple2._2();
                if (tuple29 != null) {
                    String string = (String)tuple29._1();
                    String v5 = (String)tuple29._2();
                    if ("ssl".equals(string)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$21 -> {
                            boolean x$106 = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(v5));
                            int x$107 = x$21.copy$default$1();
                            Option<String> x$108 = x$21.copy$default$2();
                            boolean x$109 = x$21.copy$default$4();
                            AuthenticationMode x$110 = x$21.copy$default$5();
                            boolean x$111 = x$21.copy$default$6();
                            boolean x$112 = x$21.copy$default$7();
                            int x$113 = x$21.copy$default$8();
                            Option<Object> x$114 = x$21.copy$default$9();
                            int x$115 = x$21.copy$default$10();
                            int x$116 = x$21.copy$default$11();
                            WriteConcern x$117 = x$21.copy$default$12();
                            ReadPreference x$118 = x$21.copy$default$13();
                            FailoverStrategy x$119 = x$21.copy$default$14();
                            int x$120 = x$21.copy$default$15();
                            int x$121 = x$21.copy$default$16();
                            int x$122 = x$21.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$123 = x$21.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$124 = x$21.copy$default$19();
                            ReadConcern x$125 = x$21.copy$default$20();
                            Option<String> x$126 = x$21.copy$default$21();
                            return x$21.copy(x$107, x$108, x$106, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$119, x$120, x$121, x$122, x$123, x$124, x$125, x$126);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple210 = (Tuple2)tuple2._2();
                if (tuple210 != null) {
                    String string = (String)tuple210._1();
                    String v6 = (String)tuple210._2();
                    if ("sslAllowsInvalidCert".equals(string)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$22 -> {
                            boolean x$127 = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(v6));
                            int x$128 = x$22.copy$default$1();
                            Option<String> x$129 = x$22.copy$default$2();
                            boolean x$130 = x$22.copy$default$3();
                            AuthenticationMode x$131 = x$22.copy$default$5();
                            boolean x$132 = x$22.copy$default$6();
                            boolean x$133 = x$22.copy$default$7();
                            int x$134 = x$22.copy$default$8();
                            Option<Object> x$135 = x$22.copy$default$9();
                            int x$136 = x$22.copy$default$10();
                            int x$137 = x$22.copy$default$11();
                            WriteConcern x$138 = x$22.copy$default$12();
                            ReadPreference x$139 = x$22.copy$default$13();
                            FailoverStrategy x$140 = x$22.copy$default$14();
                            int x$141 = x$22.copy$default$15();
                            int x$142 = x$22.copy$default$16();
                            int x$143 = x$22.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$144 = x$22.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$145 = x$22.copy$default$19();
                            ReadConcern x$146 = x$22.copy$default$20();
                            Option<String> x$147 = x$22.copy$default$21();
                            return x$22.copy(x$128, x$129, x$130, x$127, x$131, x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$139, x$140, x$141, x$142, x$143, x$144, x$145, x$146, x$147);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple211 = (Tuple2)tuple2._2();
                if (tuple211 != null) {
                    Option<Tuple2<ListSet<Compressor>, Seq<String>>> option;
                    String string = (String)tuple211._1();
                    String string4 = (String)tuple211._2();
                    if ("compressors".equals(string) && string4 != null && !(option = MongoConnection$Compressors$.MODULE$.unapply(string4)).isEmpty()) {
                        ListSet compressors = (ListSet)((Tuple2)option.get())._1();
                        Seq invalid = (Seq)((Tuple2)option.get())._2();
                        return ((MongoConnection.ParseState)invalid.foldLeft((Object)state, (Function2 & Serializable)(st, c) -> st.reject((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compressors"), c)))).updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$23 -> x$23.withCompressors((ListSet<Compressor>)compressors));
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple212 = (Tuple2)tuple2._2();
                if (tuple212 != null) {
                    String string = (String)tuple212._1();
                    String v7 = (String)tuple212._2();
                    if ("rm.tcpNoDelay".equals(string)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$24 -> {
                            boolean x$148 = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(v7));
                            int x$149 = x$24.copy$default$1();
                            Option<String> x$150 = x$24.copy$default$2();
                            boolean x$151 = x$24.copy$default$3();
                            boolean x$152 = x$24.copy$default$4();
                            AuthenticationMode x$153 = x$24.copy$default$5();
                            boolean x$154 = x$24.copy$default$7();
                            int x$155 = x$24.copy$default$8();
                            Option<Object> x$156 = x$24.copy$default$9();
                            int x$157 = x$24.copy$default$10();
                            int x$158 = x$24.copy$default$11();
                            WriteConcern x$159 = x$24.copy$default$12();
                            ReadPreference x$160 = x$24.copy$default$13();
                            FailoverStrategy x$161 = x$24.copy$default$14();
                            int x$162 = x$24.copy$default$15();
                            int x$163 = x$24.copy$default$16();
                            int x$164 = x$24.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$165 = x$24.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$166 = x$24.copy$default$19();
                            ReadConcern x$167 = x$24.copy$default$20();
                            Option<String> x$168 = x$24.copy$default$21();
                            return x$24.copy(x$149, x$150, x$151, x$152, x$153, x$148, x$154, x$155, x$156, x$157, x$158, x$159, x$160, x$161, x$162, x$163, x$164, x$165, x$166, x$167, x$168);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple213 = (Tuple2)tuple2._2();
                if (tuple213 != null) {
                    String string = (String)tuple213._1();
                    String v8 = (String)tuple213._2();
                    if ("rm.keepAlive".equals(string)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$25 -> {
                            boolean x$169 = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(v8));
                            int x$170 = x$25.copy$default$1();
                            Option<String> x$171 = x$25.copy$default$2();
                            boolean x$172 = x$25.copy$default$3();
                            boolean x$173 = x$25.copy$default$4();
                            AuthenticationMode x$174 = x$25.copy$default$5();
                            boolean x$175 = x$25.copy$default$6();
                            int x$176 = x$25.copy$default$8();
                            Option<Object> x$177 = x$25.copy$default$9();
                            int x$178 = x$25.copy$default$10();
                            int x$179 = x$25.copy$default$11();
                            WriteConcern x$180 = x$25.copy$default$12();
                            ReadPreference x$181 = x$25.copy$default$13();
                            FailoverStrategy x$182 = x$25.copy$default$14();
                            int x$183 = x$25.copy$default$15();
                            int x$184 = x$25.copy$default$16();
                            int x$185 = x$25.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$186 = x$25.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$187 = x$25.copy$default$19();
                            ReadConcern x$188 = x$25.copy$default$20();
                            Option<String> x$189 = x$25.copy$default$21();
                            return x$25.copy(x$170, x$171, x$172, x$173, x$174, x$175, x$169, x$176, x$177, x$178, x$179, x$180, x$181, x$182, x$183, x$184, x$185, x$186, x$187, x$188, x$189);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple214 = (Tuple2)tuple2._2();
                if (tuple214 != null) {
                    String string = (String)tuple214._1();
                    String v9 = (String)tuple214._2();
                    if ("rm.nbChannelsPerNode".equals(string)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$26 -> {
                            int x$190 = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(v9));
                            int x$191 = x$26.copy$default$1();
                            Option<String> x$192 = x$26.copy$default$2();
                            boolean x$193 = x$26.copy$default$3();
                            boolean x$194 = x$26.copy$default$4();
                            AuthenticationMode x$195 = x$26.copy$default$5();
                            boolean x$196 = x$26.copy$default$6();
                            boolean x$197 = x$26.copy$default$7();
                            Option<Object> x$198 = x$26.copy$default$9();
                            int x$199 = x$26.copy$default$10();
                            int x$200 = x$26.copy$default$11();
                            WriteConcern x$201 = x$26.copy$default$12();
                            ReadPreference x$202 = x$26.copy$default$13();
                            FailoverStrategy x$203 = x$26.copy$default$14();
                            int x$204 = x$26.copy$default$15();
                            int x$205 = x$26.copy$default$16();
                            int x$206 = x$26.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$207 = x$26.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$208 = x$26.copy$default$19();
                            ReadConcern x$209 = x$26.copy$default$20();
                            Option<String> x$210 = x$26.copy$default$21();
                            return x$26.copy(x$191, x$192, x$193, x$194, x$195, x$196, x$197, x$190, x$198, x$199, x$200, x$201, x$202, x$203, x$204, x$205, x$206, x$207, x$208, x$209, x$210);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple215 = (Tuple2)tuple2._2();
                if (tuple215 != null) {
                    Option option;
                    String string = (String)tuple215._1();
                    String string5 = (String)tuple215._2();
                    if ("rm.maxInFlightRequestsPerChannel".equals(string) && string5 != null && !(option = MODULE$.UnsignedInt().unapplySeq((CharSequence)string5)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                        String max = (String)((LinearSeqOps)option.get()).apply(0);
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$27 -> {
                            Some x$211 = new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(max))));
                            int x$212 = x$27.copy$default$1();
                            Option<String> x$213 = x$27.copy$default$2();
                            boolean x$214 = x$27.copy$default$3();
                            boolean x$215 = x$27.copy$default$4();
                            AuthenticationMode x$216 = x$27.copy$default$5();
                            boolean x$217 = x$27.copy$default$6();
                            boolean x$218 = x$27.copy$default$7();
                            int x$219 = x$27.copy$default$8();
                            int x$220 = x$27.copy$default$10();
                            int x$221 = x$27.copy$default$11();
                            WriteConcern x$222 = x$27.copy$default$12();
                            ReadPreference x$223 = x$27.copy$default$13();
                            FailoverStrategy x$224 = x$27.copy$default$14();
                            int x$225 = x$27.copy$default$15();
                            int x$226 = x$27.copy$default$16();
                            int x$227 = x$27.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$228 = x$27.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$229 = x$27.copy$default$19();
                            ReadConcern x$230 = x$27.copy$default$20();
                            Option<String> x$231 = x$27.copy$default$21();
                            return x$27.copy(x$212, x$213, x$214, x$215, x$216, x$217, x$218, x$219, (Option<Object>)x$211, x$220, x$221, x$222, x$223, x$224, x$225, x$226, x$227, x$228, x$229, x$230, x$231);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple216 = (Tuple2)tuple2._2();
                if (tuple216 != null) {
                    Option option;
                    String string = (String)tuple216._1();
                    String string6 = (String)tuple216._2();
                    if ("rm.minIdleChannelsPerNode".equals(string) && string6 != null && !(option = MODULE$.UnsignedInt().unapplySeq((CharSequence)string6)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                        String min = (String)((LinearSeqOps)option.get()).apply(0);
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$28 -> {
                            int x$232 = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(min));
                            int x$233 = x$28.copy$default$1();
                            Option<String> x$234 = x$28.copy$default$2();
                            boolean x$235 = x$28.copy$default$3();
                            boolean x$236 = x$28.copy$default$4();
                            AuthenticationMode x$237 = x$28.copy$default$5();
                            boolean x$238 = x$28.copy$default$6();
                            boolean x$239 = x$28.copy$default$7();
                            int x$240 = x$28.copy$default$8();
                            Option<Object> x$241 = x$28.copy$default$9();
                            int x$242 = x$28.copy$default$11();
                            WriteConcern x$243 = x$28.copy$default$12();
                            ReadPreference x$244 = x$28.copy$default$13();
                            FailoverStrategy x$245 = x$28.copy$default$14();
                            int x$246 = x$28.copy$default$15();
                            int x$247 = x$28.copy$default$16();
                            int x$248 = x$28.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$249 = x$28.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$250 = x$28.copy$default$19();
                            ReadConcern x$251 = x$28.copy$default$20();
                            Option<String> x$252 = x$28.copy$default$21();
                            return x$28.copy(x$233, x$234, x$235, x$236, x$237, x$238, x$239, x$240, x$241, x$232, x$242, x$243, x$244, x$245, x$246, x$247, x$248, x$249, x$250, x$251, x$252);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple217 = (Tuple2)tuple2._2();
                if (tuple217 != null) {
                    Option option;
                    String string = (String)tuple217._1();
                    String string7 = (String)tuple217._2();
                    if ("rm.maxNonQueryableHeartbeats".equals(string) && string7 != null && !(option = MODULE$.UnsignedInt().unapplySeq((CharSequence)string7)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                        String max;
                        String string8 = max = (String)((LinearSeqOps)option.get()).apply(0);
                        String string9 = "0";
                        if (string8 == null ? string9 != null : !string8.equals(string9)) {
                            return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$29 -> x$29.withMaxNonQueryableHeartbeats(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(max))));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple218 = (Tuple2)tuple2._2();
                if (tuple218 != null) {
                    String string = (String)tuple218._1();
                    String string10 = (String)tuple218._2();
                    if ("writeConcern".equals(string) && "unacknowledged".equals(string10)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$30 -> {
                            WriteConcern x$253 = WriteConcern$.MODULE$.Unacknowledged();
                            int x$254 = x$30.copy$default$1();
                            Option<String> x$255 = x$30.copy$default$2();
                            boolean x$256 = x$30.copy$default$3();
                            boolean x$257 = x$30.copy$default$4();
                            AuthenticationMode x$258 = x$30.copy$default$5();
                            boolean x$259 = x$30.copy$default$6();
                            boolean x$260 = x$30.copy$default$7();
                            int x$261 = x$30.copy$default$8();
                            Option<Object> x$262 = x$30.copy$default$9();
                            int x$263 = x$30.copy$default$10();
                            int x$264 = x$30.copy$default$11();
                            ReadPreference x$265 = x$30.copy$default$13();
                            FailoverStrategy x$266 = x$30.copy$default$14();
                            int x$267 = x$30.copy$default$15();
                            int x$268 = x$30.copy$default$16();
                            int x$269 = x$30.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$270 = x$30.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$271 = x$30.copy$default$19();
                            ReadConcern x$272 = x$30.copy$default$20();
                            Option<String> x$273 = x$30.copy$default$21();
                            return x$30.copy(x$254, x$255, x$256, x$257, x$258, x$259, x$260, x$261, x$262, x$263, x$264, x$253, x$265, x$266, x$267, x$268, x$269, x$270, x$271, x$272, x$273);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple219 = (Tuple2)tuple2._2();
                if (tuple219 != null) {
                    String string = (String)tuple219._1();
                    String string11 = (String)tuple219._2();
                    if ("writeConcern".equals(string) && "acknowledged".equals(string11)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$31 -> {
                            WriteConcern x$274 = WriteConcern$.MODULE$.Acknowledged();
                            int x$275 = x$31.copy$default$1();
                            Option<String> x$276 = x$31.copy$default$2();
                            boolean x$277 = x$31.copy$default$3();
                            boolean x$278 = x$31.copy$default$4();
                            AuthenticationMode x$279 = x$31.copy$default$5();
                            boolean x$280 = x$31.copy$default$6();
                            boolean x$281 = x$31.copy$default$7();
                            int x$282 = x$31.copy$default$8();
                            Option<Object> x$283 = x$31.copy$default$9();
                            int x$284 = x$31.copy$default$10();
                            int x$285 = x$31.copy$default$11();
                            ReadPreference x$286 = x$31.copy$default$13();
                            FailoverStrategy x$287 = x$31.copy$default$14();
                            int x$288 = x$31.copy$default$15();
                            int x$289 = x$31.copy$default$16();
                            int x$290 = x$31.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$291 = x$31.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$292 = x$31.copy$default$19();
                            ReadConcern x$293 = x$31.copy$default$20();
                            Option<String> x$294 = x$31.copy$default$21();
                            return x$31.copy(x$275, x$276, x$277, x$278, x$279, x$280, x$281, x$282, x$283, x$284, x$285, x$274, x$286, x$287, x$288, x$289, x$290, x$291, x$292, x$293, x$294);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple220 = (Tuple2)tuple2._2();
                if (tuple220 != null) {
                    String string = (String)tuple220._1();
                    String string12 = (String)tuple220._2();
                    if ("writeConcern".equals(string) && "journaled".equals(string12)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$32 -> {
                            WriteConcern x$295 = WriteConcern$.MODULE$.Journaled();
                            int x$296 = x$32.copy$default$1();
                            Option<String> x$297 = x$32.copy$default$2();
                            boolean x$298 = x$32.copy$default$3();
                            boolean x$299 = x$32.copy$default$4();
                            AuthenticationMode x$300 = x$32.copy$default$5();
                            boolean x$301 = x$32.copy$default$6();
                            boolean x$302 = x$32.copy$default$7();
                            int x$303 = x$32.copy$default$8();
                            Option<Object> x$304 = x$32.copy$default$9();
                            int x$305 = x$32.copy$default$10();
                            int x$306 = x$32.copy$default$11();
                            ReadPreference x$307 = x$32.copy$default$13();
                            FailoverStrategy x$308 = x$32.copy$default$14();
                            int x$309 = x$32.copy$default$15();
                            int x$310 = x$32.copy$default$16();
                            int x$311 = x$32.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$312 = x$32.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$313 = x$32.copy$default$19();
                            ReadConcern x$314 = x$32.copy$default$20();
                            Option<String> x$315 = x$32.copy$default$21();
                            return x$32.copy(x$296, x$297, x$298, x$299, x$300, x$301, x$302, x$303, x$304, x$305, x$306, x$295, x$307, x$308, x$309, x$310, x$311, x$312, x$313, x$314, x$315);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple221 = (Tuple2)tuple2._2();
                if (tuple221 != null) {
                    String string = (String)tuple221._1();
                    String string13 = (String)tuple221._2();
                    if ("writeConcern".equals(string) && "default".equals(string13)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$33 -> {
                            WriteConcern x$316 = WriteConcern$.MODULE$.Default();
                            int x$317 = x$33.copy$default$1();
                            Option<String> x$318 = x$33.copy$default$2();
                            boolean x$319 = x$33.copy$default$3();
                            boolean x$320 = x$33.copy$default$4();
                            AuthenticationMode x$321 = x$33.copy$default$5();
                            boolean x$322 = x$33.copy$default$6();
                            boolean x$323 = x$33.copy$default$7();
                            int x$324 = x$33.copy$default$8();
                            Option<Object> x$325 = x$33.copy$default$9();
                            int x$326 = x$33.copy$default$10();
                            int x$327 = x$33.copy$default$11();
                            ReadPreference x$328 = x$33.copy$default$13();
                            FailoverStrategy x$329 = x$33.copy$default$14();
                            int x$330 = x$33.copy$default$15();
                            int x$331 = x$33.copy$default$16();
                            int x$332 = x$33.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$333 = x$33.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$334 = x$33.copy$default$19();
                            ReadConcern x$335 = x$33.copy$default$20();
                            Option<String> x$336 = x$33.copy$default$21();
                            return x$33.copy(x$317, x$318, x$319, x$320, x$321, x$322, x$323, x$324, x$325, x$326, x$327, x$316, x$328, x$329, x$330, x$331, x$332, x$333, x$334, x$335, x$336);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple222 = (Tuple2)tuple2._2();
                if (tuple222 != null) {
                    String string = (String)tuple222._1();
                    String string14 = (String)tuple222._2();
                    if ("readPreference".equals(string) && "primary".equals(string14)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$34 -> {
                            ReadPreference$Primary$ x$337 = ReadPreference$.MODULE$.primary();
                            int x$338 = x$34.copy$default$1();
                            Option<String> x$339 = x$34.copy$default$2();
                            boolean x$340 = x$34.copy$default$3();
                            boolean x$341 = x$34.copy$default$4();
                            AuthenticationMode x$342 = x$34.copy$default$5();
                            boolean x$343 = x$34.copy$default$6();
                            boolean x$344 = x$34.copy$default$7();
                            int x$345 = x$34.copy$default$8();
                            Option<Object> x$346 = x$34.copy$default$9();
                            int x$347 = x$34.copy$default$10();
                            int x$348 = x$34.copy$default$11();
                            WriteConcern x$349 = x$34.copy$default$12();
                            FailoverStrategy x$350 = x$34.copy$default$14();
                            int x$351 = x$34.copy$default$15();
                            int x$352 = x$34.copy$default$16();
                            int x$353 = x$34.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$354 = x$34.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$355 = x$34.copy$default$19();
                            ReadConcern x$356 = x$34.copy$default$20();
                            Option<String> x$357 = x$34.copy$default$21();
                            return x$34.copy(x$338, x$339, x$340, x$341, x$342, x$343, x$344, x$345, x$346, x$347, x$348, x$349, x$337, x$350, x$351, x$352, x$353, x$354, x$355, x$356, x$357);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple223 = (Tuple2)tuple2._2();
                if (tuple223 != null) {
                    String string = (String)tuple223._1();
                    String string15 = (String)tuple223._2();
                    if ("readPreference".equals(string) && "primaryPreferred".equals(string15)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$35 -> {
                            ReadPreference.PrimaryPreferred x$358 = ReadPreference$.MODULE$.primaryPreferred();
                            int x$359 = x$35.copy$default$1();
                            Option<String> x$360 = x$35.copy$default$2();
                            boolean x$361 = x$35.copy$default$3();
                            boolean x$362 = x$35.copy$default$4();
                            AuthenticationMode x$363 = x$35.copy$default$5();
                            boolean x$364 = x$35.copy$default$6();
                            boolean x$365 = x$35.copy$default$7();
                            int x$366 = x$35.copy$default$8();
                            Option<Object> x$367 = x$35.copy$default$9();
                            int x$368 = x$35.copy$default$10();
                            int x$369 = x$35.copy$default$11();
                            WriteConcern x$370 = x$35.copy$default$12();
                            FailoverStrategy x$371 = x$35.copy$default$14();
                            int x$372 = x$35.copy$default$15();
                            int x$373 = x$35.copy$default$16();
                            int x$374 = x$35.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$375 = x$35.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$376 = x$35.copy$default$19();
                            ReadConcern x$377 = x$35.copy$default$20();
                            Option<String> x$378 = x$35.copy$default$21();
                            return x$35.copy(x$359, x$360, x$361, x$362, x$363, x$364, x$365, x$366, x$367, x$368, x$369, x$370, x$358, x$371, x$372, x$373, x$374, x$375, x$376, x$377, x$378);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple224 = (Tuple2)tuple2._2();
                if (tuple224 != null) {
                    String string = (String)tuple224._1();
                    String string16 = (String)tuple224._2();
                    if ("readPreference".equals(string) && "secondary".equals(string16)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$36 -> {
                            ReadPreference.Secondary x$379 = ReadPreference$.MODULE$.secondary();
                            int x$380 = x$36.copy$default$1();
                            Option<String> x$381 = x$36.copy$default$2();
                            boolean x$382 = x$36.copy$default$3();
                            boolean x$383 = x$36.copy$default$4();
                            AuthenticationMode x$384 = x$36.copy$default$5();
                            boolean x$385 = x$36.copy$default$6();
                            boolean x$386 = x$36.copy$default$7();
                            int x$387 = x$36.copy$default$8();
                            Option<Object> x$388 = x$36.copy$default$9();
                            int x$389 = x$36.copy$default$10();
                            int x$390 = x$36.copy$default$11();
                            WriteConcern x$391 = x$36.copy$default$12();
                            FailoverStrategy x$392 = x$36.copy$default$14();
                            int x$393 = x$36.copy$default$15();
                            int x$394 = x$36.copy$default$16();
                            int x$395 = x$36.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$396 = x$36.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$397 = x$36.copy$default$19();
                            ReadConcern x$398 = x$36.copy$default$20();
                            Option<String> x$399 = x$36.copy$default$21();
                            return x$36.copy(x$380, x$381, x$382, x$383, x$384, x$385, x$386, x$387, x$388, x$389, x$390, x$391, x$379, x$392, x$393, x$394, x$395, x$396, x$397, x$398, x$399);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple225 = (Tuple2)tuple2._2();
                if (tuple225 != null) {
                    String string = (String)tuple225._1();
                    String string17 = (String)tuple225._2();
                    if ("readPreference".equals(string) && "secondaryPreferred".equals(string17)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$37 -> {
                            ReadPreference.SecondaryPreferred x$400 = ReadPreference$.MODULE$.secondaryPreferred();
                            int x$401 = x$37.copy$default$1();
                            Option<String> x$402 = x$37.copy$default$2();
                            boolean x$403 = x$37.copy$default$3();
                            boolean x$404 = x$37.copy$default$4();
                            AuthenticationMode x$405 = x$37.copy$default$5();
                            boolean x$406 = x$37.copy$default$6();
                            boolean x$407 = x$37.copy$default$7();
                            int x$408 = x$37.copy$default$8();
                            Option<Object> x$409 = x$37.copy$default$9();
                            int x$410 = x$37.copy$default$10();
                            int x$411 = x$37.copy$default$11();
                            WriteConcern x$412 = x$37.copy$default$12();
                            FailoverStrategy x$413 = x$37.copy$default$14();
                            int x$414 = x$37.copy$default$15();
                            int x$415 = x$37.copy$default$16();
                            int x$416 = x$37.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$417 = x$37.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$418 = x$37.copy$default$19();
                            ReadConcern x$419 = x$37.copy$default$20();
                            Option<String> x$420 = x$37.copy$default$21();
                            return x$37.copy(x$401, x$402, x$403, x$404, x$405, x$406, x$407, x$408, x$409, x$410, x$411, x$412, x$400, x$413, x$414, x$415, x$416, x$417, x$418, x$419, x$420);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple226 = (Tuple2)tuple2._2();
                if (tuple226 != null) {
                    String string = (String)tuple226._1();
                    String string18 = (String)tuple226._2();
                    if ("readPreference".equals(string) && "nearest".equals(string18)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$38 -> {
                            ReadPreference.Nearest x$421 = ReadPreference$.MODULE$.nearest();
                            int x$422 = x$38.copy$default$1();
                            Option<String> x$423 = x$38.copy$default$2();
                            boolean x$424 = x$38.copy$default$3();
                            boolean x$425 = x$38.copy$default$4();
                            AuthenticationMode x$426 = x$38.copy$default$5();
                            boolean x$427 = x$38.copy$default$6();
                            boolean x$428 = x$38.copy$default$7();
                            int x$429 = x$38.copy$default$8();
                            Option<Object> x$430 = x$38.copy$default$9();
                            int x$431 = x$38.copy$default$10();
                            int x$432 = x$38.copy$default$11();
                            WriteConcern x$433 = x$38.copy$default$12();
                            FailoverStrategy x$434 = x$38.copy$default$14();
                            int x$435 = x$38.copy$default$15();
                            int x$436 = x$38.copy$default$16();
                            int x$437 = x$38.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$438 = x$38.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$439 = x$38.copy$default$19();
                            ReadConcern x$440 = x$38.copy$default$20();
                            Option<String> x$441 = x$38.copy$default$21();
                            return x$38.copy(x$422, x$423, x$424, x$425, x$426, x$427, x$428, x$429, x$430, x$431, x$432, x$433, x$421, x$434, x$435, x$436, x$437, x$438, x$439, x$440, x$441);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple227 = (Tuple2)tuple2._2();
                if (tuple227 != null) {
                    Option<ReadConcern> option;
                    String string = (String)tuple227._1();
                    String string19 = (String)tuple227._2();
                    if ("readConcernLevel".equals(string) && string19 != null && !(option = ReadConcern$.MODULE$.unapply(string19)).isEmpty()) {
                        ReadConcern c2 = (ReadConcern)option.get();
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$39 -> {
                            ReadConcern x$442 = c2;
                            int x$443 = x$39.copy$default$1();
                            Option<String> x$444 = x$39.copy$default$2();
                            boolean x$445 = x$39.copy$default$3();
                            boolean x$446 = x$39.copy$default$4();
                            AuthenticationMode x$447 = x$39.copy$default$5();
                            boolean x$448 = x$39.copy$default$6();
                            boolean x$449 = x$39.copy$default$7();
                            int x$450 = x$39.copy$default$8();
                            Option<Object> x$451 = x$39.copy$default$9();
                            int x$452 = x$39.copy$default$10();
                            int x$453 = x$39.copy$default$11();
                            WriteConcern x$454 = x$39.copy$default$12();
                            ReadPreference x$455 = x$39.copy$default$13();
                            FailoverStrategy x$456 = x$39.copy$default$14();
                            int x$457 = x$39.copy$default$15();
                            int x$458 = x$39.copy$default$16();
                            int x$459 = x$39.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$460 = x$39.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$461 = x$39.copy$default$19();
                            Option<String> x$462 = x$39.copy$default$21();
                            return x$39.copy(x$443, x$444, x$445, x$446, x$447, x$448, x$449, x$450, x$451, x$452, x$453, x$454, x$455, x$456, x$457, x$458, x$459, x$460, x$461, x$442, x$462);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple228 = (Tuple2)tuple2._2();
                if (tuple228 != null) {
                    String string = (String)tuple228._1();
                    String string20 = (String)tuple228._2();
                    if ("rm.failover".equals(string) && "default".equals(string20)) {
                        return state;
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple229 = (Tuple2)tuple2._2();
                if (tuple229 != null) {
                    String string = (String)tuple229._1();
                    String string21 = (String)tuple229._2();
                    if ("rm.failover".equals(string) && "remote".equals(string21)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$40 -> {
                            FailoverStrategy x$463 = FailoverStrategy$.MODULE$.remote();
                            int x$464 = x$40.copy$default$1();
                            Option<String> x$465 = x$40.copy$default$2();
                            boolean x$466 = x$40.copy$default$3();
                            boolean x$467 = x$40.copy$default$4();
                            AuthenticationMode x$468 = x$40.copy$default$5();
                            boolean x$469 = x$40.copy$default$6();
                            boolean x$470 = x$40.copy$default$7();
                            int x$471 = x$40.copy$default$8();
                            Option<Object> x$472 = x$40.copy$default$9();
                            int x$473 = x$40.copy$default$10();
                            int x$474 = x$40.copy$default$11();
                            WriteConcern x$475 = x$40.copy$default$12();
                            ReadPreference x$476 = x$40.copy$default$13();
                            int x$477 = x$40.copy$default$15();
                            int x$478 = x$40.copy$default$16();
                            int x$479 = x$40.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$480 = x$40.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$481 = x$40.copy$default$19();
                            ReadConcern x$482 = x$40.copy$default$20();
                            Option<String> x$483 = x$40.copy$default$21();
                            return x$40.copy(x$464, x$465, x$466, x$467, x$468, x$469, x$470, x$471, x$472, x$473, x$474, x$475, x$476, x$463, x$477, x$478, x$479, x$480, x$481, x$482, x$483);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple230 = (Tuple2)tuple2._2();
                if (tuple230 != null) {
                    String string = (String)tuple230._1();
                    String string22 = (String)tuple230._2();
                    if ("rm.failover".equals(string) && "strict".equals(string22)) {
                        return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$41 -> {
                            FailoverStrategy x$484 = FailoverStrategy$.MODULE$.strict();
                            int x$485 = x$41.copy$default$1();
                            Option<String> x$486 = x$41.copy$default$2();
                            boolean x$487 = x$41.copy$default$3();
                            boolean x$488 = x$41.copy$default$4();
                            AuthenticationMode x$489 = x$41.copy$default$5();
                            boolean x$490 = x$41.copy$default$6();
                            boolean x$491 = x$41.copy$default$7();
                            int x$492 = x$41.copy$default$8();
                            Option<Object> x$493 = x$41.copy$default$9();
                            int x$494 = x$41.copy$default$10();
                            int x$495 = x$41.copy$default$11();
                            WriteConcern x$496 = x$41.copy$default$12();
                            ReadPreference x$497 = x$41.copy$default$13();
                            int x$498 = x$41.copy$default$15();
                            int x$499 = x$41.copy$default$16();
                            int x$500 = x$41.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$501 = x$41.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> x$502 = x$41.copy$default$19();
                            ReadConcern x$503 = x$41.copy$default$20();
                            Option<String> x$504 = x$41.copy$default$21();
                            return x$41.copy(x$485, x$486, x$487, x$488, x$489, x$490, x$491, x$492, x$493, x$494, x$495, x$496, x$497, x$484, x$498, x$499, x$500, x$501, x$502, x$503, x$504);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple231 = (Tuple2)tuple2._2();
                if (tuple231 != null) {
                    Option option;
                    String string = (String)tuple231._1();
                    String opt = (String)tuple231._2();
                    if ("rm.failover".equals(string) && opt != null && !(option = MODULE$.FailoverRe().unapplySeq((CharSequence)opt)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(3) == 0) {
                        String d = (String)((LinearSeqOps)option.get()).apply(0);
                        String r = (String)((LinearSeqOps)option.get()).apply(1);
                        String f = (String)((LinearSeqOps)option.get()).apply(2);
                        return this.make$1("rm.failover", opt, state, (Function0 & Serializable)() -> {
                            Tuple2 dur;
                            Option option = Duration$.MODULE$.unapply(Duration$.MODULE$.apply(d));
                            if (!(option instanceof Some)) {
                                throw new MongoConnection.URIParsingException(new StringBuilder(32).append("Invalid duration 'rm.failover': ").append(opt).toString());
                            }
                            Some some = (Some)option;
                            Tuple2 tuple2 = dur = (Tuple2)some.value();
                            Tuple2 tuple22 = tuple2;
                            if (tuple22 == null) {
                                throw new MatchError((Object)tuple22);
                            }
                            long time = tuple22._1$mcJ$sp();
                            TimeUnit unit = (TimeUnit)((Object)((Object)((Object)tuple22._2())));
                            Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToLong((long)time), (Object)unit);
                            Tuple2 tuple24 = tuple23;
                            long time2 = tuple24._1$mcJ$sp();
                            TimeUnit unit2 = (TimeUnit)((Object)((Object)((Object)tuple24._2())));
                            FiniteDuration delay = FiniteDuration$.MODULE$.apply(time2, unit2);
                            int retry = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(r));
                            double factor = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(f));
                            FailoverStrategy strategy = FailoverStrategy$.MODULE$.apply(delay, retry, (Function1<Object, Object>)(JFunction1.mcDI.sp & Serializable)x$43 -> (double)x$43 * factor);
                            return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$44 -> {
                                FailoverStrategy x$505 = strategy;
                                int x$506 = x$44.copy$default$1();
                                Option<String> x$507 = x$44.copy$default$2();
                                boolean x$508 = x$44.copy$default$3();
                                boolean x$509 = x$44.copy$default$4();
                                AuthenticationMode x$510 = x$44.copy$default$5();
                                boolean x$511 = x$44.copy$default$6();
                                boolean x$512 = x$44.copy$default$7();
                                int x$513 = x$44.copy$default$8();
                                Option<Object> x$514 = x$44.copy$default$9();
                                int x$515 = x$44.copy$default$10();
                                int x$516 = x$44.copy$default$11();
                                WriteConcern x$517 = x$44.copy$default$12();
                                ReadPreference x$518 = x$44.copy$default$13();
                                int x$519 = x$44.copy$default$15();
                                int x$520 = x$44.copy$default$16();
                                int x$521 = x$44.copy$default$17();
                                scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$522 = x$44.copy$default$18();
                                Option<MongoConnectionOptions.KeyStore> x$523 = x$44.copy$default$19();
                                ReadConcern x$524 = x$44.copy$default$20();
                                Option<String> x$525 = x$44.copy$default$21();
                                return x$44.copy(x$506, x$507, x$508, x$509, x$510, x$511, x$512, x$513, x$514, x$515, x$516, x$517, x$518, x$505, x$519, x$520, x$521, x$522, x$523, x$524, x$525);
                            });
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple232 = (Tuple2)tuple2._2();
                if (tuple232 != null) {
                    String string = (String)tuple232._1();
                    String string23 = (String)tuple232._2();
                    if ("retryWrites".equals(string) && "true".equals(string23)) {
                        MODULE$.logger().info((Function0<String>)(Function0 & Serializable)() -> "Connection option 'rm.failover' should be preferred to 'retryWrites'");
                        return state;
                    }
                }
            }
            if (tuple2 != null) {
                String string;
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple233 = (Tuple2)tuple2._2();
                if (tuple233 != null && "retryWrites".equals(string = (String)tuple233._1())) {
                    MODULE$.logger().info((Function0<String>)(Function0 & Serializable)() -> "Connection option 'rm.failover' should be preferred to 'retryWrites'");
                    return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$45 -> {
                        FailoverStrategy x$526 = FailoverStrategy$.MODULE$.strict();
                        int x$527 = x$45.copy$default$1();
                        Option<String> x$528 = x$45.copy$default$2();
                        boolean x$529 = x$45.copy$default$3();
                        boolean x$530 = x$45.copy$default$4();
                        AuthenticationMode x$531 = x$45.copy$default$5();
                        boolean x$532 = x$45.copy$default$6();
                        boolean x$533 = x$45.copy$default$7();
                        int x$534 = x$45.copy$default$8();
                        Option<Object> x$535 = x$45.copy$default$9();
                        int x$536 = x$45.copy$default$10();
                        int x$537 = x$45.copy$default$11();
                        WriteConcern x$538 = x$45.copy$default$12();
                        ReadPreference x$539 = x$45.copy$default$13();
                        int x$540 = x$45.copy$default$15();
                        int x$541 = x$45.copy$default$16();
                        int x$542 = x$45.copy$default$17();
                        scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$543 = x$45.copy$default$18();
                        Option<MongoConnectionOptions.KeyStore> x$544 = x$45.copy$default$19();
                        ReadConcern x$545 = x$45.copy$default$20();
                        Option<String> x$546 = x$45.copy$default$21();
                        return x$45.copy(x$527, x$528, x$529, x$530, x$531, x$532, x$533, x$534, x$535, x$536, x$537, x$538, x$539, x$526, x$540, x$541, x$542, x$543, x$544, x$545, x$546);
                    });
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple234 = (Tuple2)tuple2._2();
                if (tuple234 != null) {
                    Option option;
                    String string = (String)tuple234._1();
                    String string24 = (String)tuple234._2();
                    if ("heartbeatFrequencyMS".equals(string) && string24 != null && !(option = MODULE$.UnsignedInt().unapplySeq((CharSequence)string24)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                        String ms = (String)((LinearSeqOps)option.get()).apply(0);
                        return this.make$1("heartbeatFrequencyMS", ms, state, (Function0 & Serializable)() -> {
                            int millis = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(ms));
                            if (millis < 500) {
                                throw new MongoConnection.URIParsingException("'heartbeatFrequencyMS' must be >= 500 milliseconds");
                            }
                            return state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$46 -> {
                                int x$547 = millis;
                                int x$548 = x$46.copy$default$1();
                                Option<String> x$549 = x$46.copy$default$2();
                                boolean x$550 = x$46.copy$default$3();
                                boolean x$551 = x$46.copy$default$4();
                                AuthenticationMode x$552 = x$46.copy$default$5();
                                boolean x$553 = x$46.copy$default$6();
                                boolean x$554 = x$46.copy$default$7();
                                int x$555 = x$46.copy$default$8();
                                Option<Object> x$556 = x$46.copy$default$9();
                                int x$557 = x$46.copy$default$10();
                                int x$558 = x$46.copy$default$11();
                                WriteConcern x$559 = x$46.copy$default$12();
                                ReadPreference x$560 = x$46.copy$default$13();
                                FailoverStrategy x$561 = x$46.copy$default$14();
                                int x$562 = x$46.copy$default$16();
                                int x$563 = x$46.copy$default$17();
                                scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$564 = x$46.copy$default$18();
                                Option<MongoConnectionOptions.KeyStore> x$565 = x$46.copy$default$19();
                                ReadConcern x$566 = x$46.copy$default$20();
                                Option<String> x$567 = x$46.copy$default$21();
                                return x$46.copy(x$548, x$549, x$550, x$551, x$552, x$553, x$554, x$555, x$556, x$557, x$558, x$559, x$560, x$561, x$547, x$562, x$563, x$564, x$565, x$566, x$567);
                            });
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple235 = (Tuple2)tuple2._2();
                if (tuple235 != null) {
                    String string = (String)tuple235._1();
                    String nme = (String)tuple235._2();
                    if ("appName".equals(string)) {
                        MongoConnection.ParseState parseState;
                        Option option = Option$.MODULE$.apply((Object)nme).map((Function1 & Serializable)x$47 -> x$47.trim()).filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$makeOptions$43(v)));
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            String appName = (String)some.value();
                            parseState = state.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$48 -> {
                                Some x$568 = new Some((Object)appName);
                                int x$569 = x$48.copy$default$1();
                                Option<String> x$570 = x$48.copy$default$2();
                                boolean x$571 = x$48.copy$default$3();
                                boolean x$572 = x$48.copy$default$4();
                                AuthenticationMode x$573 = x$48.copy$default$5();
                                boolean x$574 = x$48.copy$default$6();
                                boolean x$575 = x$48.copy$default$7();
                                int x$576 = x$48.copy$default$8();
                                Option<Object> x$577 = x$48.copy$default$9();
                                int x$578 = x$48.copy$default$10();
                                int x$579 = x$48.copy$default$11();
                                WriteConcern x$580 = x$48.copy$default$12();
                                ReadPreference x$581 = x$48.copy$default$13();
                                FailoverStrategy x$582 = x$48.copy$default$14();
                                int x$583 = x$48.copy$default$15();
                                int x$584 = x$48.copy$default$16();
                                int x$585 = x$48.copy$default$17();
                                scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$586 = x$48.copy$default$18();
                                Option<MongoConnectionOptions.KeyStore> x$587 = x$48.copy$default$19();
                                ReadConcern x$588 = x$48.copy$default$20();
                                return x$48.copy(x$569, x$570, x$571, x$572, x$573, x$574, x$575, x$576, x$577, x$578, x$579, x$580, x$581, x$582, x$583, x$584, x$585, x$586, x$587, x$588, (Option<String>)x$568);
                            });
                            return parseState;
                        } else {
                            parseState = state.reject((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"appName"), (Object)nme));
                        }
                        return parseState;
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
            Tuple2 kv = (Tuple2)tuple2._2();
            return state.reject((Tuple2<String, String>)kv);
        });
        MongoConnection.ParseState parsed2 = (MongoConnection.ParseState)parsed1.rejected().get((Object)"zlibCompressionLevel").fold((Function0 & Serializable)() -> parsed1, (Function1 & Serializable)x0$2 -> {
            MongoConnection.ParseState parseState;
            Option option;
            String string = x0$2;
            if (string != null && !(option = MODULE$.IntRe().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                MongoConnection.ParseState parseState2;
                String level = (String)((LinearSeqOps)option.get()).apply(0);
                BooleanRef valid = BooleanRef.create((boolean)false);
                ListSet compressors = (ListSet)parsed1.options().compressors().map((Function1 & Serializable)x0$3 -> {
                    Compressor compressor;
                    Option option;
                    Compressor compressor2 = x0$3;
                    if (compressor2 != null && !(option = Compressor.Zlib$.MODULE$.unapply(compressor2)).isEmpty()) {
                        valid$2.elem = true;
                        compressor = Compressor.Zlib$.MODULE$.apply(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(level)));
                    } else {
                        compressor = compressor2;
                    }
                    return compressor;
                });
                if (!valid.elem) {
                    MODULE$.logger().info((Function0<String>)(Function0 & Serializable)() -> "Connection option 'zlibCompressionLevel' must only be specified after 'compressors' with 'zlib'");
                    parseState2 = parsed1.reject((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zlibCompressionLevel"), (Object)level));
                } else {
                    parseState2 = parsed1.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$49 -> x$49.withCompressors((ListSet<Compressor>)compressors));
                }
                parseState = parseState2;
            } else {
                parseState = parsed1;
            }
            return parseState;
        });
        MongoConnection.ParseState parsed3 = (MongoConnection.ParseState)parsed2.rejected().get((Object)"keyStore").fold((Function0 & Serializable)() -> parsed2, (Function1 & Serializable)uri -> {
            MongoConnectionOptions.KeyStore keyStore = MongoConnectionOptions$KeyStore$.MODULE$.apply(new URI((String)uri), (Option<char[]>)parsed2.rejected().get((Object)"keyStorePassword").map((Function1 & Serializable)x$50 -> x$50.toCharArray()), (String)parsed2.rejected().getOrElse((Object)"keyStoreType", (Function0 & Serializable)() -> "PKCS12"), true);
            MongoConnection.ParseState qual$1 = parsed2.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)x$51 -> {
                Some x$589 = new Some((Object)keyStore);
                int x$590 = x$51.copy$default$1();
                Option<String> x$591 = x$51.copy$default$2();
                boolean x$592 = x$51.copy$default$3();
                boolean x$593 = x$51.copy$default$4();
                AuthenticationMode x$594 = x$51.copy$default$5();
                boolean x$595 = x$51.copy$default$6();
                boolean x$596 = x$51.copy$default$7();
                int x$597 = x$51.copy$default$8();
                Option<Object> x$598 = x$51.copy$default$9();
                int x$599 = x$51.copy$default$10();
                int x$600 = x$51.copy$default$11();
                WriteConcern x$601 = x$51.copy$default$12();
                ReadPreference x$602 = x$51.copy$default$13();
                FailoverStrategy x$603 = x$51.copy$default$14();
                int x$604 = x$51.copy$default$15();
                int x$605 = x$51.copy$default$16();
                int x$606 = x$51.copy$default$17();
                scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$607 = x$51.copy$default$18();
                ReadConcern x$608 = x$51.copy$default$20();
                Option<String> x$609 = x$51.copy$default$21();
                return x$51.copy(x$590, x$591, x$592, x$593, x$594, x$595, x$596, x$597, x$598, x$599, x$600, x$601, x$602, x$603, x$604, x$605, x$606, x$607, (Option<MongoConnectionOptions.KeyStore>)x$589, x$608, x$609);
            });
            scala.collection.immutable.Map x$610 = (scala.collection.immutable.Map)parsed2.rejected().$minus((Object)"keyStore").$minus((Object)"keyStorePassword").$minus((Object)"keyStoreType");
            MongoConnectionOptions x$611 = qual$1.copy$default$1();
            return qual$1.copy(x$611, (scala.collection.immutable.Map<String, String>)x$610);
        });
        MongoConnection.ParseState parsed4 = (MongoConnection.ParseState)parsed3.rejected().iterator().foldLeft((Object)parsed3, (Function2 & Serializable)(x0$4, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$4, x1$2);
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String o = (String)tuple22._1();
                    String string = (String)tuple22._2();
                    boolean bl = "writeConcernW".equals(o) ? true : "w".equals(o);
                    if (bl && "majority".equals(string)) {
                        this.deprecated$1(o, "w");
                        return MongoConnection$.updateWriteConcern$1(state, (Function1 & Serializable)x$52 -> x$52.copy(WriteConcern$Majority$.MODULE$, x$52.copy$default$2(), x$52.copy$default$3(), x$52.copy$default$4()));
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple23 != null) {
                    Option option;
                    String o = (String)tuple23._1();
                    String string = (String)tuple23._2();
                    boolean bl = "writeConcernW".equals(o) ? true : "w".equals(o);
                    if (bl && string != null && !(option = MODULE$.UnsignedInt().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                        String str = (String)((LinearSeqOps)option.get()).apply(0);
                        this.deprecated$1(o, "w");
                        return MongoConnection$.updateWriteConcern$1(state, (Function1 & Serializable)x$53 -> x$53.copy(WriteConcern$WaitForAcknowledgments$.MODULE$.apply(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(str))), x$53.copy$default$2(), x$53.copy$default$3(), x$53.copy$default$4()));
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple24 = (Tuple2)tuple2._2();
                if (tuple24 != null) {
                    String o = (String)tuple24._1();
                    String tag = (String)tuple24._2();
                    boolean bl = "writeConcernW".equals(o) ? true : "w".equals(o);
                    if (bl) {
                        this.deprecated$1(o, "w");
                        return MongoConnection$.updateWriteConcern$1(state, (Function1 & Serializable)x$54 -> x$54.copy(WriteConcern$TagSet$.MODULE$.apply(tag), x$54.copy$default$2(), x$54.copy$default$3(), x$54.copy$default$4()));
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple25 = (Tuple2)tuple2._2();
                if (tuple25 != null) {
                    String o = (String)tuple25._1();
                    String journaled = (String)tuple25._2();
                    boolean bl = "journal".equals(o) ? true : "writeConcernJ".equals(o);
                    if (bl) {
                        this.deprecated$1(o, "journal");
                        return MongoConnection$.updateWriteConcern$1(state, (Function1 & Serializable)x$55 -> {
                            boolean x$612 = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(journaled));
                            WriteConcern.W x$613 = x$55.copy$default$1();
                            boolean x$614 = x$55.copy$default$3();
                            Option<Object> x$615 = x$55.copy$default$4();
                            return x$55.copy(x$613, x$612, x$614, x$615);
                        });
                    }
                }
            }
            if (tuple2 != null) {
                MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple26 = (Tuple2)tuple2._2();
                if (tuple26 != null) {
                    Option option;
                    String o = (String)tuple26._1();
                    String string = (String)tuple26._2();
                    boolean bl = "wtimeoutMS".equals(o) ? true : "writeConcernTimeout".equals(o);
                    if (bl && string != null && !(option = MODULE$.UnsignedInt().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                        String ms = (String)((LinearSeqOps)option.get()).apply(0);
                        this.deprecated$1(o, "journal");
                        return MongoConnection$.updateWriteConcern$1(state, (Function1 & Serializable)x$56 -> {
                            Some x$616 = new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(ms))));
                            WriteConcern.W x$617 = x$56.copy$default$1();
                            boolean x$618 = x$56.copy$default$2();
                            boolean x$619 = x$56.copy$default$3();
                            return x$56.copy(x$617, x$618, x$619, (Option<Object>)x$616);
                        });
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            MongoConnection.ParseState state = (MongoConnection.ParseState)tuple2._1();
            Tuple2 kv = (Tuple2)tuple2._2();
            return state.reject((Tuple2<String, String>)kv);
        });
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(parsed4.rejected().$minus((Object)"writeConcernW").$minus((Object)"w").$minus((Object)"journal").$minus((Object)"writeConcernJ").$minus((Object)"wtimeoutMS").$minus((Object)"writeConcernTimeout").keySet().toList().sorted((Ordering)Ordering.String$.MODULE$)), (Object)parsed4.options());
    }

    public static final /* synthetic */ boolean $anonfun$parse$3(char x$4) {
        return x$4 != '?';
    }

    public static final /* synthetic */ boolean $anonfun$parse$5(char x$5) {
        return x$5 != '/';
    }

    private static final Future txtOptions$1(boolean seedList$1, String setSpec$1, int credentialEnd$1, Function1 txtResolver$1, ExecutionContext ec$1) {
        Future future;
        if (!seedList$1) {
            future = Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().empty());
        } else {
            String serviceName = StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(setSpec$1), credentialEnd$1 + 1)), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parse$5(BoxesRunTime.unboxToChar((Object)x$5))));
            future = ((Future)Await$.MODULE$.ready((Awaitable)txtResolver$1.apply((Object)serviceName), (Duration)package$.MODULE$.dnsTimeout())).flatMap((Function1 & Serializable)records -> ((Future)records.foldLeft((Object)Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().empty()), (Function2 & Serializable)(o, r) -> o.flatMap((Function1 & Serializable)prev -> MODULE$.parseOptions((String)r).map((Function1 & Serializable)cur -> (scala.collection.immutable.Map)prev.$plus$plus((IterableOnce)cur), ec$1), ec$1))).map((Function1 & Serializable)res -> res, ec$1), ec$1);
        }
        return future;
    }

    private static final String optionStr$1(String useful$1, String setSpec$1) {
        return StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(useful$1), StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(setSpec$1)))), "?");
    }

    public static final /* synthetic */ boolean $anonfun$parse$15(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$parseHosts$2(char x$10) {
        return x$10 != ':';
    }

    private final Future parse$1(Iterable input, Builder buf$1) {
        Future future;
        block15: {
            Option option;
            while ((option = input.headOption()) instanceof Some) {
                Future future2;
                String string;
                Some some = (Some)option;
                String h = (String)some.value();
                Tuple2 tuple2 = StringOps$.MODULE$.span$extension(Predef$.MODULE$.augmentString(h), (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parseHosts$2(BoxesRunTime.unboxToChar((Object)x$10))));
                if (tuple2 != null && "".equals(string = (String)tuple2._1())) {
                    future2 = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(28).append("No valid host in the URI: '").append(h).append("'").toString()));
                } else {
                    if (tuple2 != null) {
                        String host = (String)tuple2._1();
                        String string2 = (String)tuple2._2();
                        if ("".equals(string2)) {
                            buf$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)host), (Object)BoxesRunTime.boxToInteger((int)this.DefaultPort())));
                            input = (Iterable)input.drop(1);
                            continue;
                        }
                    }
                    if (tuple2 != null) {
                        Right res;
                        Object object;
                        String host = (String)tuple2._1();
                        String port = (String)tuple2._2();
                        try {
                            int p = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(port), 1)));
                            object = p <= 0 || p >= 65536 ? scala.package$.MODULE$.Left().apply((Object)new MongoConnection.URIParsingException(new StringBuilder(49).append("Could not parse host '").append(h).append("' from URI: invalid port '").append(port).append("'").toString())) : scala.package$.MODULE$.Right().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)host), (Object)BoxesRunTime.boxToInteger((int)p)));
                        }
                        catch (Throwable throwable) {
                            Option option2;
                            Left left;
                            Throwable throwable2 = throwable;
                            if (throwable2 instanceof NumberFormatException) {
                                left = scala.package$.MODULE$.Left().apply((Object)new MongoConnection.URIParsingException(new StringBuilder(49).append("Could not parse host '").append(h).append("' from URI: invalid port '").append(port).append("'").toString()));
                            } else if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                Throwable cause = (Throwable)option2.get();
                                left = scala.package$.MODULE$.Left().apply((Object)cause);
                            } else {
                                throw throwable;
                            }
                            object = left;
                        }
                        Right right = res = object;
                        if (!(right instanceof Left)) {
                            if (right instanceof Right) {
                                Right right2 = right;
                                Tuple2 node = (Tuple2)right2.value();
                                buf$1.$plus$eq((Object)node);
                                input = (Iterable)input.drop(1);
                                continue;
                            }
                            throw new MatchError((Object)right);
                        }
                        Left left = (Left)right;
                        Throwable cause = (Throwable)left.value();
                        Future future3 = Future$.MODULE$.failed(cause);
                        future2 = future3;
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                }
                future = future2;
                break block15;
            }
            future = Future$.MODULE$.successful(buf$1.result());
        }
        return future;
    }

    public static final /* synthetic */ boolean $anonfun$parseHostsAndDB$1(char x$11) {
        return x$11 != '/';
    }

    public static final /* synthetic */ boolean $anonfun$parseOptions$1(char x$14) {
        return x$14 != '=';
    }

    private final Future parse$2(Iterable input, String options$2, Map buf$2) {
        Future future;
        block3: {
            Option option;
            while ((option = input.headOption()) instanceof Some) {
                String string;
                Some some = (Some)option;
                String option2 = (String)some.value();
                Tuple2 tuple2 = StringOps$.MODULE$.span$extension(Predef$.MODULE$.augmentString(option2), (Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)MongoConnection$.$anonfun$parseOptions$1(BoxesRunTime.unboxToChar((Object)x$14))));
                if (tuple2 == null || !"".equals(string = (String)tuple2._2())) {
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        buf$2.put((Object)key, (Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(v), 1));
                        input = (Iterable)input.drop(1);
                        continue;
                    }
                    throw new MatchError((Object)tuple2);
                }
                Future future2 = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(34).append("Could not parse invalid options '").append(options$2).append("'").toString()));
                future = future2;
                break block3;
            }
            future = Future$.MODULE$.successful((Object)buf$2.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
        return future;
    }

    private final MongoConnection.ParseState make$1(String name, String input, MongoConnection.ParseState state, Function0 f) {
        MongoConnection.ParseState parseState;
        try {
            parseState = (MongoConnection.ParseState)f.apply();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable cause = (Throwable)option.get();
            this.logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Invalid option '").append(name).append("': ").append(input).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> cause);
            MongoConnection.ParseState parseState2 = state.reject((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)input));
            parseState = parseState2;
        }
        return parseState;
    }

    private final void deprecated$1(String expected, String actual) {
        block0: {
            String string = actual;
            String string2 = expected;
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            this.logger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(49).append("Connection option '").append(actual).append("' is deprecated in favor of '").append(expected).append("'").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$makeOptions$43(String v) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(v)) && ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(v.getBytes("UTF-8"))) < 128;
    }

    private static final MongoConnection.ParseState updateWriteConcern$1(MongoConnection.ParseState st, Function1 f) {
        return st.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)opts -> {
            WriteConcern x$1 = (WriteConcern)f.apply((Object)opts.writeConcern());
            int x$2 = opts.copy$default$1();
            Option<String> x$3 = opts.copy$default$2();
            boolean x$4 = opts.copy$default$3();
            boolean x$5 = opts.copy$default$4();
            AuthenticationMode x$6 = opts.copy$default$5();
            boolean x$7 = opts.copy$default$6();
            boolean x$8 = opts.copy$default$7();
            int x$9 = opts.copy$default$8();
            Option<Object> x$10 = opts.copy$default$9();
            int x$11 = opts.copy$default$10();
            int x$12 = opts.copy$default$11();
            ReadPreference x$13 = opts.copy$default$13();
            FailoverStrategy x$14 = opts.copy$default$14();
            int x$15 = opts.copy$default$15();
            int x$16 = opts.copy$default$16();
            int x$17 = opts.copy$default$17();
            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> x$18 = opts.copy$default$18();
            Option<MongoConnectionOptions.KeyStore> x$19 = opts.copy$default$19();
            ReadConcern x$20 = opts.copy$default$20();
            Option<String> x$21 = opts.copy$default$21();
            return opts.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        });
    }

    private MongoConnection$() {
    }
}

