/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.netty;

import akka.actor.ActorRef;
import akka.actor.ScalaActorRef;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import reactivemongo.api.MongoConnectionOptions;
import reactivemongo.api.MongoConnectionOptions$KeyStore$;
import reactivemongo.core.SSL;
import reactivemongo.core.actors.ChannelDisconnected;
import reactivemongo.core.errors.GenericDriverException;
import reactivemongo.core.errors.GenericDriverException$;
import reactivemongo.core.netty.ChannelFactory$;
import reactivemongo.core.netty.ChannelFactory$TrustAny$;
import reactivemongo.core.netty.Pack;
import reactivemongo.core.netty.Pack$;
import reactivemongo.core.protocol.MongoHandler;
import reactivemongo.core.protocol.RequestEncoder;
import reactivemongo.core.protocol.ResponseDecoder;
import reactivemongo.core.protocol.ResponseFrameDecoder;
import reactivemongo.io.netty.channel.package;
import reactivemongo.util.LazyLogger;
import reactivemongo.util.LazyLogger$;
import reactivemongo.util.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.concurrent.Promise;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Random;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t%g!\u0002\u00192\u0005U:\u0004\u0002D*\u0001\t\u0003\u0005)Q!A!\u0002\u0013!\u0006\u0002\u00040\u0001\t\u0003\u0005)Q!A!\u0002\u0013!\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u000b\u0019\u0004A\u0011A4\t\u0019=\u0004A\u0011!A\u0003\u0002\u000b\u0007I\u0011\u00029\t\u0013Q\u0004!\u0011!A!\u0002\u0013\t\b\u0002D;\u0001\t\u0003\u0005)\u0011!b\u0001\n\u00131\b\"\u0003>\u0001\u0005\u0003\u0005\t\u0015!\u0003x\u00111Y\b\u0001\"A\u0001\u0006\u0003\u0015\r\u0011\"\u0003}\u0011)\t\t\u0002\u0001B\u0001\u0002\u0003\u0006I! \u0005\u000f\u0003'\u0001A\u0011!A\u0003\u0002\u000b\u0007I\u0011BA\u000b\u0011-\t9\u0003\u0001B\u0001\u0002\u0003\u0006I!a\u0006\t\u001d\u0005%\u0002\u0001\"A\u0001\u0006\u0003\u0015\r\u0011\"\u0003\u0002\u0016!Y\u00111\u0006\u0001\u0003\u0002\u0003\u0005\u000b\u0011BA\f\u00119\ti\u0003\u0001C\u0001\u0002\u000b\u0005)\u0019!C\u0005\u0003_A1\"a\u000e\u0001\u0005\u0003\u0005\t\u0015!\u0003\u00022!A\u0011\u0011\b\u0001\u0005\u0002U\nY\u0004\u0003\u0006\u0002p\u0001\t\n\u0011\"\u00016\u0003cB!\"a\"\u0001#\u0003%\t!NAE\u0011)\ti\tAI\u0001\n\u0003)\u0014\u0011\u0012\u0005\b\u0003\u001f\u0003A\u0011AAI\u0011!\ty\t\u0001C\u0001k\u0005m\u0005bBAT\u0001\u0011%\u0011\u0011\u0016\u0005\b\u0003\u007f\u0003A\u0011BAa\u0011\u001d\t9\u000e\u0001C\u0005\u00033D\u0001\"a=\u0001\t\u0003)\u0014Q\u001f\u0005\b\u0005/\u0001A\u0011\u0002B\r\u0011\u001d\u00119\u0002\u0001C\u0005\u0005OAqA!\u0011\u0001\t\u0013\u0011\u0019\u0005C\u0004\u0003J\u0001!IAa\u0013\b\u000f\tE\u0003\u0001#\u0003\u0003T\u00199!q\u000b\u0001\t\n\te\u0003B\u00024!\t\u0003\u00119\u0007C\u0004\u0003j\u0001\"\tEa\u001b\t\u000f\t-\u0005\u0005\"\u0011\u0003\u000e\"9!1\u0013\u0011\u0005B\tUu\u0001\u0003BLc!\u0005QG!'\u0007\u000fA\n\u0004\u0012A\u001b\u0003\u001c\"1aM\nC\u0001\u0005GC\u0011B!*'\u0005\u0004%\tAa*\t\u0011\tMf\u0005)A\u0005\u0005SC\u0011B!.'\u0005\u0004%\tAa.\t\u0011\tmf\u0005)A\u0005\u0005sC\u0011B!0'\u0005\u0004%\tAa0\t\u0011\t\rg\u0005)A\u0005\u0005\u0003D\u0011B!2'\u0005\u0004%\tAa.\t\u0011\t\u001dg\u0005)A\u0005\u0005s\u0013ab\u00115b]:,GNR1di>\u0014\u0018P\u0003\u00023g\u0005)a.\u001a;us*\u0011A'N\u0001\u0005G>\u0014XMC\u00017\u00035\u0011X-Y2uSZ,Wn\u001c8h_N\u0011\u0001\u0001\u000f\t\u0004s5\u0003fB\u0001\u001eK\u001d\tYtI\u0004\u0002=\u000b:\u0011Qh\u0011\b\u0003}\tk\u0011a\u0010\u0006\u0003\u0001\u0006\u000ba\u0001\u0010:p_Rt4\u0001A\u0005\u0002m%\u0011A)N\u0001\u0003S>L!A\r$\u000b\u0005\u0011+\u0014B\u0001%J\u0003\u001d\u0019\u0007.\u00198oK2T!A\r$\n\u0005-c\u0015a\u00029bG.\fw-\u001a\u0006\u0003\u0011&K!AT(\u0003%\rC\u0017M\u001c8fY&s\u0017\u000e^5bY&TXM\u001d\u0006\u0003\u00172\u0003\"!O)\n\u0005I{%aB\"iC:tW\r\\\u00014e\u0016\f7\r^5wK6|gnZ8%G>\u0014X\r\n8fiRLHe\u00115b]:,GNR1di>\u0014\u0018\u0010\n\u0013tkB,'O^5t_J\u0004\"!V.\u000f\u0005YK\u0006C\u0001 X\u0015\u0005A\u0016!B:dC2\f\u0017B\u0001.X\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i;\u0016a\r:fC\u000e$\u0018N^3n_:<w\u000eJ2pe\u0016$c.\u001a;us\u0012\u001a\u0005.\u00198oK24\u0015m\u0019;pef$CeY8o]\u0016\u001cG/[8o\u0003\u001dy\u0007\u000f^5p]N\u0004\"!\u00193\u000e\u0003\tT!aY\u001b\u0002\u0007\u0005\u0004\u0018.\u0003\u0002fE\n1Rj\u001c8h_\u000e{gN\\3di&|gn\u00149uS>t7/\u0001\u0004=S:LGO\u0010\u000b\u0005Q*dg\u000e\u0005\u0002j\u00015\t\u0011\u0007C\u0003l\t\u0001\u0007A+\u0001\u0006tkB,'O^5t_JDQ!\u001c\u0003A\u0002Q\u000b!bY8o]\u0016\u001cG/[8o\u0011\u0015yF\u00011\u0001a\u00035\u0012X-Y2uSZ,Wn\u001c8h_\u0012\u001awN]3%]\u0016$H/\u001f\u0013DQ\u0006tg.\u001a7GC\u000e$xN]=%IA\f7m[\u000b\u0002cB\u0011\u0011N]\u0005\u0003gF\u0012A\u0001U1dW\u0006q#/Z1di&4X-\\8oO>$3m\u001c:fI9,G\u000f^=%\u0007\"\fgN\\3m\r\u0006\u001cGo\u001c:zI\u0011\u0002\u0018mY6!\u0003Q\u0012X-Y2uSZ,Wn\u001c8h_\u0012\u001awN]3%]\u0016$H/\u001f\u0013DQ\u0006tg.\u001a7GC\u000e$xN]=%IA\f'/\u001a8u\u000fJ|W\u000f]\u000b\u0002oB\u0011\u0011\b_\u0005\u0003s>\u0013a\"\u0012<f]Rdun\u001c9He>,\b/A\u001bsK\u0006\u001cG/\u001b<f[>twm\u001c\u0013d_J,GE\\3uif$3\t[1o]\u0016dg)Y2u_JLH\u0005\n9be\u0016tGo\u0012:pkB\u0004\u0013a\f:fC\u000e$\u0018N^3n_:<w\u000eJ2pe\u0016$c.\u001a;us\u0012\u001a\u0005.\u00198oK24\u0015m\u0019;pef$C\u0005\\8hO\u0016\u0014X#A?\u0011\u0007y\fYAD\u0002\u0000\u0003\u000bq1!PA\u0001\u0013\r\t\u0019!N\u0001\u0005kRLG.\u0003\u0003\u0002\b\u0005%\u0011A\u0003'bufdunZ4fe*\u0019\u00111A\u001b\n\t\u00055\u0011q\u0002\u0002\u000b\u0019\u0006T\u0018\u0010T8hO\u0016\u0014(\u0002BA\u0004\u0003\u0013\t\u0001G]3bGRLg/Z7p]\u001e|GeY8sK\u0012rW\r\u001e;zI\rC\u0017M\u001c8fY\u001a\u000b7\r^8ss\u0012\"Cn\\4hKJ\u0004\u0013a\r:fC\u000e$\u0018N^3n_:<w\u000eJ2pe\u0016$c.\u001a;us\u0012\u001a\u0005.\u00198oK24\u0015m\u0019;pef$C\u0005^2q\u001d>$U\r\\1z+\t\t9\u0002\u0005\u0003\u0002\u001a\u0005\rRBAA\u000e\u0015\u0011\ti\"a\b\u0002\t1\fgn\u001a\u0006\u0003\u0003C\tAA[1wC&!\u0011QEA\u000e\u0005\u001d\u0011un\u001c7fC:\fAG]3bGRLg/Z7p]\u001e|GeY8sK\u0012rW\r\u001e;zI\rC\u0017M\u001c8fY\u001a\u000b7\r^8ss\u0012\"Co\u00199O_\u0012+G.Y=!\u0003I\u0012X-Y2uSZ,Wn\u001c8h_\u0012\u001awN]3%]\u0016$H/\u001f\u0013DQ\u0006tg.\u001a7GC\u000e$xN]=%I-,W\r]!mSZ,\u0017a\r:fC\u000e$\u0018N^3n_:<w\u000eJ2pe\u0016$c.\u001a;us\u0012\u001a\u0005.\u00198oK24\u0015m\u0019;pef$Ce[3fa\u0006c\u0017N^3!\u0003I\u0012X-Y2uSZ,Wn\u001c8h_\u0012\u001awN]3%]\u0016$H/\u001f\u0013DQ\u0006tg.\u001a7GC\u000e$xN]=%IQLW.Z8vi6\u001bXCAA\u0019!\u0011\tI\"a\r\n\t\u0005U\u00121\u0004\u0002\b\u0013:$XmZ3s\u0003M\u0012X-Y2uSZ,Wn\u001c8h_\u0012\u001awN]3%]\u0016$H/\u001f\u0013DQ\u0006tg.\u001a7GC\u000e$xN]=%IQLW.Z8vi6\u001b\b%\u0001\u0004de\u0016\fG/\u001a\u000b\u000b\u0003{\t9%a\u0013\u0002X\u0005m\u0003#BA \u0003\u0007\u0002VBAA!\u0015\r\t\u0019aV\u0005\u0005\u0003\u000b\n\tEA\u0002UefD\u0001\"!\u0013\u0012!\u0003\u0005\r\u0001V\u0001\u0005Q>\u001cH\u000fC\u0005\u0002NE\u0001\n\u00111\u0001\u0002P\u0005!\u0001o\u001c:u!\u0011\t\t&a\u0015\u000e\u0003]K1!!\u0016X\u0005\rIe\u000e\u001e\u0005\n\u00033\n\u0002\u0013!a\u0001\u0003\u001f\nQ\"\\1y\u0013\u0012dW\rV5nK6\u001b\u0006bBA/#\u0001\u0007\u0011qL\u0001\te\u0016\u001cW-\u001b<feB!\u0011\u0011MA6\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014!B1di>\u0014(BAA5\u0003\u0011\t7n[1\n\t\u00055\u00141\r\u0002\t\u0003\u000e$xN\u001d*fM\u0006\u00012M]3bi\u0016$C-\u001a4bk2$H%M\u000b\u0003\u0003gR3\u0001VA;W\t\t9\b\u0005\u0003\u0002z\u0005\rUBAA>\u0015\u0011\ti(a \u0002\u0013Ut7\r[3dW\u0016$'bAAA/\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00151\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001E2sK\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00133+\t\tYI\u000b\u0003\u0002P\u0005U\u0014\u0001E2sK\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00134\u0003-Ig.\u001b;DQ\u0006tg.\u001a7\u0015\t\u0005M\u0015\u0011\u0014\t\u0005\u0003#\n)*C\u0002\u0002\u0018^\u0013A!\u00168ji\")\u0001*\u0006a\u0001!Ra\u00111SAO\u0003?\u000b\t+a)\u0002&\")\u0001J\u0006a\u0001!\"1\u0011\u0011\n\fA\u0002QCq!!\u0014\u0017\u0001\u0004\ty\u0005C\u0004\u0002ZY\u0001\r!a\u0014\t\u000f\u0005uc\u00031\u0001\u0002`\u0005A1.Z=Ti>\u0014X-\u0006\u0002\u0002,B1\u0011\u0011KAW\u0003cK1!a,X\u0005\u0019y\u0005\u000f^5p]B!\u00111WA]\u001d\r\t\u0017QW\u0005\u0004\u0003o\u0013\u0017AF'p]\u001e|7i\u001c8oK\u000e$\u0018n\u001c8PaRLwN\\:\n\t\u0005m\u0016Q\u0018\u0002\t\u0017\u0016L8\u000b^8sK*\u0019\u0011q\u00172\u0002\u0015M\u001cHnQ8oi\u0016DH/\u0006\u0002\u0002DB!\u0011QYAj\u001b\t\t9M\u0003\u0003\u0002J\u0006-\u0017aA:tY*!\u0011QZAh\u0003\rqW\r\u001e\u0006\u0003\u0003#\fQA[1wCbLA!!6\u0002H\nQ1k\u0015'D_:$X\r\u001f;\u0002\u001d\rD\u0017M\u001c8fY\u001a\u000b7\r^8ssR\u0011\u00111\u001c\t\u0005\u0003;\f9/\u0004\u0002\u0002`*!\u0011\u0011]Ar\u0003%\u0011wn\u001c;tiJ\f\u0007OC\u00023\u0003KT\u0011\u0001R\u0005\u0005\u0003S\fyNA\u0005C_>$8\u000f\u001e:ba\"\u001a\u0011$!<\u0011\t\u0005E\u0013q^\u0005\u0004\u0003c<&AB5oY&tW-A\u0004sK2,\u0017m]3\u0015\r\u0005M\u0015q\u001fB\u0004\u0011\u001d\tIP\u0007a\u0001\u0003w\f\u0001bY1mY\n\f7m\u001b\t\u0007\u0003{\u0014\u0019!a%\u000e\u0005\u0005}(b\u0001B\u0001/\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\t\u0015\u0011q \u0002\b!J|W.[:f\u0011\u001d\u0011IA\u0007a\u0001\u0005\u0017\tq\u0001^5nK>,H\u000f\u0005\u0003\u0003\u000e\tMQB\u0001B\b\u0015\u0011\u0011\t\"a@\u0002\u0011\u0011,(/\u0019;j_:LAA!\u0006\u0003\u0010\tqa)\u001b8ji\u0016$UO]1uS>t\u0017!\u00023fEV<G\u0003BAJ\u00057A\u0001B!\b\u001c\t\u0003\u0007!qD\u0001\u0004[N<\u0007#BA)\u0005C!\u0016b\u0001B\u0012/\nAAHY=oC6,g\bK\u0002\u001c\u0003[$b!a%\u0003*\t-\u0002\u0002\u0003B\u000f9\u0011\u0005\rAa\b\t\u000f\t5B\u00041\u0001\u00030\u0005)1-Y;tKB!!\u0011\u0007B\u001d\u001d\u0011\u0011\u0019Da\u000e\u000f\u0007y\u0012)$C\u0001Y\u0013\tYu+\u0003\u0003\u0003<\tu\"!\u0003+ie><\u0018M\u00197f\u0015\tYu\u000bK\u0002\u001d\u0003[\fQ\u0001\u001e:bG\u0016$B!a%\u0003F!A!QD\u000f\u0005\u0002\u0004\u0011y\u0002K\u0002\u001e\u0003[\fA!\u001b8g_R!\u00111\u0013B'\u0011!\u0011iB\bCA\u0002\t}\u0001f\u0001\u0010\u0002n\u0006AAK];ti\u0006s\u0017\u0010E\u0002\u0003V\u0001j\u0011\u0001\u0001\u0002\t)J,8\u000f^!osN)\u0001Ea\u0017\u0003bA!\u0011\u0011\u0004B/\u0013\u0011\u0011y&a\u0007\u0003\r=\u0013'.Z2u!\u0011\t)Ma\u0019\n\t\t\u0015\u0014q\u0019\u0002\u00111V\u0002\u0014\b\u0016:vgRl\u0015M\\1hKJ$\"Aa\u0015\u0002%\rDWmY6DY&,g\u000e\u001e+skN$X\r\u001a\u000b\u0007\u0003'\u0013iGa\"\t\u000f\t=$\u00051\u0001\u0003r\u0005\u00111m\u001d\t\u0007\u0003#\u0012\u0019Ha\u001e\n\u0007\tUtKA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0003z\t\rUB\u0001B>\u0015\u0011\u0011iHa \u0002\t\r,'\u000f\u001e\u0006\u0005\u0005\u0003\u000by\"\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\u0011)Ia\u001f\u0003\u001fa+\u0004'O\"feRLg-[2bi\u0016DaA!##\u0001\u0004!\u0016!A1\u0002%\rDWmY6TKJ4XM\u001d+skN$X\r\u001a\u000b\u0007\u0003'\u0013yI!%\t\u000f\t=4\u00051\u0001\u0003r!1!\u0011R\u0012A\u0002Q\u000b!cZ3u\u0003\u000e\u001cW\r\u001d;fI&\u001b8/^3sgR\u0011!\u0011O\u0001\u000f\u0007\"\fgN\\3m\r\u0006\u001cGo\u001c:z!\tIgeE\u0002'\u0005;\u0003B!!\u0015\u0003 &\u0019!\u0011U,\u0003\r\u0005s\u0017PU3g)\t\u0011I*A\u0004i_N$8*Z=\u0016\u0005\t%\u0006#\u0002BV\u0005_#VB\u0001BW\u0015\u0011\t\u0019!a9\n\t\tE&Q\u0016\u0002\r\u0003R$(/\u001b2vi\u0016\\U-_\u0001\tQ>\u001cHoS3zA\u00059\u0001o\u001c:u\u0017\u0016LXC\u0001B]!\u0019\u0011YKa,\u0002P\u0005A\u0001o\u001c:u\u0017\u0016L\b%A\u0006bGR|'OU3g\u0017\u0016LXC\u0001Ba!\u0019\u0011YKa,\u0002`\u0005a\u0011m\u0019;peJ+gmS3zA\u0005qQ.\u0019=JI2,G+[7f\u0017\u0016L\u0018aD7bq&#G.\u001a+j[\u0016\\U-\u001f\u0011")
public final class ChannelFactory
extends ChannelInitializer<Channel> {
    private volatile ChannelFactory$TrustAny$ TrustAny$module;
    public final String reactivemongo$core$netty$ChannelFactory$$supervisor;
    public final String reactivemongo$core$netty$ChannelFactory$$connection;
    private final MongoConnectionOptions options;
    private final Pack reactivemongo$core$netty$ChannelFactory$$pack;
    private final EventLoopGroup reactivemongo$core$netty$ChannelFactory$$parentGroup;
    private final LazyLogger.LazyLogger reactivemongo$core$netty$ChannelFactory$$logger;
    private final Boolean reactivemongo$core$netty$ChannelFactory$$tcpNoDelay;
    private final Boolean reactivemongo$core$netty$ChannelFactory$$keepAlive;
    private final Integer reactivemongo$core$netty$ChannelFactory$$timeoutMs;

    public static AttributeKey<Object> maxIdleTimeKey() {
        return ChannelFactory$.MODULE$.maxIdleTimeKey();
    }

    public static AttributeKey<ActorRef> actorRefKey() {
        return ChannelFactory$.MODULE$.actorRefKey();
    }

    public static AttributeKey<Object> portKey() {
        return ChannelFactory$.MODULE$.portKey();
    }

    public static AttributeKey<String> hostKey() {
        return ChannelFactory$.MODULE$.hostKey();
    }

    private ChannelFactory$TrustAny$ TrustAny() {
        if (this.TrustAny$module == null) {
            this.TrustAny$lzycompute$1();
        }
        return this.TrustAny$module;
    }

    public Pack reactivemongo$core$netty$ChannelFactory$$pack() {
        return this.reactivemongo$core$netty$ChannelFactory$$pack;
    }

    public EventLoopGroup reactivemongo$core$netty$ChannelFactory$$parentGroup() {
        return this.reactivemongo$core$netty$ChannelFactory$$parentGroup;
    }

    public LazyLogger.LazyLogger reactivemongo$core$netty$ChannelFactory$$logger() {
        return this.reactivemongo$core$netty$ChannelFactory$$logger;
    }

    public Boolean reactivemongo$core$netty$ChannelFactory$$tcpNoDelay() {
        return this.reactivemongo$core$netty$ChannelFactory$$tcpNoDelay;
    }

    public Boolean reactivemongo$core$netty$ChannelFactory$$keepAlive() {
        return this.reactivemongo$core$netty$ChannelFactory$$keepAlive;
    }

    public Integer reactivemongo$core$netty$ChannelFactory$$timeoutMs() {
        return this.reactivemongo$core$netty$ChannelFactory$$timeoutMs;
    }

    public Try<Channel> create(String host, int port, int maxIdleTimeMS, ActorRef receiver) {
        Failure failure;
        if (this.reactivemongo$core$netty$ChannelFactory$$parentGroup().isShuttingDown() || this.reactivemongo$core$netty$ChannelFactory$$parentGroup().isShutdown() || this.reactivemongo$core$netty$ChannelFactory$$parentGroup().isTerminated()) {
            String msg = new StringBuilder(50).append("Cannot create channel to '").append(host).append(":").append(port).append("' from inactive factory").toString();
            this.info((Function0<String>)(Function0 & Serializable)() -> msg);
            failure = new Failure((Throwable)new GenericDriverException(new StringBuilder(4).append(msg).append(" (").append(this.reactivemongo$core$netty$ChannelFactory$$supervisor).append("/").append(this.reactivemongo$core$netty$ChannelFactory$$connection).append(")").toString(), GenericDriverException$.MODULE$.$lessinit$greater$default$2()));
        } else {
            Bootstrap f = this.channelFactory();
            f.attr(ChannelFactory$.MODULE$.hostKey(), (Object)host);
            f.attr(ChannelFactory$.MODULE$.portKey(), (Object)BoxesRunTime.boxToInteger((int)port));
            f.attr(ChannelFactory$.MODULE$.actorRefKey(), (Object)receiver);
            f.attr(ChannelFactory$.MODULE$.maxIdleTimeKey(), (Object)BoxesRunTime.boxToInteger((int)maxIdleTimeMS));
            ChannelFuture resolution = f.connect(host, port).addListener((GenericFutureListener)new ChannelFutureListener(this, host, port, receiver){
                private final /* synthetic */ ChannelFactory $outer;
                private final String host$1;
                private final int port$1;
                private final ActorRef receiver$1;

                public void operationComplete(ChannelFuture op) {
                    block0: {
                        if (op.isSuccess()) break block0;
                        ChannelId chanId = op.channel().id();
                        this.$outer.reactivemongo$core$netty$ChannelFactory$$debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Connection to ").append($this.host$1).append(":").append($this.port$1).append(" refused for channel #").append(chanId).toString(), op.cause());
                        ScalaActorRef qual$1 = akka.actor.package$.MODULE$.actorRef2Scala(this.receiver$1);
                        ChannelDisconnected x$1 = new ChannelDisconnected(chanId);
                        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
                        qual$1.$bang((Object)x$1, x$2);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.host$1 = host$1;
                    this.port$1 = port$1;
                    this.receiver$1 = receiver$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$operationComplete$1(reactivemongo.core.netty.ChannelFactory$$anon$1 io.netty.channel.ChannelId )}, serializedLambda);
                }
            });
            Channel channel = resolution.channel();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Created new channel #").append(channel.id()).append(" to ").append(host).append(":").append(port).append(" (registered = ").append(channel.isRegistered()).append(")").toString());
            failure = new Success((Object)channel);
        }
        return failure;
    }

    public String create$default$1() {
        return "localhost";
    }

    public int create$default$2() {
        return 27017;
    }

    public int create$default$3() {
        return this.options.maxIdleTimeMS();
    }

    public void initChannel(Channel channel) {
        String host = (String)channel.attr(ChannelFactory$.MODULE$.hostKey()).get();
        int port = BoxesRunTime.unboxToInt((Object)channel.attr(ChannelFactory$.MODULE$.portKey()).get());
        int maxIdleTimeMS = BoxesRunTime.unboxToInt((Object)channel.attr(ChannelFactory$.MODULE$.maxIdleTimeKey()).get());
        ActorRef receiver = (ActorRef)channel.attr(ChannelFactory$.MODULE$.actorRefKey()).get();
        this.initChannel(channel, host, port, maxIdleTimeMS, receiver);
    }

    public void initChannel(Channel channel, String host, int port, int maxIdleTimeMS, ActorRef receiver) {
        BoxedUnit boxedUnit;
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Initializing channel ").append(channel.id()).append(" to ").append(host).append(":").append(port).append(" (").append(receiver).append(")").toString());
        ChannelPipeline pipeline = channel.pipeline();
        long idleTimeMS = maxIdleTimeMS;
        pipeline.addLast("idleState", (ChannelHandler)new IdleStateHandler(idleTimeMS, idleTimeMS, 0L, TimeUnit.MILLISECONDS));
        if (this.options.sslEnabled()) {
            SSLEngine sslEng = SSL.createEngine(this.sslContext(), host, port);
            SslHandler sslHandler = new SslHandler(sslEng, false);
            boxedUnit = pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        pipeline.addLast(new ChannelHandler[]{new ResponseFrameDecoder(), new ResponseDecoder(), new RequestEncoder(), new MongoHandler(this.reactivemongo$core$netty$ChannelFactory$$supervisor, this.reactivemongo$core$netty$ChannelFactory$$connection, receiver)});
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(126).append("Netty channel configuration:\n- connectTimeoutMS: ").append($this.options.connectTimeoutMS()).append("\n- maxIdleTimeMS: ").append($this.options.maxIdleTimeMS()).append("ms\n- tcpNoDelay: ").append($this.options.tcpNoDelay()).append("\n- keepAlive: ").append($this.options.keepAlive()).append("\n- sslEnabled: ").append($this.options.sslEnabled()).append("\n- keyStore: ").append($this.options.keyStore().fold((Function0 & Serializable)() -> "None", (Function1 & Serializable)x$1 -> x$1.toString())).toString());
    }

    private Option<MongoConnectionOptions.KeyStore> keyStore() {
        return this.options.keyStore().orElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.props().get("javax.net.ssl.keyStore").map((Function1 & Serializable)path -> {
            URI x$1 = new File((String)path).toURI();
            String x$22 = (String)scala.sys.package$.MODULE$.props().getOrElse((Object)"javax.net.ssl.keyStoreType", (Function0 & Serializable)() -> "JKS");
            Option x$3 = scala.sys.package$.MODULE$.props().get("javax.net.ssl.keyStorePassword").map((Function1 & Serializable)x$2 -> x$2.toCharArray());
            boolean x$4 = true;
            return MongoConnectionOptions$KeyStore$.MODULE$.apply(x$1, (Option<char[]>)x$3, x$22, true);
        }));
    }

    private SSLContext sslContext() {
        LazyRef loadedStore$lzy = new LazyRef();
        Option keyManagers = this.loadedStore$1(loadedStore$lzy).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            KeyStore ks = (KeyStore)tuple2._1();
            char[] password = (char[])tuple2._2();
            KeyManagerFactory res = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            res.init(ks, password);
            KeyManagerFactory kmf = res;
            KeyManager[] keyManagerArray = kmf.getKeyManagers();
            return keyManagerArray;
        });
        return this.sslCtx$1(keyManagers, loadedStore$lzy);
    }

    private Bootstrap channelFactory() {
        return (Bootstrap)new Bootstrap().group(this.reactivemongo$core$netty$ChannelFactory$$parentGroup()).channel(this.reactivemongo$core$netty$ChannelFactory$$pack().channelClass()).option(package.ChannelOption$.MODULE$.TCP_NODELAY(), (Object)this.reactivemongo$core$netty$ChannelFactory$$tcpNoDelay()).option(package.ChannelOption$.MODULE$.SO_KEEPALIVE(), (Object)this.reactivemongo$core$netty$ChannelFactory$$keepAlive()).option(package.ChannelOption$.MODULE$.CONNECT_TIMEOUT_MILLIS(), (Object)this.reactivemongo$core$netty$ChannelFactory$$timeoutMs()).handler((ChannelHandler)this);
    }

    public void release(Promise<BoxedUnit> callback, FiniteDuration timeout) {
        if (this.reactivemongo$core$netty$ChannelFactory$$parentGroup().iterator().hasNext()) {
            this.reactivemongo$core$netty$ChannelFactory$$parentGroup().shutdownGracefully(0L, timeout.length(), timeout.unit()).addListener((GenericFutureListener)new GenericFutureListener<Future<Object>>(this, callback){
                private final /* synthetic */ ChannelFactory $outer;
                private final Promise callback$1;

                public void operationComplete(Future<Object> f) {
                    ChannelFactory.reactivemongo$core$netty$ChannelFactory$$ok$1(this.callback$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.callback$1 = callback$1;
                }
            });
        } else {
            ChannelFactory.reactivemongo$core$netty$ChannelFactory$$ok$1(callback);
        }
    }

    private void debug(Function0<String> msg) {
        this.reactivemongo$core$netty$ChannelFactory$$logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(4).append("[").append($this.reactivemongo$core$netty$ChannelFactory$$supervisor).append("/").append($this.reactivemongo$core$netty$ChannelFactory$$connection).append("] ").append(msg.apply()).toString());
    }

    public void reactivemongo$core$netty$ChannelFactory$$debug(Function0<String> msg, Throwable cause) {
        this.reactivemongo$core$netty$ChannelFactory$$logger().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(4).append("[").append($this.reactivemongo$core$netty$ChannelFactory$$supervisor).append("/").append($this.reactivemongo$core$netty$ChannelFactory$$connection).append("] ").append(msg.apply()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> cause);
    }

    private void trace(Function0<String> msg) {
        this.reactivemongo$core$netty$ChannelFactory$$logger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(4).append("[").append($this.reactivemongo$core$netty$ChannelFactory$$supervisor).append("/").append($this.reactivemongo$core$netty$ChannelFactory$$connection).append("] ").append(msg.apply()).toString());
    }

    private void info(Function0<String> msg) {
        this.reactivemongo$core$netty$ChannelFactory$$logger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(4).append("[").append($this.reactivemongo$core$netty$ChannelFactory$$supervisor).append("/").append($this.reactivemongo$core$netty$ChannelFactory$$connection).append("] ").append(msg.apply()).toString());
    }

    private final void TrustAny$lzycompute$1() {
        ChannelFactory channelFactory = this;
        synchronized (channelFactory) {
            if (this.TrustAny$module == null) {
                this.TrustAny$module = new ChannelFactory$TrustAny$(this);
            }
        }
    }

    private final /* synthetic */ Option loadedStore$lzycompute$1(LazyRef loadedStore$lzy$1) {
        Option option;
        LazyRef lazyRef = loadedStore$lzy$1;
        synchronized (lazyRef) {
            option = loadedStore$lzy$1.initialized() ? (Option)loadedStore$lzy$1.value() : (Option)loadedStore$lzy$1.initialize((Object)this.keyStore().map((Function1 & Serializable)settings -> {
                char[] password = (char[])settings.password().getOrElse((Function0 & Serializable)() -> (char[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Char()));
                return (Tuple2)package$.MODULE$.withContent(settings.resource(), (Function1 & Serializable)storeIn -> {
                    KeyStore res = KeyStore.getInstance(settings.storeType());
                    res.load((InputStream)storeIn, password);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)res), (Object)password);
                });
            }));
        }
        return option;
    }

    private final Option loadedStore$1(LazyRef loadedStore$lzy$1) {
        return loadedStore$lzy$1.initialized() ? (Option)loadedStore$lzy$1.value() : this.loadedStore$lzycompute$1(loadedStore$lzy$1);
    }

    private final boolean trust$1() {
        return BoxesRunTime.unboxToBoolean((Object)this.keyStore().fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> true, (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.trust())));
    }

    /*
     * WARNING - void declaration
     */
    private final SSLContext sslCtx$1(Option keyManagers$1, LazyRef loadedStore$lzy$1) {
        void var3_3;
        SSLContext res = SSLContext.getInstance("SSL");
        TrustManager[] tm = this.options.sslAllowsInvalidCert() ? (TrustManager[])((Object[])new TrustManager[]{this.TrustAny()}) : (!this.trust$1() ? null : (TrustManager[])this.loadedStore$1(loadedStore$lzy$1).fold((Function0 & Serializable)() -> null, (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            KeyStore ks = (KeyStore)tuple2._1();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            TrustManager[] trustManagerArray = tmf.getTrustManagers();
            return trustManagerArray;
        }));
        Random rand = new Random(System.identityHashCode(tm));
        byte[] seed = (byte[])Array$.MODULE$.ofDim(128, (ClassTag)ClassTag$.MODULE$.Byte());
        rand.nextBytes(seed);
        res.init((KeyManager[])keyManagers$1.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), tm, new SecureRandom(seed));
        return var3_3;
    }

    public static final void reactivemongo$core$netty$ChannelFactory$$ok$1(Promise callback$1) {
        callback$1.success((Object)BoxedUnit.UNIT);
    }

    public ChannelFactory(String supervisor, String connection, MongoConnectionOptions options) {
        this.reactivemongo$core$netty$ChannelFactory$$supervisor = supervisor;
        this.reactivemongo$core$netty$ChannelFactory$$connection = connection;
        this.options = options;
        this.reactivemongo$core$netty$ChannelFactory$$pack = Pack$.MODULE$.apply();
        this.reactivemongo$core$netty$ChannelFactory$$parentGroup = (EventLoopGroup)this.reactivemongo$core$netty$ChannelFactory$$pack().eventLoopGroup().apply();
        this.reactivemongo$core$netty$ChannelFactory$$logger = LazyLogger$.MODULE$.apply("reactivemongo.core.nodeset.ChannelFactory");
        this.reactivemongo$core$netty$ChannelFactory$$tcpNoDelay = options.tcpNoDelay();
        this.reactivemongo$core$netty$ChannelFactory$$keepAlive = options.keepAlive();
        this.reactivemongo$core$netty$ChannelFactory$$timeoutMs = options.connectTimeoutMS();
    }
}

