/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.protocol;

import akka.actor.ActorRef;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.IdleStateEvent;
import java.io.Serializable;
import reactivemongo.core.actors.ChannelConnected;
import reactivemongo.core.actors.ChannelDisconnected;
import reactivemongo.core.protocol.MongoHandler$;
import reactivemongo.core.protocol.Response;
import reactivemongo.io.netty.channel.package;
import reactivemongo.util.LazyLogger;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005}e!B\f\u0019\u0001qq\u0002\u0002\u0004 \u0001\t\u0003\u0005)Q!A!\u0002\u0013y\u0004\u0002D%\u0001\t\u0003\u0005)Q!A!\u0002\u0013y\u0004\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u000bM\u0003A\u0011\u0001+\t\u000fq\u0003\u0001\u0019!C\u0005;\"9!\r\u0001a\u0001\n\u0013\u0019\u0007BB5\u0001A\u0003&a\fC\u0003k\u0001\u0011\u00053\u000eC\u0003r\u0001\u0011\u0005#\u000fC\u0003z\u0001\u0011\u0005#\u0010C\u0004\u0002\u0014\u0001!\t%!\u0006\t\u000f\u0005u\u0001\u0001\"\u0011\u0002 !9\u0011q\u0006\u0001\u0005B\u0005E\u0002bBA%\u0001\u0011\u0005\u00131\n\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\t\t\u0007\u0001C\u0001\u0003GBq!!\u0019\u0001\t\u0003\tYg\u0002\u0005\u0002vaA\t\u0001HA<\r\u001d9\u0002\u0004#\u0001\u001d\u0003sBaaU\n\u0005\u0002\u0005\u0005\u0005\"CAB'\t\u0007I\u0011AAC\u0011!\tij\u0005Q\u0001\n\u0005\u001d%\u0001D'p]\u001e|\u0007*\u00198eY\u0016\u0014(BA\r\u001b\u0003!\u0001(o\u001c;pG>d'BA\u000e\u001d\u0003\u0011\u0019wN]3\u000b\u0003u\tQB]3bGRLg/Z7p]\u001e|7c\u0001\u0001 SA\u0011\u0001eJ\u0007\u0002C)\u0011!eI\u0001\bG\"\fgN\\3m\u0015\t!S%A\u0003oKR$\u0018PC\u0001'\u0003\tIw.\u0003\u0002)C\t!2\t[1o]\u0016dG)\u001e9mKbD\u0015M\u001c3mKJ\u0004\"A\u000b\u001f\u000f\u0005-JdB\u0001\u00178\u001d\tiSG\u0004\u0002/i9\u0011qfM\u0007\u0002a)\u0011\u0011GM\u0001\u0007yI|w\u000e\u001e \u0004\u0001%\tQ$\u0003\u0002'9%\u0011AE\u000e\u0006\u0003MqI!A\t\u001d\u000b\u0005\u00112\u0014B\u0001\u001e<\u0003\u001d\u0001\u0018mY6bO\u0016T!A\t\u001d\n\u0005!j$B\u0001\u001e<\u0003Q\u0012X-Y2uSZ,Wn\u001c8h_\u0012\u001awN]3%aJ|Go\\2pY\u0012juN\\4p\u0011\u0006tG\r\\3sI\u0011\u001aX\u000f]3sm&\u001cxN\u001d\t\u0003\u0001\u001as!!\u0011#\u0011\u0005=\u0012%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013\u0015A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!\u0012\"\u0002iI,\u0017m\u0019;jm\u0016lwN\\4pI\r|'/\u001a\u0013qe>$xnY8mI5{gnZ8IC:$G.\u001a:%I\r|gN\\3di&|g.\u0001\u0005sK\u000e,\u0017N^3s!\ta\u0015+D\u0001N\u0015\tqu*A\u0003bGR|'OC\u0001Q\u0003\u0011\t7n[1\n\u0005Ik%\u0001C!di>\u0014(+\u001a4\u0002\rqJg.\u001b;?)\u0011)v+W.\u0011\u0005Y\u0003Q\"\u0001\r\t\u000ba#\u0001\u0019A \u0002\u0015M,\b/\u001a:wSN|'\u000fC\u0003[\t\u0001\u0007q(\u0001\u0006d_:tWm\u0019;j_:DQA\u0013\u0003A\u0002-\u000bA\u0001\\1tiV\ta\f\u0005\u0002`A6\t!)\u0003\u0002b\u0005\n!Aj\u001c8h\u0003!a\u0017m\u001d;`I\u0015\fHC\u00013h!\tyV-\u0003\u0002g\u0005\n!QK\\5u\u0011\u001dAg!!AA\u0002y\u000b1\u0001\u001f\u00132\u0003\u0015a\u0017m\u001d;!\u00035\u0019\u0007.\u00198oK2\f5\r^5wKR\u0011A\r\u001c\u0005\u0006[\"\u0001\rA\\\u0001\u0004GRD\bC\u0001\u0016p\u0013\t\u0001XHA\u000bDQ\u0006tg.\u001a7IC:$G.\u001a:D_:$X\r\u001f;\u0002%U\u001cXM]#wK:$HK]5hO\u0016\u0014X\r\u001a\u000b\u0004IN$\b\"B7\n\u0001\u0004q\u0007\"B;\n\u0001\u00041\u0018aA3wiB\u0011ql^\u0005\u0003q\n\u00131!\u00118z\u0003=\u0019\u0007.\u00198oK2Le.Y2uSZ,GC\u00013|\u0011\u0015i'\u00021\u0001oQ\u0019QQ0a\u0003\u0002\u000eA\u0019a0a\u0002\u000e\u0003}TA!!\u0001\u0002\u0004\u0005!A.\u00198h\u0015\t\t)!\u0001\u0003kCZ\f\u0017bAA\u0005\u007f\n\u00012+\u001e9qe\u0016\u001c8oV1s]&twm]\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003\u001f\t#!!\u0005\u0002\u001b9+H\u000e\u001c)be\u0006lW\r^3s\u0003-\u0019\u0007.\u00198oK2\u0014V-\u00193\u0015\u000b\u0011\f9\"!\u0007\t\u000b5\\\u0001\u0019\u00018\t\r\u0005m1\u00021\u0001w\u0003\ri7oZ\u0001\u0006oJLG/\u001a\u000b\bI\u0006\u0005\u00121EA\u0013\u0011\u0015iG\u00021\u0001o\u0011\u0019\tY\u0002\u0004a\u0001m\"9\u0011q\u0005\u0007A\u0002\u0005%\u0012a\u00029s_6L7/\u001a\t\u0004U\u0005-\u0012bAA\u0017{\tq1\t[1o]\u0016d\u0007K]8nSN,\u0017aD3yG\u0016\u0004H/[8o\u0007\u0006,x\r\u001b;\u0015\u000b\u0011\f\u0019$!\u000e\t\u000b5l\u0001\u0019\u00018\t\u000f\u0005]R\u00021\u0001\u0002:\u0005)1-Y;tKB!\u00111HA\"\u001d\u0011\ti$!\u0011\u000f\u0007=\ny$C\u0001D\u0013\tQ$)\u0003\u0003\u0002F\u0005\u001d#!\u0003+ie><\u0018M\u00197f\u0015\tQ$)\u0001\u0007iC:$G.\u001a:BI\u0012,G\rF\u0002e\u0003\u001bBQ!\u001c\bA\u00029\fAa^1s]R)A-a\u0015\u0002V!)Qn\u0004a\u0001]\"1\u0011qK\bA\u0002}\n\u0011a\u001d\u0015\u0004\u001f\u0005m\u0003cA0\u0002^%\u0019\u0011q\f\"\u0003\r%tG.\u001b8f\u0003\rawn\u001a\u000b\u0006I\u0006\u0015\u0014q\r\u0005\u0006[B\u0001\rA\u001c\u0005\u0007\u0003/\u0002\u0002\u0019A )\u0007A\tY\u0006F\u0004e\u0003[\ny'!\u001d\t\u000b5\f\u0002\u0019\u00018\t\r\u0005]\u0013\u00031\u0001@\u0011\u001d\t9$\u0005a\u0001\u0003sA3!EA.\u00031iuN\\4p\u0011\u0006tG\r\\3s!\t16cE\u0002\u0014\u0003w\u00022aXA?\u0013\r\tyH\u0011\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005]\u0014A\u00027pO\u001e,'/\u0006\u0002\u0002\bB!\u0011\u0011RAL\u001d\u0011\tY)!%\u000f\u00079\ni)C\u0002\u0002\u0010r\tA!\u001e;jY&!\u00111SAK\u0003)a\u0015M_=M_\u001e<WM\u001d\u0006\u0004\u0003\u001fc\u0012\u0002BAM\u00037\u0013!\u0002T1{s2{wmZ3s\u0015\u0011\t\u0019*!&\u0002\u000f1|wmZ3sA\u0001")
public class MongoHandler
extends ChannelDuplexHandler
implements package.ChannelDuplexHandler {
    public final String reactivemongo$core$protocol$MongoHandler$$supervisor;
    public final String reactivemongo$core$protocol$MongoHandler$$connection;
    private final ActorRef receiver;
    private long last;

    public static LazyLogger.LazyLogger logger() {
        return MongoHandler$.MODULE$.logger();
    }

    private long last() {
        return this.last;
    }

    private void last_$eq(long x$1) {
        this.last = x$1;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.log(ctx, "Channel is active");
        this.last_$eq(System.nanoTime());
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.receiver);
        ChannelConnected x$1 = new ChannelConnected(ctx.channel().id());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
        super.channelActive(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        BoxedUnit boxedUnit;
        Object object = evt;
        if (object instanceof IdleStateEvent) {
            if (this.last() != -1L) {
                long now = System.nanoTime();
                this.log(ctx, new StringBuilder(40).append("Channel has been inactive for ").append(now - this.last()).append(" (last = ").append(this.last()).append(")").toString());
            }
            boxedUnit = ctx.channel().close();
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        super.userEventTriggered(ctx, evt);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        long now = System.nanoTime();
        if (this.last() != -1L) {
            Channel chan = ctx.channel();
            long delay = now - this.last();
            if (delay < 500000000L) {
                this.warn(ctx, new StringBuilder(62).append(MongoHandler.msg$1(delay, chan)).append("; Please check network connectivity and the status of the set.").toString());
            } else if (chan.remoteAddress() != null) {
                this.log(ctx, MongoHandler.msg$1(delay, chan));
            }
            this.last_$eq(now);
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.receiver);
            ChannelDisconnected x$1 = new ChannelDisconnected(chan.id());
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
        }
        super.channelInactive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.last_$eq(System.nanoTime());
        Object object = msg;
        if (object instanceof Response) {
            Response response = (Response)object;
            this.log(ctx, new StringBuilder(43).append("Channel received message ").append(response).append("; Will be send to ").append(this.receiver.path()).toString());
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.receiver);
            Response x$1 = response;
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.log(ctx, new StringBuilder(20).append("Unexpected message: ").append(msg).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        this.log(ctx, "Channel is requested to write");
        this.last_$eq(System.nanoTime());
        super.write(ctx, msg, promise);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.log(ctx, new StringBuilder(18).append("Error on channel #").append(ctx.channel().id()).toString(), cause);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive()) {
            this.channelActive(ctx);
        }
        super.handlerAdded(ctx);
    }

    public void warn(ChannelHandlerContext ctx, String s) {
        MongoHandler$.MODULE$.logger().warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(15).append("[").append($this.reactivemongo$core$protocol$MongoHandler$$supervisor).append("/").append($this.reactivemongo$core$protocol$MongoHandler$$connection).append("] ").append(s).append(" (channel ").append(ctx.channel()).append(")").toString());
    }

    public void log(ChannelHandlerContext ctx, String s) {
        MongoHandler$.MODULE$.logger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(15).append("[").append($this.reactivemongo$core$protocol$MongoHandler$$supervisor).append("/").append($this.reactivemongo$core$protocol$MongoHandler$$connection).append("] ").append(s).append(" (channel ").append(ctx.channel()).append(")").toString());
    }

    public void log(ChannelHandlerContext ctx, String s, Throwable cause) {
        MongoHandler$.MODULE$.logger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(15).append("[").append($this.reactivemongo$core$protocol$MongoHandler$$supervisor).append("/").append($this.reactivemongo$core$protocol$MongoHandler$$connection).append("] ").append(s).append(" (channel ").append(ctx.channel()).append(")").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> cause);
    }

    private static final String msg$1(long delay$1, Channel chan$1) {
        return new StringBuilder(28).append("Channel is closed under ").append(delay$1).append("ns: ").append(chan$1.remoteAddress()).toString();
    }

    public MongoHandler(String supervisor, String connection, ActorRef receiver) {
        this.reactivemongo$core$protocol$MongoHandler$$supervisor = supervisor;
        this.reactivemongo$core$protocol$MongoHandler$$connection = connection;
        this.receiver = receiver;
        this.last = -1L;
    }
}

