/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.Props$;
import akka.actor.Terminated;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicLong;
import reactivemongo.api.AsyncDriver$;
import reactivemongo.api.AsyncDriver$AddConnection$;
import reactivemongo.api.AuthenticationMode;
import reactivemongo.api.FailoverStrategy;
import reactivemongo.api.MongoConnection;
import reactivemongo.api.MongoConnection$;
import reactivemongo.api.MongoConnectionOptions;
import reactivemongo.api.MongoConnectionOptions$;
import reactivemongo.api.ReadConcern;
import reactivemongo.api.ReadPreference;
import reactivemongo.api.ScramSha256Authentication$;
import reactivemongo.api.WriteConcern;
import reactivemongo.api.X509Authentication$;
import reactivemongo.core.AsyncSystemControl;
import reactivemongo.core.AsyncSystemControl$;
import reactivemongo.core.SystemControl;
import reactivemongo.core.SystemControl$;
import reactivemongo.core.TimedSystemControl;
import reactivemongo.core.TimedSystemControl$;
import reactivemongo.core.actors.Close;
import reactivemongo.core.actors.Close$;
import reactivemongo.core.actors.Closed$;
import reactivemongo.core.actors.Exceptions;
import reactivemongo.core.actors.MongoDBSystem;
import reactivemongo.core.actors.StandardDBSystem;
import reactivemongo.core.actors.StandardDBSystemWithScramSha256;
import reactivemongo.core.actors.StandardDBSystemWithX509;
import reactivemongo.core.errors.ConnectionException;
import reactivemongo.core.nodeset.Authenticate;
import reactivemongo.core.nodeset.Authenticate$;
import reactivemongo.util.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class AsyncDriver {
    private final Option config;
    private final Option classLoader;
    private final ActorSystem system;
    private StackTraceElement[] closedBy;
    private final Function1<Option<FiniteDuration>, Future<BoxedUnit>> systemClose;
    private final String supervisorName;
    private final ActorRef supervisorActor;
    private final Map connectionMonitors;
    private final AtomicLong connectionCounter;
    public final AsyncDriver$AddConnection$ AddConnection$lzy1;

    public static AsyncDriver apply() {
        return AsyncDriver$.MODULE$.apply();
    }

    public static AsyncDriver apply(Config config) {
        return AsyncDriver$.MODULE$.apply(config);
    }

    public static AsyncDriver apply(Config config, ClassLoader classLoader) {
        return AsyncDriver$.MODULE$.apply(config, classLoader);
    }

    public static AtomicLong counter() {
        return AsyncDriver$.MODULE$.counter();
    }

    public static Option<Config> $lessinit$greater$default$1() {
        return AsyncDriver$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<ClassLoader> $lessinit$greater$default$2() {
        return AsyncDriver$.MODULE$.$lessinit$greater$default$2();
    }

    /*
     * Unable to fully structure code
     */
    public AsyncDriver(Option<Config> config, Option<ClassLoader> classLoader) {
        this.config = config;
        this.classLoader = classLoader;
        super();
        this.AddConnection$lzy1 = new AsyncDriver$AddConnection$(this);
        reference = (Config)config.getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$1(), ()Lcom/typesafe/config/Config;)());
        if (!reference.hasPath("mongo-async-driver")) {
            AsyncDriver$.reactivemongo$api$AsyncDriver$$$logger.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$2(), ()Ljava/lang/String;)());
            v0 = ConfigFactory.empty();
        } else {
            v0 = reference.getConfig("mongo-async-driver");
        }
        cfg = v0;
        this.system = ActorSystem$.MODULE$.apply("reactivemongo", (Option)Some$.MODULE$.apply((Object)cfg), classLoader, ActorSystem$.MODULE$.apply$default$4());
        this.closedBy = (StackTraceElement[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StackTraceElement.class));
        var5_5 = SystemControl$.MODULE$.apply(this.system());
        if (!(var5_5 instanceof Success)) ** GOTO lbl-1000
        var6_6 = (SystemControl)((Success)var5_5).value();
        if (var6_6 instanceof TimedSystemControl) {
            var7_7 = TimedSystemControl$.MODULE$.unapply((TimedSystemControl)var6_6);
            close = var8_8 = var7_7._1();
            v1 = (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $init$$$anonfun$1(scala.Function1 scala.Option ), (Lscala/Option;)Lscala/concurrent/Future;)(close);
        } else if (var6_6 instanceof AsyncSystemControl) {
            var10_10 = AsyncSystemControl$.MODULE$.unapply((AsyncSystemControl)var6_6);
            close = var11_11 = var10_10._1();
            v1 = (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $init$$$anonfun$2(scala.Function0 scala.Option ), (Lscala/Option;)Lscala/concurrent/Future;)(close);
        } else if (var5_5 instanceof Failure) {
            cause = ((Failure)var5_5).exception();
            v1 = (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $init$$$anonfun$3(java.lang.Throwable scala.Option ), (Lscala/Option;)Lscala/concurrent/Future;)((Throwable)cause);
        } else {
            throw new MatchError(var5_5);
        }
        this.systemClose = v1;
        this.supervisorName = new StringBuilder(11).append("Supervisor-").append(AsyncDriver$.MODULE$.counter().incrementAndGet()).toString();
        this.supervisorActor = this.system().actorOf(Props$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $init$$$anonfun$4(), ()Lreactivemongo/api/AsyncDriver$SupervisorActor;)((AsyncDriver)this), ClassTag$.MODULE$.apply(SupervisorActor.class)), this.supervisorName());
        this.connectionMonitors = (Map)Map$.MODULE$.empty();
        this.connectionCounter = new AtomicLong(0L);
    }

    public Option<Config> config() {
        return this.config;
    }

    public Option<ClassLoader> classLoader() {
        return this.classLoader;
    }

    public ActorSystem system() {
        return this.system;
    }

    public int numConnections() {
        return this.connectionMonitors().size();
    }

    public Future<MongoConnection> connect(Seq<String> nodes) {
        return this.askConnection(nodes, MongoConnectionOptions$.MODULE$.default(), (Option<String>)Option$.MODULE$.empty());
    }

    public Future<MongoConnection> connect(Seq<String> nodes, MongoConnectionOptions options) {
        return this.askConnection(nodes, options, (Option<String>)Option$.MODULE$.empty());
    }

    public Future<MongoConnection> connect(Seq<String> nodes, MongoConnectionOptions options, String name) {
        return this.askConnection(nodes, options, (Option<String>)Some$.MODULE$.apply((Object)name));
    }

    public Future<MongoConnection> connect(String uriStrict) {
        return this.connect(uriStrict, (Option<String>)None$.MODULE$);
    }

    public Future<MongoConnection> connect(String uriStrict, Option<String> name) {
        return MongoConnection$.MODULE$.fromString(uriStrict, AsyncDriver.ec$1()).flatMap((Function1 & Serializable)_$1 -> this.connect((MongoConnection.URI)_$1, name), AsyncDriver.ec$1());
    }

    public <T> Future<MongoConnection> connect(MongoConnection.URI<T> parsedURI, Option<String> name) {
        return this.connect(parsedURI, name, true);
    }

    public <T> Future<MongoConnection> connect(MongoConnection.URI<T> parsedURI, Option<String> name, boolean strictMode) {
        if (strictMode && parsedURI.ignoredOptions().nonEmpty()) {
            return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(49).append("The connection URI contains unsupported options: ").append(parsedURI.ignoredOptions().mkString(", ")).toString()));
        }
        scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = parsedURI.options().credentials();
        int n = parsedURI.options().copy$default$1();
        Option<String> option = parsedURI.options().copy$default$2();
        boolean bl = parsedURI.options().copy$default$3();
        boolean bl2 = parsedURI.options().copy$default$4();
        AuthenticationMode authenticationMode = parsedURI.options().copy$default$5();
        boolean bl3 = parsedURI.options().copy$default$6();
        boolean bl4 = parsedURI.options().copy$default$7();
        int n2 = parsedURI.options().copy$default$8();
        Option<Object> option2 = parsedURI.options().copy$default$9();
        int n3 = parsedURI.options().copy$default$10();
        int n4 = parsedURI.options().copy$default$11();
        WriteConcern writeConcern = parsedURI.options().copy$default$12();
        ReadPreference readPreference = parsedURI.options().copy$default$13();
        FailoverStrategy failoverStrategy = parsedURI.options().copy$default$14();
        int n5 = parsedURI.options().copy$default$15();
        int n6 = parsedURI.options().copy$default$16();
        int n7 = parsedURI.options().copy$default$17();
        Option<MongoConnectionOptions.KeyStore> option3 = parsedURI.options().copy$default$19();
        ReadConcern readConcern = parsedURI.options().copy$default$20();
        Option<String> option4 = parsedURI.options().copy$default$21();
        return this.askConnection((Seq<String>)((IterableOnceOps)parsedURI.hosts().map((Function1 & Serializable)h -> new StringBuilder(11).append((String)h._1()).append(':').append(h._2()).toString())).toSeq(), parsedURI.options().copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4), name);
    }

    public <T> Future<MongoConnection> connect(MongoConnection.URI<T> parsedURI) {
        return this.connect(parsedURI, (Option<String>)None$.MODULE$);
    }

    public Future<BoxedUnit> close(FiniteDuration timeout, ExecutionContext ec) {
        boolean bl;
        AsyncDriver$.reactivemongo$api$AsyncDriver$$$logger.info((Function0<String>)((Function0 & Serializable)this::close$$anonfun$1));
        Object object = Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.drop$extension(object, 3));
        StackTraceElement[] callerSTE = (StackTraceElement[])ArrayOps$.MODULE$.take$extension(object2, 3);
        Function1<Option<FiniteDuration>, Future<BoxedUnit>> function1 = this.systemClose;
        synchronized (function1) {
            boolean bl2;
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])this.closedBy);
            if (ArrayOps$.MODULE$.isEmpty$extension(object3)) {
                this.closedBy = callerSTE;
                bl2 = false;
            } else {
                bl2 = true;
            }
            bl = bl2;
        }
        boolean alreadyClosing = bl;
        if (alreadyClosing) {
            AsyncDriver$.reactivemongo$api$AsyncDriver$$$logger.info((Function0<String>)((Function0 & Serializable)this::close$$anonfun$2));
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        ActorRef actorRef = akka.pattern.package$.MODULE$.ask(this.supervisorActor());
        Close close = AsyncDriver.msg$1(timeout);
        return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)close, Timeout$.MODULE$.apply(timeout), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)close)).recover((PartialFunction)new Serializable(callerSTE, this){
            private final StackTraceElement[] callerSTE$1;
            private final /* synthetic */ AsyncDriver $outer;
            {
                this.callerSTE$1 = callerSTE$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable err = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable err = throwable = x;
                err.setStackTrace(this.callerSTE$1);
                AsyncDriver$.reactivemongo$api$AsyncDriver$$$logger.warn((Function0<String>)((Function0 & Serializable)this::applyOrElse$$anonfun$1), (Function0<Throwable>)((Function0 & Serializable)() -> AsyncDriver.reactivemongo$api$AsyncDriver$$anon$1$$_$applyOrElse$$anonfun$2(err)));
                return BoxedUnit.UNIT;
            }

            private final String applyOrElse$$anonfun$1() {
                return new StringBuilder(96).append("[").append(this.$outer.supervisorName()).append("] Fails to close connections within timeout. Continuing closing of ReactiveMongo driver anyway.").toString();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(), reactivemongo$api$AsyncDriver$$anon$1$$_$applyOrElse$$anonfun$2(java.lang.Throwable )}, serializedLambda);
            }
        }, ec).flatMap((Function1 & Serializable)_$2 -> (Future)this.systemClose.apply((Object)Some$.MODULE$.apply((Object)timeout)), ec);
    }

    public FiniteDuration close$default$1() {
        return FiniteDuration$.MODULE$.apply(2L, scala.concurrent.duration.package$.MODULE$.SECONDS());
    }

    public final String supervisorName() {
        return this.supervisorName;
    }

    public final ActorRef supervisorActor() {
        return this.supervisorActor;
    }

    public final Map<ActorRef, MongoConnection> connectionMonitors() {
        return this.connectionMonitors;
    }

    public Future<MongoConnection> askConnection(Seq<String> nodes, MongoConnectionOptions options, Option<String> name) {
        MongoConnectionOptions mongoConnectionOptions;
        if (nodes.isEmpty()) {
            return Future$.MODULE$.failed((Throwable)new ConnectionException("No node specified"));
        }
        LazyRef lazyRef = new LazyRef();
        String nm = (String)name.getOrElse(this::$anonfun$3);
        Seq authentications = ((IterableOnceOps)options.credentials().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String db = (String)tuple2._1();
                MongoConnectionOptions.Credential c = (MongoConnectionOptions.Credential)tuple2._2();
                return Authenticate$.MODULE$.apply(db, c.user(), c.password());
            }
            throw new MatchError((Object)tuple2);
        })).toSeq();
        Option<String> option = options.appName();
        if (option instanceof Some) {
            mongoConnectionOptions = options;
        } else {
            Some some = Some$.MODULE$.apply((Object)new StringBuilder(1).append(this.supervisorName()).append("/").append(nm).toString());
            int n = options.copy$default$1();
            Option<String> option2 = options.copy$default$2();
            boolean bl = options.copy$default$3();
            boolean bl2 = options.copy$default$4();
            AuthenticationMode authenticationMode = options.copy$default$5();
            boolean bl3 = options.copy$default$6();
            boolean bl4 = options.copy$default$7();
            int n2 = options.copy$default$8();
            Option<Object> option3 = options.copy$default$9();
            int n3 = options.copy$default$10();
            int n4 = options.copy$default$11();
            WriteConcern writeConcern = options.copy$default$12();
            ReadPreference readPreference = options.copy$default$13();
            FailoverStrategy failoverStrategy = options.copy$default$14();
            int n5 = options.copy$default$15();
            int n6 = options.copy$default$16();
            int n7 = options.copy$default$17();
            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = options.copy$default$18();
            Option<MongoConnectionOptions.KeyStore> option4 = options.copy$default$19();
            ReadConcern readConcern = options.copy$default$20();
            mongoConnectionOptions = options.copy(n, option2, bl, bl2, authenticationMode, bl3, bl4, n2, option3, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option4, readConcern, (Option<String>)some);
        }
        MongoConnectionOptions opts = mongoConnectionOptions;
        ActorRef mongosystem = this.system().actorOf(Props$.MODULE$.apply(() -> this.$anonfun$5(nodes, nm, authentications, opts, lazyRef), ClassTag$.MODULE$.apply(MongoDBSystem.class)), nm);
        AsyncDriver$.reactivemongo$api$AsyncDriver$$$logger.info((Function0<String>)((Function0 & Serializable)() -> this.askConnection$$anonfun$1(nm)));
        return this.connection$1(nodes, nm, opts, mongosystem).mapTo(ClassTag$.MODULE$.apply(MongoConnection.class)).map((Function1 & Serializable)c -> {
            c.history_$eq((Function0<Exceptions.InternalState>)(Function0 & Serializable)() -> this.dbsystem$1(nodes, nm, authentications, opts, lazyRef).internalState());
            return c;
        }, (ExecutionContext)this.system().dispatcher());
    }

    public final AsyncDriver$AddConnection$ reactivemongo$api$AsyncDriver$$AddConnection() {
        return this.AddConnection$lzy1;
    }

    public Object addConnectionMsg(String name, Seq<String> nodes, MongoConnectionOptions options, ActorRef mongosystem) {
        return this.reactivemongo$api$AsyncDriver$$AddConnection().apply(name, nodes, options, mongosystem);
    }

    private static final Config $anonfun$1() {
        return ConfigFactory.load();
    }

    private static final String $anonfun$2() {
        return "No mongo-async-driver configuration found";
    }

    private static final /* synthetic */ Future $init$$$anonfun$1(Function1 close$1, Option timeout) {
        Try try_ = (Try)close$1.apply((Object)timeout);
        if (try_ instanceof Failure) {
            Throwable cause = ((Failure)try_).exception();
            return Future$.MODULE$.failed(cause);
        }
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    private static final /* synthetic */ Future $init$$$anonfun$2(Function0 close$2, Option _$3) {
        return (Future)close$2.apply();
    }

    private static final /* synthetic */ Future $init$$$anonfun$3(Throwable cause$1, Option _$4) {
        return Future$.MODULE$.failed(cause$1);
    }

    private final SupervisorActor $init$$$anonfun$4() {
        return new SupervisorActor(this, this);
    }

    private static final ExecutionContext ec$1() {
        return package$.MODULE$.sameThreadExecutionContext();
    }

    private final String close$$anonfun$1() {
        return new StringBuilder(43).append("[").append(this.supervisorName()).append("] Closing instance of ReactiveMongo driver").toString();
    }

    private final String close$$anonfun$2() {
        return new StringBuilder(23).append("System already closed: ").append(this.supervisorName()).toString();
    }

    private static final Close msg$1(FiniteDuration timeout$1) {
        return Close$.MODULE$.apply("AsyncDriver.close", timeout$1);
    }

    public static final Throwable reactivemongo$api$AsyncDriver$$anon$1$$_$applyOrElse$$anonfun$2(Throwable err$1) {
        return err$1;
    }

    private final String $anonfun$3() {
        return new StringBuilder(11).append("Connection-").append(this.connectionCounter.incrementAndGet()).toString();
    }

    private final MongoDBSystem dbsystem$lzyINIT1$1(Seq nodes$1, String nm$1, Seq authentications$1, MongoConnectionOptions opts$1, LazyRef dbsystem$lzy1$1) {
        MongoDBSystem mongoDBSystem;
        LazyRef lazyRef = dbsystem$lzy1$1;
        synchronized (lazyRef) {
            AuthenticationMode authenticationMode;
            mongoDBSystem = (MongoDBSystem)(dbsystem$lzy1$1.initialized() ? dbsystem$lzy1$1.value() : dbsystem$lzy1$1.initialize((Object)(X509Authentication$.MODULE$.equals(authenticationMode = opts$1.authenticationMechanism()) ? new StandardDBSystemWithX509(this.supervisorName(), nm$1, (Seq<String>)nodes$1, (Seq<Authenticate>)authentications$1, opts$1) : (ScramSha256Authentication$.MODULE$.equals(authenticationMode) ? new StandardDBSystemWithScramSha256(this.supervisorName(), nm$1, (Seq<String>)nodes$1, (Seq<Authenticate>)authentications$1, opts$1) : new StandardDBSystem(this.supervisorName(), nm$1, (Seq<String>)nodes$1, (Seq<Authenticate>)authentications$1, opts$1)))));
        }
        return mongoDBSystem;
    }

    private final MongoDBSystem dbsystem$1(Seq nodes$2, String nm$2, Seq authentications$2, MongoConnectionOptions opts$2, LazyRef dbsystem$lzy1$2) {
        return (MongoDBSystem)(dbsystem$lzy1$2.initialized() ? dbsystem$lzy1$2.value() : this.dbsystem$lzyINIT1$1(nodes$2, nm$2, authentications$2, opts$2, dbsystem$lzy1$2));
    }

    private final MongoDBSystem $anonfun$5(Seq nodes$4, String nm$5, Seq authentications$3, MongoConnectionOptions opts$5, LazyRef dbsystem$lzy1$3) {
        return this.dbsystem$1(nodes$4, nm$5, authentications$3, opts$5, dbsystem$lzy1$3);
    }

    private static final Timeout timeout$3(MongoConnectionOptions opts$3) {
        if (opts$3.connectTimeoutMS() > 0) {
            return Timeout$.MODULE$.apply((long)opts$3.connectTimeoutMS(), scala.concurrent.duration.package$.MODULE$.MILLISECONDS());
        }
        return Timeout$.MODULE$.apply(10000L, scala.concurrent.duration.package$.MODULE$.MILLISECONDS());
    }

    private final Future connection$1(Seq nodes$3, String nm$3, MongoConnectionOptions opts$4, ActorRef mongosystem$1) {
        ActorRef actorRef = akka.pattern.package$.MODULE$.ask(this.supervisorActor());
        AddConnection addConnection = this.reactivemongo$api$AsyncDriver$$AddConnection().apply(nm$3, (Seq<String>)nodes$3, opts$4, mongosystem$1);
        return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)addConnection, AsyncDriver.timeout$3(opts$4), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)addConnection));
    }

    private final String askConnection$$anonfun$1(String nm$4) {
        return new StringBuilder(24).append("[").append(this.supervisorName()).append("] Creating connection: ").append(nm$4).toString();
    }

    private static final FiniteDuration timeout$4(Close close$3) {
        return close$3.timeout();
    }

    public static final /* synthetic */ Future reactivemongo$api$AsyncDriver$$anon$2$$_$applyOrElse$$anonfun$6(Close close$4, MongoConnection _$5) {
        return _$5.close(AsyncDriver.timeout$4(close$4));
    }

    public static final /* synthetic */ boolean reactivemongo$api$AsyncDriver$$anon$3$$_$applyOrElse$$anonfun$8$$anonfun$2(ActorRef _$6) {
        return true;
    }

    public class AddConnection
    implements Product,
    Serializable {
        private final String name;
        private final Seq nodes;
        private final MongoConnectionOptions options;
        private final ActorRef mongosystem;
        private final /* synthetic */ AsyncDriver $outer;

        public AddConnection(AsyncDriver $outer, String name, Seq<String> nodes, MongoConnectionOptions options, ActorRef mongosystem) {
            this.name = name;
            this.nodes = nodes;
            this.options = options;
            this.mongosystem = mongosystem;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AddConnection)) return false;
            if (((AddConnection)object).reactivemongo$api$AsyncDriver$AddConnection$$$outer() != this.$outer) return false;
            AddConnection addConnection = (AddConnection)object;
            String string = this.name();
            String string2 = addConnection.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Seq<String> seq = this.nodes();
            Seq<String> seq2 = addConnection.nodes();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            MongoConnectionOptions mongoConnectionOptions = this.options();
            MongoConnectionOptions mongoConnectionOptions2 = addConnection.options();
            if (mongoConnectionOptions == null) {
                if (mongoConnectionOptions2 != null) {
                    return false;
                }
            } else if (!((Object)mongoConnectionOptions).equals(mongoConnectionOptions2)) return false;
            ActorRef actorRef = this.mongosystem();
            ActorRef actorRef2 = addConnection.mongosystem();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            if (!addConnection.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AddConnection;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "AddConnection";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "nodes";
                }
                case 2: {
                    return "options";
                }
                case 3: {
                    return "mongosystem";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public Seq<String> nodes() {
            return this.nodes;
        }

        public MongoConnectionOptions options() {
            return this.options;
        }

        public ActorRef mongosystem() {
            return this.mongosystem;
        }

        public AddConnection copy(String name, Seq<String> nodes, MongoConnectionOptions options, ActorRef mongosystem) {
            return new AddConnection(this.$outer, name, nodes, options, mongosystem);
        }

        public String copy$default$1() {
            return this.name();
        }

        public Seq<String> copy$default$2() {
            return this.nodes();
        }

        public MongoConnectionOptions copy$default$3() {
            return this.options();
        }

        public ActorRef copy$default$4() {
            return this.mongosystem();
        }

        public String _1() {
            return this.name();
        }

        public Seq<String> _2() {
            return this.nodes();
        }

        public MongoConnectionOptions _3() {
            return this.options();
        }

        public ActorRef _4() {
            return this.mongosystem();
        }

        public final /* synthetic */ AsyncDriver reactivemongo$api$AsyncDriver$AddConnection$$$outer() {
            return this.$outer;
        }
    }

    public final class SupervisorActor
    implements Actor {
        private ActorContext context;
        private ActorRef self;
        public final AsyncDriver reactivemongo$api$AsyncDriver$SupervisorActor$$driver;
        private final PartialFunction receive;
        private final /* synthetic */ AsyncDriver $outer;

        public SupervisorActor(AsyncDriver $outer, AsyncDriver driver) {
            this.reactivemongo$api$AsyncDriver$SupervisorActor$$driver = driver;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Actor.$init$((Actor)this);
            this.receive = new Serializable(this){
                private final /* synthetic */ SupervisorActor $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Object x) {
                    Close close;
                    Option<String> option;
                    Object object = x;
                    if (object instanceof AddConnection && ((AddConnection)object).reactivemongo$api$AsyncDriver$AddConnection$$$outer() == this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer()) {
                        AddConnection addConnection = this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().reactivemongo$api$AsyncDriver$$AddConnection().unapply((AddConnection)object);
                        String string = addConnection._1();
                        Seq<String> seq = addConnection._2();
                        MongoConnectionOptions mongoConnectionOptions = addConnection._3();
                        ActorRef actorRef = addConnection._4();
                        String name = string;
                        MongoConnectionOptions opts = mongoConnectionOptions;
                        ActorRef sys = actorRef;
                        return true;
                    }
                    if (object instanceof Terminated) {
                        Terminated term = (Terminated)object;
                        return true;
                    }
                    if (object instanceof Close && !(option = Close$.MODULE$.unapply(close = (Close)object)).isEmpty()) {
                        String string;
                        String src = string = (String)option.get();
                        Close close2 = close;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Close close;
                    Option<String> option;
                    Object object = x;
                    if (object instanceof AddConnection && ((AddConnection)object).reactivemongo$api$AsyncDriver$AddConnection$$$outer() == this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer()) {
                        AddConnection addConnection = this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().reactivemongo$api$AsyncDriver$$AddConnection().unapply((AddConnection)object);
                        String string = addConnection._1();
                        Seq<String> seq = addConnection._2();
                        MongoConnectionOptions mongoConnectionOptions = addConnection._3();
                        ActorRef actorRef = addConnection._4();
                        String name = string;
                        MongoConnectionOptions opts = mongoConnectionOptions;
                        ActorRef sys = actorRef;
                        AsyncDriver$.reactivemongo$api$AsyncDriver$$$logger.debug((Function0<String>)((Function0 & Serializable)() -> this.applyOrElse$$anonfun$3(name)));
                        MongoConnection connection = new MongoConnection(this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName(), name, this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.system(), sys, opts);
                        this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().put((Object)connection.monitor(), (Object)connection);
                        this.$outer.context().watch(connection.monitor());
                        this.$outer.sender().$bang((Object)connection, this.$outer.self());
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof Terminated) {
                        Terminated term = (Terminated)object;
                        AsyncDriver$.reactivemongo$api$AsyncDriver$$$logger.debug((Function0<String>)((Function0 & Serializable)() -> this.applyOrElse$$anonfun$4(term)));
                        this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().remove((Object)term.actor());
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof Close && !(option = Close$.MODULE$.unapply(close = (Close)object)).isEmpty()) {
                        String string;
                        String src = string = (String)option.get();
                        Close close2 = close;
                        AsyncDriver$.reactivemongo$api$AsyncDriver$$$logger.debug((Function0<String>)((Function0 & Serializable)() -> this.applyOrElse$$anonfun$5(src)));
                        if (this.$outer.isEmpty()) {
                            this.$outer.context().stop(this.$outer.self());
                            this.$outer.sender().$bang((Object)Closed$.MODULE$, this.$outer.self());
                            return BoxedUnit.UNIT;
                        }
                        this.$outer.context().become(this.$outer.closing());
                        Future$.MODULE$.sequence((IterableOnce)this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().values().map(arg_0 -> AsyncDriver.reactivemongo$api$AsyncDriver$$anon$2$$_$applyOrElse$$anonfun$6(close2, arg_0)), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec$2());
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply(x);
                }

                private final String applyOrElse$$anonfun$3(String name$2) {
                    return new StringBuilder(37).append("[").append(this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Add connection to the supervisor: ").append(name$2).toString();
                }

                private final String applyOrElse$$anonfun$4(Terminated term$1) {
                    return new StringBuilder(29).append("[").append(this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Connection is terminated: ").append(term$1.actor().path()).toString();
                }

                private final String applyOrElse$$anonfun$5(String src$1) {
                    return new StringBuilder(28).append("[").append(this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Close the supervisor for ").append(src$1).toString();
                }

                private final ExecutionContext ec$2() {
                    return this.$outer.context().dispatcher();
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$3(java.lang.String ), applyOrElse$$anonfun$4(akka.actor.Terminated ), applyOrElse$$anonfun$5(java.lang.String ), reactivemongo$api$AsyncDriver$$anon$2$$_$applyOrElse$$anonfun$6(reactivemongo.core.actors.Close reactivemongo.api.MongoConnection )}, serializedLambda);
                }
            };
            Statics.releaseFence();
        }

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
            this.context = x$0;
        }

        public void akka$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
            this.self = x$0;
        }

        public boolean isEmpty() {
            return this.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().isEmpty();
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return this.receive;
        }

        public PartialFunction<Object, BoxedUnit> closing() {
            Queue waitingForClose = (Queue)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ActorRef[]{this.sender()}));
            return new Serializable(waitingForClose, this){
                private final Queue waitingForClose$1;
                private final /* synthetic */ SupervisorActor $outer;
                {
                    this.waitingForClose$1 = waitingForClose$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Object x) {
                    Option<String> option;
                    Object object = x;
                    if (object instanceof AddConnection && ((AddConnection)object).reactivemongo$api$AsyncDriver$AddConnection$$$outer() == this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer()) {
                        AddConnection addConnection = this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().reactivemongo$api$AsyncDriver$$AddConnection().unapply((AddConnection)object);
                        String string = addConnection._1();
                        Seq<String> seq = addConnection._2();
                        MongoConnectionOptions mongoConnectionOptions = addConnection._3();
                        ActorRef actorRef = addConnection._4();
                        String name = string;
                        return true;
                    }
                    if (object instanceof Terminated) {
                        Terminated term = (Terminated)object;
                        return true;
                    }
                    if (object instanceof Close && !(option = Close$.MODULE$.unapply((Close)object)).isEmpty()) {
                        String string;
                        String string2;
                        String src = string2 = (string = (String)option.get());
                        if (this.$outer.isEmpty()) {
                            return true;
                        }
                        String src2 = string2;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Option<String> option;
                    Object object = x;
                    if (object instanceof AddConnection && ((AddConnection)object).reactivemongo$api$AsyncDriver$AddConnection$$$outer() == this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer()) {
                        AddConnection addConnection = this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().reactivemongo$api$AsyncDriver$$AddConnection().unapply((AddConnection)object);
                        String string = addConnection._1();
                        Seq<String> seq = addConnection._2();
                        MongoConnectionOptions mongoConnectionOptions = addConnection._3();
                        ActorRef actorRef = addConnection._4();
                        String name = string;
                        AsyncDriver$.reactivemongo$api$AsyncDriver$$$logger.warn((Function0<String>)((Function0 & Serializable)() -> this.applyOrElse$$anonfun$7(name)));
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof Terminated) {
                        Terminated term = (Terminated)object;
                        this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$driver.connectionMonitors().remove((Object)term.actor()).foreach((Function1)(JProcedure1 & Serializable)con -> {
                            AsyncDriver$.reactivemongo$api$AsyncDriver$$$logger.debug((Function0<String>)((Function0 & Serializable)() -> this.applyOrElse$$anonfun$8$$anonfun$1(con)));
                            if (this.$outer.isEmpty()) {
                                this.$outer.context().stop(this.$outer.self());
                                this.waitingForClose$1.dequeueAll(AsyncDriver::reactivemongo$api$AsyncDriver$$anon$3$$_$applyOrElse$$anonfun$8$$anonfun$2).foreach((Function1)(JProcedure1 & Serializable)_$7 -> _$7.$bang((Object)Closed$.MODULE$, this.$outer.self()));
                                return;
                            }
                        });
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof Close && !(option = Close$.MODULE$.unapply((Close)object)).isEmpty()) {
                        String string;
                        String string2;
                        String src = string2 = (string = (String)option.get());
                        if (this.$outer.isEmpty()) {
                            AsyncDriver$.reactivemongo$api$AsyncDriver$$$logger.debug((Function0<String>)((Function0 & Serializable)() -> this.applyOrElse$$anonfun$9(src)));
                            this.$outer.sender().$bang((Object)Closed$.MODULE$, this.$outer.self());
                            return BoxedUnit.UNIT;
                        }
                        String src2 = string2;
                        AsyncDriver$.reactivemongo$api$AsyncDriver$$$logger.warn((Function0<String>)((Function0 & Serializable)() -> this.applyOrElse$$anonfun$10(src2)));
                        this.waitingForClose$1.$plus$eq((Object)this.$outer.sender());
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply(x);
                }

                private final String applyOrElse$$anonfun$7(String name$3) {
                    return new StringBuilder(59).append("[").append(this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Refusing to add connection while the driver is closing: ").append(name$3).toString();
                }

                private final String applyOrElse$$anonfun$8$$anonfun$1(MongoConnection con$1) {
                    return new StringBuilder(29).append("[").append(this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Connection is terminated: ").append(con$1.name()).toString();
                }

                private final String applyOrElse$$anonfun$9(String src$2) {
                    return new StringBuilder(28).append("[").append(this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Close the supervisor for ").append(src$2).toString();
                }

                private final String applyOrElse$$anonfun$10(String src$3) {
                    return new StringBuilder(53).append("[").append(this.$outer.reactivemongo$api$AsyncDriver$SupervisorActor$$$outer().supervisorName()).append("] Close request received from ").append(src$3).append(", but already closing.").toString();
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$7(java.lang.String ), applyOrElse$$anonfun$8(reactivemongo.api.MongoConnection ), applyOrElse$$anonfun$9(java.lang.String ), applyOrElse$$anonfun$10(java.lang.String ), applyOrElse$$anonfun$8$$anonfun$1(reactivemongo.api.MongoConnection ), reactivemongo$api$AsyncDriver$$anon$3$$_$applyOrElse$$anonfun$8$$anonfun$2(akka.actor.ActorRef ), applyOrElse$$anonfun$8$$anonfun$3(akka.actor.ActorRef )}, serializedLambda);
                }
            };
        }

        public void postStop() {
            AsyncDriver$.reactivemongo$api$AsyncDriver$$$logger.info((Function0<String>)((Function0 & Serializable)this::postStop$$anonfun$1));
        }

        public final /* synthetic */ AsyncDriver reactivemongo$api$AsyncDriver$SupervisorActor$$$outer() {
            return this.$outer;
        }

        private final String postStop$$anonfun$1() {
            return new StringBuilder(26).append("[").append(this.$outer.supervisorName()).append("] Stopping the monitor...").toString();
        }
    }
}

