/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api.collections;

import java.io.Serializable;
import reactivemongo.api.collections.BulkOps$;
import reactivemongo.api.collections.BulkOps$BulkStage$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class BulkOps {
    public static <I, O> Future<Seq<O>> bulkApply(BulkProducer<I> bulkProducer, Function1<Iterable<I>, Future<O>> function1, Option<Function1<Exception, Future<O>>> option, ExecutionContext executionContext) {
        return BulkOps$.MODULE$.bulkApply(bulkProducer, function1, option, executionContext);
    }

    public static <I> BulkProducer<I> bulks(Iterable<I> iterable, int n, int n2, Function1<I, Object> function1) {
        return BulkOps$.MODULE$.bulks(iterable, n, n2, function1);
    }

    public static <I, O> Option<Function1<Exception, Future<Nothing$>>> bulkApply$default$3(BulkProducer<I> bulkProducer) {
        return BulkOps$.MODULE$.bulkApply$default$3(bulkProducer);
    }

    public static final class BulkProducer<I>
    implements Function0<Either<String, BulkStage<I>>> {
        private final int offset;
        private final Iterable<I> documents;
        private final Function1<I, Object> sz;
        private final int maxBsonSize;
        private final int maxBulkSize;
        private final String toString;

        public BulkProducer(int offset, Iterable<I> documents, Function1<I, Object> sz, int maxBsonSize, int maxBulkSize) {
            this.offset = offset;
            this.documents = documents;
            this.sz = sz;
            this.maxBsonSize = maxBsonSize;
            this.maxBulkSize = maxBulkSize;
            this.toString = new StringBuilder(23).append("BulkProducer(offset = ").append(offset).append(")").toString();
        }

        public Either<String, BulkStage<I>> apply() {
            return this.go(this.documents, 0, 0, (Seq)package$.MODULE$.Seq().empty());
        }

        public Either<String, BulkStage<I>> go(Iterable<I> input, int docs, int bsonSize, Seq<I> bulk) {
            Option option;
            while ((option = input.headOption()) instanceof Some) {
                Object doc = ((Some)option).value();
                int bsz = BoxesRunTime.unboxToInt((Object)this.sz.apply(doc));
                if (bsz + 1 + 2 > this.maxBsonSize) {
                    return package$.MODULE$.Left().apply((Object)new StringBuilder(50).append("size of document #").append(this.offset + docs).append(" exceed the maxBsonSize: ").append(bsz).append(" + 3 > ").append(this.maxBsonSize).toString());
                }
                int nc = docs + 1;
                Object object = Predef$.MODULE$.byteArrayOps(BoxesRunTime.boxToInteger((int)docs).toString().getBytes());
                int keySize = ArrayOps$.MODULE$.size$extension(object);
                int nsz = bsonSize + bsz + keySize + 2;
                if (nsz > this.maxBsonSize) {
                    return package$.MODULE$.Right().apply(BulkOps$BulkStage$.MODULE$.apply((Iterable)bulk.reverse(), Some$.MODULE$.apply(new BulkProducer<I>(this.offset + nc, input, this.sz, this.maxBsonSize, this.maxBulkSize))));
                }
                if (nc == this.maxBulkSize || nsz == this.maxBsonSize) {
                    return package$.MODULE$.Right().apply(BulkOps$BulkStage$.MODULE$.apply((Iterable)((SeqOps)bulk.$plus$colon(doc)).reverse(), Some$.MODULE$.apply(new BulkProducer<I>(this.offset + nc, (Iterable)input.drop(1), this.sz, this.maxBsonSize, this.maxBulkSize))));
                }
                Iterable iterable = (Iterable)input.drop(1);
                int n = nc;
                int n2 = nsz;
                Seq seq = (Seq)bulk.$plus$colon(doc);
                input = iterable;
                docs = n;
                bsonSize = n2;
                bulk = seq;
            }
            return package$.MODULE$.Right().apply(BulkOps$BulkStage$.MODULE$.apply((Iterable)bulk.reverse(), None$.MODULE$));
        }

        public String toString() {
            return this.toString;
        }
    }

    public static class BulkStage<I>
    implements Product,
    Serializable {
        private final Iterable bulk;
        private final Option next;

        public static <I> BulkStage<I> apply(Iterable<I> iterable, Option<BulkProducer<I>> option) {
            return BulkOps$BulkStage$.MODULE$.apply(iterable, option);
        }

        public static BulkStage<?> fromProduct(Product product) {
            return BulkOps$BulkStage$.MODULE$.fromProduct(product);
        }

        public static <I> BulkStage<I> unapply(BulkStage<I> bulkStage) {
            return BulkOps$BulkStage$.MODULE$.unapply(bulkStage);
        }

        public BulkStage(Iterable<I> bulk, Option<BulkProducer<I>> next) {
            this.bulk = bulk;
            this.next = next;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BulkStage)) return false;
            BulkStage bulkStage = (BulkStage)object;
            Iterable<I> iterable = this.bulk();
            Iterable<I> iterable2 = bulkStage.bulk();
            if (iterable == null) {
                if (iterable2 != null) {
                    return false;
                }
            } else if (!iterable.equals(iterable2)) return false;
            Option<BulkProducer<I>> option = this.next();
            Option<BulkProducer<I>> option2 = bulkStage.next();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!bulkStage.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BulkStage;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "BulkStage";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "bulk";
            }
            if (1 == n2) {
                return "next";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Iterable<I> bulk() {
            return this.bulk;
        }

        public Option<BulkProducer<I>> next() {
            return this.next;
        }

        public <I> BulkStage<I> copy(Iterable<I> bulk, Option<BulkProducer<I>> next) {
            return new BulkStage<I>(bulk, next);
        }

        public <I> Iterable<I> copy$default$1() {
            return this.bulk();
        }

        public <I> Option<BulkProducer<I>> copy$default$2() {
            return this.next();
        }

        public Iterable<I> _1() {
            return this.bulk();
        }

        public Option<BulkProducer<I>> _2() {
            return this.next();
        }
    }
}

