/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.nodeset;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.DefaultChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import reactivemongo.api.Compressor;
import reactivemongo.core.nodeset.Authenticated;
import reactivemongo.core.nodeset.Authenticating;
import reactivemongo.core.nodeset.ConnectionStatus;
import reactivemongo.core.protocol.Request;
import reactivemongo.core.protocol.Request$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class Connection {
    private final Channel channel;
    private final ConnectionStatus status;
    private final Set authenticated;
    private final Option authenticating;
    private final boolean signaling;

    public Connection(Channel channel, ConnectionStatus status, Set<Authenticated> authenticated, Option<Authenticating> authenticating, boolean signaling) {
        this.channel = channel;
        this.status = status;
        this.authenticated = authenticated;
        this.authenticating = authenticating;
        this.signaling = signaling;
    }

    public Channel channel() {
        return this.channel;
    }

    public ConnectionStatus status() {
        return this.status;
    }

    public Set<Authenticated> authenticated() {
        return this.authenticated;
    }

    public Option<Authenticating> authenticating() {
        return this.authenticating;
    }

    public boolean signaling() {
        return this.signaling;
    }

    public ChannelFuture send(Request message, Request writeConcern, ListSet<Compressor> compression) {
        return (ChannelFuture)this.withPrepared(compression, message).apply((Function2 & Serializable)(msg, onComplete) -> {
            this.channel().write(msg).addListener((GenericFutureListener)new ChannelFutureListener((Function0)onComplete){
                private final Function0 onComplete$1;
                {
                    this.onComplete$1 = onComplete$3;
                }

                public void operationComplete(ChannelFuture op) {
                    this.onComplete$1.apply();
                }
            });
            return this.channel().writeAndFlush((Object)writeConcern);
        });
    }

    public ChannelFuture send(Request message, ListSet<Compressor> compression) {
        return (ChannelFuture)this.withPrepared(compression, message).apply((Function2 & Serializable)(msg, onComplete) -> this.channel().writeAndFlush(msg).addListener((GenericFutureListener)new ChannelFutureListener((Function0)onComplete){
            private final Function0 onComplete$2;
            {
                this.onComplete$2 = onComplete$4;
            }

            public void operationComplete(ChannelFuture op) {
                this.onComplete$2.apply();
            }
        }));
    }

    public boolean isAuthenticated(String db, String user) {
        return this.authenticated().exists((Function1 & Serializable)auth -> {
            String string = auth.user();
            String string2 = user;
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = auth.db();
            String string4 = db;
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        });
    }

    private Function1<Function2<Request, Function0<Object>, ChannelFuture>, ChannelFuture> withPrepared(ListSet<Compressor> compression, Request request) {
        Option option = compression.headOption();
        if (option instanceof Some) {
            Compressor compressor = (Compressor)((Some)option).value();
            Try<Request> try_ = this.compress(request, compressor, (ListSet<Compressor>)((ListSet)compression.tail()));
            if (try_ instanceof Success) {
                Request prepared = (Request)((Success)try_).value();
                return (Function1 & Serializable)_$1 -> (ChannelFuture)_$1.apply((Object)prepared, (Function0 & Serializable)() -> BoxesRunTime.boxToBoolean((boolean)prepared.payload().release()));
            }
            if (try_ instanceof Failure) {
                Throwable cause = ((Failure)try_).exception();
                DefaultChannelPromise failed = new DefaultChannelPromise(this.channel());
                failed.setFailure(cause);
                return (Function1 & Serializable)_$2 -> failed;
            }
            throw new MatchError(try_);
        }
        return (Function1 & Serializable)_$3 -> (ChannelFuture)_$3.apply((Object)request, (Function0 & Serializable)() -> BoxedUnit.UNIT);
    }

    private Try<Request> compress(Request request, Compressor next, ListSet<Compressor> alternatives) {
        Try<Request> try_;
        block10: {
            Failure failed;
            while (true) {
                Compressor c;
                if ((try_ = Request$.MODULE$.compress(request, next, (Function1<Object, ByteBuf>)(Function1 & Serializable)_$4 -> this.compress$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$4)))) instanceof Success) {
                    Success success;
                    Success compressed = (Success)try_;
                    try {
                        success = compressed;
                    }
                    finally {
                        request.payload().release();
                    }
                    return success;
                }
                if (!(try_ instanceof Failure)) break block10;
                failed = (Failure)try_;
                Option option = alternatives.headOption();
                if (!(option instanceof Some)) break;
                Compressor compressor = c = (Compressor)((Some)option).value();
                ListSet listSet = (ListSet)alternatives.tail();
                next = compressor;
                alternatives = listSet;
            }
            if (request.payload().refCnt() > 0) {
                try {
                    request.payload().release();
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3 = (Throwable)option.get();
                    }
                    throw throwable;
                }
            }
            return failed;
        }
        throw new MatchError(try_);
    }

    public Connection copy(Channel channel, ConnectionStatus status, Set<Authenticated> authenticated, Option<Authenticating> authenticating) {
        return new Connection(channel, status, authenticated, authenticating, this.signaling());
    }

    public Channel copy$default$1() {
        return this.channel();
    }

    public ConnectionStatus copy$default$2() {
        return this.status();
    }

    public Set<Authenticated> copy$default$3() {
        return this.authenticated();
    }

    public Option<Authenticating> copy$default$4() {
        return this.authenticating();
    }

    public Tuple4<Channel, ConnectionStatus, Set<Authenticated>, Option<Authenticating>> tupled() {
        return Tuple4$.MODULE$.apply((Object)this.channel(), (Object)this.status(), this.authenticated(), this.authenticating());
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof Connection) {
            Connection other = (Connection)object;
            Tuple4<Channel, ConnectionStatus, Set<Authenticated>, Option<Authenticating>> tuple4 = this.tupled();
            Tuple4<Channel, ConnectionStatus, Set<Authenticated>, Option<Authenticating>> tuple42 = other.tupled();
            return !(tuple4 != null ? !tuple4.equals(tuple42) : tuple42 != null) && this.signaling() == other.signaling();
        }
        return false;
    }

    public int hashCode() {
        return this.tupled().hashCode() + BoxesRunTime.boxToBoolean((boolean)this.signaling()).hashCode();
    }

    public String toString() {
        return new StringBuilder(10).append("Connection").append(this.tupled()).toString();
    }

    private final /* synthetic */ ByteBuf compress$$anonfun$1(int _$4) {
        return this.channel().alloc().directBuffer(_$4);
    }
}

