/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api;

import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.xbill.DNS.Record;
import reactivemongo.api.AuthenticationMode;
import reactivemongo.api.Compressor;
import reactivemongo.api.FailoverStrategy;
import reactivemongo.api.FailoverStrategy$;
import reactivemongo.api.MongoConnection;
import reactivemongo.api.MongoConnection$Compressors$;
import reactivemongo.api.MongoConnection$ParseState$;
import reactivemongo.api.MongoConnection$URIBuilder$;
import reactivemongo.api.MongoConnectionOptions;
import reactivemongo.api.MongoConnectionOptions$;
import reactivemongo.api.MongoConnectionOptions$Credential$;
import reactivemongo.api.MongoConnectionOptions$KeyStore$;
import reactivemongo.api.ReadConcern;
import reactivemongo.api.ReadConcern$;
import reactivemongo.api.ReadPreference;
import reactivemongo.api.ReadPreference$;
import reactivemongo.api.ReadPreference$Primary$;
import reactivemongo.api.ScramSha1Authentication$;
import reactivemongo.api.ScramSha256Authentication$;
import reactivemongo.api.WriteConcern;
import reactivemongo.api.WriteConcern$;
import reactivemongo.api.WriteConcern$Majority$;
import reactivemongo.api.WriteConcern$TagSet$;
import reactivemongo.api.WriteConcern$WaitForAcknowledgments$;
import reactivemongo.api.X509Authentication$;
import reactivemongo.util.LazyLogger;
import reactivemongo.util.LazyLogger$;
import reactivemongo.util.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class MongoConnection$
implements Serializable {
    private static final String DefaultHost;
    private static final int DefaultPort;
    private static final LazyLogger.LazyLogger logger;
    public static final MongoConnection$URIBuilder$ URIBuilder;
    private static final Regex UnsignedInt;
    private static final Regex IntRe;
    private static final Regex FailoverRe;
    private static final MongoConnection$Compressors$ Compressors;
    private static final MongoConnection$ParseState$ ParseState;
    public static final MongoConnection$ MODULE$;

    private MongoConnection$() {
    }

    static {
        MODULE$ = new MongoConnection$();
        DefaultHost = "localhost";
        DefaultPort = 27017;
        logger = LazyLogger$.MODULE$.apply("reactivemongo.api.MongoConnection");
        UnsignedInt = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([0-9]+)$"));
        IntRe = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([-]?[0-9]+)$"));
        FailoverRe = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([^:]+):([0-9]+)x([0-9.]+)$"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MongoConnection$.class);
    }

    public String DefaultHost() {
        return DefaultHost;
    }

    public int DefaultPort() {
        return DefaultPort;
    }

    public LazyLogger.LazyLogger logger() {
        return logger;
    }

    public Future<MongoConnection.URI<Option<String>>> fromString(String uri, ExecutionContext ec) {
        return this.parse(uri, package$.MODULE$.dnsResolve(package$.MODULE$.dnsResolve$default$1(), package$.MODULE$.dnsResolve$default$2()), package$.MODULE$.txtRecords(package$.MODULE$.txtRecords$default$1(), ec), ec, MongoConnection$URIBuilder$.MODULE$.default());
    }

    public Future<MongoConnection.URI<String>> fromStringWithDB(String uri, ExecutionContext ec) {
        return this.parse(uri, package$.MODULE$.dnsResolve(package$.MODULE$.dnsResolve$default$1(), package$.MODULE$.dnsResolve$default$2()), package$.MODULE$.txtRecords(package$.MODULE$.txtRecords$default$1(), ec), ec, MongoConnection$URIBuilder$.MODULE$.requiredDB());
    }

    public <T> Future<MongoConnection.URI<T>> parse(String uri, Function1<ExecutionContext, Function1<String, Future<Record[]>>> srvRecResolver, Function1<String, Future<ListSet<String>>> txtResolver, ExecutionContext ec, MongoConnection.URIBuilder<T> uriBuilder) {
        boolean seedList = uri.startsWith("mongodb+srv://");
        Function4 & Serializable createUri = (Function4 & Serializable)(hosts, options, ignoredOptions, db) -> uriBuilder.apply((ListSet<Tuple2<String, Object>>)hosts, (MongoConnectionOptions)options, (List<String>)ignoredOptions, (Option<String>)db).recoverWith((PartialFunction)new Serializable(uri){
            private final String uri$2;
            {
                this.uri$2 = uri$7;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof IllegalArgumentException) {
                    IllegalArgumentException cause = (IllegalArgumentException)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof IllegalArgumentException) {
                    IllegalArgumentException cause = (IllegalArgumentException)throwable;
                    return Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(2).append(cause.getMessage()).append(": ").append(this.uri$2).toString()));
                }
                return function1.apply((Object)x);
            }
        }, ec);
        return (uri.startsWith("mongodb://") ? Future$.MODULE$.successful((Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(uri), 10)) : (seedList ? Future$.MODULE$.successful((Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(uri), 14)) : Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(16).append("Invalid scheme: ").append(uri).toString())))).map((Function1 & Serializable)useful -> {
            String setSpec = StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(useful), (Function1 & Serializable)_$4 -> MongoConnection$.$anonfun$4(BoxesRunTime.unboxToChar((Object)_$4)));
            int credentialEnd = setSpec.indexOf("@");
            return Tuple3$.MODULE$.apply(useful, (Object)setSpec, (Object)BoxesRunTime.boxToInteger((int)credentialEnd));
        }, ec).flatMap((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                String useful = (String)tuple3._1();
                String setSpec = (String)tuple3._2();
                int credentialEnd = BoxesRunTime.unboxToInt((Object)tuple3._3());
                MongoConnectionOptions empty = MongoConnectionOptions$.MODULE$.default();
                MongoConnectionOptions initial = !seedList ? empty : empty.copy(empty.copy$default$1(), empty.copy$default$2(), true, empty.copy$default$4(), empty.copy$default$5(), empty.copy$default$6(), empty.copy$default$7(), empty.copy$default$8(), empty.copy$default$9(), empty.copy$default$10(), empty.copy$default$11(), empty.copy$default$12(), empty.copy$default$13(), empty.copy$default$14(), empty.copy$default$15(), empty.copy$default$16(), empty.copy$default$17(), empty.copy$default$18(), empty.copy$default$19(), empty.copy$default$20(), empty.copy$default$21());
                return this.txtOptions$1(seedList, setSpec, credentialEnd, txtResolver, ec).flatMap((Function1 & Serializable)txt -> this.parseOptions(this.optionStr$1(useful, setSpec)).map((Function1 & Serializable)os -> {
                    Tuple2<List<String>, MongoConnectionOptions> opts = MODULE$.makeOptions((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)txt.$plus$plus((IterableOnce)os)), initial);
                    return Tuple2$.MODULE$.apply(os, opts);
                }, ec).flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        scala.collection.immutable.Map os = (scala.collection.immutable.Map)tuple2._1();
                        Tuple2 opts = (Tuple2)tuple2._2();
                        return (((MongoConnectionOptions)opts._2()).maxIdleTimeMS() != 0 && ((MongoConnectionOptions)opts._2()).maxIdleTimeMS() < ((MongoConnectionOptions)opts._2()).heartbeatFrequencyMS() ? Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(61).append("Invalid URI options: maxIdleTimeMS(").append(((MongoConnectionOptions)opts._2()).maxIdleTimeMS()).append(") < heartbeatFrequencyMS(").append(((MongoConnectionOptions)opts._2()).heartbeatFrequencyMS()).append(")").toString())) : Future$.MODULE$.successful((Object)opts)).map((Function1 & Serializable)res -> res, ec);
                    }
                    throw new MatchError((Object)tuple2);
                }, ec), ec).flatMap((Function1 & Serializable)x$12 -> {
                    Tuple2 tuple2 = x$12;
                    if (tuple2 != null) {
                        Future future;
                        List unsupportedKeys = (List)tuple2._1();
                        MongoConnectionOptions options = (MongoConnectionOptions)tuple2._2();
                        if (credentialEnd == -1) {
                            future = MODULE$.parseHostsAndDB(seedList, setSpec, srvRecResolver, ec).flatMap((Function1 & Serializable)x$1 -> {
                                Tuple2 tuple2 = x$1;
                                if (tuple2 != null) {
                                    Option db = (Option)tuple2._1();
                                    ListSet hosts = (ListSet)tuple2._2();
                                    AuthenticationMode authenticationMode = options.authenticationMechanism();
                                    if (X509Authentication$.MODULE$.equals(authenticationMode)) {
                                        Option option = db;
                                        if (option instanceof Some) {
                                            String dbName = (String)((Some)option).value();
                                            Object[] objectArray = new Tuple2[1];
                                            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)dbName);
                                            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)MongoConnectionOptions$Credential$.MODULE$.apply("", (Option<String>)None$.MODULE$));
                                            scala.collection.immutable.Map map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                                            int n = options.copy$default$1();
                                            Option<String> option2 = options.copy$default$2();
                                            boolean bl = options.copy$default$3();
                                            boolean bl2 = options.copy$default$4();
                                            AuthenticationMode authenticationMode2 = options.copy$default$5();
                                            boolean bl3 = options.copy$default$6();
                                            boolean bl4 = options.copy$default$7();
                                            int n2 = options.copy$default$8();
                                            Option<Object> option3 = options.copy$default$9();
                                            int n3 = options.copy$default$10();
                                            int n4 = options.copy$default$11();
                                            WriteConcern writeConcern = options.copy$default$12();
                                            ReadPreference readPreference = options.copy$default$13();
                                            FailoverStrategy failoverStrategy = options.copy$default$14();
                                            int n5 = options.copy$default$15();
                                            int n6 = options.copy$default$16();
                                            int n7 = options.copy$default$17();
                                            Option<MongoConnectionOptions.KeyStore> option4 = options.copy$default$19();
                                            ReadConcern readConcern = options.copy$default$20();
                                            Option<String> option5 = options.copy$default$21();
                                            MongoConnectionOptions optsWithX509 = options.copy(n, option2, bl, bl2, authenticationMode2, bl3, bl4, n2, option3, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, (scala.collection.immutable.Map<String, MongoConnectionOptions.Credential>)map, option4, readConcern, option5);
                                            return (Future)createUri.apply((Object)hosts, (Object)optsWithX509, (Object)unsupportedKeys, (Object)db);
                                        }
                                        return Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(84).append("Could not parse URI '").append(uri).append("': authentication information found but no database name in URI").toString()));
                                    }
                                    return (Future)createUri.apply((Object)hosts, (Object)options, (Object)unsupportedKeys, (Object)db);
                                }
                                throw new MatchError((Object)tuple2);
                            }, ec);
                        } else {
                            List list;
                            Option option;
                            Regex WithAuth = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([^:]+)(|:[^@]*)@(.+)"));
                            String string = setSpec;
                            if (string != null && !(option = WithAuth.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(3) == 0) {
                                String string2 = (String)list.apply(0);
                                String string3 = (String)list.apply(1);
                                String string4 = (String)list.apply(2);
                                String user = string2;
                                String p = string3;
                                String hostsPortsAndDB = string4;
                                String pass = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(p), ":");
                                future = MODULE$.parseHostsAndDB(seedList, hostsPortsAndDB, srvRecResolver, ec).flatMap((Function1 & Serializable)x$1 -> {
                                    Option option;
                                    Tuple2 tuple2 = x$1;
                                    if (tuple2 != null && (option = (Option)tuple2._1()) instanceof Some) {
                                        String database = (String)((Some)option).value();
                                        ListSet hosts = (ListSet)tuple2._2();
                                        AuthenticationMode authenticationMode = options.authenticationMechanism();
                                        X509Authentication$ x509Authentication$ = X509Authentication$.MODULE$;
                                        if (!(authenticationMode != null ? !authenticationMode.equals(x509Authentication$) : x509Authentication$ != null) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(pass))) {
                                            return Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException("You should not provide a password when authenticating with X509 authentication"));
                                        }
                                        AuthenticationMode authenticationMode2 = options.authenticationMechanism();
                                        X509Authentication$ x509Authentication$2 = X509Authentication$.MODULE$;
                                        Option password = (authenticationMode2 == null ? x509Authentication$2 != null : !authenticationMode2.equals(x509Authentication$2)) ? Option$.MODULE$.apply((Object)pass) : Option$.MODULE$.empty();
                                        String authDb = (String)options.authenticationDatabase().getOrElse(() -> MongoConnection$.$anonfun$6(database));
                                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)authDb);
                                        scala.collection.immutable.Map map = (scala.collection.immutable.Map)options.credentials().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)MongoConnectionOptions$Credential$.MODULE$.apply(user, (Option<String>)password)));
                                        int n = options.copy$default$1();
                                        Option<String> option2 = options.copy$default$2();
                                        boolean bl = options.copy$default$3();
                                        boolean bl2 = options.copy$default$4();
                                        AuthenticationMode authenticationMode3 = options.copy$default$5();
                                        boolean bl3 = options.copy$default$6();
                                        boolean bl4 = options.copy$default$7();
                                        int n2 = options.copy$default$8();
                                        Option<Object> option3 = options.copy$default$9();
                                        int n3 = options.copy$default$10();
                                        int n4 = options.copy$default$11();
                                        WriteConcern writeConcern = options.copy$default$12();
                                        ReadPreference readPreference = options.copy$default$13();
                                        FailoverStrategy failoverStrategy = options.copy$default$14();
                                        int n5 = options.copy$default$15();
                                        int n6 = options.copy$default$16();
                                        int n7 = options.copy$default$17();
                                        Option<MongoConnectionOptions.KeyStore> option4 = options.copy$default$19();
                                        ReadConcern readConcern = options.copy$default$20();
                                        Option<String> option5 = options.copy$default$21();
                                        MongoConnectionOptions optsWithCred = options.copy(n, option2, bl, bl2, authenticationMode3, bl3, bl4, n2, option3, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, (scala.collection.immutable.Map<String, MongoConnectionOptions.Credential>)map, option4, readConcern, option5);
                                        return (Future)createUri.apply((Object)hosts, (Object)optsWithCred, (Object)unsupportedKeys, (Object)Some$.MODULE$.apply((Object)database));
                                    }
                                    return Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(84).append("Could not parse URI '").append(uri).append("': authentication information found but no database name in URI").toString()));
                                }, ec);
                            } else {
                                future = Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(22).append("Could not parse URI '").append(uri).append("'").toString()));
                            }
                        }
                        return future.map((Function1 & Serializable)parsedUri -> parsedUri, ec);
                    }
                    throw new MatchError((Object)tuple2);
                }, ec);
            }
            throw new MatchError((Object)tuple3);
        }, ec);
    }

    private Future<ListSet<Tuple2<String, Object>>> parseHosts(boolean seedList, String hosts, Function1<ExecutionContext, Function1<String, Future<Record[]>>> srvRecResolver, ExecutionContext ec) {
        if (seedList) {
            return ((Future)Await$.MODULE$.ready(package$.MODULE$.srvRecords(hosts, srvRecResolver, ec), (Duration)package$.MODULE$.dnsTimeout())).map((Function1 & Serializable)_$6 -> (ListSet)ListSet$.MODULE$.empty().$plus$plus((IterableOnce)_$6), ec);
        }
        Builder buf = ListSet$.MODULE$.newBuilder();
        return this.parse$1(buf, (Iterable)Predef$.MODULE$.wrapRefArray((Object[])hosts.split(",")));
    }

    private Future<Tuple2<Option<String>, ListSet<Tuple2<String, Object>>>> parseHostsAndDB(boolean seedList, String input, Function1<ExecutionContext, Function1<String, Future<Record[]>>> srvRecResolver, ExecutionContext ec) {
        Tuple2 tuple2 = StringOps$.MODULE$.span$extension(Predef$.MODULE$.augmentString(input), (Function1 & Serializable)_$8 -> MongoConnection$.parseHostsAndDB$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$8)));
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String string2 = (String)tuple2._2();
            String hosts = string;
            if ("".equals(string2)) {
                return this.parseHosts(seedList, hosts, srvRecResolver, ec).map((Function1 & Serializable)_$9 -> {
                    None$ none$ = (None$)Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)none$, _$9);
                }, ec);
            }
            String hosts2 = string;
            String dbName = string2;
            return this.parseHosts(seedList, hosts2, srvRecResolver, ec).map((Function1 & Serializable)_$10 -> {
                Some some = (Some)Predef$.MODULE$.ArrowAssoc((Object)Some$.MODULE$.apply((Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(dbName), 1)));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)some, _$10);
            }, ec);
        }
        throw new MatchError((Object)tuple2);
    }

    private Future<scala.collection.immutable.Map<String, String>> parseOptions(String options) {
        if (options.isEmpty()) {
            return Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().empty());
        }
        Map buf = (Map)Map$.MODULE$.empty();
        return this.parse$2(options, buf, (Iterable)Predef$.MODULE$.wrapRefArray((Object[])options.split("&")));
    }

    private Tuple2<List<String>, MongoConnectionOptions> makeOptions(scala.collection.immutable.Map<String, String> opts, MongoConnectionOptions initial) {
        MongoConnection.ParseState parsed1 = (MongoConnection.ParseState)opts.iterator().foldLeft((Object)MongoConnection$ParseState$.MODULE$.apply(initial, MongoConnection$ParseState$.MODULE$.$lessinit$greater$default$2()), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                MongoConnection.ParseState parseState = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                MongoConnection.ParseState state = parseState;
                if (tuple22 != null) {
                    List list;
                    Option option;
                    List list2;
                    Option option2;
                    Option<ReadConcern> option3;
                    List list3;
                    Option option4;
                    List list4;
                    Option option5;
                    List list5;
                    Option option6;
                    Option<Tuple2<ListSet<Compressor>, Seq<String>>> option7;
                    String string = (String)tuple22._1();
                    String string2 = (String)tuple22._2();
                    if ("replicaSet".equals(string)) {
                        this.logger().info((Function0<String>)((Function0 & Serializable)MongoConnection$::$anonfun$7$$anonfun$1));
                        return state;
                    }
                    MongoConnection.ParseState state2 = parseState;
                    if ("authenticationMechanism".equals(string) && "x509".equals(string2)) {
                        return state2.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$12 -> {
                            X509Authentication$ x509Authentication$ = X509Authentication$.MODULE$;
                            int n = _$12.copy$default$1();
                            Option<String> option = _$12.copy$default$2();
                            boolean bl = _$12.copy$default$3();
                            boolean bl2 = _$12.copy$default$4();
                            boolean bl3 = _$12.copy$default$6();
                            boolean bl4 = _$12.copy$default$7();
                            int n2 = _$12.copy$default$8();
                            Option<Object> option2 = _$12.copy$default$9();
                            int n3 = _$12.copy$default$10();
                            int n4 = _$12.copy$default$11();
                            WriteConcern writeConcern = _$12.copy$default$12();
                            ReadPreference readPreference = _$12.copy$default$13();
                            FailoverStrategy failoverStrategy = _$12.copy$default$14();
                            int n5 = _$12.copy$default$15();
                            int n6 = _$12.copy$default$16();
                            int n7 = _$12.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$12.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$12.copy$default$19();
                            ReadConcern readConcern = _$12.copy$default$20();
                            Option<String> option4 = _$12.copy$default$21();
                            return _$12.copy(n, option, bl, bl2, x509Authentication$, bl3, bl4, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state3 = parseState;
                    if ("authenticationMechanism".equals(string) && "scram-sha256".equals(string2)) {
                        return state3.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$13 -> {
                            ScramSha256Authentication$ scramSha256Authentication$ = ScramSha256Authentication$.MODULE$;
                            int n = _$13.copy$default$1();
                            Option<String> option = _$13.copy$default$2();
                            boolean bl = _$13.copy$default$3();
                            boolean bl2 = _$13.copy$default$4();
                            boolean bl3 = _$13.copy$default$6();
                            boolean bl4 = _$13.copy$default$7();
                            int n2 = _$13.copy$default$8();
                            Option<Object> option2 = _$13.copy$default$9();
                            int n3 = _$13.copy$default$10();
                            int n4 = _$13.copy$default$11();
                            WriteConcern writeConcern = _$13.copy$default$12();
                            ReadPreference readPreference = _$13.copy$default$13();
                            FailoverStrategy failoverStrategy = _$13.copy$default$14();
                            int n5 = _$13.copy$default$15();
                            int n6 = _$13.copy$default$16();
                            int n7 = _$13.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$13.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$13.copy$default$19();
                            ReadConcern readConcern = _$13.copy$default$20();
                            Option<String> option4 = _$13.copy$default$21();
                            return _$13.copy(n, option, bl, bl2, scramSha256Authentication$, bl3, bl4, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state4 = parseState;
                    if ("authenticationMechanism".equals(string)) {
                        return state4.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$14 -> {
                            ScramSha1Authentication$ scramSha1Authentication$ = ScramSha1Authentication$.MODULE$;
                            int n = _$14.copy$default$1();
                            Option<String> option = _$14.copy$default$2();
                            boolean bl = _$14.copy$default$3();
                            boolean bl2 = _$14.copy$default$4();
                            boolean bl3 = _$14.copy$default$6();
                            boolean bl4 = _$14.copy$default$7();
                            int n2 = _$14.copy$default$8();
                            Option<Object> option2 = _$14.copy$default$9();
                            int n3 = _$14.copy$default$10();
                            int n4 = _$14.copy$default$11();
                            WriteConcern writeConcern = _$14.copy$default$12();
                            ReadPreference readPreference = _$14.copy$default$13();
                            FailoverStrategy failoverStrategy = _$14.copy$default$14();
                            int n5 = _$14.copy$default$15();
                            int n6 = _$14.copy$default$16();
                            int n7 = _$14.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$14.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$14.copy$default$19();
                            ReadConcern readConcern = _$14.copy$default$20();
                            Option<String> option4 = _$14.copy$default$21();
                            return _$14.copy(n, option, bl, bl2, scramSha1Authentication$, bl3, bl4, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state5 = parseState;
                    if ("authenticationDatabase".equals(string) || "authSource".equals(string)) {
                        String n = string;
                        String v2 = string2;
                        this.deprecated$1(n, "authenticationDatabase");
                        return state5.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$15 -> {
                            Some some = Some$.MODULE$.apply((Object)v2);
                            int n = _$15.copy$default$1();
                            boolean bl = _$15.copy$default$3();
                            boolean bl2 = _$15.copy$default$4();
                            AuthenticationMode authenticationMode = _$15.copy$default$5();
                            boolean bl3 = _$15.copy$default$6();
                            boolean bl4 = _$15.copy$default$7();
                            int n2 = _$15.copy$default$8();
                            Option<Object> option = _$15.copy$default$9();
                            int n3 = _$15.copy$default$10();
                            int n4 = _$15.copy$default$11();
                            WriteConcern writeConcern = _$15.copy$default$12();
                            ReadPreference readPreference = _$15.copy$default$13();
                            FailoverStrategy failoverStrategy = _$15.copy$default$14();
                            int n5 = _$15.copy$default$15();
                            int n6 = _$15.copy$default$16();
                            int n7 = _$15.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$15.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option2 = _$15.copy$default$19();
                            ReadConcern readConcern = _$15.copy$default$20();
                            Option<String> option3 = _$15.copy$default$21();
                            return _$15.copy(n, (Option<String>)some, bl, bl2, authenticationMode, bl3, bl4, n2, option, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option2, readConcern, option3);
                        });
                    }
                    MongoConnection.ParseState state6 = parseState;
                    if ("connectTimeoutMS".equals(string)) {
                        String v3 = string2;
                        return state6.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$16 -> _$16.copy(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(v3)), _$16.copy$default$2(), _$16.copy$default$3(), _$16.copy$default$4(), _$16.copy$default$5(), _$16.copy$default$6(), _$16.copy$default$7(), _$16.copy$default$8(), _$16.copy$default$9(), _$16.copy$default$10(), _$16.copy$default$11(), _$16.copy$default$12(), _$16.copy$default$13(), _$16.copy$default$14(), _$16.copy$default$15(), _$16.copy$default$16(), _$16.copy$default$17(), _$16.copy$default$18(), _$16.copy$default$19(), _$16.copy$default$20(), _$16.copy$default$21()));
                    }
                    MongoConnection.ParseState state7 = parseState;
                    if ("maxIdleTimeMS".equals(string)) {
                        String v4 = string2;
                        return state7.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$17 -> {
                            int n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(v4));
                            int n2 = _$17.copy$default$1();
                            Option<String> option = _$17.copy$default$2();
                            boolean bl = _$17.copy$default$3();
                            boolean bl2 = _$17.copy$default$4();
                            AuthenticationMode authenticationMode = _$17.copy$default$5();
                            boolean bl3 = _$17.copy$default$6();
                            boolean bl4 = _$17.copy$default$7();
                            int n3 = _$17.copy$default$8();
                            Option<Object> option2 = _$17.copy$default$9();
                            int n4 = _$17.copy$default$10();
                            int n5 = _$17.copy$default$11();
                            WriteConcern writeConcern = _$17.copy$default$12();
                            ReadPreference readPreference = _$17.copy$default$13();
                            FailoverStrategy failoverStrategy = _$17.copy$default$14();
                            int n6 = _$17.copy$default$15();
                            int n7 = _$17.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$17.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$17.copy$default$19();
                            ReadConcern readConcern = _$17.copy$default$20();
                            Option<String> option4 = _$17.copy$default$21();
                            return _$17.copy(n2, option, bl, bl2, authenticationMode, bl3, bl4, n3, option2, n4, n5, writeConcern, readPreference, failoverStrategy, n6, n, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state8 = parseState;
                    if ("ssl".equals(string)) {
                        String v5 = string2;
                        return state8.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$18 -> {
                            boolean bl = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(v5));
                            int n = _$18.copy$default$1();
                            Option<String> option = _$18.copy$default$2();
                            boolean bl2 = _$18.copy$default$4();
                            AuthenticationMode authenticationMode = _$18.copy$default$5();
                            boolean bl3 = _$18.copy$default$6();
                            boolean bl4 = _$18.copy$default$7();
                            int n2 = _$18.copy$default$8();
                            Option<Object> option2 = _$18.copy$default$9();
                            int n3 = _$18.copy$default$10();
                            int n4 = _$18.copy$default$11();
                            WriteConcern writeConcern = _$18.copy$default$12();
                            ReadPreference readPreference = _$18.copy$default$13();
                            FailoverStrategy failoverStrategy = _$18.copy$default$14();
                            int n5 = _$18.copy$default$15();
                            int n6 = _$18.copy$default$16();
                            int n7 = _$18.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$18.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$18.copy$default$19();
                            ReadConcern readConcern = _$18.copy$default$20();
                            Option<String> option4 = _$18.copy$default$21();
                            return _$18.copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state9 = parseState;
                    if ("sslAllowsInvalidCert".equals(string)) {
                        String v6 = string2;
                        return state9.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$19 -> {
                            boolean bl = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(v6));
                            int n = _$19.copy$default$1();
                            Option<String> option = _$19.copy$default$2();
                            boolean bl2 = _$19.copy$default$3();
                            AuthenticationMode authenticationMode = _$19.copy$default$5();
                            boolean bl3 = _$19.copy$default$6();
                            boolean bl4 = _$19.copy$default$7();
                            int n2 = _$19.copy$default$8();
                            Option<Object> option2 = _$19.copy$default$9();
                            int n3 = _$19.copy$default$10();
                            int n4 = _$19.copy$default$11();
                            WriteConcern writeConcern = _$19.copy$default$12();
                            ReadPreference readPreference = _$19.copy$default$13();
                            FailoverStrategy failoverStrategy = _$19.copy$default$14();
                            int n5 = _$19.copy$default$15();
                            int n6 = _$19.copy$default$16();
                            int n7 = _$19.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$19.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$19.copy$default$19();
                            ReadConcern readConcern = _$19.copy$default$20();
                            Option<String> option4 = _$19.copy$default$21();
                            return _$19.copy(n, option, bl2, bl, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state10 = parseState;
                    if ("compressors".equals(string) && string2 != null && !(option7 = MongoConnection$Compressors$.MODULE$.unapply(string2)).isEmpty()) {
                        Tuple2 tuple23 = (Tuple2)option7.get();
                        ListSet compressors = (ListSet)tuple23._1();
                        Seq invalid = (Seq)tuple23._2();
                        return ((MongoConnection.ParseState)invalid.foldLeft((Object)state10, (Function2 & Serializable)(st, c) -> {
                            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"compressors");
                            return st.reject((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, c));
                        })).updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$20 -> _$20.withCompressors((ListSet<Compressor>)compressors));
                    }
                    MongoConnection.ParseState state11 = parseState;
                    if ("rm.tcpNoDelay".equals(string)) {
                        String v7 = string2;
                        return state11.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$21 -> {
                            boolean bl = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(v7));
                            int n = _$21.copy$default$1();
                            Option<String> option = _$21.copy$default$2();
                            boolean bl2 = _$21.copy$default$3();
                            boolean bl3 = _$21.copy$default$4();
                            AuthenticationMode authenticationMode = _$21.copy$default$5();
                            boolean bl4 = _$21.copy$default$7();
                            int n2 = _$21.copy$default$8();
                            Option<Object> option2 = _$21.copy$default$9();
                            int n3 = _$21.copy$default$10();
                            int n4 = _$21.copy$default$11();
                            WriteConcern writeConcern = _$21.copy$default$12();
                            ReadPreference readPreference = _$21.copy$default$13();
                            FailoverStrategy failoverStrategy = _$21.copy$default$14();
                            int n5 = _$21.copy$default$15();
                            int n6 = _$21.copy$default$16();
                            int n7 = _$21.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$21.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$21.copy$default$19();
                            ReadConcern readConcern = _$21.copy$default$20();
                            Option<String> option4 = _$21.copy$default$21();
                            return _$21.copy(n, option, bl2, bl3, authenticationMode, bl, bl4, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state12 = parseState;
                    if ("rm.keepAlive".equals(string)) {
                        String v8 = string2;
                        return state12.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$22 -> {
                            boolean bl = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(v8));
                            int n = _$22.copy$default$1();
                            Option<String> option = _$22.copy$default$2();
                            boolean bl2 = _$22.copy$default$3();
                            boolean bl3 = _$22.copy$default$4();
                            AuthenticationMode authenticationMode = _$22.copy$default$5();
                            boolean bl4 = _$22.copy$default$6();
                            int n2 = _$22.copy$default$8();
                            Option<Object> option2 = _$22.copy$default$9();
                            int n3 = _$22.copy$default$10();
                            int n4 = _$22.copy$default$11();
                            WriteConcern writeConcern = _$22.copy$default$12();
                            ReadPreference readPreference = _$22.copy$default$13();
                            FailoverStrategy failoverStrategy = _$22.copy$default$14();
                            int n5 = _$22.copy$default$15();
                            int n6 = _$22.copy$default$16();
                            int n7 = _$22.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$22.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$22.copy$default$19();
                            ReadConcern readConcern = _$22.copy$default$20();
                            Option<String> option4 = _$22.copy$default$21();
                            return _$22.copy(n, option, bl2, bl3, authenticationMode, bl4, bl, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state13 = parseState;
                    if ("rm.nbChannelsPerNode".equals(string)) {
                        String v9 = string2;
                        return state13.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$23 -> {
                            int n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(v9));
                            int n2 = _$23.copy$default$1();
                            Option<String> option = _$23.copy$default$2();
                            boolean bl = _$23.copy$default$3();
                            boolean bl2 = _$23.copy$default$4();
                            AuthenticationMode authenticationMode = _$23.copy$default$5();
                            boolean bl3 = _$23.copy$default$6();
                            boolean bl4 = _$23.copy$default$7();
                            Option<Object> option2 = _$23.copy$default$9();
                            int n3 = _$23.copy$default$10();
                            int n4 = _$23.copy$default$11();
                            WriteConcern writeConcern = _$23.copy$default$12();
                            ReadPreference readPreference = _$23.copy$default$13();
                            FailoverStrategy failoverStrategy = _$23.copy$default$14();
                            int n5 = _$23.copy$default$15();
                            int n6 = _$23.copy$default$16();
                            int n7 = _$23.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$23.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$23.copy$default$19();
                            ReadConcern readConcern = _$23.copy$default$20();
                            Option<String> option4 = _$23.copy$default$21();
                            return _$23.copy(n2, option, bl, bl2, authenticationMode, bl3, bl4, n, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state14 = parseState;
                    if ("rm.maxInFlightRequestsPerChannel".equals(string) && string2 != null && !(option6 = UnsignedInt.unapplySeq((CharSequence)string2)).isEmpty() && (list5 = (List)option6.get()).lengthCompare(1) == 0) {
                        String string3;
                        String max = string3 = (String)list5.apply(0);
                        return state14.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$24 -> {
                            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(max))));
                            int n = _$24.copy$default$1();
                            Option<String> option = _$24.copy$default$2();
                            boolean bl = _$24.copy$default$3();
                            boolean bl2 = _$24.copy$default$4();
                            AuthenticationMode authenticationMode = _$24.copy$default$5();
                            boolean bl3 = _$24.copy$default$6();
                            boolean bl4 = _$24.copy$default$7();
                            int n2 = _$24.copy$default$8();
                            int n3 = _$24.copy$default$10();
                            int n4 = _$24.copy$default$11();
                            WriteConcern writeConcern = _$24.copy$default$12();
                            ReadPreference readPreference = _$24.copy$default$13();
                            FailoverStrategy failoverStrategy = _$24.copy$default$14();
                            int n5 = _$24.copy$default$15();
                            int n6 = _$24.copy$default$16();
                            int n7 = _$24.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$24.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option2 = _$24.copy$default$19();
                            ReadConcern readConcern = _$24.copy$default$20();
                            Option<String> option3 = _$24.copy$default$21();
                            return _$24.copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, (Option<Object>)some, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option2, readConcern, option3);
                        });
                    }
                    MongoConnection.ParseState state15 = parseState;
                    if ("rm.minIdleChannelsPerNode".equals(string) && string2 != null && !(option5 = UnsignedInt.unapplySeq((CharSequence)string2)).isEmpty() && (list4 = (List)option5.get()).lengthCompare(1) == 0) {
                        String string4;
                        String min = string4 = (String)list4.apply(0);
                        return state15.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$25 -> {
                            int n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(min));
                            int n2 = _$25.copy$default$1();
                            Option<String> option = _$25.copy$default$2();
                            boolean bl = _$25.copy$default$3();
                            boolean bl2 = _$25.copy$default$4();
                            AuthenticationMode authenticationMode = _$25.copy$default$5();
                            boolean bl3 = _$25.copy$default$6();
                            boolean bl4 = _$25.copy$default$7();
                            int n3 = _$25.copy$default$8();
                            Option<Object> option2 = _$25.copy$default$9();
                            int n4 = _$25.copy$default$11();
                            WriteConcern writeConcern = _$25.copy$default$12();
                            ReadPreference readPreference = _$25.copy$default$13();
                            FailoverStrategy failoverStrategy = _$25.copy$default$14();
                            int n5 = _$25.copy$default$15();
                            int n6 = _$25.copy$default$16();
                            int n7 = _$25.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$25.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$25.copy$default$19();
                            ReadConcern readConcern = _$25.copy$default$20();
                            Option<String> option4 = _$25.copy$default$21();
                            return _$25.copy(n2, option, bl, bl2, authenticationMode, bl3, bl4, n3, option2, n, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state16 = parseState;
                    if ("rm.maxNonQueryableHeartbeats".equals(string) && string2 != null && !(option4 = UnsignedInt.unapplySeq((CharSequence)string2)).isEmpty() && (list3 = (List)option4.get()).lengthCompare(1) == 0) {
                        String string5;
                        String max;
                        String string6 = max = (string5 = (String)list3.apply(0));
                        String string7 = "0";
                        if (string6 == null ? string7 != null : !string6.equals(string7)) {
                            return state16.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$26 -> _$26.withMaxNonQueryableHeartbeats(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(max))));
                        }
                    }
                    MongoConnection.ParseState state17 = parseState;
                    if ("writeConcern".equals(string) && "unacknowledged".equals(string2)) {
                        return state17.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$27 -> {
                            WriteConcern writeConcern = WriteConcern$.MODULE$.Unacknowledged();
                            int n = _$27.copy$default$1();
                            Option<String> option = _$27.copy$default$2();
                            boolean bl = _$27.copy$default$3();
                            boolean bl2 = _$27.copy$default$4();
                            AuthenticationMode authenticationMode = _$27.copy$default$5();
                            boolean bl3 = _$27.copy$default$6();
                            boolean bl4 = _$27.copy$default$7();
                            int n2 = _$27.copy$default$8();
                            Option<Object> option2 = _$27.copy$default$9();
                            int n3 = _$27.copy$default$10();
                            int n4 = _$27.copy$default$11();
                            ReadPreference readPreference = _$27.copy$default$13();
                            FailoverStrategy failoverStrategy = _$27.copy$default$14();
                            int n5 = _$27.copy$default$15();
                            int n6 = _$27.copy$default$16();
                            int n7 = _$27.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$27.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$27.copy$default$19();
                            ReadConcern readConcern = _$27.copy$default$20();
                            Option<String> option4 = _$27.copy$default$21();
                            return _$27.copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state18 = parseState;
                    if ("writeConcern".equals(string) && "acknowledged".equals(string2)) {
                        return state18.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$28 -> {
                            WriteConcern writeConcern = WriteConcern$.MODULE$.Acknowledged();
                            int n = _$28.copy$default$1();
                            Option<String> option = _$28.copy$default$2();
                            boolean bl = _$28.copy$default$3();
                            boolean bl2 = _$28.copy$default$4();
                            AuthenticationMode authenticationMode = _$28.copy$default$5();
                            boolean bl3 = _$28.copy$default$6();
                            boolean bl4 = _$28.copy$default$7();
                            int n2 = _$28.copy$default$8();
                            Option<Object> option2 = _$28.copy$default$9();
                            int n3 = _$28.copy$default$10();
                            int n4 = _$28.copy$default$11();
                            ReadPreference readPreference = _$28.copy$default$13();
                            FailoverStrategy failoverStrategy = _$28.copy$default$14();
                            int n5 = _$28.copy$default$15();
                            int n6 = _$28.copy$default$16();
                            int n7 = _$28.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$28.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$28.copy$default$19();
                            ReadConcern readConcern = _$28.copy$default$20();
                            Option<String> option4 = _$28.copy$default$21();
                            return _$28.copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state19 = parseState;
                    if ("writeConcern".equals(string) && "journaled".equals(string2)) {
                        return state19.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$29 -> {
                            WriteConcern writeConcern = WriteConcern$.MODULE$.Journaled();
                            int n = _$29.copy$default$1();
                            Option<String> option = _$29.copy$default$2();
                            boolean bl = _$29.copy$default$3();
                            boolean bl2 = _$29.copy$default$4();
                            AuthenticationMode authenticationMode = _$29.copy$default$5();
                            boolean bl3 = _$29.copy$default$6();
                            boolean bl4 = _$29.copy$default$7();
                            int n2 = _$29.copy$default$8();
                            Option<Object> option2 = _$29.copy$default$9();
                            int n3 = _$29.copy$default$10();
                            int n4 = _$29.copy$default$11();
                            ReadPreference readPreference = _$29.copy$default$13();
                            FailoverStrategy failoverStrategy = _$29.copy$default$14();
                            int n5 = _$29.copy$default$15();
                            int n6 = _$29.copy$default$16();
                            int n7 = _$29.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$29.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$29.copy$default$19();
                            ReadConcern readConcern = _$29.copy$default$20();
                            Option<String> option4 = _$29.copy$default$21();
                            return _$29.copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state20 = parseState;
                    if ("writeConcern".equals(string) && "default".equals(string2)) {
                        return state20.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$30 -> {
                            WriteConcern writeConcern = WriteConcern$.MODULE$.Default();
                            int n = _$30.copy$default$1();
                            Option<String> option = _$30.copy$default$2();
                            boolean bl = _$30.copy$default$3();
                            boolean bl2 = _$30.copy$default$4();
                            AuthenticationMode authenticationMode = _$30.copy$default$5();
                            boolean bl3 = _$30.copy$default$6();
                            boolean bl4 = _$30.copy$default$7();
                            int n2 = _$30.copy$default$8();
                            Option<Object> option2 = _$30.copy$default$9();
                            int n3 = _$30.copy$default$10();
                            int n4 = _$30.copy$default$11();
                            ReadPreference readPreference = _$30.copy$default$13();
                            FailoverStrategy failoverStrategy = _$30.copy$default$14();
                            int n5 = _$30.copy$default$15();
                            int n6 = _$30.copy$default$16();
                            int n7 = _$30.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$30.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$30.copy$default$19();
                            ReadConcern readConcern = _$30.copy$default$20();
                            Option<String> option4 = _$30.copy$default$21();
                            return _$30.copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state21 = parseState;
                    if ("readPreference".equals(string) && "primary".equals(string2)) {
                        return state21.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$31 -> {
                            ReadPreference$Primary$ readPreference$Primary$ = ReadPreference$.MODULE$.primary();
                            int n = _$31.copy$default$1();
                            Option<String> option = _$31.copy$default$2();
                            boolean bl = _$31.copy$default$3();
                            boolean bl2 = _$31.copy$default$4();
                            AuthenticationMode authenticationMode = _$31.copy$default$5();
                            boolean bl3 = _$31.copy$default$6();
                            boolean bl4 = _$31.copy$default$7();
                            int n2 = _$31.copy$default$8();
                            Option<Object> option2 = _$31.copy$default$9();
                            int n3 = _$31.copy$default$10();
                            int n4 = _$31.copy$default$11();
                            WriteConcern writeConcern = _$31.copy$default$12();
                            FailoverStrategy failoverStrategy = _$31.copy$default$14();
                            int n5 = _$31.copy$default$15();
                            int n6 = _$31.copy$default$16();
                            int n7 = _$31.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$31.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$31.copy$default$19();
                            ReadConcern readConcern = _$31.copy$default$20();
                            Option<String> option4 = _$31.copy$default$21();
                            return _$31.copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, readPreference$Primary$, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state22 = parseState;
                    if ("readPreference".equals(string) && "primaryPreferred".equals(string2)) {
                        return state22.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$32 -> {
                            ReadPreference.PrimaryPreferred primaryPreferred = ReadPreference$.MODULE$.primaryPreferred();
                            int n = _$32.copy$default$1();
                            Option<String> option = _$32.copy$default$2();
                            boolean bl = _$32.copy$default$3();
                            boolean bl2 = _$32.copy$default$4();
                            AuthenticationMode authenticationMode = _$32.copy$default$5();
                            boolean bl3 = _$32.copy$default$6();
                            boolean bl4 = _$32.copy$default$7();
                            int n2 = _$32.copy$default$8();
                            Option<Object> option2 = _$32.copy$default$9();
                            int n3 = _$32.copy$default$10();
                            int n4 = _$32.copy$default$11();
                            WriteConcern writeConcern = _$32.copy$default$12();
                            FailoverStrategy failoverStrategy = _$32.copy$default$14();
                            int n5 = _$32.copy$default$15();
                            int n6 = _$32.copy$default$16();
                            int n7 = _$32.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$32.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$32.copy$default$19();
                            ReadConcern readConcern = _$32.copy$default$20();
                            Option<String> option4 = _$32.copy$default$21();
                            return _$32.copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, primaryPreferred, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state23 = parseState;
                    if ("readPreference".equals(string) && "secondary".equals(string2)) {
                        return state23.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$33 -> {
                            ReadPreference.Secondary secondary = ReadPreference$.MODULE$.secondary();
                            int n = _$33.copy$default$1();
                            Option<String> option = _$33.copy$default$2();
                            boolean bl = _$33.copy$default$3();
                            boolean bl2 = _$33.copy$default$4();
                            AuthenticationMode authenticationMode = _$33.copy$default$5();
                            boolean bl3 = _$33.copy$default$6();
                            boolean bl4 = _$33.copy$default$7();
                            int n2 = _$33.copy$default$8();
                            Option<Object> option2 = _$33.copy$default$9();
                            int n3 = _$33.copy$default$10();
                            int n4 = _$33.copy$default$11();
                            WriteConcern writeConcern = _$33.copy$default$12();
                            FailoverStrategy failoverStrategy = _$33.copy$default$14();
                            int n5 = _$33.copy$default$15();
                            int n6 = _$33.copy$default$16();
                            int n7 = _$33.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$33.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$33.copy$default$19();
                            ReadConcern readConcern = _$33.copy$default$20();
                            Option<String> option4 = _$33.copy$default$21();
                            return _$33.copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, secondary, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state24 = parseState;
                    if ("readPreference".equals(string) && "secondaryPreferred".equals(string2)) {
                        return state24.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$34 -> {
                            ReadPreference.SecondaryPreferred secondaryPreferred = ReadPreference$.MODULE$.secondaryPreferred();
                            int n = _$34.copy$default$1();
                            Option<String> option = _$34.copy$default$2();
                            boolean bl = _$34.copy$default$3();
                            boolean bl2 = _$34.copy$default$4();
                            AuthenticationMode authenticationMode = _$34.copy$default$5();
                            boolean bl3 = _$34.copy$default$6();
                            boolean bl4 = _$34.copy$default$7();
                            int n2 = _$34.copy$default$8();
                            Option<Object> option2 = _$34.copy$default$9();
                            int n3 = _$34.copy$default$10();
                            int n4 = _$34.copy$default$11();
                            WriteConcern writeConcern = _$34.copy$default$12();
                            FailoverStrategy failoverStrategy = _$34.copy$default$14();
                            int n5 = _$34.copy$default$15();
                            int n6 = _$34.copy$default$16();
                            int n7 = _$34.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$34.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$34.copy$default$19();
                            ReadConcern readConcern = _$34.copy$default$20();
                            Option<String> option4 = _$34.copy$default$21();
                            return _$34.copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, secondaryPreferred, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state25 = parseState;
                    if ("readPreference".equals(string) && "nearest".equals(string2)) {
                        return state25.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$35 -> {
                            ReadPreference.Nearest nearest = ReadPreference$.MODULE$.nearest();
                            int n = _$35.copy$default$1();
                            Option<String> option = _$35.copy$default$2();
                            boolean bl = _$35.copy$default$3();
                            boolean bl2 = _$35.copy$default$4();
                            AuthenticationMode authenticationMode = _$35.copy$default$5();
                            boolean bl3 = _$35.copy$default$6();
                            boolean bl4 = _$35.copy$default$7();
                            int n2 = _$35.copy$default$8();
                            Option<Object> option2 = _$35.copy$default$9();
                            int n3 = _$35.copy$default$10();
                            int n4 = _$35.copy$default$11();
                            WriteConcern writeConcern = _$35.copy$default$12();
                            FailoverStrategy failoverStrategy = _$35.copy$default$14();
                            int n5 = _$35.copy$default$15();
                            int n6 = _$35.copy$default$16();
                            int n7 = _$35.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$35.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$35.copy$default$19();
                            ReadConcern readConcern = _$35.copy$default$20();
                            Option<String> option4 = _$35.copy$default$21();
                            return _$35.copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, nearest, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state26 = parseState;
                    if ("readConcernLevel".equals(string) && string2 != null && !(option3 = ReadConcern$.MODULE$.unapply(string2)).isEmpty()) {
                        ReadConcern readConcern;
                        ReadConcern c2 = readConcern = (ReadConcern)option3.get();
                        return state26.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$36 -> _$36.copy(_$36.copy$default$1(), _$36.copy$default$2(), _$36.copy$default$3(), _$36.copy$default$4(), _$36.copy$default$5(), _$36.copy$default$6(), _$36.copy$default$7(), _$36.copy$default$8(), _$36.copy$default$9(), _$36.copy$default$10(), _$36.copy$default$11(), _$36.copy$default$12(), _$36.copy$default$13(), _$36.copy$default$14(), _$36.copy$default$15(), _$36.copy$default$16(), _$36.copy$default$17(), _$36.copy$default$18(), _$36.copy$default$19(), c2, _$36.copy$default$21()));
                    }
                    MongoConnection.ParseState state27 = parseState;
                    if ("rm.failover".equals(string) && "default".equals(string2)) {
                        return state27;
                    }
                    MongoConnection.ParseState state28 = parseState;
                    if ("rm.failover".equals(string) && "remote".equals(string2)) {
                        return state28.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$37 -> {
                            FailoverStrategy failoverStrategy = FailoverStrategy$.MODULE$.remote();
                            int n = _$37.copy$default$1();
                            Option<String> option = _$37.copy$default$2();
                            boolean bl = _$37.copy$default$3();
                            boolean bl2 = _$37.copy$default$4();
                            AuthenticationMode authenticationMode = _$37.copy$default$5();
                            boolean bl3 = _$37.copy$default$6();
                            boolean bl4 = _$37.copy$default$7();
                            int n2 = _$37.copy$default$8();
                            Option<Object> option2 = _$37.copy$default$9();
                            int n3 = _$37.copy$default$10();
                            int n4 = _$37.copy$default$11();
                            WriteConcern writeConcern = _$37.copy$default$12();
                            ReadPreference readPreference = _$37.copy$default$13();
                            int n5 = _$37.copy$default$15();
                            int n6 = _$37.copy$default$16();
                            int n7 = _$37.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$37.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$37.copy$default$19();
                            ReadConcern readConcern = _$37.copy$default$20();
                            Option<String> option4 = _$37.copy$default$21();
                            return _$37.copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state29 = parseState;
                    if ("rm.failover".equals(string) && "strict".equals(string2)) {
                        return state29.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$38 -> {
                            FailoverStrategy failoverStrategy = FailoverStrategy$.MODULE$.strict();
                            int n = _$38.copy$default$1();
                            Option<String> option = _$38.copy$default$2();
                            boolean bl = _$38.copy$default$3();
                            boolean bl2 = _$38.copy$default$4();
                            AuthenticationMode authenticationMode = _$38.copy$default$5();
                            boolean bl3 = _$38.copy$default$6();
                            boolean bl4 = _$38.copy$default$7();
                            int n2 = _$38.copy$default$8();
                            Option<Object> option2 = _$38.copy$default$9();
                            int n3 = _$38.copy$default$10();
                            int n4 = _$38.copy$default$11();
                            WriteConcern writeConcern = _$38.copy$default$12();
                            ReadPreference readPreference = _$38.copy$default$13();
                            int n5 = _$38.copy$default$15();
                            int n6 = _$38.copy$default$16();
                            int n7 = _$38.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$38.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$38.copy$default$19();
                            ReadConcern readConcern = _$38.copy$default$20();
                            Option<String> option4 = _$38.copy$default$21();
                            return _$38.copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state30 = parseState;
                    if ("rm.failover".equals(string) && string2 != null && !(option2 = FailoverRe.unapplySeq((CharSequence)string2)).isEmpty() && (list2 = (List)option2.get()).lengthCompare(3) == 0) {
                        String string8 = (String)list2.apply(0);
                        String string9 = (String)list2.apply(1);
                        String string10 = (String)list2.apply(2);
                        String d = string8;
                        String r = string9;
                        String f = string10;
                        String opt = string2;
                        return this.make$1("rm.failover", opt, state30, () -> MongoConnection$.$anonfun$7$$anonfun$30(d, opt, r, f, state30));
                    }
                    MongoConnection.ParseState state31 = parseState;
                    if ("retryWrites".equals(string) && "true".equals(string2)) {
                        this.logger().info((Function0<String>)((Function0 & Serializable)MongoConnection$::$anonfun$7$$anonfun$31));
                        return state31;
                    }
                    MongoConnection.ParseState state32 = parseState;
                    if ("retryWrites".equals(string)) {
                        this.logger().info((Function0<String>)((Function0 & Serializable)MongoConnection$::$anonfun$7$$anonfun$32));
                        return state32.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$41 -> {
                            FailoverStrategy failoverStrategy = FailoverStrategy$.MODULE$.strict();
                            int n = _$41.copy$default$1();
                            Option<String> option = _$41.copy$default$2();
                            boolean bl = _$41.copy$default$3();
                            boolean bl2 = _$41.copy$default$4();
                            AuthenticationMode authenticationMode = _$41.copy$default$5();
                            boolean bl3 = _$41.copy$default$6();
                            boolean bl4 = _$41.copy$default$7();
                            int n2 = _$41.copy$default$8();
                            Option<Object> option2 = _$41.copy$default$9();
                            int n3 = _$41.copy$default$10();
                            int n4 = _$41.copy$default$11();
                            WriteConcern writeConcern = _$41.copy$default$12();
                            ReadPreference readPreference = _$41.copy$default$13();
                            int n5 = _$41.copy$default$15();
                            int n6 = _$41.copy$default$16();
                            int n7 = _$41.copy$default$17();
                            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$41.copy$default$18();
                            Option<MongoConnectionOptions.KeyStore> option3 = _$41.copy$default$19();
                            ReadConcern readConcern = _$41.copy$default$20();
                            Option<String> option4 = _$41.copy$default$21();
                            return _$41.copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
                        });
                    }
                    MongoConnection.ParseState state33 = parseState;
                    if ("heartbeatFrequencyMS".equals(string) && string2 != null && !(option = UnsignedInt.unapplySeq((CharSequence)string2)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                        String string11;
                        String ms = string11 = (String)list.apply(0);
                        return this.make$1("heartbeatFrequencyMS", ms, state33, () -> MongoConnection$.$anonfun$7$$anonfun$34(ms, state33));
                    }
                    MongoConnection.ParseState state34 = parseState;
                    if ("appName".equals(string)) {
                        String nme = string2;
                        Option option8 = Option$.MODULE$.apply((Object)nme).map((Function1 & Serializable)_$43 -> _$43.trim()).filter((Function1 & Serializable)v -> {
                            Object object;
                            return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(v)) && ArrayOps$.MODULE$.size$extension(object = Predef$.MODULE$.byteArrayOps(v.getBytes("UTF-8"))) < 128;
                        });
                        if (option8 instanceof Some) {
                            String appName = (String)((Some)option8).value();
                            return state34.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$44 -> {
                                Some some = Some$.MODULE$.apply((Object)appName);
                                int n = _$44.copy$default$1();
                                Option<String> option = _$44.copy$default$2();
                                boolean bl = _$44.copy$default$3();
                                boolean bl2 = _$44.copy$default$4();
                                AuthenticationMode authenticationMode = _$44.copy$default$5();
                                boolean bl3 = _$44.copy$default$6();
                                boolean bl4 = _$44.copy$default$7();
                                int n2 = _$44.copy$default$8();
                                Option<Object> option2 = _$44.copy$default$9();
                                int n3 = _$44.copy$default$10();
                                int n4 = _$44.copy$default$11();
                                WriteConcern writeConcern = _$44.copy$default$12();
                                ReadPreference readPreference = _$44.copy$default$13();
                                FailoverStrategy failoverStrategy = _$44.copy$default$14();
                                int n5 = _$44.copy$default$15();
                                int n6 = _$44.copy$default$16();
                                int n7 = _$44.copy$default$17();
                                scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$44.copy$default$18();
                                Option<MongoConnectionOptions.KeyStore> option3 = _$44.copy$default$19();
                                ReadConcern readConcern = _$44.copy$default$20();
                                return _$44.copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, (Option<String>)some);
                            });
                        }
                        String string12 = (String)Predef$.MODULE$.ArrowAssoc((Object)"appName");
                        return state34.reject((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string12, (Object)nme));
                    }
                }
                MongoConnection.ParseState state35 = parseState;
                Tuple2 kv = tuple22;
                return state35.reject((Tuple2<String, String>)kv);
            }
            throw new MatchError((Object)tuple2);
        });
        MongoConnection.ParseState parsed2 = (MongoConnection.ParseState)parsed1.rejected().get((Object)"zlibCompressionLevel").fold(() -> MongoConnection$.$anonfun$9(parsed1), (Function1 & Serializable)x$12 -> {
            List list;
            Option option;
            String string = x$12;
            if (string != null && !(option = IntRe.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                String string2;
                String level = string2 = (String)list.apply(0);
                BooleanRef valid = BooleanRef.create((boolean)false);
                ListSet compressors = (ListSet)parsed1.options().compressors().map((Function1 & Serializable)x$1 -> {
                    Option option;
                    Compressor compressor = x$1;
                    if (compressor != null && !(option = Compressor.Zlib$.MODULE$.unapply(compressor)).isEmpty()) {
                        int n = BoxesRunTime.unboxToInt((Object)option.get());
                        valid$2.elem = true;
                        return Compressor.Zlib$.MODULE$.apply(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(level)));
                    }
                    Compressor compressor2 = compressor;
                    return compressor2;
                });
                if (!valid.elem) {
                    MODULE$.logger().info((Function0<String>)((Function0 & Serializable)MongoConnection$::$anonfun$10$$anonfun$1));
                    String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"zlibCompressionLevel");
                    return parsed1.reject((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)level));
                }
                return parsed1.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$45 -> _$45.withCompressors((ListSet<Compressor>)compressors));
            }
            return parsed1;
        });
        MongoConnection.ParseState parsed3 = (MongoConnection.ParseState)parsed2.rejected().get((Object)"keyStore").fold(() -> MongoConnection$.$anonfun$12(parsed2), (Function1 & Serializable)uri -> {
            MongoConnectionOptions.KeyStore keyStore = MongoConnectionOptions$KeyStore$.MODULE$.apply(new URI((String)uri), (Option<char[]>)parsed2.rejected().get((Object)"keyStorePassword").map((Function1 & Serializable)_$46 -> _$46.toCharArray()), (String)parsed2.rejected().getOrElse((Object)"keyStoreType", MongoConnection$::$anonfun$15), true);
            MongoConnection.ParseState parseState = parsed2.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$47 -> {
                Some some = Some$.MODULE$.apply((Object)keyStore);
                int n = _$47.copy$default$1();
                Option<String> option = _$47.copy$default$2();
                boolean bl = _$47.copy$default$3();
                boolean bl2 = _$47.copy$default$4();
                AuthenticationMode authenticationMode = _$47.copy$default$5();
                boolean bl3 = _$47.copy$default$6();
                boolean bl4 = _$47.copy$default$7();
                int n2 = _$47.copy$default$8();
                Option<Object> option2 = _$47.copy$default$9();
                int n3 = _$47.copy$default$10();
                int n4 = _$47.copy$default$11();
                WriteConcern writeConcern = _$47.copy$default$12();
                ReadPreference readPreference = _$47.copy$default$13();
                FailoverStrategy failoverStrategy = _$47.copy$default$14();
                int n5 = _$47.copy$default$15();
                int n6 = _$47.copy$default$16();
                int n7 = _$47.copy$default$17();
                scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = _$47.copy$default$18();
                ReadConcern readConcern = _$47.copy$default$20();
                Option<String> option3 = _$47.copy$default$21();
                return _$47.copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, (Option<MongoConnectionOptions.KeyStore>)some, readConcern, option3);
            });
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)parsed2.rejected().$minus((Object)"keyStore").$minus((Object)"keyStorePassword").$minus((Object)"keyStoreType");
            MongoConnectionOptions mongoConnectionOptions = parseState.copy$default$1();
            return parseState.copy(mongoConnectionOptions, (scala.collection.immutable.Map<String, String>)map);
        });
        MongoConnection.ParseState parsed4 = (MongoConnection.ParseState)parsed3.rejected().iterator().foldLeft((Object)parsed3, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                MongoConnection.ParseState parseState = (MongoConnection.ParseState)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                MongoConnection.ParseState state = parseState;
                if (tuple22 != null) {
                    String string = (String)tuple22._1();
                    String string2 = (String)tuple22._2();
                    if ("writeConcernW".equals(string) || "w".equals(string)) {
                        String o = string;
                        if ("majority".equals(string2)) {
                            this.deprecated$1(o, "w");
                            return this.updateWriteConcern$1(state, (Function1 & Serializable)_$48 -> _$48.copy(WriteConcern$Majority$.MODULE$, _$48.copy$default$2(), _$48.copy$default$3(), _$48.copy$default$4()));
                        }
                    }
                    MongoConnection.ParseState state2 = parseState;
                    if ("writeConcernW".equals(string) || "w".equals(string)) {
                        List list;
                        Option option;
                        String o = string;
                        if (string2 != null && !(option = UnsignedInt.unapplySeq((CharSequence)string2)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                            String string3;
                            String str = string3 = (String)list.apply(0);
                            this.deprecated$1(o, "w");
                            return this.updateWriteConcern$1(state2, (Function1 & Serializable)_$49 -> _$49.copy(WriteConcern$WaitForAcknowledgments$.MODULE$.apply(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(str))), _$49.copy$default$2(), _$49.copy$default$3(), _$49.copy$default$4()));
                        }
                    }
                    MongoConnection.ParseState state3 = parseState;
                    if ("writeConcernW".equals(string) || "w".equals(string)) {
                        String o = string;
                        String tag = string2;
                        this.deprecated$1(o, "w");
                        return this.updateWriteConcern$1(state3, (Function1 & Serializable)_$50 -> _$50.copy(WriteConcern$TagSet$.MODULE$.apply(tag), _$50.copy$default$2(), _$50.copy$default$3(), _$50.copy$default$4()));
                    }
                    MongoConnection.ParseState state4 = parseState;
                    if ("journal".equals(string) || "writeConcernJ".equals(string)) {
                        String o = string;
                        String journaled = string2;
                        this.deprecated$1(o, "journal");
                        return this.updateWriteConcern$1(state4, (Function1 & Serializable)_$51 -> {
                            boolean bl = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(journaled));
                            WriteConcern.W w = _$51.copy$default$1();
                            boolean bl2 = _$51.copy$default$3();
                            Option<Object> option = _$51.copy$default$4();
                            return _$51.copy(w, bl, bl2, option);
                        });
                    }
                    MongoConnection.ParseState state5 = parseState;
                    if ("wtimeoutMS".equals(string) || "writeConcernTimeout".equals(string)) {
                        List list;
                        Option option;
                        String o = string;
                        if (string2 != null && !(option = UnsignedInt.unapplySeq((CharSequence)string2)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                            String string4;
                            String ms = string4 = (String)list.apply(0);
                            this.deprecated$1(o, "journal");
                            return this.updateWriteConcern$1(state5, (Function1 & Serializable)_$52 -> {
                                Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(ms))));
                                WriteConcern.W w = _$52.copy$default$1();
                                boolean bl = _$52.copy$default$2();
                                boolean bl2 = _$52.copy$default$3();
                                return _$52.copy(w, bl, bl2, (Option<Object>)some);
                            });
                        }
                    }
                }
                MongoConnection.ParseState state6 = parseState;
                Tuple2 kv = tuple22;
                return state6.reject((Tuple2<String, String>)kv);
            }
            throw new MatchError((Object)tuple2);
        });
        List list = (List)Predef$.MODULE$.ArrowAssoc(parsed4.rejected().$minus((Object)"writeConcernW").$minus((Object)"w").$minus((Object)"journal").$minus((Object)"writeConcernJ").$minus((Object)"wtimeoutMS").$minus((Object)"writeConcernTimeout").keySet().toList().sorted((Ordering)Ordering.String$.MODULE$));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)list, (Object)parsed4.options());
    }

    public static final /* synthetic */ Future reactivemongo$api$MongoConnection$URIBuilder$$$_$default$$anonfun$1(ListSet hosts, MongoConnectionOptions options, List ignoredOptions, Option db) {
        return Future$.MODULE$.successful(new MongoConnection.URI<Option>((ListSet<Tuple2<String, Object>>)hosts, options, (List<String>)ignoredOptions, db));
    }

    public static final /* synthetic */ Future reactivemongo$api$MongoConnection$URIBuilder$$$_$requiredDB$$anonfun$1(ListSet x$1, MongoConnectionOptions x$2, List x$3, Option x$4) {
        Tuple4 tuple4 = Tuple4$.MODULE$.apply((Object)x$1, (Object)x$2, (Object)x$3, (Object)x$4);
        if (tuple4 != null) {
            Option option = (Option)tuple4._4();
            ListSet hosts = (ListSet)tuple4._1();
            MongoConnectionOptions options = (MongoConnectionOptions)tuple4._2();
            List ignoredOptions = (List)tuple4._3();
            if (option instanceof Some) {
                String db = (String)((Some)option).value();
                return Future$.MODULE$.successful(new MongoConnection.URI<String>((ListSet<Tuple2<String, Object>>)hosts, options, (List<String>)ignoredOptions, db));
            }
        }
        return Future$.MODULE$.failed((Throwable)new IllegalArgumentException("Missing database name"));
    }

    private static final /* synthetic */ boolean $anonfun$4(char _$4) {
        return _$4 != '?';
    }

    private static final /* synthetic */ boolean $anonfun$5(char _$5) {
        return _$5 != '/';
    }

    private final Future txtOptions$1(boolean seedList$2, String setSpec$1, int credentialEnd$1, Function1 txtResolver$2, ExecutionContext ec$3) {
        if (!seedList$2) {
            return Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().empty());
        }
        String serviceName = StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(setSpec$1), credentialEnd$1 + 1)), (Function1 & Serializable)_$5 -> MongoConnection$.$anonfun$5(BoxesRunTime.unboxToChar((Object)_$5)));
        return ((Future)Await$.MODULE$.ready((Awaitable)txtResolver$2.apply((Object)serviceName), (Duration)package$.MODULE$.dnsTimeout())).flatMap((Function1 & Serializable)records -> ((Future)records.foldLeft((Object)Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().empty()), (Function2 & Serializable)(o, r) -> o.flatMap((Function1 & Serializable)prev -> MODULE$.parseOptions((String)r).map((Function1 & Serializable)cur -> (scala.collection.immutable.Map)prev.$plus$plus((IterableOnce)cur), ec$3), ec$3))).map((Function1 & Serializable)res -> res, ec$3), ec$3);
    }

    private final String optionStr$1(String useful$1, String setSpec$2) {
        return StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(useful$1), StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(setSpec$2)))), "?");
    }

    private static final String $anonfun$6(String database$1) {
        return database$1;
    }

    private static final /* synthetic */ boolean parse$1$$anonfun$1(char _$7) {
        return _$7 != ':';
    }

    private final Future parse$1(Builder buf$1, Iterable input) {
        Option option;
        while ((option = input.headOption()) instanceof Some) {
            String h = (String)((Some)option).value();
            Tuple2 tuple2 = StringOps$.MODULE$.span$extension(Predef$.MODULE$.augmentString(h), (Function1 & Serializable)_$7 -> MongoConnection$.parse$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$7)));
            if (tuple2 != null) {
                Left res;
                Left left;
                String string = (String)tuple2._1();
                String string2 = (String)tuple2._2();
                if ("".equals(string)) {
                    return Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(28).append("No valid host in the URI: '").append(h).append("'").toString()));
                }
                String host = string;
                if ("".equals(string2)) {
                    String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)host);
                    buf$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToInteger((int)this.DefaultPort())));
                    input = (Iterable)input.drop(1);
                    continue;
                }
                String host2 = string;
                String port = string2;
                try {
                    int p = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(port), 1)));
                    if (p <= 0 || p >= 65536) {
                        left = scala.package$.MODULE$.Left().apply((Object)new MongoConnection.URIParsingException(new StringBuilder(49).append("Could not parse host '").append(h).append("' from URI: invalid port '").append(port).append("'").toString()));
                    } else {
                        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)host2);
                        left = scala.package$.MODULE$.Right().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BoxesRunTime.boxToInteger((int)p)));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    left = scala.package$.MODULE$.Left().apply((Object)new MongoConnection.URIParsingException(new StringBuilder(49).append("Could not parse host '").append(h).append("' from URI: invalid port '").append(port).append("'").toString()));
                }
                catch (Throwable throwable) {
                    Option option2;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable cause = throwable3 = (Throwable)option2.get();
                        left = scala.package$.MODULE$.Left().apply((Object)cause);
                    }
                    throw throwable;
                }
                Left left2 = res = left;
                if (left2 instanceof Left) {
                    Throwable cause = (Throwable)left2.value();
                    return Future$.MODULE$.failed(cause);
                }
                if (left2 instanceof Right) {
                    Tuple2 node = (Tuple2)((Right)left2).value();
                    buf$1.$plus$eq((Object)node);
                    input = (Iterable)input.drop(1);
                    continue;
                }
                throw new MatchError((Object)left2);
            }
            throw new MatchError((Object)tuple2);
        }
        return Future$.MODULE$.successful(buf$1.result());
    }

    private static final /* synthetic */ boolean parseHostsAndDB$$anonfun$1(char _$8) {
        return _$8 != '/';
    }

    private static final /* synthetic */ boolean parse$2$$anonfun$1(char _$11) {
        return _$11 != '=';
    }

    private final Future parse$2(String options$5, Map buf$2, Iterable input) {
        Option option;
        while ((option = input.headOption()) instanceof Some) {
            String option2 = (String)((Some)option).value();
            Tuple2 tuple2 = StringOps$.MODULE$.span$extension(Predef$.MODULE$.augmentString(option2), (Function1 & Serializable)_$11 -> MongoConnection$.parse$2$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$11)));
            if (tuple2 != null) {
                String string = (String)tuple2._2();
                if ("".equals(string)) {
                    return Future$.MODULE$.failed((Throwable)new MongoConnection.URIParsingException(new StringBuilder(34).append("Could not parse invalid options '").append(options$5).append("'").toString()));
                }
                String key = (String)tuple2._1();
                String v = string;
                buf$2.put((Object)key, (Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(v), 1));
                input = (Iterable)input.drop(1);
                continue;
            }
            throw new MatchError((Object)tuple2);
        }
        return Future$.MODULE$.successful((Object)buf$2.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ Builder reactivemongo$api$MongoConnection$Compressors$$$_$unapply$$anonfun$1(Builder valid$1, Builder invalid$1, String x$1) {
        String string = x$1;
        String string2 = Compressor.Zlib$.MODULE$.name();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return (Builder)valid$1.$plus$eq((Object)Compressor.Zlib$.MODULE$.DefaultCompressor());
        }
        String string4 = Compressor.Zstd$.MODULE$.name();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return (Builder)valid$1.$plus$eq((Object)Compressor.Zstd$.MODULE$);
        }
        String string6 = Compressor.Snappy$.MODULE$.name();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return (Builder)valid$1.$plus$eq((Object)Compressor.Snappy$.MODULE$);
        }
        String name = string;
        return (Builder)invalid$1.$plus$eq((Object)name);
    }

    private static final String make$1$$anonfun$1(String name$2, String input$1) {
        return new StringBuilder(19).append("Invalid option '").append(name$2).append("': ").append(input$1).toString();
    }

    private static final Throwable make$1$$anonfun$2(Throwable cause$2) {
        return cause$2;
    }

    private final MongoConnection.ParseState make$1(String name, String input, MongoConnection.ParseState state, Function0 f) {
        MongoConnection.ParseState parseState;
        try {
            parseState = (MongoConnection.ParseState)f.apply();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable cause = throwable3 = (Throwable)option.get();
                this.logger().debug((Function0<String>)((Function0 & Serializable)() -> MongoConnection$.make$1$$anonfun$1(name, input)), (Function0<Throwable>)((Function0 & Serializable)() -> MongoConnection$.make$1$$anonfun$2(cause)));
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
                parseState = state.reject((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)input));
            }
            throw throwable;
        }
        return parseState;
    }

    private static final String deprecated$1$$anonfun$1(String actual$1, String expected$1) {
        return new StringBuilder(49).append("Connection option '").append(actual$1).append("' is deprecated in favor of '").append(expected$1).append("'").toString();
    }

    private final void deprecated$1(String expected, String actual) {
        String string = actual;
        String string2 = expected;
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.logger().info((Function0<String>)((Function0 & Serializable)() -> MongoConnection$.deprecated$1$$anonfun$1(actual, expected)));
            return;
        }
    }

    private static final String $anonfun$7$$anonfun$1() {
        return "Connection option 'replicaSet' is ignored: determined from servers response";
    }

    private static final MongoConnection.ParseState $anonfun$7$$anonfun$30(String d$1, String opt$1, String r$2, String f$1, MongoConnection.ParseState state$1) {
        Option option = Duration$.MODULE$.unapply(Duration$.MODULE$.apply(d$1));
        if (!(option instanceof Some)) {
            throw new MongoConnection.URIParsingException(new StringBuilder(32).append("Invalid duration 'rm.failover': ").append(opt$1).toString());
        }
        Tuple2 dur = (Tuple2)((Some)option).value();
        Tuple2 tuple2 = dur;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long time = BoxesRunTime.unboxToLong((Object)tuple2._1());
        TimeUnit unit = (TimeUnit)((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)time), (Object)unit);
        long time2 = BoxesRunTime.unboxToLong((Object)tuple22._1());
        TimeUnit unit2 = (TimeUnit)((Object)tuple22._2());
        FiniteDuration delay = FiniteDuration$.MODULE$.apply(time2, unit2);
        int retry = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(r$2));
        double factor = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(f$1));
        FailoverStrategy strategy = FailoverStrategy$.MODULE$.apply(delay, retry, (Function1<Object, Object>)(JFunction1.mcDI.sp & Serializable)_$39 -> (double)_$39 * factor);
        return state$1.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$40 -> _$40.copy(_$40.copy$default$1(), _$40.copy$default$2(), _$40.copy$default$3(), _$40.copy$default$4(), _$40.copy$default$5(), _$40.copy$default$6(), _$40.copy$default$7(), _$40.copy$default$8(), _$40.copy$default$9(), _$40.copy$default$10(), _$40.copy$default$11(), _$40.copy$default$12(), _$40.copy$default$13(), strategy, _$40.copy$default$15(), _$40.copy$default$16(), _$40.copy$default$17(), _$40.copy$default$18(), _$40.copy$default$19(), _$40.copy$default$20(), _$40.copy$default$21()));
    }

    private static final String $anonfun$7$$anonfun$31() {
        return "Connection option 'rm.failover' should be preferred to 'retryWrites'";
    }

    private static final String $anonfun$7$$anonfun$32() {
        return "Connection option 'rm.failover' should be preferred to 'retryWrites'";
    }

    private static final MongoConnection.ParseState $anonfun$7$$anonfun$34(String ms$1, MongoConnection.ParseState state$2) {
        int millis = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(ms$1));
        if (millis < 500) {
            throw new MongoConnection.URIParsingException("'heartbeatFrequencyMS' must be >= 500 milliseconds");
        }
        return state$2.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)_$42 -> _$42.copy(_$42.copy$default$1(), _$42.copy$default$2(), _$42.copy$default$3(), _$42.copy$default$4(), _$42.copy$default$5(), _$42.copy$default$6(), _$42.copy$default$7(), _$42.copy$default$8(), _$42.copy$default$9(), _$42.copy$default$10(), _$42.copy$default$11(), _$42.copy$default$12(), _$42.copy$default$13(), _$42.copy$default$14(), millis, _$42.copy$default$16(), _$42.copy$default$17(), _$42.copy$default$18(), _$42.copy$default$19(), _$42.copy$default$20(), _$42.copy$default$21()));
    }

    private static final MongoConnection.ParseState $anonfun$9(MongoConnection.ParseState parsed1$1) {
        return parsed1$1;
    }

    private static final String $anonfun$10$$anonfun$1() {
        return "Connection option 'zlibCompressionLevel' must only be specified after 'compressors' with 'zlib'";
    }

    private static final MongoConnection.ParseState $anonfun$12(MongoConnection.ParseState parsed2$1) {
        return parsed2$1;
    }

    private static final String $anonfun$15() {
        return "PKCS12";
    }

    private final MongoConnection.ParseState updateWriteConcern$1(MongoConnection.ParseState st, Function1 f) {
        return st.updateOption((Function1<MongoConnectionOptions, MongoConnectionOptions>)(Function1 & Serializable)opts -> {
            WriteConcern writeConcern = (WriteConcern)f.apply((Object)opts.writeConcern());
            int n = opts.copy$default$1();
            Option<String> option = opts.copy$default$2();
            boolean bl = opts.copy$default$3();
            boolean bl2 = opts.copy$default$4();
            AuthenticationMode authenticationMode = opts.copy$default$5();
            boolean bl3 = opts.copy$default$6();
            boolean bl4 = opts.copy$default$7();
            int n2 = opts.copy$default$8();
            Option<Object> option2 = opts.copy$default$9();
            int n3 = opts.copy$default$10();
            int n4 = opts.copy$default$11();
            ReadPreference readPreference = opts.copy$default$13();
            FailoverStrategy failoverStrategy = opts.copy$default$14();
            int n5 = opts.copy$default$15();
            int n6 = opts.copy$default$16();
            int n7 = opts.copy$default$17();
            scala.collection.immutable.Map<String, MongoConnectionOptions.Credential> map = opts.copy$default$18();
            Option<MongoConnectionOptions.KeyStore> option3 = opts.copy$default$19();
            ReadConcern readConcern = opts.copy$default$20();
            Option<String> option4 = opts.copy$default$21();
            return opts.copy(n, option, bl, bl2, authenticationMode, bl3, bl4, n2, option2, n3, n4, writeConcern, readPreference, failoverStrategy, n5, n6, n7, map, option3, readConcern, option4);
        });
    }
}

