/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.nodeset;

import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import reactivemongo.core.netty.ChannelFactory;
import reactivemongo.core.nodeset.Authenticated;
import reactivemongo.core.nodeset.Authenticating;
import reactivemongo.core.nodeset.Connection;
import reactivemongo.core.nodeset.ConnectionStatus;
import reactivemongo.core.nodeset.ConnectionStatus$Connected$;
import reactivemongo.core.nodeset.ConnectionStatus$Connecting$;
import reactivemongo.core.nodeset.NodeInfo;
import reactivemongo.core.nodeset.NodeStatus;
import reactivemongo.core.nodeset.PingInfo;
import reactivemongo.core.nodeset.RoundRobiner;
import reactivemongo.core.nodeset.RoundRobiner$;
import reactivemongo.core.nodeset.utils.package$;
import reactivemongo.core.protocol.ProtocolMetadata;
import reactivemongo.io.netty.channel.Channel;
import reactivemongo.io.netty.channel.ChannelId;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple8;
import scala.Tuple8$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class Node {
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(Node.class.getDeclaredField("tupled$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(Node.class.getDeclaredField("toShortString$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Node.class.getDeclaredField("signaling$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Node.class.getDeclaredField("names$lzy1"));
    private final String name;
    private final Set<String> aliases;
    private final NodeStatus status;
    private final Vector<Connection> connections;
    private final Set<Authenticated> authenticated;
    private final Map<String, String> tags;
    private final ProtocolMetadata protocolMetadata;
    private final PingInfo pingInfo;
    private final boolean isMongos;
    private final long statusChanged;
    private volatile Object names$lzy1;
    private final String host;
    private final int port;
    private final Vector<Connection> connected;
    private final RoundRobiner<Connection, Vector> authenticatedConnections;
    private volatile Object signaling$lzy1;
    private volatile Object toShortString$lzy1;
    private volatile Object tupled$lzy1;

    public Node(String name, Set<String> aliases, NodeStatus status, Vector<Connection> connections, Set<Authenticated> authenticated, Map<String, String> tags, ProtocolMetadata protocolMetadata, PingInfo pingInfo, boolean isMongos, long statusChanged) {
        String host;
        int n;
        block7: {
            Tuple2 tuple2;
            block6: {
                Integer n2;
                String string;
                this.name = name;
                this.aliases = aliases;
                this.status = status;
                this.connections = connections;
                this.authenticated = authenticated;
                this.tags = tags;
                this.protocolMetadata = protocolMetadata;
                this.pingInfo = pingInfo;
                this.isMongos = isMongos;
                this.statusChanged = statusChanged;
                Tuple2 splitted = StringOps$.MODULE$.span$extension(Predef$.MODULE$.augmentString(name), (Function1 & Serializable)_$1 -> Node.$init$$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1)));
                String string2 = string = (String)Predef$.MODULE$.ArrowAssoc(splitted._1());
                Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                try {
                    n2 = BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString((String)splitted._2()), 1))));
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    Throwable throwable3 = (Throwable)option.get();
                    n2 = BoxesRunTime.boxToInteger((int)27017);
                }
                Integer n3 = n2;
                Predef.ArrowAssoc$ arrowAssoc$2 = arrowAssoc$;
                arrowAssoc$ = null;
                String string3 = string2;
                string2 = null;
                Integer n4 = n3;
                n3 = null;
                tuple2 = arrowAssoc$2.$minus$greater$extension((Object)string3, (Object)n4);
                if (tuple2 == null) break block6;
                String string4 = (String)tuple2._1();
                n = BoxesRunTime.unboxToInt((Object)tuple2._2());
                if (string4 == null) break block6;
                host = string4;
                if (true) break block7;
            }
            throw new MatchError((Object)tuple2);
        }
        int port = n;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
        this.host = (String)tuple2._1();
        this.port = BoxesRunTime.unboxToInt((Object)tuple2._2());
        this.connected = (Vector)connections.filter((Function1 & Serializable)c -> {
            if (c.signaling()) return false;
            ConnectionStatus connectionStatus = c.status();
            ConnectionStatus$Connected$ connectionStatus$Connected$ = ConnectionStatus$Connected$.MODULE$;
            if (connectionStatus != null) {
                if (!connectionStatus.equals(connectionStatus$Connected$)) return false;
                return true;
            }
            if (connectionStatus$Connected$ == null) return true;
            return false;
        });
        this.authenticatedConnections = RoundRobiner$.MODULE$.apply((Iterable)this.connected().filter((Function1 & Serializable)_$2 -> _$2.authenticated().forall((Function1 & Serializable)auth -> authenticated.contains(auth))));
    }

    public String name() {
        return this.name;
    }

    public Set<String> aliases() {
        return this.aliases;
    }

    public NodeStatus status() {
        return this.status;
    }

    public Vector<Connection> connections() {
        return this.connections;
    }

    public Set<Authenticated> authenticated() {
        return this.authenticated;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ProtocolMetadata protocolMetadata() {
        return this.protocolMetadata;
    }

    public PingInfo pingInfo() {
        return this.pingInfo;
    }

    public boolean isMongos() {
        return this.isMongos;
    }

    public long statusChanged() {
        return this.statusChanged;
    }

    public Set<String> names() {
        Object object = this.names$lzy1;
        if (object instanceof Set) {
            return (Set)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Set)this.names$lzyINIT1();
    }

    private Object names$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.names$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Set set = null;
                    try {
                        set = (Set)this.aliases().$plus((Object)this.name());
                        object2 = set == null ? LazyVals.NullValue$.MODULE$ : set;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.names$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return set;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public Vector<Connection> connected() {
        return this.connected;
    }

    public RoundRobiner<Connection, Vector> authenticatedConnections() {
        return this.authenticatedConnections;
    }

    public Option<Connection> signaling() {
        Object object = this.signaling$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.signaling$lzyINIT1();
    }

    private Object signaling$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.signaling$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = this.connections().find((Function1 & Serializable)c -> {
                            if (!c.signaling()) return false;
                            ConnectionStatus connectionStatus = c.status();
                            ConnectionStatus$Connected$ connectionStatus$Connected$ = ConnectionStatus$Connected$.MODULE$;
                            if (connectionStatus != null) {
                                if (!connectionStatus.equals(connectionStatus$Connected$)) return false;
                                return true;
                            }
                            if (connectionStatus$Connected$ == null) return true;
                            return false;
                        });
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.signaling$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Try<Node> createSignalingConnection(ChannelFactory channelFactory, int heartbeatFrequencyMS, ActorRef receiver) {
        Option<Connection> option = this.signaling();
        if (option instanceof Some) {
            return Success$.MODULE$.apply((Object)this);
        }
        return this.createConnection(channelFactory, heartbeatFrequencyMS, receiver, true).map((Function1 & Serializable)con -> {
            Vector vector = (Vector)this.connections().$plus$colon(con);
            String string = this.copy$default$1();
            NodeStatus nodeStatus = this.copy$default$2();
            Set<Authenticated> set = this.copy$default$4();
            Map<String, String> map = this.copy$default$5();
            ProtocolMetadata protocolMetadata = this.copy$default$6();
            PingInfo pingInfo = this.copy$default$7();
            boolean bl = this.copy$default$8();
            Set<String> set2 = this.copy$default$9();
            long l = this.copy$default$10();
            return this.copy(string, nodeStatus, (Vector<Connection>)vector, set, map, protocolMetadata, pingInfo, bl, set2, l);
        });
    }

    public Try<Node> createUserConnections(ChannelFactory channelFactory, int maxIdleTimeMS, ActorRef receiver, int upTo) {
        int count = this.connections().count((Function1 & Serializable)_$3 -> !_$3.signaling());
        if (count < upTo) {
            return this.createChannels(channelFactory, maxIdleTimeMS, receiver, upTo - count, (Vector<Connection>)scala.package$.MODULE$.Vector().empty()).map((Function1 & Serializable)created -> {
                Vector vector = (Vector)this.connections().$plus$plus((IterableOnce)created);
                String string = this.copy$default$1();
                NodeStatus nodeStatus = this.copy$default$2();
                Set<Authenticated> set = this.copy$default$4();
                Map<String, String> map = this.copy$default$5();
                ProtocolMetadata protocolMetadata = this.copy$default$6();
                PingInfo pingInfo = this.copy$default$7();
                boolean bl = this.copy$default$8();
                Set<String> set2 = this.copy$default$9();
                long l = this.copy$default$10();
                return this.copy(string, nodeStatus, (Vector<Connection>)vector, set, map, protocolMetadata, pingInfo, bl, set2, l);
            });
        }
        return Success$.MODULE$.apply((Object)this);
    }

    private Try<Vector<Connection>> createChannels(ChannelFactory channelFactory, int maxIdleTimeMS, ActorRef receiver, int count, Vector<Connection> created) {
        while (count > 0) {
            Try<Connection> try_ = this.createConnection(channelFactory, maxIdleTimeMS, receiver, false);
            if (try_ instanceof Success) {
                Connection con = (Connection)((Success)try_).value();
                int n = count - 1;
                Vector vector = (Vector)created.$plus$colon((Object)con);
                count = n;
                created = vector;
                continue;
            }
            if (try_ instanceof Failure) {
                Throwable cause = ((Failure)try_).exception();
                return Failure$.MODULE$.apply(cause);
            }
            throw new MatchError(try_);
        }
        return Success$.MODULE$.apply(created);
    }

    public Try<Connection> createConnection(ChannelFactory channelFactory, int maxIdleTimeMS, ActorRef receiver, boolean _signaling) {
        return channelFactory.create(this.host(), this.port(), maxIdleTimeMS, receiver).map((Function1 & Serializable)chan -> new Connection((Channel)chan, ConnectionStatus$Connecting$.MODULE$, (Set<Authenticated>)Set$.MODULE$.empty(), (Option<Authenticating>)None$.MODULE$, _signaling));
    }

    public Node withAlias(String as) {
        return new Node(this.name(), (Set<String>)((Set)this.aliases().$plus((Object)as)), this.status(), this.connections(), this.authenticated(), this.tags(), this.protocolMetadata(), this.pingInfo(), this.isMongos(), this.statusChanged());
    }

    public Node copy(String name, NodeStatus status, Vector<Connection> connections, Set<Authenticated> authenticated, Map<String, String> tags, ProtocolMetadata protocolMetadata, PingInfo pingInfo, boolean isMongos, Set<String> aliases, long statusChanged) {
        return new Node(name, aliases, status, connections, authenticated, tags, protocolMetadata, pingInfo, isMongos, statusChanged);
    }

    public String copy$default$1() {
        return this.name();
    }

    public NodeStatus copy$default$2() {
        return this.status();
    }

    public Vector<Connection> copy$default$3() {
        return this.connections();
    }

    public Set<Authenticated> copy$default$4() {
        return this.authenticated();
    }

    public Map<String, String> copy$default$5() {
        return this.tags();
    }

    public ProtocolMetadata copy$default$6() {
        return this.protocolMetadata();
    }

    public PingInfo copy$default$7() {
        return this.pingInfo();
    }

    public boolean copy$default$8() {
        return this.isMongos();
    }

    public Set<String> copy$default$9() {
        return this.aliases();
    }

    public long copy$default$10() {
        return this.statusChanged();
    }

    public Option<Connection> pickConnectionByChannelId(ChannelId id) {
        return this.connections().find((Function1 & Serializable)_$4 -> {
            ChannelId channelId = _$4.channel().id();
            ChannelId channelId2 = id;
            return !(channelId != null ? !channelId.equals(channelId2) : channelId2 != null);
        });
    }

    public Node updateByChannelId(ChannelId id, Function1<Connection, Connection> fc, Function1<Node, Node> fn) {
        Tuple2<Iterable<Connection>, Object> tuple2 = package$.MODULE$.update(this.connections(), new Serializable(id, fc){
            private final ChannelId id$2;
            private final Function1 fc$1;
            {
                this.id$2 = id$3;
                this.fc$1 = fc$2;
            }

            public final boolean isDefinedAt(Connection x) {
                Connection connection;
                Connection conn = connection = x;
                ChannelId channelId = conn.channel().id();
                ChannelId channelId2 = this.id$2;
                return !(channelId != null ? !channelId.equals(channelId2) : channelId2 != null);
            }

            public final Object applyOrElse(Connection x, Function1 function1) {
                Connection connection;
                Connection conn = connection = x;
                ChannelId channelId = conn.channel().id();
                ChannelId channelId2 = this.id$2;
                if (!(channelId != null ? !channelId.equals(channelId2) : channelId2 != null)) {
                    return this.fc$1.apply((Object)conn);
                }
                return function1.apply((Object)x);
            }
        }, Vector$.MODULE$.iterableFactory());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Vector updCons = (Vector)tuple2._1();
        boolean updated = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)updCons, (Object)BoxesRunTime.boxToBoolean((boolean)updated));
        Vector updCons2 = (Vector)tuple22._1();
        boolean updated2 = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
        if (updated2) {
            return (Node)fn.apply((Object)this.copy(this.copy$default$1(), this.copy$default$2(), (Vector<Connection>)updCons2, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10()));
        }
        return this;
    }

    public String toShortString() {
        Object object = this.toShortString$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.toShortString$lzyINIT1();
    }

    private Object toShortString$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.toShortString$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = new StringBuilder(65).append("Node[").append(this.name()).append(": ").append(this.status()).append("<").append(Node.hns$1(this.statusChanged())).append("> (").append(this.authenticatedConnections().size()).append("/").append(this.connected().size()).append("/").append(((SeqOps)this.connections().filterNot((Function1 & Serializable)_$5 -> _$5.signaling())).size()).append(" available connections), latency=").append(Node.hns$1(this.pingInfo().ping())).append(", authenticated={").append(((IterableOnceOps)this.authenticated().map((Function1 & Serializable)_$6 -> _$6.toShortString())).mkString(", ")).append("}]").toString();
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.toShortString$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.toShortString$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public NodeInfo info() {
        return new NodeInfo(this.name(), this.aliases(), this.host(), this.port(), this.status(), this.connections().count((Function1 & Serializable)_$7 -> !_$7.signaling()), this.connected().size(), this.authenticatedConnections().size(), this.tags(), this.protocolMetadata(), this.pingInfo(), this.isMongos());
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof Node) {
            Node other = (Node)object;
            Tuple8<String, NodeStatus, Vector<Connection>, Set<Authenticated>, Map<String, String>, ProtocolMetadata, PingInfo, Object> tuple8 = other.tupled();
            Tuple8<String, NodeStatus, Vector<Connection>, Set<Authenticated>, Map<String, String>, ProtocolMetadata, PingInfo, Object> tuple82 = this.tupled();
            return !(tuple8 != null ? !tuple8.equals(tuple82) : tuple82 != null);
        }
        return false;
    }

    public int hashCode() {
        return this.tupled().hashCode();
    }

    public Tuple8<String, NodeStatus, Vector<Connection>, Set<Authenticated>, Map<String, String>, ProtocolMetadata, PingInfo, Object> tupled() {
        Object object = this.tupled$lzy1;
        if (object instanceof Tuple8) {
            return (Tuple8)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Tuple8)this.tupled$lzyINIT1();
    }

    private Object tupled$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.tupled$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Tuple8 tuple8 = null;
                    try {
                        tuple8 = Tuple8$.MODULE$.apply((Object)this.name(), (Object)this.status(), this.connections(), this.authenticated(), this.tags(), (Object)this.protocolMetadata(), (Object)this.pingInfo(), (Object)BoxesRunTime.boxToBoolean((boolean)this.isMongos()));
                        object2 = tuple8 == null ? LazyVals.NullValue$.MODULE$ : tuple8;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.tupled$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.tupled$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return tuple8;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private static final /* synthetic */ boolean $init$$$anonfun$1(char _$1) {
        return _$1 != ':';
    }

    private static final String hns$1(long ns) {
        if (ns < 1000L) {
            return new StringBuilder(2).append(BoxesRunTime.boxToLong((long)ns).toString()).append("ns").toString();
        }
        if (ns < 100000000L) {
            return new StringBuilder(2).append(BoxesRunTime.boxToLong((long)(ns / 1000000L)).toString()).append("ms").toString();
        }
        return new StringBuilder(1).append(BoxesRunTime.boxToLong((long)(ns / 1000000000L)).toString()).append("s").toString();
    }
}

