/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.nodeset;

import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import reactivemongo.api.Compressor;
import reactivemongo.api.ReadPreference;
import reactivemongo.api.ReadPreference$;
import reactivemongo.api.ReadPreference$Nearest$;
import reactivemongo.api.ReadPreference$PrimaryPreferred$;
import reactivemongo.api.ReadPreference$Secondary$;
import reactivemongo.api.ReadPreference$SecondaryPreferred$;
import reactivemongo.core.netty.ChannelFactory;
import reactivemongo.core.nodeset.Authenticate;
import reactivemongo.core.nodeset.Authenticated;
import reactivemongo.core.nodeset.Connection;
import reactivemongo.core.nodeset.ConnectionStatus;
import reactivemongo.core.nodeset.ConnectionStatus$Connected$;
import reactivemongo.core.nodeset.Node;
import reactivemongo.core.nodeset.NodeInfo;
import reactivemongo.core.nodeset.NodeSetInfo;
import reactivemongo.core.nodeset.NodeStatus;
import reactivemongo.core.nodeset.NodeStatus$Primary$;
import reactivemongo.core.nodeset.NodeStatus$Secondary$;
import reactivemongo.core.nodeset.RoundRobiner;
import reactivemongo.core.nodeset.RoundRobiner$;
import reactivemongo.core.nodeset.utils.package$;
import reactivemongo.core.protocol.ProtocolMetadata;
import reactivemongo.core.protocol.ProtocolMetadata$;
import reactivemongo.io.netty.channel.ChannelId;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple5;
import scala.Tuple5$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;

public class NodeSet {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(NodeSet.class.getDeclaredField("tupled$lzy1"));
    private final Option<String> name;
    private final Option<Object> version;
    private final Vector<Node> nodes;
    private final transient Set<Authenticate> authenticates;
    private final transient ListSet<Compressor> compression;
    private final Option<Node> primary;
    private final Option<Node> mongos;
    private final Vector<Node> _secondaries;
    private final transient RoundRobiner<Node, Vector> secondaries;
    private final Vector<Node> queryable;
    private final transient RoundRobiner<Node, Vector> nearestGroup;
    private final Option<Node> nearest;
    private final ProtocolMetadata protocolMetadata;
    private volatile Object tupled$lzy1;

    public NodeSet(Option<String> name, Option<Object> version, Vector<Node> nodes, Set<Authenticate> authenticates, ListSet<Compressor> compression) {
        this.name = name;
        this.version = version;
        this.nodes = nodes;
        this.authenticates = authenticates;
        this.compression = compression;
        this.primary = nodes.find((Function1 & Serializable)_$1 -> {
            NodeStatus nodeStatus = _$1.status();
            NodeStatus$Primary$ nodeStatus$Primary$ = NodeStatus$Primary$.MODULE$;
            return !(nodeStatus != null ? !nodeStatus.equals(nodeStatus$Primary$) : nodeStatus$Primary$ != null);
        });
        this.mongos = nodes.find((Function1 & Serializable)_$3 -> _$3.isMongos());
        this._secondaries = (Vector)nodes.filter((Function1 & Serializable)_$4 -> {
            NodeStatus nodeStatus = _$4.status();
            NodeStatus$Secondary$ nodeStatus$Secondary$ = NodeStatus$Secondary$.MODULE$;
            return !(nodeStatus != null ? !nodeStatus.equals(nodeStatus$Secondary$) : nodeStatus$Secondary$ != null);
        });
        this.secondaries = RoundRobiner$.MODULE$.apply(this._secondaries);
        this.queryable = (Vector)this._secondaries.$plus$plus(this.primary());
        this.nearestGroup = RoundRobiner$.MODULE$.apply((Iterable)this.queryable().sortWith((Function2 & Serializable)(_$5, _$6) -> _$5.pingInfo().ping() < _$6.pingInfo().ping()));
        this.nearest = this.nearestGroup().pick();
        this.protocolMetadata = (ProtocolMetadata)this.primary().orElse(this::$init$$$anonfun$5).fold(NodeSet::$init$$$anonfun$6, (Function1 & Serializable)_$7 -> _$7.protocolMetadata());
    }

    public Option<String> name() {
        return this.name;
    }

    public Option<Object> version() {
        return this.version;
    }

    public Vector<Node> nodes() {
        return this.nodes;
    }

    public Set<Authenticate> authenticates() {
        return this.authenticates;
    }

    public ListSet<Compressor> compression() {
        return this.compression;
    }

    public Option<Node> primary() {
        return this.primary;
    }

    public boolean isMongos() {
        return this.primary().exists((Function1 & Serializable)_$2 -> _$2.isMongos());
    }

    public Option<Node> mongos() {
        return this.mongos;
    }

    public RoundRobiner<Node, Vector> secondaries() {
        return this.secondaries;
    }

    public Vector<Node> queryable() {
        return this.queryable;
    }

    public RoundRobiner<Node, Vector> nearestGroup() {
        return this.nearestGroup;
    }

    public Option<Node> nearest() {
        return this.nearest;
    }

    public ProtocolMetadata protocolMetadata() {
        return this.protocolMetadata;
    }

    public Option<Node> primary(Authenticated authenticated) {
        return this.primary().filter((Function1 & Serializable)_$8 -> _$8.authenticated().contains((Object)authenticated));
    }

    public boolean isReachable() {
        return this.primary().nonEmpty() || this._secondaries.nonEmpty();
    }

    public NodeSet updateOrAddNode(PartialFunction<Node, Node> f, Node node) {
        Tuple2<Iterable<Node>, Object> tuple2 = package$.MODULE$.update(this.nodes(), f, Vector$.MODULE$.iterableFactory());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Vector maybeUpdatedNodes = (Vector)tuple2._1();
        boolean updated = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)maybeUpdatedNodes, (Object)BoxesRunTime.boxToBoolean((boolean)updated));
        Vector maybeUpdatedNodes2 = (Vector)tuple22._1();
        boolean updated2 = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
        if (!updated2) {
            Vector vector = (Vector)this.nodes().$plus$colon((Object)node);
            Option<String> option = this.copy$default$1();
            Option<Object> option2 = this.copy$default$2();
            Set<Authenticate> set = this.copy$default$4();
            ListSet<Compressor> listSet = this.copy$default$5();
            return this.copy(option, option2, (Vector<Node>)vector, set, listSet);
        }
        return this.copy(this.copy$default$1(), this.copy$default$2(), (Vector<Node>)maybeUpdatedNodes2, this.copy$default$4(), this.copy$default$5());
    }

    public NodeSet updateOrAddNodes(PartialFunction<Node, Node> f, Seq<Node> ns) {
        return (NodeSet)ns.foldLeft((Object)this, (Function2 & Serializable)(_$9, _$10) -> _$9.updateOrAddNode(f, (Node)_$10));
    }

    public NodeSet updateAll(Function1<Node, Node> f) {
        Vector vector = (Vector)this.nodes().map(f);
        Option<String> option = this.copy$default$1();
        Option<Object> option2 = this.copy$default$2();
        Set<Authenticate> set = this.copy$default$4();
        ListSet<Compressor> listSet = this.copy$default$5();
        return this.copy(option, option2, (Vector<Node>)vector, set, listSet);
    }

    public NodeSet updateNodeByChannelId(ChannelId id, Function1<Node, Node> f) {
        return this.updateByChannelId(id, (Function1<Connection, Connection>)(Function1 & Serializable)x -> (Connection)Predef$.MODULE$.identity(x), f);
    }

    public NodeSet updateConnectionByChannelId(ChannelId id, Function1<Connection, Connection> f) {
        return this.updateByChannelId(id, f, (Function1<Node, Node>)(Function1 & Serializable)x -> (Node)Predef$.MODULE$.identity(x));
    }

    public NodeSet updateByChannelId(ChannelId id, Function1<Connection, Connection> fc, Function1<Node, Node> fn) {
        Vector vector = (Vector)this.nodes().map((Function1 & Serializable)_$11 -> _$11.updateByChannelId(id, fc, fn));
        Option<String> option = this.copy$default$1();
        Option<Object> option2 = this.copy$default$2();
        Set<Authenticate> set = this.copy$default$4();
        ListSet<Compressor> listSet = this.copy$default$5();
        return this.copy(option, option2, (Vector<Node>)vector, set, listSet);
    }

    public Option<Tuple2<Node, Connection>> pickByChannelId(ChannelId id) {
        return this.nodes().view().map((Function1 & Serializable)node -> {
            Node node2 = (Node)Predef$.MODULE$.ArrowAssoc(node);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)node2, (Object)node.connections().find((Function1 & Serializable)_$12 -> {
                ChannelId channelId = _$12.channel().id();
                ChannelId channelId2 = id;
                return !(channelId != null ? !channelId.equals(channelId2) : channelId2 != null);
            }));
        }).collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    Node node = (Node)tuple2._1();
                    if (option instanceof Some) {
                        Connection con = (Connection)((Some)option).value();
                        ConnectionStatus connectionStatus = con.status();
                        ConnectionStatus$Connected$ connectionStatus$Connected$ = ConnectionStatus$Connected$.MODULE$;
                        if (!(connectionStatus != null ? !connectionStatus.equals(connectionStatus$Connected$) : connectionStatus$Connected$ != null)) {
                            return true;
                        }
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    Node node = (Node)tuple2._1();
                    if (option instanceof Some) {
                        Connection con = (Connection)((Some)option).value();
                        ConnectionStatus connectionStatus = con.status();
                        ConnectionStatus$Connected$ connectionStatus$Connected$ = ConnectionStatus$Connected$.MODULE$;
                        if (!(connectionStatus != null ? !connectionStatus.equals(connectionStatus$Connected$) : connectionStatus$Connected$ != null)) {
                            Node node2 = (Node)Predef$.MODULE$.ArrowAssoc((Object)node);
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)node2, (Object)con);
                        }
                    }
                }
                return function1.apply((Object)x);
            }
        });
    }

    public Option<Tuple2<Node, Connection>> pick(ReadPreference preference, int unpriorised, Function1<Connection, Object> accept, Ordering<Node> ord) {
        Option<List<Map<String, String>>> option;
        Option<List<Map<String, String>>> option2;
        Option<List<Map<String, String>>> option3;
        Option<List<Map<String, String>>> option4;
        Function1<Option<Node>, Option<Tuple2<Node, Connection>>> resolve = this.connectionAndFlatten(accept);
        if (this.mongos().isDefined()) {
            return (Option)resolve.apply(this.mongos());
        }
        ReadPreference readPreference = preference;
        if (readPreference instanceof ReadPreference.PrimaryPreferred && !(option4 = ReadPreference$PrimaryPreferred$.MODULE$.unapply((ReadPreference.PrimaryPreferred)readPreference)).isEmpty()) {
            List list;
            List tags = list = (List)option4.get();
            return ((Option)resolve.apply(this.primary())).orElse(() -> this.pick$$anonfun$1(resolve, tags, unpriorised, ord));
        }
        if (readPreference instanceof ReadPreference.Secondary && !(option3 = ReadPreference$Secondary$.MODULE$.unapply((ReadPreference.Secondary)readPreference)).isEmpty()) {
            List list;
            List tags = list = (List)option3.get();
            return (Option)resolve.apply(this.findNode(this.secondaries(), (Option<Function1<Map<String, String>, Object>>)NodeSet.filter$1((Seq)tags), (Function0<Option<Node>>)((Function0 & Serializable)this::pick$$anonfun$2), unpriorised, ord));
        }
        if (readPreference instanceof ReadPreference.SecondaryPreferred && !(option2 = ReadPreference$SecondaryPreferred$.MODULE$.unapply((ReadPreference.SecondaryPreferred)readPreference)).isEmpty()) {
            List list;
            List tags = list = (List)option2.get();
            return ((Option)resolve.apply(this.findNode(this.secondaries(), (Option<Function1<Map<String, String>, Object>>)NodeSet.filter$1((Seq)tags), (Function0<Option<Node>>)((Function0 & Serializable)this::pick$$anonfun$3), unpriorised, ord))).orElse(() -> this.pick$$anonfun$4(resolve));
        }
        if (readPreference instanceof ReadPreference.Nearest && !(option = ReadPreference$Nearest$.MODULE$.unapply((ReadPreference.Nearest)readPreference)).isEmpty()) {
            List list;
            List tags = list = (List)option.get();
            return (Option)resolve.apply(this.findNode(this.nearestGroup(), (Option<Function1<Map<String, String>, Object>>)NodeSet.filter$1((Seq)tags), (Function0<Option<Node>>)((Function0 & Serializable)this::pick$$anonfun$5), unpriorised, ord));
        }
        return (Option)resolve.apply(this.primary());
    }

    private Function1<Option<Node>, Option<Tuple2<Node, Connection>>> connectionAndFlatten(Function1<Connection, Object> accept) {
        Function1 & Serializable p = this.authenticates().isEmpty() ? (Function1 & Serializable)_$13 -> _$13.pickWithFilter(accept) : (Function1 & Serializable)_$14 -> _$14.pickWithFilter((Function1 & Serializable)c -> !c.authenticating().isDefined() && c.authenticated().nonEmpty() && BoxesRunTime.unboxToBoolean((Object)accept.apply(c)));
        return (Function1 & Serializable)_$15 -> _$15.flatMap((Function1 & Serializable)node -> ((Option)p.apply(node.authenticatedConnections())).map((Function1 & Serializable)_$16 -> {
            Node node = (Node)Predef$.MODULE$.ArrowAssoc(node);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)node, _$16);
        }));
    }

    private Option<Node> findNode(RoundRobiner<Node, Vector<Object>> roundRobiner, Option<Function1<Map<String, String>, Object>> filter, Function0<Option<Node>> fallback, int unpriorised, Ordering<Node> ord) {
        Option<Function1<Map<String, String>, Object>> option = filter;
        if (option instanceof Some) {
            Function1 f = (Function1)((Some)option).value();
            Function1 & Serializable nodeFilter = (Function1 & Serializable)n -> {
                if (n.tags().isEmpty()) {
                    return false;
                }
                return BoxesRunTime.unboxToBoolean((Object)f.apply(n.tags()));
            };
            return (unpriorised > 1 ? roundRobiner.pickWithFilterAndPriority((Function1<Node, Object>)nodeFilter, unpriorised, ord) : roundRobiner.pickWithFilter((Function1<Node, Object>)nodeFilter)).orElse(fallback);
        }
        return (Option)fallback.apply();
    }

    public Try<NodeSet> createUserConnections(ChannelFactory channelFactory, int maxIdleTimeMS, ActorRef receiver, int upTo) {
        return NodeSet.update$1(channelFactory, maxIdleTimeMS, receiver, upTo, this.nodes(), scala.package$.MODULE$.Vector().empty()).map((Function1 & Serializable)upd -> this.copy(this.copy$default$1(), this.copy$default$2(), (Vector<Node>)upd, this.copy$default$4(), this.copy$default$5()));
    }

    public String toShortString() {
        return new StringBuilder(14).append("{{NodeSet ").append(this.name()).append(" ").append(((IterableOnceOps)this.nodes().map((Function1 & Serializable)_$17 -> _$17.toShortString())).mkString(" | ")).append(" }}").toString();
    }

    public NodeSetInfo info() {
        Vector ns = (Vector)this.nodes().map((Function1 & Serializable)_$18 -> _$18.info());
        return new NodeSetInfo(this.name(), this.version(), (Vector<NodeInfo>)ns, (Option<NodeInfo>)this.primary().map((Function1 & Serializable)_$19 -> _$19.info()), (Option<NodeInfo>)this.mongos().map((Function1 & Serializable)_$20 -> _$20.info()), (Vector<NodeInfo>)((Vector)ns.filter((Function1 & Serializable)_$21 -> {
            NodeStatus nodeStatus = _$21.status();
            NodeStatus$Secondary$ nodeStatus$Secondary$ = NodeStatus$Secondary$.MODULE$;
            return !(nodeStatus != null ? !nodeStatus.equals(nodeStatus$Secondary$) : nodeStatus$Secondary$ != null);
        })), (Option<NodeInfo>)this.nearest().map((Function1 & Serializable)_$22 -> _$22.info()), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, this.compression());
    }

    public NodeSet copy(Option<String> name, Option<Object> version, Vector<Node> nodes, Set<Authenticate> authenticates, ListSet<Compressor> compression) {
        return new NodeSet(name, version, nodes, authenticates, compression);
    }

    public Option<String> copy$default$1() {
        return this.name();
    }

    public Option<Object> copy$default$2() {
        return this.version();
    }

    public Vector<Node> copy$default$3() {
        return this.nodes();
    }

    public Set<Authenticate> copy$default$4() {
        return this.authenticates();
    }

    public ListSet<Compressor> copy$default$5() {
        return this.compression();
    }

    public Tuple5<Option<String>, Option<Object>, Vector<Node>, Set<Authenticate>, ListSet<Compressor>> tupled() {
        Object object = this.tupled$lzy1;
        if (object instanceof Tuple5) {
            return (Tuple5)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Tuple5)this.tupled$lzyINIT1();
    }

    private Object tupled$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.tupled$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Tuple5 tuple5 = null;
                    try {
                        tuple5 = Tuple5$.MODULE$.apply(this.name(), this.version(), this.nodes(), this.authenticates(), this.compression());
                        object2 = tuple5 == null ? LazyVals.NullValue$.MODULE$ : tuple5;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.tupled$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return tuple5;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof NodeSet) {
            NodeSet other = (NodeSet)object;
            Tuple5<Option<String>, Option<Object>, Vector<Node>, Set<Authenticate>, ListSet<Compressor>> tuple5 = this.tupled();
            Tuple5<Option<String>, Option<Object>, Vector<Node>, Set<Authenticate>, ListSet<Compressor>> tuple52 = other.tupled();
            return !(tuple5 != null ? !tuple5.equals(tuple52) : tuple52 != null);
        }
        return false;
    }

    public int hashCode() {
        return this.tupled().hashCode();
    }

    public String toString() {
        return new StringBuilder(7).append("NodeSet").append(this.tupled().toString()).toString();
    }

    private final Option $init$$$anonfun$5() {
        return this.secondaries().pick();
    }

    private static final ProtocolMetadata $init$$$anonfun$6() {
        return ProtocolMetadata$.MODULE$.Default();
    }

    private static final Option filter$1(Seq tags) {
        return ReadPreference$.MODULE$.TagFilter((Seq<Map<String, String>>)tags);
    }

    private final Option pick$$anonfun$1$$anonfun$1() {
        return this.secondaries().pick();
    }

    private final Option pick$$anonfun$1(Function1 resolve$1, List tags$1, int unpriorised$1, Ordering ord$1) {
        return (Option)resolve$1.apply(this.findNode(this.secondaries(), (Option<Function1<Map<String, String>, Object>>)NodeSet.filter$1((Seq)tags$1), (Function0<Option<Node>>)((Function0 & Serializable)this::pick$$anonfun$1$$anonfun$1), unpriorised$1, (Ordering<Node>)ord$1));
    }

    private final Option pick$$anonfun$2() {
        return this.secondaries().pick();
    }

    private final Option pick$$anonfun$3() {
        return this.secondaries().pick();
    }

    private final Option pick$$anonfun$4(Function1 resolve$2) {
        return (Option)resolve$2.apply(this.primary());
    }

    private final Option pick$$anonfun$5() {
        return this.nearest();
    }

    private static final Try update$1(ChannelFactory channelFactory$1, int maxIdleTimeMS$1, ActorRef receiver$1, int upTo$1, Vector ns, Vector upd) {
        Option option;
        while ((option = ns.headOption()) instanceof Some) {
            Node node = (Node)((Some)option).value();
            Try<Node> try_ = node.createUserConnections(channelFactory$1, maxIdleTimeMS$1, receiver$1, upTo$1);
            if (try_ instanceof Failure) {
                Throwable cause = ((Failure)try_).exception();
                return Failure$.MODULE$.apply(cause);
            }
            if (try_ instanceof Success) {
                Node updated = (Node)((Success)try_).value();
                Vector vector = ns.drop(1);
                Vector vector2 = (Vector)upd.$plus$colon((Object)updated);
                ns = vector;
                upd = vector2;
                continue;
            }
            throw new MatchError(try_);
        }
        return Success$.MODULE$.apply((Object)upd);
    }
}

