/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.protocol;

import java.io.Serializable;
import reactivemongo.api.Compressor;
import reactivemongo.api.ReadPreference;
import reactivemongo.core.protocol.MessageHeader;
import reactivemongo.core.protocol.Request$;
import reactivemongo.core.protocol.RequestOp;
import reactivemongo.core.protocol.buffer.ChannelBufferWritable;
import reactivemongo.io.netty.buffer.ByteBuf;
import reactivemongo.io.netty.channel.ChannelId;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.Try;

public final class Request
implements ChannelBufferWritable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Request.class.getDeclaredField("header$lzy1"));
    private final String kind;
    private final int requestID;
    private final int responseTo;
    private final RequestOp op;
    private final ByteBuf payload;
    private final ReadPreference readPreference;
    private final Option<ChannelId> channelIdHint;
    private final int payloadSize;
    private final Function1<ByteBuf, BoxedUnit> writeTo;
    private volatile Object header$lzy1;

    public static Request apply(String string, int n, int n2, RequestOp requestOp, ByteBuf byteBuf, ReadPreference readPreference, Option<ChannelId> option, Seq<StackTraceElement> seq) {
        return Request$.MODULE$.apply(string, n, n2, requestOp, byteBuf, readPreference, option, seq);
    }

    public static Request apply(String string, int n, int n2, RequestOp requestOp, byte[] byArray) {
        return Request$.MODULE$.apply(string, n, n2, requestOp, byArray);
    }

    public static Request apply(String string, int n, RequestOp requestOp) {
        return Request$.MODULE$.apply(string, n, requestOp);
    }

    public static Request apply(String string, int n, RequestOp requestOp, byte[] byArray) {
        return Request$.MODULE$.apply(string, n, requestOp, byArray);
    }

    public static Try<Request> compress(Request request, Compressor compressor, Function1<Object, ByteBuf> function1) {
        return Request$.MODULE$.compress(request, compressor, function1);
    }

    public static ReadPreference apply$default$6() {
        return Request$.MODULE$.apply$default$6();
    }

    public static Option<ChannelId> apply$default$7() {
        return Request$.MODULE$.apply$default$7();
    }

    public static Seq<StackTraceElement> apply$default$8() {
        return Request$.MODULE$.apply$default$8();
    }

    public Request(String kind, int requestID, int responseTo, RequestOp op, ByteBuf payload, ReadPreference readPreference, Option<ChannelId> channelIdHint) {
        this.kind = kind;
        this.requestID = requestID;
        this.responseTo = responseTo;
        this.op = op;
        this.payload = payload;
        this.readPreference = readPreference;
        this.channelIdHint = channelIdHint;
        this.payloadSize = payload.writerIndex();
        this.writeTo = (JProcedure1 & Serializable)buffer -> {
            this.header().writeTo().apply(buffer);
            op.writeTo().apply(buffer);
            buffer.writeBytes(payload);
        };
    }

    public String kind() {
        return this.kind;
    }

    public int requestID() {
        return this.requestID;
    }

    public int responseTo() {
        return this.responseTo;
    }

    public RequestOp op() {
        return this.op;
    }

    public ByteBuf payload() {
        return this.payload;
    }

    public ReadPreference readPreference() {
        return this.readPreference;
    }

    public Option<ChannelId> channelIdHint() {
        return this.channelIdHint;
    }

    public Function1<ByteBuf, BoxedUnit> writeTo() {
        return this.writeTo;
    }

    public int size() {
        return 16 + this.op().size() + this.payloadSize;
    }

    public MessageHeader header() {
        Object object = this.header$lzy1;
        if (object instanceof MessageHeader) {
            return (MessageHeader)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (MessageHeader)this.header$lzyINIT1();
    }

    private Object header$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.header$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    MessageHeader messageHeader = null;
                    try {
                        messageHeader = new MessageHeader(this.size(), this.requestID(), this.responseTo(), this.op().code());
                        object2 = messageHeader == null ? LazyVals.NullValue$.MODULE$ : messageHeader;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.header$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return messageHeader;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String toString() {
        return new StringBuilder(17).append("Request(").append(this.requestID()).append(", ").append(this.responseTo()).append(", ").append(this.op()).append(", ").append(this.readPreference()).append(", ").append(this.channelIdHint()).append(")").toString();
    }
}

