/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.util;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.security.MessageDigest;
import java.time.Duration;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import reactivemongo.UtilCompat;
import reactivemongo.core.errors.GenericDriverException;
import reactivemongo.core.errors.GenericDriverException$;
import reactivemongo.util.DefaultSRVResolver;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.control.NonFatal$;

public final class package$
implements UtilCompat,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(package$.class.getDeclaredField("dnsTimeout$lzy1"));
    private static final char[] HEX_CHARS;
    private volatile Object dnsTimeout$lzy1;
    public static final package$ MODULE$;

    private package$() {
    }

    static {
        MODULE$ = new package$();
        HEX_CHARS = "0123456789abcdef".toCharArray();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(package$.class);
    }

    public char[] HEX_CHARS() {
        return HEX_CHARS;
    }

    public String hex2Str(byte[] bytes) {
        char[] hex = new char[2 * bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            hex[2 * i] = this.HEX_CHARS()[(bytes[i] & 0xF0) >>> 4];
            hex[2 * i + 1] = this.HEX_CHARS()[bytes[i] & 0xF];
        }
        return new String(hex);
    }

    public String md5Hex(String string, String encoding) {
        return this.hex2Str(this.md5(string, encoding));
    }

    public byte[] md5(String string, String encoding) {
        return this.md5(string.getBytes(encoding));
    }

    public byte[] md5(byte[] bytes) {
        return MessageDigest.getInstance("MD5").digest(bytes);
    }

    public <T> Option<T> option(Function0<Object> cond, Function0<T> value) {
        if (cond.apply$mcZ$sp()) {
            return Some$.MODULE$.apply(value.apply());
        }
        return None$.MODULE$;
    }

    public <T> T withContent(URI uri, Function1<InputStream, T> f) {
        Object object;
        LazyRef lazyRef = new LazyRef();
        try {
            try {
                object = f.apply((Object)this.in$1(lazyRef, uri));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable cause = throwable3 = (Throwable)option.get();
                    throw cause;
                }
                throw throwable;
            }
        }
        finally {
            this.in$1(lazyRef, uri).close();
        }
        return (T)object;
    }

    public FiniteDuration dnsTimeout() {
        Object object = this.dnsTimeout$lzy1;
        if (object instanceof FiniteDuration) {
            return (FiniteDuration)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (FiniteDuration)this.dnsTimeout$lzyINIT1();
    }

    private Object dnsTimeout$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.dnsTimeout$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    FiniteDuration finiteDuration = null;
                    try {
                        finiteDuration = FiniteDuration$.MODULE$.apply(5L, "seconds");
                        object2 = finiteDuration == null ? LazyVals.NullValue$.MODULE$ : finiteDuration;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.dnsTimeout$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return finiteDuration;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Future<List<Tuple2<String, Object>>> srvRecords(String name, Function1<ExecutionContext, Function1<String, Future<Record[]>>> resolver, ExecutionContext ec) {
        DefaultSRVResolver resolve = new DefaultSRVResolver(resolver, ec);
        return resolve.apply(name);
    }

    public Function1<ExecutionContext, Function1<String, Future<Record[]>>> dnsResolve(String srvPrefix, FiniteDuration timeout) {
        return (Function1 & Serializable)ec -> (Function1 & Serializable)name -> {
            Name service = Name.fromConstantString((String)new StringBuilder(11).append((String)name).append('.').toString());
            if (service.labels() < 3) {
                return Future$.MODULE$.failed((Throwable)new GenericDriverException(new StringBuilder(54).append("Invalid DNS service name (e.g. 'service.domain.tld'): ").append(service).toString(), GenericDriverException$.MODULE$.$lessinit$greater$default$2()));
            }
            return Future$.MODULE$.apply(() -> package$.dnsResolve$$anonfun$1$$anonfun$1$$anonfun$1(srvPrefix, service, timeout), ec);
        };
    }

    public String dnsResolve$default$1() {
        return "_mongodb._tcp";
    }

    public FiniteDuration dnsResolve$default$2() {
        return this.dnsTimeout();
    }

    public Function1<String, Future<ListSet<String>>> txtRecords(FiniteDuration timeout, ExecutionContext ec) {
        return (Function1 & Serializable)name -> {
            Lookup lookup = new Lookup(name, 16);
            Resolver r = Lookup.getDefaultResolver();
            r.setTimeout(Duration.ofSeconds(timeout.toSeconds()));
            lookup.setResolver(r);
            return Future$.MODULE$.apply(() -> package$.txtRecords$$anonfun$1$$anonfun$1(lookup), ec).map((Function1 & Serializable)x$1 -> {
                Object[] objectArray = x$1;
                if (objectArray == null) {
                    return ListSet$.MODULE$.empty();
                }
                Object[] records = objectArray;
                ListSet txts = MODULE$.toListSet((Iterable)Predef$.MODULE$.wrapRefArray(records), (Function1 & Serializable)rec -> {
                    String stripped;
                    String data = rec.rdataToString();
                    String string = stripped = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(data), "\"");
                    String string2 = data;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return data;
                    }
                    return StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(stripped), "\"");
                });
                return txts;
            }, ec);
        };
    }

    public FiniteDuration txtRecords$default$1() {
        return this.dnsTimeout();
    }

    private final InputStream in$lzyINIT1$1(LazyRef in$lzy1$1, URI uri$1) {
        InputStream inputStream;
        LazyRef lazyRef = in$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (in$lzy1$1.initialized()) {
                object = in$lzy1$1.value();
            } else {
                String string = uri$1.getScheme();
                String string2 = "classpath";
                object = in$lzy1$1.initialize((Object)(!(string != null ? !string.equals(string2) : string2 != null) ? Thread.currentThread().getContextClassLoader().getResourceAsStream(uri$1.getPath()) : uri$1.toURL().openStream()));
            }
            inputStream = (InputStream)object;
        }
        return inputStream;
    }

    private final InputStream in$1(LazyRef in$lzy1$2, URI uri$2) {
        return (InputStream)(in$lzy1$2.initialized() ? in$lzy1$2.value() : this.in$lzyINIT1$1(in$lzy1$2, uri$2));
    }

    private static final Record[] dnsResolve$$anonfun$1$$anonfun$1$$anonfun$1(String srvPrefix$3, Name service$1, FiniteDuration timeout$3) {
        Name srvName = Name.concatenate((Name)Name.fromConstantString((String)srvPrefix$3), (Name)service$1);
        Lookup lookup = new Lookup(srvName, 33);
        Resolver r = Lookup.getDefaultResolver();
        r.setTimeout(Duration.ofSeconds(timeout$3.toSeconds()));
        lookup.setResolver(r);
        return lookup.run();
    }

    private static final Record[] txtRecords$$anonfun$1$$anonfun$1(Lookup lookup$1) {
        return lookup$1.run();
    }
}

