/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.api;

import java.io.Serializable;
import reactivemongo.api.Cursor$;
import reactivemongo.api.Cursor$Cont$;
import reactivemongo.api.Cursor$Done$;
import reactivemongo.api.Cursor$Fail$;
import reactivemongo.api.Cursor$Result$;
import reactivemongo.api.CursorCompatAPI;
import reactivemongo.api.CursorFlattener;
import reactivemongo.util.LazyLogger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

public interface Cursor<T>
extends CursorCompatAPI<T> {
    public static <A> Function2<A, Throwable, State<A>> ContOnError(Function2<A, Throwable, BoxedUnit> function2) {
        return Cursor$.MODULE$.ContOnError(function2);
    }

    public static int DefaultBatchSize() {
        return Cursor$.MODULE$.DefaultBatchSize();
    }

    public static <A> Function2<A, Throwable, State<A>> DoneOnError(Function2<A, Throwable, BoxedUnit> function2) {
        return Cursor$.MODULE$.DoneOnError(function2);
    }

    public static <A> Function2<A, Throwable, State<A>> FailOnError(Function2<A, Throwable, BoxedUnit> function2) {
        return Cursor$.MODULE$.FailOnError(function2);
    }

    public static <A> Function2<BoxedUnit, A, State<BoxedUnit>> Ignore(Function1<A, BoxedUnit> function1) {
        return Cursor$.MODULE$.Ignore(function1);
    }

    public static <T, C extends Cursor<?>> Cursor<T> flatten(Future<Cursor<T>> future, CursorFlattener<C> cursorFlattener) {
        return Cursor$.MODULE$.flatten(future, cursorFlattener);
    }

    public static LazyLogger.LazyLogger logger() {
        return Cursor$.MODULE$.logger();
    }

    public static <A> Function2<A, Throwable, BoxedUnit> ContOnError$default$1() {
        return Cursor$.MODULE$.ContOnError$default$1();
    }

    public static <A> Function2<A, Throwable, BoxedUnit> DoneOnError$default$1() {
        return Cursor$.MODULE$.DoneOnError$default$1();
    }

    public static <A> Function2<A, Throwable, BoxedUnit> FailOnError$default$1() {
        return Cursor$.MODULE$.FailOnError$default$1();
    }

    public static <A> Function1<A, BoxedUnit> Ignore$default$1() {
        return Cursor$.MODULE$.Ignore$default$1();
    }

    public <A> Future<A> foldBulks(Function0<A> var1, int var2, Function2<A, Iterator<T>, State<A>> var3, Function2<A, Throwable, State<A>> var4, ExecutionContext var5);

    public static int foldBulks$default$2$(Cursor $this) {
        return $this.foldBulks$default$2();
    }

    default public int foldBulks$default$2() {
        return -1;
    }

    public static Function2 foldBulks$default$4$(Cursor $this, Function0 z, int maxDocs) {
        return $this.foldBulks$default$4(z, maxDocs);
    }

    default public <A> Function2<A, Throwable, State<A>> foldBulks$default$4(Function0<A> z, int maxDocs) {
        return Cursor$.MODULE$.FailOnError(Cursor$.MODULE$.FailOnError$default$1());
    }

    public <A> Future<A> foldBulksM(Function0<A> var1, int var2, Function2<A, Iterator<T>, Future<State<A>>> var3, Function2<A, Throwable, State<A>> var4, ExecutionContext var5);

    public static int foldBulksM$default$2$(Cursor $this) {
        return $this.foldBulksM$default$2();
    }

    default public int foldBulksM$default$2() {
        return -1;
    }

    public static Function2 foldBulksM$default$4$(Cursor $this, Function0 z, int maxDocs) {
        return $this.foldBulksM$default$4(z, maxDocs);
    }

    default public <A> Function2<A, Throwable, State<A>> foldBulksM$default$4(Function0<A> z, int maxDocs) {
        return Cursor$.MODULE$.FailOnError(Cursor$.MODULE$.FailOnError$default$1());
    }

    public <A> Future<A> foldWhile(Function0<A> var1, int var2, Function2<A, T, State<A>> var3, Function2<A, Throwable, State<A>> var4, ExecutionContext var5);

    public static int foldWhile$default$2$(Cursor $this) {
        return $this.foldWhile$default$2();
    }

    default public int foldWhile$default$2() {
        return -1;
    }

    public static Function2 foldWhile$default$4$(Cursor $this, Function0 z, int maxDocs) {
        return $this.foldWhile$default$4(z, maxDocs);
    }

    default public <A> Function2<A, Throwable, State<A>> foldWhile$default$4(Function0<A> z, int maxDocs) {
        return Cursor$.MODULE$.FailOnError(Cursor$.MODULE$.FailOnError$default$1());
    }

    public <A> Future<A> foldWhileM(Function0<A> var1, int var2, Function2<A, T, Future<State<A>>> var3, Function2<A, Throwable, State<A>> var4, ExecutionContext var5);

    public static int foldWhileM$default$2$(Cursor $this) {
        return $this.foldWhileM$default$2();
    }

    default public int foldWhileM$default$2() {
        return -1;
    }

    public static Function2 foldWhileM$default$4$(Cursor $this, Function0 z, int maxDocs) {
        return $this.foldWhileM$default$4(z, maxDocs);
    }

    default public <A> Function2<A, Throwable, State<A>> foldWhileM$default$4(Function0<A> z, int maxDocs) {
        return Cursor$.MODULE$.FailOnError(Cursor$.MODULE$.FailOnError$default$1());
    }

    public static Future fold$(Cursor $this, Function0 z, int maxDocs, Function2 suc, ExecutionContext ec) {
        return $this.fold(z, maxDocs, suc, ec);
    }

    default public <A> Future<A> fold(Function0<A> z, int maxDocs, Function2<A, T, A> suc, ExecutionContext ec) {
        return this.foldWhile(z, maxDocs, (Function2 & Serializable)(st, v) -> Cursor$Cont$.MODULE$.apply(suc.apply(st, v)), Cursor$.MODULE$.FailOnError(Cursor$.MODULE$.FailOnError$default$1()), ec);
    }

    public static int fold$default$2$(Cursor $this) {
        return $this.fold$default$2();
    }

    default public int fold$default$2() {
        return -1;
    }

    public Future<T> head(ExecutionContext var1);

    public Future<Option<T>> headOption(ExecutionContext var1);

    public static final class Cont<T>
    implements State<T> {
        private final T value;

        public static <T> Cont<T> apply(T t) {
            return Cursor$Cont$.MODULE$.apply(t);
        }

        public static <T> Option<T> unapply(Cont<T> cont) {
            return Cursor$Cont$.MODULE$.unapply(cont);
        }

        public Cont(T value) {
            this.value = value;
        }

        public T value() {
            return this.value;
        }

        @Override
        public <U> State<U> map(Function1<T, U> f) {
            return Cursor$Cont$.MODULE$.apply(f.apply(this.value()));
        }
    }

    public static final class Done<T>
    implements State<T> {
        private final T value;

        public static <T> Done<T> apply(T t) {
            return Cursor$Done$.MODULE$.apply(t);
        }

        public static <T> Option<T> unapply(Done<T> done) {
            return Cursor$Done$.MODULE$.unapply(done);
        }

        public Done(T value) {
            this.value = value;
        }

        public T value() {
            return this.value;
        }

        @Override
        public <U> State<U> map(Function1<T, U> f) {
            return Cursor$Done$.MODULE$.apply(f.apply(this.value()));
        }
    }

    public static final class Fail<T>
    implements State<T> {
        private final Throwable cause;

        public static <T> Fail<T> apply(Throwable throwable) {
            return Cursor$Fail$.MODULE$.apply(throwable);
        }

        public static <T> Option<Throwable> unapply(Fail<T> fail) {
            return Cursor$Fail$.MODULE$.unapply(fail);
        }

        public Fail(Throwable cause) {
            this.cause = cause;
        }

        public Throwable cause() {
            return this.cause;
        }

        @Override
        public <U> State<U> map(Function1<T, U> f) {
            return Cursor$Fail$.MODULE$.apply(this.cause());
        }
    }

    public static final class Reference {
        private final String collectionName;
        private final long cursorId;
        private final int numberToReturn;
        private final boolean tailable;
        private final Option<String> pinnedNode;

        public Reference(String collectionName, long cursorId, int numberToReturn, boolean tailable, Option<String> pinnedNode) {
            this.collectionName = collectionName;
            this.cursorId = cursorId;
            this.numberToReturn = numberToReturn;
            this.tailable = tailable;
            this.pinnedNode = pinnedNode;
        }

        public String collectionName() {
            return this.collectionName;
        }

        public long cursorId() {
            return this.cursorId;
        }

        public int numberToReturn() {
            return this.numberToReturn;
        }

        public boolean tailable() {
            return this.tailable;
        }

        public Option<String> pinnedNode() {
            return this.pinnedNode;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object that) {
            Object object = that;
            if (object == null) {
                return false;
            }
            if (!(object instanceof Reference)) return false;
            Reference other = (Reference)object;
            if (this.cursorId() != other.cursorId()) return false;
            if (this.tailable() != other.tailable()) return false;
            if (this.numberToReturn() != other.numberToReturn()) return false;
            if (this.pinnedNode() != null || other.pinnedNode() != null) {
                if (this.pinnedNode() == null) return false;
                Option<String> option = this.pinnedNode();
                Option<String> option2 = other.pinnedNode();
                if (option == null) {
                    if (option2 != null) {
                        return false;
                    }
                } else if (!option.equals(option2)) return false;
            }
            if (this.collectionName() == null) {
                if (other.collectionName() == null) return true;
            }
            if (this.collectionName() == null) return false;
            String string = this.collectionName();
            String string2 = other.collectionName();
            if (string == null) {
                if (string2 == null) return true;
                return false;
            } else {
                if (!string.equals(string2)) return false;
                return true;
            }
        }

        public int hashCode() {
            int nh1 = MurmurHash3$.MODULE$.mix(-889275714, Statics.longHash((long)this.cursorId()));
            int nh2 = MurmurHash3$.MODULE$.mix(nh1, this.numberToReturn());
            int nh3 = MurmurHash3$.MODULE$.mix(nh2, Statics.anyHash((Object)BoxesRunTime.boxToBoolean((boolean)this.tailable())));
            int nh4 = MurmurHash3$.MODULE$.mix(nh3, Statics.anyHash((Object)this.collectionName()));
            return MurmurHash3$.MODULE$.mixLast(nh4, Statics.anyHash(this.pinnedNode()));
        }

        public String toString() {
            return new StringBuilder(81).append("Result(collection = ").append(this.collectionName()).append(", cursorId = ").append(this.cursorId()).append(", numberToReturn = ").append(this.numberToReturn()).append(", tailable = ").append(this.tailable()).append(", pinnedNode = ").append(this.pinnedNode().getOrElse(Cursor$::reactivemongo$api$Cursor$Reference$$_$toString$$anonfun$1)).append(")").toString();
        }
    }

    public static final class Result<T> {
        private final T value;
        private final Reference reference;

        public static <T> Option<Tuple2<T, Reference>> unapply(Result<T> result) {
            return Cursor$Result$.MODULE$.unapply(result);
        }

        public Result(T value, Reference reference) {
            this.value = value;
            this.reference = reference;
        }

        public T value() {
            return this.value;
        }

        public Reference reference() {
            return this.reference;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object that) {
            Object object = that;
            if (object == null) {
                return false;
            }
            if (!(object instanceof Result)) return false;
            Result other = (Result)object;
            if (this.value() != null || other.value() != null) {
                if (this.value() == null) return false;
                if (!BoxesRunTime.equals(this.value(), other.value())) return false;
            }
            if (this.reference() == null) {
                if (other.reference() == null) return true;
            }
            if (this.reference() == null) return false;
            Reference reference = this.reference();
            Reference reference2 = other.reference();
            if (reference != null) {
                if (!((Object)reference).equals(reference2)) return false;
                return true;
            }
            if (reference2 == null) return true;
            return false;
        }

        public int hashCode() {
            int nh1 = MurmurHash3$.MODULE$.mix(-889275714, Statics.anyHash(this.value()));
            return MurmurHash3$.MODULE$.mixLast(nh1, Statics.anyHash((Object)this.reference()));
        }

        public String toString() {
            return new StringBuilder(10).append("Result(").append(this.value()).append(", ").append(this.reference()).append(")").toString();
        }
    }

    public static interface State<T> {
        public <U> State<U> map(Function1<T, U> var1);
    }
}

