/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.protocol;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.IdleStateEvent;
import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import reactivemongo.core.actors.ChannelConnected;
import reactivemongo.core.actors.ChannelConnected$;
import reactivemongo.core.actors.ChannelDisconnected;
import reactivemongo.core.actors.ChannelDisconnected$;
import reactivemongo.core.protocol.MongoHandler$;
import reactivemongo.core.protocol.Response;
import reactivemongo.io.netty.channel.package;
import reactivemongo.util.LazyLogger;
import scala.Function0;
import scala.runtime.BoxedUnit;

public class MongoHandler
extends ChannelDuplexHandler
implements package.ChannelDuplexHandler {
    private final String supervisor;
    private final String connection;
    private final ActorRef receiver;
    private long last;

    public static LazyLogger.LazyLogger logger() {
        return MongoHandler$.MODULE$.logger();
    }

    public MongoHandler(String supervisor, String connection, ActorRef receiver) {
        this.supervisor = supervisor;
        this.connection = connection;
        this.receiver = receiver;
        this.last = -1L;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.log(ctx, "Channel is active");
        this.last = System.nanoTime();
        ChannelConnected channelConnected = ChannelConnected$.MODULE$.apply(ctx.channel().id());
        this.receiver.$bang((Object)channelConnected, this.receiver.$bang$default$2((Object)channelConnected));
        super.channelActive(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        BoxedUnit boxedUnit;
        Object object = evt;
        if (object instanceof IdleStateEvent) {
            if (this.last != -1L) {
                long now = System.nanoTime();
                this.log(ctx, new StringBuilder(40).append("Channel has been inactive for ").append(now - this.last).append(" (last = ").append(this.last).append(")").toString());
            }
            boxedUnit = ctx.channel().close();
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        super.userEventTriggered(ctx, evt);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        long now = System.nanoTime();
        if (this.last != -1L) {
            Channel chan = ctx.channel();
            long delay = now - this.last;
            if (delay < 500000000L) {
                this.warn(ctx, new StringBuilder(62).append(MongoHandler.msg$1(delay, chan)).append("; Please check network connectivity and the status of the set.").toString());
            } else if (chan.remoteAddress() != null) {
                this.log(ctx, MongoHandler.msg$1(delay, chan));
            }
            this.last = now;
            ChannelDisconnected channelDisconnected = ChannelDisconnected$.MODULE$.apply(chan.id());
            this.receiver.$bang((Object)channelDisconnected, this.receiver.$bang$default$2((Object)channelDisconnected));
        }
        super.channelInactive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.last = System.nanoTime();
        Object object = msg;
        if (object instanceof Response) {
            Response response = (Response)object;
            this.log(ctx, new StringBuilder(43).append("Channel received message ").append(response).append("; Will be send to ").append(this.receiver.path()).toString());
            this.receiver.$bang((Object)response, this.receiver.$bang$default$2((Object)response));
            return;
        }
        this.log(ctx, new StringBuilder(20).append("Unexpected message: ").append(msg).toString());
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        this.log(ctx, "Channel is requested to write");
        this.last = System.nanoTime();
        super.write(ctx, msg, promise);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.log(ctx, new StringBuilder(18).append("Error on channel #").append(ctx.channel().id()).toString(), cause);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive()) {
            this.channelActive(ctx);
        }
        super.handlerAdded(ctx);
    }

    public void warn(ChannelHandlerContext ctx, String s) {
        MongoHandler$.MODULE$.logger().warn((Function0<String>)((Function0 & Serializable)() -> this.warn$$anonfun$1(s, ctx)));
    }

    public void log(ChannelHandlerContext ctx, String s) {
        MongoHandler$.MODULE$.logger().trace((Function0<String>)((Function0 & Serializable)() -> this.log$$anonfun$1(s, ctx)));
    }

    public void log(ChannelHandlerContext ctx, String s, Throwable cause) {
        MongoHandler$.MODULE$.logger().trace((Function0<String>)((Function0 & Serializable)() -> this.log$$anonfun$2(s, ctx)), (Function0<Throwable>)((Function0 & Serializable)() -> MongoHandler.log$$anonfun$3(cause)));
    }

    private static final String msg$1(long delay$1, Channel chan$1) {
        return new StringBuilder(28).append("Channel is closed under ").append(delay$1).append("ns: ").append(chan$1.remoteAddress()).toString();
    }

    private final String warn$$anonfun$1(String s$1, ChannelHandlerContext ctx$1) {
        return new StringBuilder(15).append("[").append(this.supervisor).append("/").append(this.connection).append("] ").append(s$1).append(" (channel ").append(ctx$1.channel()).append(")").toString();
    }

    private final String log$$anonfun$1(String s$2, ChannelHandlerContext ctx$2) {
        return new StringBuilder(15).append("[").append(this.supervisor).append("/").append(this.connection).append("] ").append(s$2).append(" (channel ").append(ctx$2.channel()).append(")").toString();
    }

    private final String log$$anonfun$2(String s$3, ChannelHandlerContext ctx$3) {
        return new StringBuilder(15).append("[").append(this.supervisor).append("/").append(this.connection).append("] ").append(s$3).append(" (channel ").append(ctx$3.channel()).append(")").toString();
    }

    private static final Throwable log$$anonfun$3(Throwable cause$1) {
        return cause$1;
    }
}

