/*
 * Decompiled with CFR 0.152.
 */
package reactivemongo.core.protocol;

import com.github.luben.zstd.Zstd;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelId;
import java.io.Serializable;
import org.xerial.snappy.Snappy;
import reactivemongo.api.Compressor;
import reactivemongo.api.ReadPreference;
import reactivemongo.api.ReadPreference$;
import reactivemongo.core.protocol.CompressedOp;
import reactivemongo.core.protocol.CompressedOp$;
import reactivemongo.core.protocol.Request;
import reactivemongo.core.protocol.RequestOp;
import reactivemongo.core.protocol.buffer.Snappy$;
import reactivemongo.core.protocol.buffer.Zlib$;
import reactivemongo.core.protocol.buffer.Zstd$;
import reactivemongo.io.netty.buffer.package;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class Request$
implements Serializable {
    public static final Request$ MODULE$ = new Request$();

    private Request$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Request$.class);
    }

    private ReadPreference $lessinit$greater$default$6() {
        return ReadPreference$.MODULE$.primary();
    }

    private Option<ChannelId> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    public Request apply(String kind, int requestID, int responseTo, RequestOp op, ByteBuf documents, ReadPreference readPreference, Option<ChannelId> channelIdHint, Seq<StackTraceElement> callerSTE) {
        Request request;
        try {
            request = new Request(kind, requestID, responseTo, op, documents, readPreference, channelIdHint);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable cause = throwable3 = (Throwable)option.get();
                Object[] trace = cause.getStackTrace();
                ArrayBuilder callerTrace = (ArrayBuilder)Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(StackTraceElement.class)).$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray(trace));
                Object object = Predef$.MODULE$.refArrayOps(trace);
                if (ArrayOps$.MODULE$.nonEmpty$extension(object)) {
                    callerTrace.$plus$eq((Object)new StackTraceElement("---", "---", "---", -1));
                }
                callerTrace.$plus$plus$eq(callerSTE);
                cause.setStackTrace((StackTraceElement[])callerTrace.result());
                throw cause;
            }
            throw throwable;
        }
        return request;
    }

    public ReadPreference apply$default$6() {
        return ReadPreference$.MODULE$.primary();
    }

    public Option<ChannelId> apply$default$7() {
        return None$.MODULE$;
    }

    public Seq<StackTraceElement> apply$default$8() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Request apply(String kind, int requestID, int responseTo, RequestOp op, byte[] documents) {
        return new Request(kind, requestID, responseTo, op, package.Unpooled$.MODULE$.wrappedBuffer(documents), this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7());
    }

    public Request apply(String kind, int requestID, RequestOp op, byte[] documents) {
        return this.apply(kind, requestID, 0, op, documents);
    }

    public Request apply(String kind, int requestID, RequestOp op) {
        return this.apply(kind, requestID, op, new byte[0]);
    }

    public Try<Request> compress(Request req, Compressor compressor, Function1<Object, ByteBuf> allocDirect) {
        Option option;
        Success success;
        if (req.op().code() == CompressedOp$.MODULE$.code()) {
            return Success$.MODULE$.apply((Object)req);
        }
        int uncompressedSize = req.size() - 16;
        Compressor compressor2 = compressor;
        if (Compressor.Snappy$.MODULE$.equals(compressor2)) {
            success = Try$.MODULE$.apply(() -> Request$.$anonfun$1(uncompressedSize, allocDirect)).flatMap((Function1 & Serializable)out -> (Try)this.withData$1(allocDirect, uncompressedSize, req, (Function1 & Serializable)_$1 -> Snappy$.MODULE$.apply().encode(_$1, out).map((Function1 & Serializable)_$2 -> out)));
        } else if (Compressor.Zstd$.MODULE$.equals(compressor2)) {
            success = Try$.MODULE$.apply(() -> Request$.$anonfun$3(uncompressedSize, allocDirect)).flatMap((Function1 & Serializable)out -> (Try)this.withData$1(allocDirect, uncompressedSize, req, (Function1 & Serializable)_$3 -> Zstd$.MODULE$.apply(Zstd$.MODULE$.apply$default$1(), Zstd$.MODULE$.apply$default$2(), Zstd$.MODULE$.apply$default$3()).encode(_$3, out).map((Function1 & Serializable)_$4 -> out)));
        } else if (compressor2 != null && !(option = Compressor.Zlib$.MODULE$.unapply(compressor2)).isEmpty()) {
            int n;
            int level = n = BoxesRunTime.unboxToInt((Object)option.get());
            success = Try$.MODULE$.apply(() -> Request$.$anonfun$5(uncompressedSize, allocDirect)).flatMap((Function1 & Serializable)out -> (Try)this.withData$1(allocDirect, uncompressedSize, req, (Function1 & Serializable)_$5 -> Zlib$.MODULE$.apply(level).encode(_$5, out).map((Function1 & Serializable)_$6 -> out)));
        } else {
            success = Success$.MODULE$.apply((Object)req.payload());
        }
        Success compressed = success;
        return compressed.map((Function1 & Serializable)payload -> new Request(req.kind(), req.requestID(), req.responseTo(), (RequestOp)new CompressedOp(req.op().expectsResponse(), req.op().requiresPrimary(), req.op().code(), uncompressedSize, compressor.id()), (ByteBuf)payload, req.readPreference(), req.channelIdHint()));
    }

    private final Object withData$1(Function1 allocDirect$1, int uncompressedSize$1, Request req$1, Function1 f) {
        Object object;
        ByteBuf buf = null;
        try {
            try {
                buf = (ByteBuf)allocDirect$1.apply((Object)BoxesRunTime.boxToInteger((int)uncompressedSize$1));
                req$1.op().writeTo().apply((Object)buf);
                buf.writeBytes(req$1.payload());
                object = f.apply((Object)buf);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable cause = throwable3 = (Throwable)option.get();
                    throw cause;
                }
                throw throwable;
            }
        }
        finally {
            if (buf != null) {
                buf.release();
            }
        }
        return object;
    }

    private static final ByteBuf $anonfun$1(int uncompressedSize$2, Function1 allocDirect$2) {
        int bufSize = Snappy.maxCompressedLength((int)uncompressedSize$2);
        return (ByteBuf)allocDirect$2.apply((Object)BoxesRunTime.boxToInteger((int)bufSize));
    }

    private static final ByteBuf $anonfun$3(int uncompressedSize$3, Function1 allocDirect$3) {
        int bufSize = (int)Zstd.compressBound((long)uncompressedSize$3);
        return (ByteBuf)allocDirect$3.apply((Object)BoxesRunTime.boxToInteger((int)bufSize));
    }

    private static final ByteBuf $anonfun$5(int uncompressedSize$4, Function1 allocDirect$4) {
        int bufSize = (int)((double)uncompressedSize$4 * 1.2);
        return (ByteBuf)allocDirect$4.apply((Object)BoxesRunTime.boxToInteger((int)bufSize));
    }
}

