/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.RandomAccess;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;

public class IntArrayList
extends AbstractList<Integer>
implements List<Integer>,
RandomAccess {
    public static final int DEFAULT_NULL_VALUE = Integer.MIN_VALUE;
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    public static final int MAX_SIZE = 0x7FFFFFF7;
    private final int nullValue;
    private int size = 0;
    private int[] elements;

    public IntArrayList() {
        this(10, Integer.MIN_VALUE);
    }

    public IntArrayList(int initialCapacity, int nullValue) {
        this.nullValue = nullValue;
        this.elements = new int[initialCapacity];
    }

    public IntArrayList(int[] initialElements, int initialSize, int nullValue) {
        this.wrap(initialElements, initialSize);
        this.nullValue = nullValue;
    }

    public void wrap(int[] initialElements, int initialSize) {
        if (initialSize < 0 || initialSize > initialElements.length) {
            throw new IllegalArgumentException("Illegal size " + initialSize + " for array length " + initialElements.length);
        }
        this.elements = initialElements;
        this.size = initialSize;
    }

    public int nullValue() {
        return this.nullValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trimToSize() {
        if (this.elements.length != this.size) {
            this.elements = Arrays.copyOf(this.elements, this.size);
        }
    }

    @Override
    public Integer get(int index) {
        int value = this.getInt(index);
        return value == this.nullValue ? null : Integer.valueOf(value);
    }

    public int getInt(int index) {
        this.checkIndex(index);
        return this.elements[index];
    }

    @Override
    public boolean add(Integer element) {
        return this.addInt(null == element ? this.nullValue : element);
    }

    public boolean addInt(int element) {
        this.ensureCapacity(this.size + 1);
        this.elements[this.size] = element;
        ++this.size;
        return true;
    }

    @Override
    public void add(int index, Integer element) {
        this.addInt(index, null == element ? this.nullValue : element);
    }

    public void addInt(int index, int element) {
        this.checkIndexForAdd(index);
        int requiredSize = this.size + 1;
        this.ensureCapacity(requiredSize);
        if (index < this.size) {
            System.arraycopy(this.elements, index, this.elements, index + 1, requiredSize - index);
        }
        this.elements[index] = element;
        ++this.size;
    }

    @Override
    public Integer set(int index, Integer element) {
        int previous = this.setInt(index, null == element ? this.nullValue : element);
        return this.nullValue == previous ? null : Integer.valueOf(previous);
    }

    public int setInt(int index, int element) {
        this.checkIndex(index);
        int previous = this.elements[index];
        this.elements[index] = element;
        return previous;
    }

    public boolean containsInt(int value) {
        return -1 != this.indexOf(value);
    }

    public int indexOf(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (value != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int value) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (value != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Integer remove(int index) {
        this.checkIndex(index);
        int value = this.elements[index];
        int moveCount = this.size - index - 1;
        if (moveCount > 0) {
            System.arraycopy(this.elements, index + 1, this.elements, index, moveCount);
        }
        --this.size;
        return value;
    }

    public boolean removeInt(int value) {
        int index = this.indexOf(value);
        if (-1 != index) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public void forEachOrderedInt(IntConsumer consumer) {
        for (int i = 0; i < this.size; ++i) {
            consumer.accept(this.elements[i]);
        }
    }

    public IntStream intStream() {
        return Arrays.stream(this.elements, 0, this.size);
    }

    public int[] toIntArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    public int[] toIntArray(int[] dst) {
        if (dst.length == this.size) {
            System.arraycopy(this.elements, 0, dst, 0, dst.length);
            return dst;
        }
        return Arrays.copyOf(this.elements, this.size);
    }

    public void ensureCapacity(int requiredCapacity) {
        int capacity = this.elements.length;
        if (requiredCapacity > capacity) {
            int newCapacity = capacity * 2;
            if (newCapacity < 0) {
                if (0x7FFFFFF7 == capacity) {
                    throw new IndexOutOfBoundsException("Max size reached: 2147483639");
                }
                newCapacity = 0x7FFFFFF7;
            }
            int[] newElements = new int[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, capacity);
            this.elements = newElements;
        }
    }

    private void checkIndex(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + " size=" + this.size);
        }
    }

    private void checkIndexForAdd(int index) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + " size=" + this.size);
        }
    }
}

