/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal;

import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public class ConfigurationUtil {
    private final BiFunction<String, String, String> getProperty = System::getProperty;
    private final BiFunction<String, String, String> getPropertyDefault = (p, d) -> d;

    protected final int getInteger(String key, int defaultValue) {
        String value = this.getProperty(key, (String)null);
        if (value == null) {
            return defaultValue;
        }
        return Integer.decode(value);
    }

    protected final boolean getBoolean(String key, boolean defaultValue) {
        String value = this.getProperty(key, (String)null);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    protected final String getProperty(String key, Supplier<String> defaultValue) {
        String value = this.getProperty(key, (String)null);
        if (value == null) {
            return defaultValue.get();
        }
        return value;
    }

    protected final int getInteger(String key, IntSupplier defaultValue) {
        String value = this.getProperty(key, (String)null);
        if (value == null) {
            return defaultValue.getAsInt();
        }
        return Integer.decode(value);
    }

    protected final boolean getBoolean(String key, BooleanSupplier defaultValue) {
        String value = this.getProperty(key, (String)null);
        if (value == null) {
            return defaultValue.getAsBoolean();
        }
        return Boolean.valueOf(value);
    }

    protected String getProperty(String key, String defaultValue) {
        return this.getProperty.apply(key, this.getPropertyDefault.apply(key, defaultValue));
    }
}

