/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.reaktivity.command.log.internal.LogCommandConfiguration;
import org.reaktivity.command.log.internal.LogCountersCommand;
import org.reaktivity.command.log.internal.LogQueueDepthCommand;
import org.reaktivity.command.log.internal.LogRoutesCommand;
import org.reaktivity.command.log.internal.LogStreamsCommand;

public final class LogCommand {
    public static void main(String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption(Option.builder("h").longOpt("help").desc("print this message").build());
        options.addOption(Option.builder("t").hasArg().required(false).longOpt("type").desc("streams* | streams-nowait | counters | queues | routes").build());
        options.addOption(Option.builder("d").longOpt("directory").hasArg().desc("configuration directory").build());
        options.addOption(Option.builder("v").longOpt("verbose").desc("verbose output").build());
        options.addOption(Option.builder("i").hasArg().longOpt("interval").desc("run command continuously at interval").build());
        options.addOption(Option.builder("s").longOpt("separator").desc("include thousands separator in integer values").build());
        CommandLine cmdline = parser.parse(options, args);
        if (cmdline.hasOption("help") || !cmdline.hasOption("directory")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("log", options);
        } else {
            String directory = cmdline.getOptionValue("directory");
            boolean verbose = cmdline.hasOption("verbose");
            boolean separator = cmdline.hasOption("separator");
            String type = cmdline.getOptionValue("type", "streams");
            int interval = Integer.parseInt(cmdline.getOptionValue("interval", "0"));
            Properties properties = new Properties();
            properties.setProperty("reaktor.directory", directory);
            LogCommandConfiguration config = new LogCommandConfiguration(properties);
            Runnable command = null;
            if ("streams".equals(type) || "streams-nowait".equals(type)) {
                command = new LogStreamsCommand(config, System.out::printf, verbose, "streams".equals(type));
            } else if ("counters".equals(type)) {
                command = new LogCountersCommand(config, System.out::printf, verbose, separator);
            } else if ("queues".equals(type)) {
                command = new LogQueueDepthCommand(config, System.out::printf, verbose, separator);
            } else if ("routes".equals(type)) {
                command = new LogRoutesCommand(config, System.out::printf, verbose);
            }
            do {
                command.run();
                Thread.sleep(TimeUnit.SECONDS.toMillis(interval));
            } while (interval > 0);
        }
    }
}

