/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.agrona.LangUtil;
import org.agrona.concurrent.status.CountersManager;
import org.reaktivity.command.log.internal.Logger;
import org.reaktivity.command.log.internal.layouts.ControlLayout;
import org.reaktivity.nukleus.Configuration;

public final class LogCountersCommand
implements Runnable {
    private final Path directory;
    private final boolean verbose;
    private final boolean separator;
    private final int commandBufferCapacity;
    private final int responseBufferCapacity;
    private final int counterLabelsBufferCapacity;
    private final int counterValuesBufferCapacity;
    private final Logger out;
    private final Map<Path, CountersManager> countersByPath;

    LogCountersCommand(Configuration config, Logger out, boolean verbose, boolean separator) {
        this.directory = config.directory();
        this.verbose = verbose;
        this.separator = separator;
        this.commandBufferCapacity = config.commandBufferCapacity();
        this.responseBufferCapacity = config.responseBufferCapacity();
        this.counterLabelsBufferCapacity = config.counterLabelsBufferCapacity();
        this.counterValuesBufferCapacity = config.counterValuesBufferCapacity();
        this.out = out;
        this.countersByPath = new LinkedHashMap<Path, CountersManager>();
    }

    private boolean isControlFile(Path path) {
        return path.getNameCount() - this.directory.getNameCount() == 2 && "control".equals(path.getName(path.getNameCount() - 1).toString()) && Files.isRegularFile(path, new LinkOption[0]);
    }

    private void onDiscovered(Path path) {
        if (this.verbose) {
            this.out.printf("Discovered: %s\n", path);
        }
    }

    private void counters(Path controlPath) {
        String owner = controlPath.getName(controlPath.getNameCount() - 2).toString();
        CountersManager manager = this.countersByPath.computeIfAbsent(controlPath, this::newCountersManager);
        String valueFormat = this.separator ? ",d" : "d";
        manager.forEach((id, name) -> this.out.printf("{\"nukleus\": \"%s\",\"name\": \"%s\",\"value\":%" + valueFormat + "}\n", owner, name, manager.getCounterValue(id)));
    }

    private CountersManager newCountersManager(Path path) {
        ControlLayout layout = new ControlLayout.Builder().controlPath(path).commandBufferCapacity(this.commandBufferCapacity).responseBufferCapacity(this.responseBufferCapacity).counterLabelsBufferCapacity(this.counterLabelsBufferCapacity).counterValuesBufferCapacity(this.counterValuesBufferCapacity).readonly(true).build();
        return new CountersManager(layout.counterLabelsBuffer(), layout.counterValuesBuffer());
    }

    @Override
    public void run() {
        try (Stream<Path> files = Files.walk(this.directory, 2, new FileVisitOption[0]);){
            files.filter(this::isControlFile).peek(this::onDiscovered).forEach(this::counters);
            this.out.printf("\n", new Object[0]);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }
}

