/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.agrona.LangUtil;
import org.reaktivity.command.log.internal.Logger;
import org.reaktivity.command.log.internal.layouts.StreamsLayout;
import org.reaktivity.command.log.internal.spy.RingBufferSpy;
import org.reaktivity.nukleus.Configuration;

public final class LogQueueDepthCommand
implements Runnable {
    private final Path directory;
    private final boolean verbose;
    private final boolean separator;
    private final Logger out;
    private final long streamsCapacity;
    private final Map<Path, StreamsLayout> layoutsByPath;

    public LogQueueDepthCommand(Configuration config, Logger out, boolean verbose, boolean separator) {
        this.directory = config.directory();
        this.out = out;
        this.verbose = verbose;
        this.separator = separator;
        this.streamsCapacity = config.streamsBufferCapacity();
        this.layoutsByPath = new LinkedHashMap<Path, StreamsLayout>();
    }

    private boolean isStreamsFile(Path path) {
        return path.getNameCount() - this.directory.getNameCount() == 3 && "streams".equals(path.getName(path.getNameCount() - 2).toString()) && Files.isRegularFile(path, new LinkOption[0]);
    }

    private void onDiscovered(Path path) {
        if (this.verbose) {
            this.out.printf("Discovered: %s\n", path);
        }
    }

    private void displayQueueDepth(Path path) {
        StreamsLayout layout = this.layoutsByPath.computeIfAbsent(path, this::newStreamsLayout);
        String nukleus = path.getName(path.getNameCount() - 3).toString();
        String source = path.getName(path.getNameCount() - 1).toString();
        this.displayQueueDepth(nukleus, source, "streams", layout.streamsBuffer());
    }

    private StreamsLayout newStreamsLayout(Path path) {
        return new StreamsLayout.Builder().path(path).streamsCapacity(this.streamsCapacity).readonly(true).build();
    }

    private void displayQueueDepth(String nukleus, String source, String type, RingBufferSpy buffer) {
        long consumerAt = buffer.consumerPosition();
        long producerAt = buffer.producerPosition();
        String valueFormat = this.separator ? ",d" : "d";
        this.out.printf("{\"nukleus\":\"%s\", \"source\":\"%s\", \"type\":\"%s\", \"depth\":%" + valueFormat + "}\n", nukleus, source, type, producerAt - consumerAt);
    }

    @Override
    public void run() {
        try (Stream<Path> files = Files.walk(this.directory, 3, new FileVisitOption[0]);){
            files.filter(this::isStreamsFile).peek(this::onDiscovered).forEach(this::displayQueueDepth);
            this.out.printf("\n", new Object[0]);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }
}

