/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.agrona.LangUtil;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.reaktivity.command.log.internal.ConfigurationUtil;
import org.reaktivity.command.log.internal.LoggableRoutes;
import org.reaktivity.command.log.internal.Logger;
import org.reaktivity.command.log.internal.layouts.RoutesLayout;
import org.reaktivity.nukleus.Configuration;

public class LogRoutesCommand
implements Runnable {
    public static final String ROUTES_BUFFER_CAPACITY_PROPERTY_NAME = "reaktor.routes.buffer.capacity";
    public static final int ROUTES_BUFFER_CAPACITY_DEFAULT = 0x100000;
    private static final long MAX_PARK_NS = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final long MIN_PARK_NS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final int MAX_YIELDS = 300;
    private static final int MAX_SPINS = 200;
    private final Path directory;
    private final boolean verbose;
    private final int routesCapacity;
    private final Logger out;
    private final ConfigurationUtil configUtil = new ConfigurationUtil();
    private final IdleStrategy idleStrategy = new BackoffIdleStrategy(200L, 300L, MIN_PARK_NS, MAX_PARK_NS);

    LogRoutesCommand(Configuration config, Logger out, boolean verbose) {
        this.directory = config.directory();
        this.verbose = verbose;
        this.routesCapacity = this.configUtil.getInteger(ROUTES_BUFFER_CAPACITY_PROPERTY_NAME, 0x100000);
        this.out = out;
    }

    private boolean isRoutesFile(Path path) {
        return path.getNameCount() - this.directory.getNameCount() == 2 && "routes".equals(path.getName(path.getNameCount() - 1).toString()) && Files.isRegularFile(path, new LinkOption[0]);
    }

    private LoggableRoutes newLoggable(Path path) {
        RoutesLayout layout = new RoutesLayout.Builder().routesPath(path).routesBufferCapacity(this.routesCapacity).build();
        String nukleusName = path.getName(path.getNameCount() - 2).toString();
        return new LoggableRoutes(layout, nukleusName, this.out, this.idleStrategy);
    }

    private void onDiscovered(Path path) {
        if (this.verbose) {
            this.out.printf("Discovered: %s\n", path);
        }
    }

    @Override
    public void run() {
        try (Stream<Path> files = Files.walk(this.directory, 2, new FileVisitOption[0]);){
            LoggableRoutes[] loggables = files.filter(this::isRoutesFile).peek(this::onDiscovered).map(this::newLoggable).collect(Collectors.toList()).toArray(new LoggableRoutes[0]);
            for (int i = 0; i < loggables.length; ++i) {
                loggables[i].process();
            }
            this.out.printf("\n", new Object[0]);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }
}

