/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.agrona.LangUtil;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.reaktivity.command.log.internal.LoggableStream;
import org.reaktivity.command.log.internal.Logger;
import org.reaktivity.command.log.internal.layouts.StreamsLayout;
import org.reaktivity.nukleus.Configuration;

public final class LogStreamsCommand
implements Runnable {
    private static final Pattern SENDER_NAME = Pattern.compile("([^#]+).*");
    private static final long MAX_PARK_NS = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final long MIN_PARK_NS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final int MAX_YIELDS = 30;
    private static final int MAX_SPINS = 20;
    private final Path directory;
    private final boolean verbose;
    private final long streamsCapacity;
    private final boolean continuous;
    private final Logger out;
    private final Long2LongHashMap timestamps;
    private long nextTimestamp = Long.MAX_VALUE;

    LogStreamsCommand(Configuration config, Logger out, boolean verbose, boolean continuous) {
        this.directory = config.directory();
        this.verbose = verbose;
        this.streamsCapacity = config.streamsBufferCapacity();
        this.continuous = continuous;
        this.out = out;
        this.timestamps = new Long2LongHashMap(-1L);
    }

    private boolean isStreamsFile(Path path) {
        return path.getNameCount() - this.directory.getNameCount() == 3 && "streams".equals(path.getName(path.getNameCount() - 2).toString()) && Files.isRegularFile(path, new LinkOption[0]);
    }

    private LoggableStream newLoggable(Path path) {
        StreamsLayout layout = new StreamsLayout.Builder().path(path).streamsCapacity(this.streamsCapacity).readonly(true).build();
        String receiver = path.getName(path.getNameCount() - 3).toString();
        String sender = LogStreamsCommand.sender(path);
        return new LoggableStream(receiver, sender, layout, this.out, this.verbose, this.timestamps, this::nextTimestamp);
    }

    private void onDiscovered(Path path) {
        if (this.verbose) {
            this.out.printf("Discovered: %s\n", path);
        }
    }

    @Override
    public void run() {
        try (Stream<Path> files = Files.walk(this.directory, 3, new FileVisitOption[0]);){
            int workCount;
            LoggableStream[] loggables = (LoggableStream[])files.filter(this::isStreamsFile).peek(this::onDiscovered).map(this::newLoggable).toArray(LoggableStream[]::new);
            BackoffIdleStrategy idleStrategy = new BackoffIdleStrategy(20L, 30L, MIN_PARK_NS, MAX_PARK_NS);
            int exitWorkCount = this.continuous ? -1 : 0;
            do {
                workCount = 0;
                for (int i = 0; i < loggables.length; ++i) {
                    workCount += loggables[i].process();
                }
                idleStrategy.idle(workCount);
            } while (workCount != exitWorkCount);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    private boolean nextTimestamp(long timestamp) {
        if (timestamp != this.nextTimestamp) {
            this.nextTimestamp = Math.min(timestamp, this.nextTimestamp);
            return false;
        }
        this.nextTimestamp = Long.MAX_VALUE;
        return true;
    }

    private static String sender(Path path) {
        Matcher matcher = SENDER_NAME.matcher(path.getName(path.getNameCount() - 1).toString());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalStateException();
    }
}

