/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal;

import java.util.concurrent.atomic.AtomicInteger;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.command.log.internal.Logger;
import org.reaktivity.command.log.internal.layouts.RoutesLayout;
import org.reaktivity.command.log.internal.types.OctetsFW;
import org.reaktivity.command.log.internal.types.control.RouteFW;
import org.reaktivity.command.log.internal.types.control.TlsRouteExFW;
import org.reaktivity.command.log.internal.types.state.RouteTableFW;

public final class LoggableRoutes
implements AutoCloseable {
    private final RoutesLayout layout;
    private final MutableDirectBuffer routesBuffer;
    private final Logger out;
    private final IdleStrategy idleStrategy;
    private final RouteTableFW routeTableRO;
    private final byte[] copyBuf;
    private final int capacity;
    private final UnsafeBuffer copyBufFW;
    private final RouteFW routeRO;
    private final LongHashSet loggedRoutes;
    private final String nukleusName;

    LoggableRoutes(RoutesLayout layout, String nukleusName, Logger logger, IdleStrategy idleStrategy) {
        this.layout = layout;
        this.nukleusName = nukleusName;
        this.routesBuffer = layout.routesBuffer();
        this.out = logger;
        this.idleStrategy = idleStrategy;
        this.routeTableRO = new RouteTableFW();
        this.capacity = layout.capacity();
        this.copyBuf = new byte[this.capacity];
        this.copyBufFW = new UnsafeBuffer(this.copyBuf);
        this.routeRO = new RouteFW();
        this.loggedRoutes = new LongHashSet(-1L);
    }

    int process() {
        RouteTableFW routeTable = this.routeTableRO.wrap(this.routesBuffer, 0, this.capacity);
        int beforeAcquires = this.routeTableRO.writeLockAcquires();
        if (beforeAcquires == this.routeTableRO.writeLockReleases()) {
            this.routesBuffer.getBytes(0, this.copyBuf);
            this.copyBufFW.wrap(this.copyBuf);
            routeTable = this.routeTableRO.wrap(this.copyBufFW, 0, this.capacity);
            int afterCopyAcquires = routeTable.writeLockAcquires();
            if (beforeAcquires == afterCopyAcquires) {
                return this.logRoutes(routeTable, new LongHashSet(-1L), new AtomicInteger(0));
            }
        }
        this.idleStrategy.idle();
        return this.process();
    }

    private int logRoutes(RouteTableFW routeTable, LongHashSet thisIterationRoutes, AtomicInteger workCnt) {
        routeTable.routeEntries().forEach(e -> {
            OctetsFW routeOctets = e.route();
            DirectBuffer buffer = routeOctets.buffer();
            int offset = routeOctets.offset();
            int routeSize = (int)e.routeSize();
            RouteFW route = this.routeRO.wrap(buffer, offset, offset + routeSize);
            long correlationId = route.correlationId();
            String role = route.role().toString();
            String source = route.source().asString();
            long sourceRef = route.sourceRef();
            String target = route.target().asString();
            long targetRef = route.targetRef();
            long authorization = route.authorization();
            thisIterationRoutes.add(correlationId);
            if (!this.loggedRoutes.contains(correlationId)) {
                workCnt.incrementAndGet();
                String extension = this.extension(route);
                this.out.printf(String.format("{\"$nukleus\":\"%s\", \"$id\":%d, \"role\":\"%s\", \"source\":\"%s\", \"sourceRef\":%d, \"target\":\"%s\", \"targetRef\":%d, \"authorization\":%d%s}\n", this.nukleusName, correlationId, role, source, sourceRef, target, targetRef, authorization, extension == null ? "" : String.format(", \"extension\": %s", extension)), new Object[0]);
                this.loggedRoutes.add(correlationId);
                workCnt.incrementAndGet();
            }
        });
        LongHashSet removedRoutes = this.loggedRoutes.difference(thisIterationRoutes);
        if (removedRoutes != null) {
            removedRoutes.stream().forEach(correlationId -> {
                this.out.printf(String.format("Unrouted %s#%d\n", this.nukleusName, correlationId), new Object[0]);
                this.loggedRoutes.remove(correlationId);
            });
        }
        return workCnt.get();
    }

    private String extension(RouteFW route) {
        String extension = null;
        if ("tls".equals(this.nukleusName)) {
            TlsRouteExFW ext = new TlsRouteExFW();
            int index = route.extension().offset();
            ext.wrap(route.extension().buffer(), index, index + route.extension().sizeof());
            String applicationProtocol = ext.applicationProtocol().asString();
            String hostname = ext.hostname().asString();
            String store = ext.store().asString();
            extension = String.format("{\"store\":\"%s\",\"hostname\":\"%s\",\"applicationProtocol\":\"%s\"}", store, hostname, applicationProtocol);
        }
        return extension;
    }

    @Override
    public void close() throws Exception {
        this.layout.close();
    }
}

