/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.layouts;

import java.io.File;
import java.nio.MappedByteBuffer;
import java.nio.file.Path;
import org.agrona.BitUtil;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.broadcast.BroadcastBufferDescriptor;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;
import org.reaktivity.command.log.internal.layouts.Layout;

public final class ControlLayout
extends Layout {
    private static final int CONTROL_VERSION = 1;
    private static final int FIELD_OFFSET_VERSION = 0;
    private static final int FIELD_SIZE_VERSION = 4;
    private static final int FIELD_OFFSET_COMMAND_BUFFER_LENGTH = 4;
    private static final int FIELD_SIZE_COMMAND_BUFFER_LENGTH = 4;
    private static final int FIELD_OFFSET_RESPONSE_BUFFER_LENGTH = 8;
    private static final int FIELD_SIZE_RESPONSE_BUFFER_LENGTH = 4;
    private static final int FIELD_OFFSET_COUNTER_LABELS_BUFFER_LENGTH = 12;
    private static final int FIELD_SIZE_COUNTER_LABELS_BUFFER_LENGTH = 4;
    private static final int FIELD_OFFSET_COUNTER_VALUES_BUFFER_LENGTH = 16;
    private static final int FIELD_SIZE_COUNTER_VALUES_BUFFER_LENGTH = 4;
    private static final int END_OF_META_DATA_OFFSET = BitUtil.align(20, 64);
    private final AtomicBuffer commandBuffer = new UnsafeBuffer(new byte[0]);
    private final AtomicBuffer responseBuffer = new UnsafeBuffer(new byte[0]);
    private final AtomicBuffer counterLabelsBuffer = new UnsafeBuffer(new byte[0]);
    private final AtomicBuffer counterValuesBuffer = new UnsafeBuffer(new byte[0]);

    public AtomicBuffer commandBuffer() {
        return this.commandBuffer;
    }

    public AtomicBuffer responseBuffer() {
        return this.responseBuffer;
    }

    public AtomicBuffer counterLabelsBuffer() {
        return this.counterLabelsBuffer;
    }

    public AtomicBuffer counterValuesBuffer() {
        return this.counterValuesBuffer;
    }

    @Override
    public void close() {
        IoUtil.unmap(this.commandBuffer.byteBuffer());
        IoUtil.unmap(this.responseBuffer.byteBuffer());
        IoUtil.unmap(this.counterLabelsBuffer.byteBuffer());
        IoUtil.unmap(this.counterValuesBuffer.byteBuffer());
    }

    public static final class Builder
    extends Layout.Builder<ControlLayout> {
        private final ControlLayout layout = new ControlLayout();
        private Path controlPath;
        private int commandBufferCapacity;
        private int responseBufferCapacity;
        private int counterLabelsBufferCapacity;
        private int counterValuesBufferCapacity;
        private AtomicBuffer counterLabelsBuffer;
        private AtomicBuffer counterValuesBuffer;
        private boolean readonly;

        public Builder controlPath(Path controlPath) {
            this.controlPath = controlPath;
            return this;
        }

        public Path controlPath() {
            return this.controlPath;
        }

        public Builder commandBufferCapacity(int commandBufferCapacity) {
            this.commandBufferCapacity = commandBufferCapacity;
            return this;
        }

        public Builder responseBufferCapacity(int responseBufferCapacity) {
            this.responseBufferCapacity = responseBufferCapacity;
            return this;
        }

        public Builder counterLabelsBufferCapacity(int counterLabelsBufferCapacity) {
            this.counterLabelsBufferCapacity = counterLabelsBufferCapacity;
            return this;
        }

        public Builder counterValuesBufferCapacity(int counterValuesBufferCapacity) {
            this.counterValuesBufferCapacity = counterValuesBufferCapacity;
            return this;
        }

        public Builder counterLabelsBuffer(AtomicBuffer counterLabelsBuffer) {
            this.counterLabelsBuffer = counterLabelsBuffer;
            return this;
        }

        public Builder counterValuesBuffer(AtomicBuffer counterValuesBuffer) {
            this.counterValuesBuffer = counterValuesBuffer;
            return this;
        }

        public Builder readonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        @Override
        public ControlLayout build() {
            File controlFile = this.controlPath.toFile();
            int commandBufferLength = this.commandBufferCapacity + RingBufferDescriptor.TRAILER_LENGTH;
            int responseBufferLength = this.responseBufferCapacity + BroadcastBufferDescriptor.TRAILER_LENGTH;
            int counterLabelsBufferLength = this.counterLabelsBufferCapacity;
            int counterValuesBufferLength = this.counterValuesBufferCapacity;
            if (!this.readonly) {
                IoUtil.createEmptyFile(controlFile, END_OF_META_DATA_OFFSET + commandBufferLength + responseBufferLength + counterLabelsBufferLength + counterValuesBufferLength);
                MappedByteBuffer metadata = IoUtil.mapExistingFile(controlFile, "metadata", 0L, END_OF_META_DATA_OFFSET);
                metadata.putInt(0, 1);
                metadata.putInt(4, this.commandBufferCapacity);
                metadata.putInt(8, this.responseBufferCapacity);
                metadata.putInt(12, this.counterLabelsBufferCapacity);
                metadata.putInt(16, this.counterValuesBufferCapacity);
                IoUtil.unmap(metadata);
            }
            int commandBufferOffset = END_OF_META_DATA_OFFSET;
            this.layout.commandBuffer.wrap(IoUtil.mapExistingFile(controlFile, "commands", commandBufferOffset, commandBufferLength));
            int responseBufferOffset = commandBufferOffset + commandBufferLength;
            this.layout.responseBuffer.wrap(IoUtil.mapExistingFile(controlFile, "responses", responseBufferOffset, responseBufferLength));
            int counterLabelsBufferOffset = responseBufferOffset + responseBufferLength;
            if (this.counterLabelsBuffer != null) {
                this.layout.counterLabelsBuffer.wrap(this.counterLabelsBuffer);
                this.counterLabelsBuffer = null;
            } else {
                this.layout.counterLabelsBuffer.wrap(IoUtil.mapExistingFile(controlFile, "counterLabels", counterLabelsBufferOffset, counterLabelsBufferLength));
            }
            int counterValuesBufferOffset = counterLabelsBufferOffset + counterLabelsBufferLength;
            if (this.counterValuesBuffer != null) {
                this.layout.counterValuesBuffer.wrap(this.counterValuesBuffer);
                this.counterValuesBuffer = null;
            } else {
                this.layout.counterValuesBuffer.wrap(IoUtil.mapExistingFile(controlFile, "counterValues", counterValuesBufferOffset, counterValuesBufferLength));
            }
            return this.layout;
        }
    }
}

