/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.layouts;

import java.io.File;
import java.nio.MappedByteBuffer;
import java.nio.file.Path;
import org.agrona.IoUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.command.log.internal.layouts.Layout;

public final class RoutesLayout
extends Layout {
    private final UnsafeBuffer routesBuffer;
    private final int routesBufferCapacity;

    private RoutesLayout(UnsafeBuffer routesBuffer, int routesBufferCapacity) {
        this.routesBuffer = routesBuffer;
        this.routesBufferCapacity = routesBufferCapacity;
    }

    @Override
    public void close() {
        IoUtil.unmap(this.routesBuffer().byteBuffer());
    }

    public MutableDirectBuffer routesBuffer() {
        return this.routesBuffer;
    }

    public int capacity() {
        return this.routesBufferCapacity;
    }

    public static final class Builder
    extends Layout.Builder<RoutesLayout> {
        private Path path;
        private int routesBufferCapacity;

        public Builder routesPath(Path path) {
            this.path = path;
            return this;
        }

        public Builder routesBufferCapacity(int routesBufferCapacity) {
            this.routesBufferCapacity = routesBufferCapacity;
            return this;
        }

        @Override
        public RoutesLayout build() {
            File routes = this.path.toFile();
            MappedByteBuffer mappedRoutes = IoUtil.mapExistingFile(routes, "routes", 0L, this.routesBufferCapacity);
            UnsafeBuffer mutableRoutesBuffer = new UnsafeBuffer(mappedRoutes);
            return new RoutesLayout(mutableRoutesBuffer, this.routesBufferCapacity);
        }
    }
}

