/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types;

import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.String16FW;
import org.reaktivity.command.log.internal.types.StringFW;

public final class HttpHeaderFW
extends Flyweight {
    public static final int FIELD_OFFSET_REPRESENTATION = 0;
    private static final int FIELD_SIZE_REPRESENTATION = 1;
    public static final int FIELD_OFFSET_NAME = 1;
    public static final int FIELD_OFFSET_VALUE = 0;
    private final StringFW nameRO = new StringFW();
    private final String16FW valueRO = new String16FW();

    public byte representation() {
        return this.buffer().getByte(this.offset() + 0);
    }

    public StringFW name() {
        return this.nameRO;
    }

    public String16FW value() {
        return this.valueRO;
    }

    @Override
    public HttpHeaderFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.nameRO.wrap(buffer, offset + 1, maxLimit);
        this.valueRO.wrap(buffer, this.nameRO.limit() + 0, maxLimit);
        HttpHeaderFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.valueRO.limit();
    }

    public String toString() {
        return String.format("HTTP_HEADER [representation=%d, name=%s, value=%s]", this.representation(), this.nameRO.asString(), this.valueRO.asString());
    }

    public static final class Builder
    extends Flyweight.Builder<HttpHeaderFW> {
        private static final int INDEX_REPRESENTATION = 0;
        private static final byte DEFAULT_REPRESENTATION = 0;
        private static final int INDEX_NAME = 1;
        private static final int INDEX_VALUE = 2;
        private static final int FIELD_COUNT = 3;
        private static final BitSet FIELDS_WITH_DEFAULTS = new BitSet(3){
            {
                this.set(0);
            }
        };
        private static final String[] FIELD_NAMES = new String[]{"representation", "name", "value"};
        private final StringFW.Builder nameRW = new StringFW.Builder();
        private final String16FW.Builder valueRW = new String16FW.Builder();
        private final BitSet fieldsSet = new BitSet(3);

        public Builder() {
            super(new HttpHeaderFW());
        }

        public Builder representation(byte value) {
            this.checkFieldNotSet(0);
            this.checkFieldsSet(0, 0);
            int newLimit = this.limit() + 1;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(this.limit(), value);
            this.fieldsSet.set(0);
            this.limit(newLimit);
            return this;
        }

        private StringFW.Builder name() {
            this.checkFieldNotSet(1);
            if (!this.fieldsSet.get(0)) {
                this.representation((byte)0);
            }
            this.checkFieldsSet(0, 1);
            return this.nameRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder name(String value) {
            StringFW.Builder nameRW = this.name();
            nameRW.set(value, StandardCharsets.UTF_8);
            this.fieldsSet.set(1);
            this.limit(nameRW.build().limit());
            return this;
        }

        public Builder name(StringFW value) {
            StringFW.Builder nameRW = this.name();
            nameRW.set(value);
            this.fieldsSet.set(1);
            this.limit(nameRW.build().limit());
            return this;
        }

        public Builder name(DirectBuffer buffer, int offset, int length) {
            StringFW.Builder nameRW = this.name();
            nameRW.set(buffer, offset, length);
            this.fieldsSet.set(1);
            this.limit(nameRW.build().limit());
            return this;
        }

        private String16FW.Builder value() {
            this.checkFieldNotSet(2);
            this.checkFieldsSet(0, 2);
            return this.valueRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder value(String value) {
            String16FW.Builder valueRW = this.value();
            valueRW.set(value, StandardCharsets.UTF_8);
            this.fieldsSet.set(2);
            this.limit(valueRW.build().limit());
            return this;
        }

        public Builder value(String16FW value) {
            String16FW.Builder valueRW = this.value();
            valueRW.set(value);
            this.fieldsSet.set(2);
            this.limit(valueRW.build().limit());
            return this;
        }

        public Builder value(DirectBuffer buffer, int offset, int length) {
            String16FW.Builder valueRW = this.value();
            valueRW.set(buffer, offset, length);
            this.fieldsSet.set(2);
            this.limit(valueRW.build().limit());
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            this.fieldsSet.clear();
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        @Override
        public HttpHeaderFW build() {
            this.checkFieldsSet(0, 3);
            this.fieldsSet.clear();
            return (HttpHeaderFW)super.build();
        }

        private void checkFieldNotSet(int index) {
            if (this.fieldsSet.get(index)) {
                throw new IllegalStateException(String.format("Field \"%s\" has already been set", FIELD_NAMES[index]));
            }
        }

        private void checkFieldsSet(int fromIndex, int toIndex) {
            int fieldNotSet = fromIndex - 1;
            while ((fieldNotSet = this.fieldsSet.nextClearBit(fieldNotSet + 1)) < toIndex && FIELDS_WITH_DEFAULTS.get(fieldNotSet)) {
            }
            if (fieldNotSet < toIndex) {
                throw new IllegalStateException(String.format("Required field \"%s\" is not set", FIELD_NAMES[fieldNotSet]));
            }
        }
    }
}

