/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;

public final class StringFW
extends Flyweight {
    private static final int FIELD_OFFSET_LENGTH = 0;
    private static final int FIELD_SIZE_LENGTH = 1;

    @Override
    public int limit() {
        return this.maxLimit() == this.offset() ? this.offset() : this.offset() + 1 + Math.max(this.length0(), 0);
    }

    public String asString() {
        if (this.maxLimit() == this.offset() || this.length0() == -1) {
            return null;
        }
        return this.buffer().getStringWithoutLengthUtf8(this.offset() + 1, this.length0());
    }

    @Override
    public StringFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        StringFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    public String toString() {
        return this.maxLimit() == this.offset() ? "null" : String.format("\"%s\"", this.asString());
    }

    private int length0() {
        int length = this.buffer().getByte(this.offset() + 0) & 0xFF;
        return length == 255 ? -1 : length;
    }

    public static final class Builder
    extends Flyweight.Builder<StringFW> {
        private boolean valueSet;

        public Builder() {
            super(new StringFW());
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            Flyweight.checkLimit(offset + 0 + 1, maxLimit);
            super.wrap(buffer, offset, maxLimit);
            this.valueSet = false;
            return this;
        }

        public Builder set(StringFW value) {
            if (value == null) {
                int newLimit = this.offset() + 1;
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putByte(this.offset(), (byte)-1);
                this.limit(newLimit);
            } else {
                int newLimit = this.offset() + value.sizeof();
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putBytes(this.offset(), value.buffer(), value.offset(), value.sizeof());
                this.limit(newLimit);
            }
            this.valueSet = true;
            return this;
        }

        public Builder set(DirectBuffer srcBuffer, int srcOffset, int length) {
            Builder.checkLength(length);
            int offset = this.offset();
            int newLimit = offset + length + 1;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(offset, (byte)length);
            this.buffer().putBytes(offset + 1, srcBuffer, srcOffset, length);
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        public Builder set(String value, Charset charset) {
            if (value == null) {
                int newLimit = this.offset() + 1;
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putByte(this.offset(), (byte)-1);
                this.limit(newLimit);
            } else {
                byte[] charBytes = value.getBytes(charset);
                Builder.checkLength(charBytes.length);
                int newLimit = this.offset() + 1 + charBytes.length;
                Flyweight.checkLimit(newLimit, this.maxLimit());
                this.buffer().putByte(this.offset(), (byte)charBytes.length);
                this.buffer().putBytes(this.offset() + 1, charBytes);
                this.limit(newLimit);
            }
            this.valueSet = true;
            return this;
        }

        private static void checkLength(int length) {
            int maxLength = 254;
            if (length > 254) {
                String msg = String.format("length=%d is beyond maximum length=%d", length, 254);
                throw new IllegalArgumentException(msg);
            }
        }

        @Override
        public StringFW build() {
            if (!this.valueSet) {
                this.set(null, StandardCharsets.UTF_8);
            }
            return (StringFW)super.build();
        }
    }
}

