/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;

public final class Varint32FW
extends Flyweight {
    private int size;

    @Override
    public int limit() {
        return this.offset() + this.size;
    }

    public int value() {
        byte b;
        int value = 0;
        int i = 0;
        int pos = this.offset();
        while (((b = this.buffer().getByte(pos++)) & 0x80) != 0) {
            value |= (b & 0x7F) << i;
            if ((i += 7) <= 35) continue;
            throw new IllegalArgumentException("varint32 value too long");
        }
        int unsigned = value | b << i;
        int result = (unsigned << 31 >> 31 ^ unsigned) >> 1;
        return result ^= unsigned & Integer.MIN_VALUE;
    }

    @Override
    public Varint32FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.size = this.length0();
        Varint32FW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    public String toString() {
        return Integer.toString(this.value());
    }

    private int length0() {
        int mask;
        int pos;
        byte b = 0;
        int maxPos = Math.max(pos + 5, this.maxLimit());
        for (pos = this.offset(); pos <= maxPos && ((b = this.buffer().getByte(pos)) & 0x80) != 0; ++pos) {
        }
        int size = 1 + pos - this.offset();
        int n = mask = size < 5 ? 128 : 240;
        if ((b & mask) != 0) {
            throw new IllegalArgumentException(String.format("varint32 value at offset %d exceeds 32 bits", this.offset()));
        }
        return size;
    }

    public static final class Builder
    extends Flyweight.Builder<Varint32FW> {
        private boolean valueSet;

        public Builder() {
            super(new Varint32FW());
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            Flyweight.checkLimit(offset + 1, maxLimit);
            super.wrap(buffer, offset, maxLimit);
            this.valueSet = false;
            return this;
        }

        public Builder set(int value) {
            int zigzagged = value << 1 ^ value >> 31;
            int pos = this.offset();
            int bits = 1 + Integer.numberOfTrailingZeros(Integer.highestOneBit(zigzagged));
            int size = bits / 7;
            if (size * 7 < bits) {
                ++size;
            }
            int newLimit = pos + size;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            while ((zigzagged & 0xFFFFFF80) != 0) {
                this.buffer().putByte(pos++, (byte)(zigzagged & 0x7F | 0x80));
                zigzagged >>>= 7;
            }
            this.buffer().putByte(pos, (byte)(zigzagged & 0x7F));
            this.limit(newLimit);
            this.valueSet = true;
            return this;
        }

        @Override
        public Varint32FW build() {
            if (!this.valueSet) {
                throw new IllegalArgumentException("value not set");
            }
            return (Varint32FW)super.build();
        }
    }
}

