/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types.control;

import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.OctetsFW;
import org.reaktivity.command.log.internal.types.StringFW;
import org.reaktivity.command.log.internal.types.control.RoleFW;

public final class RouteFW
extends Flyweight {
    public static final int FIELD_OFFSET_CORRELATION_ID = 0;
    private static final int FIELD_SIZE_CORRELATION_ID = 8;
    public static final int FIELD_OFFSET_ROLE = 8;
    public static final int FIELD_OFFSET_SOURCE = 0;
    public static final int FIELD_OFFSET_SOURCE_REF = 0;
    private static final int FIELD_SIZE_SOURCE_REF = 8;
    public static final int FIELD_OFFSET_TARGET = 8;
    public static final int FIELD_OFFSET_TARGET_REF = 0;
    private static final int FIELD_SIZE_TARGET_REF = 8;
    public static final int FIELD_OFFSET_AUTHORIZATION = 8;
    private static final int FIELD_SIZE_AUTHORIZATION = 8;
    public static final int FIELD_OFFSET_EXTENSION = 16;
    public static final int TYPE_ID = 1;
    private final RoleFW roleRO = new RoleFW();
    private final StringFW sourceRO = new StringFW();
    private final StringFW targetRO = new StringFW();
    private final OctetsFW extensionRO = new OctetsFW();

    public long correlationId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public RoleFW role() {
        return this.roleRO;
    }

    public StringFW source() {
        return this.sourceRO;
    }

    public long sourceRef() {
        return this.buffer().getLong(this.sourceRO.limit() + 0);
    }

    public StringFW target() {
        return this.targetRO;
    }

    public long targetRef() {
        return this.buffer().getLong(this.targetRO.limit() + 0);
    }

    public long authorization() {
        return this.buffer().getLong(this.targetRO.limit() + 8);
    }

    public OctetsFW extension() {
        return this.extensionRO;
    }

    public int typeId() {
        return 1;
    }

    @Override
    public RouteFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.roleRO.wrap(buffer, offset + 8, maxLimit);
        this.sourceRO.wrap(buffer, this.roleRO.limit() + 0, maxLimit);
        this.targetRO.wrap(buffer, this.sourceRO.limit() + 8, maxLimit);
        this.extensionRO.wrap(buffer, this.targetRO.limit() + 16, maxLimit);
        RouteFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.extensionRO.limit();
    }

    public String toString() {
        return String.format("ROUTE [correlationId=%d, role=%s, source=%s, sourceRef=%d, target=%s, targetRef=%d, authorization=%d, extension=%s]", this.correlationId(), this.role(), this.sourceRO.asString(), this.sourceRef(), this.targetRO.asString(), this.targetRef(), this.authorization(), this.extension());
    }

    public static final class Builder
    extends Flyweight.Builder<RouteFW> {
        private static final int INDEX_CORRELATION_ID = 0;
        private static final int INDEX_ROLE = 1;
        private static final int INDEX_SOURCE = 2;
        private static final int INDEX_SOURCE_REF = 3;
        private static final int INDEX_TARGET = 4;
        private static final int INDEX_TARGET_REF = 5;
        private static final int INDEX_AUTHORIZATION = 6;
        private static final long DEFAULT_AUTHORIZATION = 0L;
        private static final int INDEX_EXTENSION = 7;
        private static final int FIELD_COUNT = 8;
        private static final BitSet FIELDS_WITH_DEFAULTS = new BitSet(8){
            {
                this.set(1);
                this.set(6);
                this.set(7);
            }
        };
        private static final String[] FIELD_NAMES = new String[]{"correlationId", "role", "source", "sourceRef", "target", "targetRef", "authorization", "extension"};
        private final RoleFW.Builder roleRW = new RoleFW.Builder();
        private final StringFW.Builder sourceRW = new StringFW.Builder();
        private final StringFW.Builder targetRW = new StringFW.Builder();
        private final OctetsFW.Builder extensionRW = new OctetsFW.Builder();
        private final BitSet fieldsSet = new BitSet(8);

        public Builder() {
            super(new RouteFW());
        }

        public Builder correlationId(long value) {
            this.checkFieldNotSet(0);
            this.checkFieldsSet(0, 0);
            int newLimit = this.limit() + 8;
            RouteFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(0);
            this.limit(newLimit);
            return this;
        }

        public Builder role(Consumer<RoleFW.Builder> mutator) {
            this.checkFieldNotSet(1);
            this.checkFieldsSet(0, 1);
            RoleFW.Builder roleRW = this.roleRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(roleRW);
            this.limit(roleRW.build().limit());
            this.fieldsSet.set(1);
            return this;
        }

        private StringFW.Builder source() {
            this.checkFieldNotSet(2);
            if (!this.fieldsSet.get(1)) {
                this.role(b -> {});
            }
            this.checkFieldsSet(0, 2);
            return this.sourceRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder source(String value) {
            StringFW.Builder sourceRW = this.source();
            sourceRW.set(value, StandardCharsets.UTF_8);
            this.fieldsSet.set(2);
            this.limit(sourceRW.build().limit());
            return this;
        }

        public Builder source(StringFW value) {
            StringFW.Builder sourceRW = this.source();
            sourceRW.set(value);
            this.fieldsSet.set(2);
            this.limit(sourceRW.build().limit());
            return this;
        }

        public Builder source(DirectBuffer buffer, int offset, int length) {
            StringFW.Builder sourceRW = this.source();
            sourceRW.set(buffer, offset, length);
            this.fieldsSet.set(2);
            this.limit(sourceRW.build().limit());
            return this;
        }

        public Builder sourceRef(long value) {
            this.checkFieldNotSet(3);
            this.checkFieldsSet(0, 3);
            int newLimit = this.limit() + 8;
            RouteFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(3);
            this.limit(newLimit);
            return this;
        }

        private StringFW.Builder target() {
            this.checkFieldNotSet(4);
            this.checkFieldsSet(0, 4);
            return this.targetRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder target(String value) {
            StringFW.Builder targetRW = this.target();
            targetRW.set(value, StandardCharsets.UTF_8);
            this.fieldsSet.set(4);
            this.limit(targetRW.build().limit());
            return this;
        }

        public Builder target(StringFW value) {
            StringFW.Builder targetRW = this.target();
            targetRW.set(value);
            this.fieldsSet.set(4);
            this.limit(targetRW.build().limit());
            return this;
        }

        public Builder target(DirectBuffer buffer, int offset, int length) {
            StringFW.Builder targetRW = this.target();
            targetRW.set(buffer, offset, length);
            this.fieldsSet.set(4);
            this.limit(targetRW.build().limit());
            return this;
        }

        public Builder targetRef(long value) {
            this.checkFieldNotSet(5);
            this.checkFieldsSet(0, 5);
            int newLimit = this.limit() + 8;
            RouteFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(5);
            this.limit(newLimit);
            return this;
        }

        public Builder authorization(long value) {
            this.checkFieldNotSet(6);
            this.checkFieldsSet(0, 6);
            int newLimit = this.limit() + 8;
            RouteFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(6);
            this.limit(newLimit);
            return this;
        }

        private OctetsFW.Builder extension() {
            this.checkFieldNotSet(7);
            if (!this.fieldsSet.get(6)) {
                this.authorization(0L);
            }
            this.checkFieldsSet(0, 7);
            return this.extensionRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder extension(OctetsFW value) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(value);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.fieldsSet.set(7);
            return this;
        }

        public Builder extension(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder extensionRW = this.extension();
            mutator.accept(extensionRW);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.fieldsSet.set(7);
            return this;
        }

        public Builder extension(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(buffer, offset, length);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.fieldsSet.set(7);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            this.fieldsSet.clear();
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        @Override
        public RouteFW build() {
            if (!this.fieldsSet.get(7)) {
                this.extension((OctetsFW.Builder b) -> {});
            }
            this.checkFieldsSet(0, 8);
            this.fieldsSet.clear();
            return (RouteFW)super.build();
        }

        private void checkFieldNotSet(int index) {
            if (this.fieldsSet.get(index)) {
                throw new IllegalStateException(String.format("Field \"%s\" has already been set", FIELD_NAMES[index]));
            }
        }

        private void checkFieldsSet(int fromIndex, int toIndex) {
            int fieldNotSet = fromIndex - 1;
            while ((fieldNotSet = this.fieldsSet.nextClearBit(fieldNotSet + 1)) < toIndex && FIELDS_WITH_DEFAULTS.get(fieldNotSet)) {
            }
            if (fieldNotSet < toIndex) {
                throw new IllegalStateException(String.format("Required field \"%s\" is not set", FIELD_NAMES[fieldNotSet]));
            }
        }
    }
}

