/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types.control;

import java.util.BitSet;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;

public final class RoutedFW
extends Flyweight {
    public static final int FIELD_OFFSET_CORRELATION_ID = 0;
    private static final int FIELD_SIZE_CORRELATION_ID = 8;
    public static final int FIELD_OFFSET_SOURCE_REF = 8;
    private static final int FIELD_SIZE_SOURCE_REF = 8;
    public static final int FIELD_OFFSET_TARGET_REF = 16;
    private static final int FIELD_SIZE_TARGET_REF = 8;
    public static final int TYPE_ID = 0x40000001;

    public long correlationId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public long sourceRef() {
        return this.buffer().getLong(this.offset() + 8);
    }

    public long targetRef() {
        return this.buffer().getLong(this.offset() + 16);
    }

    public int typeId() {
        return 0x40000001;
    }

    @Override
    public RoutedFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        RoutedFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 16 + 8;
    }

    public String toString() {
        return String.format("ROUTED [correlationId=%d, sourceRef=%d, targetRef=%d]", this.correlationId(), this.sourceRef(), this.targetRef());
    }

    public static final class Builder
    extends Flyweight.Builder<RoutedFW> {
        private static final int INDEX_CORRELATION_ID = 0;
        private static final int INDEX_SOURCE_REF = 1;
        private static final int INDEX_TARGET_REF = 2;
        private static final int FIELD_COUNT = 3;
        private static final BitSet FIELDS_WITH_DEFAULTS = new BitSet(3){};
        private static final String[] FIELD_NAMES = new String[]{"correlationId", "sourceRef", "targetRef"};
        private final BitSet fieldsSet = new BitSet(3);

        public Builder() {
            super(new RoutedFW());
        }

        public Builder correlationId(long value) {
            this.checkFieldNotSet(0);
            this.checkFieldsSet(0, 0);
            int newLimit = this.limit() + 8;
            RoutedFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(0);
            this.limit(newLimit);
            return this;
        }

        public Builder sourceRef(long value) {
            this.checkFieldNotSet(1);
            this.checkFieldsSet(0, 1);
            int newLimit = this.limit() + 8;
            RoutedFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(1);
            this.limit(newLimit);
            return this;
        }

        public Builder targetRef(long value) {
            this.checkFieldNotSet(2);
            this.checkFieldsSet(0, 2);
            int newLimit = this.limit() + 8;
            RoutedFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(2);
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            this.fieldsSet.clear();
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        @Override
        public RoutedFW build() {
            this.checkFieldsSet(0, 3);
            this.fieldsSet.clear();
            return (RoutedFW)super.build();
        }

        private void checkFieldNotSet(int index) {
            if (this.fieldsSet.get(index)) {
                throw new IllegalStateException(String.format("Field \"%s\" has already been set", FIELD_NAMES[index]));
            }
        }

        private void checkFieldsSet(int fromIndex, int toIndex) {
            int fieldNotSet = fromIndex - 1;
            while ((fieldNotSet = this.fieldsSet.nextClearBit(fieldNotSet + 1)) < toIndex && FIELDS_WITH_DEFAULTS.get(fieldNotSet)) {
            }
            if (fieldNotSet < toIndex) {
                throw new IllegalStateException(String.format("Required field \"%s\" is not set", FIELD_NAMES[fieldNotSet]));
            }
        }
    }
}

