/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types.control;

import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.StringFW;

public final class TlsRouteExFW
extends Flyweight {
    public static final int FIELD_OFFSET_STORE = 0;
    public static final int FIELD_OFFSET_HOSTNAME = 0;
    public static final int FIELD_OFFSET_APPLICATION_PROTOCOL = 0;
    private final StringFW storeRO = new StringFW();
    private final StringFW hostnameRO = new StringFW();
    private final StringFW applicationProtocolRO = new StringFW();

    public StringFW store() {
        return this.storeRO;
    }

    public StringFW hostname() {
        return this.hostnameRO;
    }

    public StringFW applicationProtocol() {
        return this.applicationProtocolRO;
    }

    @Override
    public TlsRouteExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.storeRO.wrap(buffer, offset + 0, maxLimit);
        this.hostnameRO.wrap(buffer, this.storeRO.limit() + 0, maxLimit);
        this.applicationProtocolRO.wrap(buffer, this.hostnameRO.limit() + 0, maxLimit);
        TlsRouteExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.applicationProtocolRO.limit();
    }

    public String toString() {
        return String.format("TLS_ROUTE_EX [store=%s, hostname=%s, applicationProtocol=%s]", this.storeRO.asString(), this.hostnameRO.asString(), this.applicationProtocolRO.asString());
    }

    public static final class Builder
    extends Flyweight.Builder<TlsRouteExFW> {
        private static final int INDEX_STORE = 0;
        private static final int INDEX_HOSTNAME = 1;
        private static final int INDEX_APPLICATION_PROTOCOL = 2;
        private static final int FIELD_COUNT = 3;
        private static final BitSet FIELDS_WITH_DEFAULTS = new BitSet(3){};
        private static final String[] FIELD_NAMES = new String[]{"store", "hostname", "applicationProtocol"};
        private final StringFW.Builder storeRW = new StringFW.Builder();
        private final StringFW.Builder hostnameRW = new StringFW.Builder();
        private final StringFW.Builder applicationProtocolRW = new StringFW.Builder();
        private final BitSet fieldsSet = new BitSet(3);

        public Builder() {
            super(new TlsRouteExFW());
        }

        private StringFW.Builder store() {
            this.checkFieldNotSet(0);
            this.checkFieldsSet(0, 0);
            return this.storeRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder store(String value) {
            StringFW.Builder storeRW = this.store();
            storeRW.set(value, StandardCharsets.UTF_8);
            this.fieldsSet.set(0);
            this.limit(storeRW.build().limit());
            return this;
        }

        public Builder store(StringFW value) {
            StringFW.Builder storeRW = this.store();
            storeRW.set(value);
            this.fieldsSet.set(0);
            this.limit(storeRW.build().limit());
            return this;
        }

        public Builder store(DirectBuffer buffer, int offset, int length) {
            StringFW.Builder storeRW = this.store();
            storeRW.set(buffer, offset, length);
            this.fieldsSet.set(0);
            this.limit(storeRW.build().limit());
            return this;
        }

        private StringFW.Builder hostname() {
            this.checkFieldNotSet(1);
            this.checkFieldsSet(0, 1);
            return this.hostnameRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder hostname(String value) {
            StringFW.Builder hostnameRW = this.hostname();
            hostnameRW.set(value, StandardCharsets.UTF_8);
            this.fieldsSet.set(1);
            this.limit(hostnameRW.build().limit());
            return this;
        }

        public Builder hostname(StringFW value) {
            StringFW.Builder hostnameRW = this.hostname();
            hostnameRW.set(value);
            this.fieldsSet.set(1);
            this.limit(hostnameRW.build().limit());
            return this;
        }

        public Builder hostname(DirectBuffer buffer, int offset, int length) {
            StringFW.Builder hostnameRW = this.hostname();
            hostnameRW.set(buffer, offset, length);
            this.fieldsSet.set(1);
            this.limit(hostnameRW.build().limit());
            return this;
        }

        private StringFW.Builder applicationProtocol() {
            this.checkFieldNotSet(2);
            this.checkFieldsSet(0, 2);
            return this.applicationProtocolRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder applicationProtocol(String value) {
            StringFW.Builder applicationProtocolRW = this.applicationProtocol();
            applicationProtocolRW.set(value, StandardCharsets.UTF_8);
            this.fieldsSet.set(2);
            this.limit(applicationProtocolRW.build().limit());
            return this;
        }

        public Builder applicationProtocol(StringFW value) {
            StringFW.Builder applicationProtocolRW = this.applicationProtocol();
            applicationProtocolRW.set(value);
            this.fieldsSet.set(2);
            this.limit(applicationProtocolRW.build().limit());
            return this;
        }

        public Builder applicationProtocol(DirectBuffer buffer, int offset, int length) {
            StringFW.Builder applicationProtocolRW = this.applicationProtocol();
            applicationProtocolRW.set(buffer, offset, length);
            this.fieldsSet.set(2);
            this.limit(applicationProtocolRW.build().limit());
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            this.fieldsSet.clear();
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        @Override
        public TlsRouteExFW build() {
            this.checkFieldsSet(0, 3);
            this.fieldsSet.clear();
            return (TlsRouteExFW)super.build();
        }

        private void checkFieldNotSet(int index) {
            if (this.fieldsSet.get(index)) {
                throw new IllegalStateException(String.format("Field \"%s\" has already been set", FIELD_NAMES[index]));
            }
        }

        private void checkFieldsSet(int fromIndex, int toIndex) {
            int fieldNotSet = fromIndex - 1;
            while ((fieldNotSet = this.fieldsSet.nextClearBit(fieldNotSet + 1)) < toIndex && FIELDS_WITH_DEFAULTS.get(fieldNotSet)) {
            }
            if (fieldNotSet < toIndex) {
                throw new IllegalStateException(String.format("Required field \"%s\" is not set", FIELD_NAMES[fieldNotSet]));
            }
        }
    }
}

