/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types.control.auth;

import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.ListFW;
import org.reaktivity.command.log.internal.types.StringFW;

public final class ResolveFW
extends Flyweight {
    public static final int FIELD_OFFSET_CORRELATION_ID = 0;
    private static final int FIELD_SIZE_CORRELATION_ID = 8;
    public static final int FIELD_OFFSET_REALM = 8;
    public static final int FIELD_OFFSET_ROLES = 0;
    public static final int TYPE_ID = 17;
    private final StringFW realmRO = new StringFW();
    private final ListFW<StringFW> rolesRO = new ListFW<StringFW>(new StringFW());

    public long correlationId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public StringFW realm() {
        return this.realmRO;
    }

    public ListFW<StringFW> roles() {
        return this.rolesRO;
    }

    public int typeId() {
        return 17;
    }

    @Override
    public ResolveFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.realmRO.wrap(buffer, offset + 8, maxLimit);
        this.rolesRO.wrap(buffer, this.realmRO.limit() + 0, maxLimit);
        ResolveFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.rolesRO.limit();
    }

    public String toString() {
        return String.format("RESOLVE [correlationId=%d, realm=%s, roles=%s]", this.correlationId(), this.realmRO.asString(), this.roles());
    }

    public static final class Builder
    extends Flyweight.Builder<ResolveFW> {
        private static final int INDEX_CORRELATION_ID = 0;
        private static final int INDEX_REALM = 1;
        private static final int INDEX_ROLES = 2;
        private static final int FIELD_COUNT = 3;
        private static final BitSet FIELDS_WITH_DEFAULTS = new BitSet(3){
            {
                this.set(2);
            }
        };
        private static final String[] FIELD_NAMES = new String[]{"correlationId", "realm", "roles"};
        private final StringFW.Builder realmRW = new StringFW.Builder();
        private final ListFW.Builder<StringFW.Builder, StringFW> rolesRW = new ListFW.Builder<StringFW.Builder, StringFW>(new StringFW.Builder(), new StringFW());
        private final BitSet fieldsSet = new BitSet(3);

        public Builder() {
            super(new ResolveFW());
        }

        public Builder correlationId(long value) {
            this.checkFieldNotSet(0);
            this.checkFieldsSet(0, 0);
            int newLimit = this.limit() + 8;
            ResolveFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(0);
            this.limit(newLimit);
            return this;
        }

        private StringFW.Builder realm() {
            this.checkFieldNotSet(1);
            this.checkFieldsSet(0, 1);
            return this.realmRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder realm(String value) {
            StringFW.Builder realmRW = this.realm();
            realmRW.set(value, StandardCharsets.UTF_8);
            this.fieldsSet.set(1);
            this.limit(realmRW.build().limit());
            return this;
        }

        public Builder realm(StringFW value) {
            StringFW.Builder realmRW = this.realm();
            realmRW.set(value);
            this.fieldsSet.set(1);
            this.limit(realmRW.build().limit());
            return this;
        }

        public Builder realm(DirectBuffer buffer, int offset, int length) {
            StringFW.Builder realmRW = this.realm();
            realmRW.set(buffer, offset, length);
            this.fieldsSet.set(1);
            this.limit(realmRW.build().limit());
            return this;
        }

        public Builder roles(Consumer<ListFW.Builder<StringFW.Builder, StringFW>> mutator) {
            this.checkFieldNotSet(2);
            this.checkFieldsSet(0, 2);
            Flyweight.Builder rolesRW = this.rolesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((ListFW.Builder<StringFW.Builder, StringFW>)rolesRW);
            this.limit(((ListFW)((ListFW.Builder)rolesRW).build()).limit());
            this.fieldsSet.set(2);
            return this;
        }

        public Builder rolesItem(Consumer<StringFW.Builder> mutator) {
            this.checkFieldsSet(0, 2);
            if (!this.fieldsSet.get(2)) {
                Flyweight.Builder builder = this.rolesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.rolesRW.item(mutator);
            this.limit(((ListFW)this.rolesRW.build()).limit());
            this.fieldsSet.set(2);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            this.fieldsSet.clear();
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        @Override
        public ResolveFW build() {
            if (!this.fieldsSet.get(2)) {
                this.roles(b -> {});
            }
            this.checkFieldsSet(0, 3);
            this.fieldsSet.clear();
            return (ResolveFW)super.build();
        }

        private void checkFieldNotSet(int index) {
            if (this.fieldsSet.get(index)) {
                throw new IllegalStateException(String.format("Field \"%s\" has already been set", FIELD_NAMES[index]));
            }
        }

        private void checkFieldsSet(int fromIndex, int toIndex) {
            int fieldNotSet = fromIndex - 1;
            while ((fieldNotSet = this.fieldsSet.nextClearBit(fieldNotSet + 1)) < toIndex && FIELDS_WITH_DEFAULTS.get(fieldNotSet)) {
            }
            if (fieldNotSet < toIndex) {
                throw new IllegalStateException(String.format("Required field \"%s\" is not set", FIELD_NAMES[fieldNotSet]));
            }
        }
    }
}

