/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types.control.auth;

import java.util.BitSet;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;

public final class UnresolveFW
extends Flyweight {
    public static final int FIELD_OFFSET_CORRELATION_ID = 0;
    private static final int FIELD_SIZE_CORRELATION_ID = 8;
    public static final int FIELD_OFFSET_AUTHORIZATION = 8;
    private static final int FIELD_SIZE_AUTHORIZATION = 8;
    public static final int TYPE_ID = 18;

    public long correlationId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public long authorization() {
        return this.buffer().getLong(this.offset() + 8);
    }

    public int typeId() {
        return 18;
    }

    @Override
    public UnresolveFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        UnresolveFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 8 + 8;
    }

    public String toString() {
        return String.format("UNRESOLVE [correlationId=%d, authorization=%d]", this.correlationId(), this.authorization());
    }

    public static final class Builder
    extends Flyweight.Builder<UnresolveFW> {
        private static final int INDEX_CORRELATION_ID = 0;
        private static final int INDEX_AUTHORIZATION = 1;
        private static final int FIELD_COUNT = 2;
        private static final BitSet FIELDS_WITH_DEFAULTS = new BitSet(2){};
        private static final String[] FIELD_NAMES = new String[]{"correlationId", "authorization"};
        private final BitSet fieldsSet = new BitSet(2);

        public Builder() {
            super(new UnresolveFW());
        }

        public Builder correlationId(long value) {
            this.checkFieldNotSet(0);
            this.checkFieldsSet(0, 0);
            int newLimit = this.limit() + 8;
            UnresolveFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(0);
            this.limit(newLimit);
            return this;
        }

        public Builder authorization(long value) {
            this.checkFieldNotSet(1);
            this.checkFieldsSet(0, 1);
            int newLimit = this.limit() + 8;
            UnresolveFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(1);
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            this.fieldsSet.clear();
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        @Override
        public UnresolveFW build() {
            this.checkFieldsSet(0, 2);
            this.fieldsSet.clear();
            return (UnresolveFW)super.build();
        }

        private void checkFieldNotSet(int index) {
            if (this.fieldsSet.get(index)) {
                throw new IllegalStateException(String.format("Field \"%s\" has already been set", FIELD_NAMES[index]));
            }
        }

        private void checkFieldsSet(int fromIndex, int toIndex) {
            int fieldNotSet = fromIndex - 1;
            while ((fieldNotSet = this.fieldsSet.nextClearBit(fieldNotSet + 1)) < toIndex && FIELDS_WITH_DEFAULTS.get(fieldNotSet)) {
            }
            if (fieldNotSet < toIndex) {
                throw new IllegalStateException(String.format("Required field \"%s\" is not set", FIELD_NAMES[fieldNotSet]));
            }
        }
    }
}

