/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types.state;

import java.util.BitSet;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.OctetsFW;

public final class RouteEntryFW
extends Flyweight {
    public static final int FIELD_OFFSET_ROUTE_SIZE = 0;
    private static final int FIELD_SIZE_ROUTE_SIZE = 4;
    public static final int FIELD_OFFSET_ROUTE = 4;
    private final OctetsFW routeRO = new OctetsFW();

    public long routeSize() {
        return (long)this.buffer().getInt(this.offset() + 0) & 0xFFFFFFFFL;
    }

    public OctetsFW route() {
        return this.routeRO;
    }

    @Override
    public RouteEntryFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.routeRO.wrap(buffer, offset + 4, offset + 4 + (int)this.routeSize());
        RouteEntryFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.routeRO.limit();
    }

    public String toString() {
        return String.format("ROUTE_ENTRY [routeSize=%d, route=%s]", this.routeSize(), this.route());
    }

    public static final class Builder
    extends Flyweight.Builder<RouteEntryFW> {
        private static final int INDEX_ROUTE_SIZE = 0;
        private static final long DEFAULT_ROUTE_SIZE = 0L;
        private static final int INDEX_ROUTE = 1;
        private static final int FIELD_COUNT = 2;
        private static final BitSet FIELDS_WITH_DEFAULTS = new BitSet(2){
            {
                this.set(0);
            }
        };
        private static final String[] FIELD_NAMES = new String[]{"routeSize", "route"};
        private int dynamicOffsetRouteSize;
        private final OctetsFW.Builder routeRW = new OctetsFW.Builder();
        private final BitSet fieldsSet = new BitSet(2);

        public Builder() {
            super(new RouteEntryFW());
        }

        private Builder routeSize(long value) {
            if (value < 0L) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"routeSize\"", value));
            }
            if (value > 0xFFFFFFFFL) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"routeSize\"", value));
            }
            this.checkFieldsSet(0, 0);
            int newLimit = this.limit() + 4;
            RouteEntryFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), (int)(value & 0xFFFFFFFFL));
            this.dynamicOffsetRouteSize = this.limit();
            this.fieldsSet.set(0);
            this.limit(newLimit);
            return this;
        }

        private OctetsFW.Builder route() {
            this.checkFieldNotSet(1);
            if (!this.fieldsSet.get(0)) {
                this.routeSize(0L);
            }
            this.checkFieldsSet(0, 1);
            return this.routeRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder route(OctetsFW value) {
            OctetsFW.Builder routeRW = this.route();
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null for field \"route\" that does not default to null");
            }
            int newLimit = ((OctetsFW)routeRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetRouteSize);
            this.routeSize(size$);
            this.limit(newLimit);
            this.fieldsSet.set(1);
            return this;
        }

        public Builder route(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder routeRW = this.route();
            mutator.accept(routeRW);
            int newLimit = ((OctetsFW)routeRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetRouteSize);
            this.routeSize(size$);
            this.limit(newLimit);
            this.fieldsSet.set(1);
            return this;
        }

        public Builder route(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder routeRW = this.route();
            routeRW.set(buffer, offset, length);
            int newLimit = ((OctetsFW)routeRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetRouteSize);
            this.routeSize(size$);
            this.limit(newLimit);
            this.fieldsSet.set(1);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            this.fieldsSet.clear();
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        @Override
        public RouteEntryFW build() {
            this.checkFieldsSet(0, 2);
            this.fieldsSet.clear();
            return (RouteEntryFW)super.build();
        }

        private void checkFieldNotSet(int index) {
            if (this.fieldsSet.get(index)) {
                throw new IllegalStateException(String.format("Field \"%s\" has already been set", FIELD_NAMES[index]));
            }
        }

        private void checkFieldsSet(int fromIndex, int toIndex) {
            int fieldNotSet = fromIndex - 1;
            while ((fieldNotSet = this.fieldsSet.nextClearBit(fieldNotSet + 1)) < toIndex && FIELDS_WITH_DEFAULTS.get(fieldNotSet)) {
            }
            if (fieldNotSet < toIndex) {
                throw new IllegalStateException(String.format("Required field \"%s\" is not set", FIELD_NAMES[fieldNotSet]));
            }
        }
    }
}

