/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types.state;

import java.util.BitSet;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.ListFW;
import org.reaktivity.command.log.internal.types.state.RouteEntryFW;

public final class RouteTableFW
extends Flyweight {
    public static final int FIELD_OFFSET_WRITE_LOCK_ACQUIRES = 0;
    private static final int FIELD_SIZE_WRITE_LOCK_ACQUIRES = 4;
    public static final int FIELD_OFFSET_WRITE_LOCK_RELEASES = 4;
    private static final int FIELD_SIZE_WRITE_LOCK_RELEASES = 4;
    public static final int FIELD_OFFSET_ROUTE_ENTRIES = 8;
    private final ListFW<RouteEntryFW> routeEntriesRO = new ListFW<RouteEntryFW>(new RouteEntryFW());

    public int writeLockAcquires() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public int writeLockReleases() {
        return this.buffer().getInt(this.offset() + 4);
    }

    public ListFW<RouteEntryFW> routeEntries() {
        return this.routeEntriesRO;
    }

    @Override
    public RouteTableFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.routeEntriesRO.wrap(buffer, offset + 8, maxLimit);
        RouteTableFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.routeEntriesRO.limit();
    }

    public String toString() {
        return String.format("ROUTE_TABLE [writeLockAcquires=%d, writeLockReleases=%d, routeEntries=%s]", this.writeLockAcquires(), this.writeLockReleases(), this.routeEntries());
    }

    public static final class Builder
    extends Flyweight.Builder<RouteTableFW> {
        private static final int INDEX_WRITE_LOCK_ACQUIRES = 0;
        private static final int INDEX_WRITE_LOCK_RELEASES = 1;
        private static final int INDEX_ROUTE_ENTRIES = 2;
        private static final int FIELD_COUNT = 3;
        private static final BitSet FIELDS_WITH_DEFAULTS = new BitSet(3){
            {
                this.set(2);
            }
        };
        private static final String[] FIELD_NAMES = new String[]{"writeLockAcquires", "writeLockReleases", "routeEntries"};
        private final ListFW.Builder<RouteEntryFW.Builder, RouteEntryFW> routeEntriesRW = new ListFW.Builder<RouteEntryFW.Builder, RouteEntryFW>(new RouteEntryFW.Builder(), new RouteEntryFW());
        private final BitSet fieldsSet = new BitSet(3);

        public Builder() {
            super(new RouteTableFW());
        }

        public Builder writeLockAcquires(int value) {
            this.checkFieldNotSet(0);
            this.checkFieldsSet(0, 0);
            int newLimit = this.limit() + 4;
            RouteTableFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.fieldsSet.set(0);
            this.limit(newLimit);
            return this;
        }

        public Builder writeLockReleases(int value) {
            this.checkFieldNotSet(1);
            this.checkFieldsSet(0, 1);
            int newLimit = this.limit() + 4;
            RouteTableFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.fieldsSet.set(1);
            this.limit(newLimit);
            return this;
        }

        public Builder routeEntries(Consumer<ListFW.Builder<RouteEntryFW.Builder, RouteEntryFW>> mutator) {
            this.checkFieldNotSet(2);
            this.checkFieldsSet(0, 2);
            Flyweight.Builder routeEntriesRW = this.routeEntriesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept((ListFW.Builder<RouteEntryFW.Builder, RouteEntryFW>)routeEntriesRW);
            this.limit(((ListFW)((ListFW.Builder)routeEntriesRW).build()).limit());
            this.fieldsSet.set(2);
            return this;
        }

        public Builder routeEntriesItem(Consumer<RouteEntryFW.Builder> mutator) {
            this.checkFieldsSet(0, 2);
            if (!this.fieldsSet.get(2)) {
                Flyweight.Builder builder = this.routeEntriesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            }
            this.routeEntriesRW.item(mutator);
            this.limit(((ListFW)this.routeEntriesRW.build()).limit());
            this.fieldsSet.set(2);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            this.fieldsSet.clear();
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        @Override
        public RouteTableFW build() {
            if (!this.fieldsSet.get(2)) {
                this.routeEntries(b -> {});
            }
            this.checkFieldsSet(0, 3);
            this.fieldsSet.clear();
            return (RouteTableFW)super.build();
        }

        private void checkFieldNotSet(int index) {
            if (this.fieldsSet.get(index)) {
                throw new IllegalStateException(String.format("Field \"%s\" has already been set", FIELD_NAMES[index]));
            }
        }

        private void checkFieldsSet(int fromIndex, int toIndex) {
            int fieldNotSet = fromIndex - 1;
            while ((fieldNotSet = this.fieldsSet.nextClearBit(fieldNotSet + 1)) < toIndex && FIELDS_WITH_DEFAULTS.get(fieldNotSet)) {
            }
            if (fieldNotSet < toIndex) {
                throw new IllegalStateException(String.format("Required field \"%s\" is not set", FIELD_NAMES[fieldNotSet]));
            }
        }
    }
}

