/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types.stream;

import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.OctetsFW;
import org.reaktivity.command.log.internal.types.StringFW;

public final class BeginFW
extends Flyweight {
    public static final int FIELD_OFFSET_STREAM_ID = 0;
    private static final int FIELD_SIZE_STREAM_ID = 8;
    public static final int FIELD_OFFSET_TIMESTAMP = 8;
    private static final int FIELD_SIZE_TIMESTAMP = 8;
    public static final int FIELD_OFFSET_TRACE = 16;
    private static final int FIELD_SIZE_TRACE = 8;
    public static final int FIELD_OFFSET_AUTHORIZATION = 24;
    private static final int FIELD_SIZE_AUTHORIZATION = 8;
    public static final int FIELD_OFFSET_SOURCE = 32;
    public static final int FIELD_OFFSET_SOURCE_REF = 0;
    private static final int FIELD_SIZE_SOURCE_REF = 8;
    public static final int FIELD_OFFSET_CORRELATION_ID = 8;
    private static final int FIELD_SIZE_CORRELATION_ID = 8;
    public static final int FIELD_OFFSET_AFFINITY = 16;
    private static final int FIELD_SIZE_AFFINITY = 8;
    public static final int FIELD_OFFSET_EXTENSION = 24;
    public static final int TYPE_ID = 1;
    private final StringFW sourceRO = new StringFW();
    private final OctetsFW extensionRO = new OctetsFW();

    public long streamId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public long timestamp() {
        return this.buffer().getLong(this.offset() + 8);
    }

    public long trace() {
        return this.buffer().getLong(this.offset() + 16);
    }

    public long authorization() {
        return this.buffer().getLong(this.offset() + 24);
    }

    public StringFW source() {
        return this.sourceRO;
    }

    public long sourceRef() {
        return this.buffer().getLong(this.sourceRO.limit() + 0);
    }

    public long correlationId() {
        return this.buffer().getLong(this.sourceRO.limit() + 8);
    }

    public long affinity() {
        return this.buffer().getLong(this.sourceRO.limit() + 16);
    }

    public OctetsFW extension() {
        return this.extensionRO;
    }

    public int typeId() {
        return 1;
    }

    @Override
    public BeginFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.sourceRO.wrap(buffer, offset + 32, maxLimit);
        this.extensionRO.wrap(buffer, this.sourceRO.limit() + 24, maxLimit);
        BeginFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.extensionRO.limit();
    }

    public String toString() {
        return String.format("BEGIN [streamId=%d, timestamp=%d, trace=%d, authorization=%d, source=%s, sourceRef=%d, correlationId=%d, affinity=%d, extension=%s]", this.streamId(), this.timestamp(), this.trace(), this.authorization(), this.sourceRO.asString(), this.sourceRef(), this.correlationId(), this.affinity(), this.extension());
    }

    public static final class Builder
    extends Flyweight.Builder<BeginFW> {
        private static final int INDEX_STREAM_ID = 0;
        private static final int INDEX_TIMESTAMP = 1;
        private static final long DEFAULT_TIMESTAMP = 0L;
        private static final int INDEX_TRACE = 2;
        private static final long DEFAULT_TRACE = 0L;
        private static final int INDEX_AUTHORIZATION = 3;
        private static final long DEFAULT_AUTHORIZATION = 0L;
        private static final int INDEX_SOURCE = 4;
        private static final int INDEX_SOURCE_REF = 5;
        private static final int INDEX_CORRELATION_ID = 6;
        private static final int INDEX_AFFINITY = 7;
        private static final long DEFAULT_AFFINITY = 0L;
        private static final int INDEX_EXTENSION = 8;
        private static final int FIELD_COUNT = 9;
        private static final BitSet FIELDS_WITH_DEFAULTS = new BitSet(9){
            {
                this.set(1);
                this.set(2);
                this.set(3);
                this.set(7);
                this.set(8);
            }
        };
        private static final String[] FIELD_NAMES = new String[]{"streamId", "timestamp", "trace", "authorization", "source", "sourceRef", "correlationId", "affinity", "extension"};
        private final StringFW.Builder sourceRW = new StringFW.Builder();
        private final OctetsFW.Builder extensionRW = new OctetsFW.Builder();
        private final BitSet fieldsSet = new BitSet(9);

        public Builder() {
            super(new BeginFW());
        }

        public Builder streamId(long value) {
            this.checkFieldNotSet(0);
            this.checkFieldsSet(0, 0);
            int newLimit = this.limit() + 8;
            BeginFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(0);
            this.limit(newLimit);
            return this;
        }

        public Builder timestamp(long value) {
            this.checkFieldNotSet(1);
            this.checkFieldsSet(0, 1);
            int newLimit = this.limit() + 8;
            BeginFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(1);
            this.limit(newLimit);
            return this;
        }

        public Builder trace(long value) {
            this.checkFieldNotSet(2);
            if (!this.fieldsSet.get(1)) {
                this.timestamp(0L);
            }
            this.checkFieldsSet(0, 2);
            int newLimit = this.limit() + 8;
            BeginFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(2);
            this.limit(newLimit);
            return this;
        }

        public Builder authorization(long value) {
            this.checkFieldNotSet(3);
            if (!this.fieldsSet.get(2)) {
                this.trace(0L);
            }
            this.checkFieldsSet(0, 3);
            int newLimit = this.limit() + 8;
            BeginFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(3);
            this.limit(newLimit);
            return this;
        }

        private StringFW.Builder source() {
            this.checkFieldNotSet(4);
            if (!this.fieldsSet.get(3)) {
                this.authorization(0L);
            }
            this.checkFieldsSet(0, 4);
            return this.sourceRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder source(String value) {
            StringFW.Builder sourceRW = this.source();
            sourceRW.set(value, StandardCharsets.UTF_8);
            this.fieldsSet.set(4);
            this.limit(sourceRW.build().limit());
            return this;
        }

        public Builder source(StringFW value) {
            StringFW.Builder sourceRW = this.source();
            sourceRW.set(value);
            this.fieldsSet.set(4);
            this.limit(sourceRW.build().limit());
            return this;
        }

        public Builder source(DirectBuffer buffer, int offset, int length) {
            StringFW.Builder sourceRW = this.source();
            sourceRW.set(buffer, offset, length);
            this.fieldsSet.set(4);
            this.limit(sourceRW.build().limit());
            return this;
        }

        public Builder sourceRef(long value) {
            this.checkFieldNotSet(5);
            this.checkFieldsSet(0, 5);
            int newLimit = this.limit() + 8;
            BeginFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(5);
            this.limit(newLimit);
            return this;
        }

        public Builder correlationId(long value) {
            this.checkFieldNotSet(6);
            this.checkFieldsSet(0, 6);
            int newLimit = this.limit() + 8;
            BeginFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(6);
            this.limit(newLimit);
            return this;
        }

        public Builder affinity(long value) {
            this.checkFieldNotSet(7);
            this.checkFieldsSet(0, 7);
            int newLimit = this.limit() + 8;
            BeginFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(7);
            this.limit(newLimit);
            return this;
        }

        private OctetsFW.Builder extension() {
            this.checkFieldNotSet(8);
            if (!this.fieldsSet.get(7)) {
                this.affinity(0L);
            }
            this.checkFieldsSet(0, 8);
            return this.extensionRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder extension(OctetsFW value) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(value);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.fieldsSet.set(8);
            return this;
        }

        public Builder extension(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder extensionRW = this.extension();
            mutator.accept(extensionRW);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.fieldsSet.set(8);
            return this;
        }

        public Builder extension(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(buffer, offset, length);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.fieldsSet.set(8);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            this.fieldsSet.clear();
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        @Override
        public BeginFW build() {
            if (!this.fieldsSet.get(8)) {
                this.extension((OctetsFW.Builder b) -> {});
            }
            this.checkFieldsSet(0, 9);
            this.fieldsSet.clear();
            return (BeginFW)super.build();
        }

        private void checkFieldNotSet(int index) {
            if (this.fieldsSet.get(index)) {
                throw new IllegalStateException(String.format("Field \"%s\" has already been set", FIELD_NAMES[index]));
            }
        }

        private void checkFieldsSet(int fromIndex, int toIndex) {
            int fieldNotSet = fromIndex - 1;
            while ((fieldNotSet = this.fieldsSet.nextClearBit(fieldNotSet + 1)) < toIndex && FIELDS_WITH_DEFAULTS.get(fieldNotSet)) {
            }
            if (fieldNotSet < toIndex) {
                throw new IllegalStateException(String.format("Required field \"%s\" is not set", FIELD_NAMES[fieldNotSet]));
            }
        }
    }
}

