/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types.stream;

import java.util.BitSet;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.OctetsFW;

public final class DataFW
extends Flyweight {
    public static final int FIELD_OFFSET_STREAM_ID = 0;
    private static final int FIELD_SIZE_STREAM_ID = 8;
    public static final int FIELD_OFFSET_TIMESTAMP = 8;
    private static final int FIELD_SIZE_TIMESTAMP = 8;
    public static final int FIELD_OFFSET_TRACE = 16;
    private static final int FIELD_SIZE_TRACE = 8;
    public static final int FIELD_OFFSET_AUTHORIZATION = 24;
    private static final int FIELD_SIZE_AUTHORIZATION = 8;
    public static final int FIELD_OFFSET_FLAGS = 32;
    private static final int FIELD_SIZE_FLAGS = 1;
    public static final int FIELD_OFFSET_GROUP_ID = 33;
    private static final int FIELD_SIZE_GROUP_ID = 8;
    public static final int FIELD_OFFSET_PADDING = 41;
    private static final int FIELD_SIZE_PADDING = 4;
    public static final int FIELD_OFFSET_LENGTH = 45;
    private static final int FIELD_SIZE_LENGTH = 4;
    public static final int FIELD_OFFSET_PAYLOAD = 49;
    public static final int FIELD_OFFSET_EXTENSION = 0;
    public static final int TYPE_ID = 2;
    private OctetsFW payloadRO = new OctetsFW();
    private final OctetsFW extensionRO = new OctetsFW();

    public long streamId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public long timestamp() {
        return this.buffer().getLong(this.offset() + 8);
    }

    public long trace() {
        return this.buffer().getLong(this.offset() + 16);
    }

    public long authorization() {
        return this.buffer().getLong(this.offset() + 24);
    }

    public int flags() {
        return this.buffer().getByte(this.offset() + 32) & 0xFF;
    }

    public long groupId() {
        return this.buffer().getLong(this.offset() + 33);
    }

    public int padding() {
        return this.buffer().getInt(this.offset() + 41);
    }

    public int length() {
        return this.buffer().getInt(this.offset() + 45);
    }

    public OctetsFW payload() {
        return this.length() == -1 ? null : this.payloadRO;
    }

    public OctetsFW extension() {
        return this.extensionRO;
    }

    public int typeId() {
        return 2;
    }

    @Override
    public DataFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.payloadRO.wrap(buffer, offset + 49, offset + 49 + (this.length() == -1 ? 0 : this.length()));
        this.extensionRO.wrap(buffer, this.payloadRO.limit() + 0, maxLimit);
        DataFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.extensionRO.limit();
    }

    public String toString() {
        return String.format("DATA [streamId=%d, timestamp=%d, trace=%d, authorization=%d, flags=%d, groupId=%d, padding=%d, length=%d, payload=%s, extension=%s]", this.streamId(), this.timestamp(), this.trace(), this.authorization(), this.flags(), this.groupId(), this.padding(), this.length(), this.payload(), this.extension());
    }

    public static final class Builder
    extends Flyweight.Builder<DataFW> {
        private static final int INDEX_STREAM_ID = 0;
        private static final int INDEX_TIMESTAMP = 1;
        private static final long DEFAULT_TIMESTAMP = 0L;
        private static final int INDEX_TRACE = 2;
        private static final long DEFAULT_TRACE = 0L;
        private static final int INDEX_AUTHORIZATION = 3;
        private static final long DEFAULT_AUTHORIZATION = 0L;
        private static final int INDEX_FLAGS = 4;
        private static final int DEFAULT_FLAGS = 3;
        private static final int INDEX_GROUP_ID = 5;
        private static final int INDEX_PADDING = 6;
        private static final int INDEX_LENGTH = 7;
        private static final int DEFAULT_LENGTH = 0;
        private static final int INDEX_PAYLOAD = 8;
        private static final int INDEX_EXTENSION = 9;
        private static final int FIELD_COUNT = 10;
        private static final BitSet FIELDS_WITH_DEFAULTS = new BitSet(10){
            {
                this.set(1);
                this.set(2);
                this.set(3);
                this.set(4);
                this.set(7);
                this.set(9);
            }
        };
        private static final String[] FIELD_NAMES = new String[]{"streamId", "timestamp", "trace", "authorization", "flags", "groupId", "padding", "length", "payload", "extension"};
        private int dynamicOffsetLength;
        private final OctetsFW.Builder payloadRW = new OctetsFW.Builder();
        private final OctetsFW.Builder extensionRW = new OctetsFW.Builder();
        private final BitSet fieldsSet = new BitSet(10);

        public Builder() {
            super(new DataFW());
        }

        public Builder streamId(long value) {
            this.checkFieldNotSet(0);
            this.checkFieldsSet(0, 0);
            int newLimit = this.limit() + 8;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(0);
            this.limit(newLimit);
            return this;
        }

        public Builder timestamp(long value) {
            this.checkFieldNotSet(1);
            this.checkFieldsSet(0, 1);
            int newLimit = this.limit() + 8;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(1);
            this.limit(newLimit);
            return this;
        }

        public Builder trace(long value) {
            this.checkFieldNotSet(2);
            if (!this.fieldsSet.get(1)) {
                this.timestamp(0L);
            }
            this.checkFieldsSet(0, 2);
            int newLimit = this.limit() + 8;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(2);
            this.limit(newLimit);
            return this;
        }

        public Builder authorization(long value) {
            this.checkFieldNotSet(3);
            if (!this.fieldsSet.get(2)) {
                this.trace(0L);
            }
            this.checkFieldsSet(0, 3);
            int newLimit = this.limit() + 8;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(3);
            this.limit(newLimit);
            return this;
        }

        public Builder flags(int value) {
            this.checkFieldNotSet(4);
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"flags\"", value));
            }
            if (value > 255) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"flags\"", value));
            }
            if (!this.fieldsSet.get(3)) {
                this.authorization(0L);
            }
            this.checkFieldsSet(0, 4);
            int newLimit = this.limit() + 1;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(this.limit(), (byte)(value & 0xFF));
            this.fieldsSet.set(4);
            this.limit(newLimit);
            return this;
        }

        public Builder groupId(long value) {
            this.checkFieldNotSet(5);
            if (!this.fieldsSet.get(4)) {
                this.flags(3);
            }
            this.checkFieldsSet(0, 5);
            int newLimit = this.limit() + 8;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(5);
            this.limit(newLimit);
            return this;
        }

        public Builder padding(int value) {
            this.checkFieldNotSet(6);
            this.checkFieldsSet(0, 6);
            int newLimit = this.limit() + 4;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.fieldsSet.set(6);
            this.limit(newLimit);
            return this;
        }

        private Builder length(int value) {
            this.checkFieldsSet(0, 7);
            int newLimit = this.limit() + 4;
            DataFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.dynamicOffsetLength = this.limit();
            this.fieldsSet.set(7);
            this.limit(newLimit);
            return this;
        }

        private OctetsFW.Builder payload() {
            this.checkFieldNotSet(8);
            if (!this.fieldsSet.get(7)) {
                this.length(0);
            }
            this.checkFieldsSet(0, 8);
            return this.payloadRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder payload(OctetsFW value) {
            int newLimit;
            int size$;
            OctetsFW.Builder payloadRW = this.payload();
            if (value == null) {
                size$ = -1;
                newLimit = this.limit();
            } else {
                payloadRW.set(value);
                newLimit = ((OctetsFW)payloadRW.build()).limit();
                size$ = newLimit - this.limit();
            }
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.fieldsSet.set(8);
            return this;
        }

        public Builder payload(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder payloadRW = this.payload();
            mutator.accept(payloadRW);
            int newLimit = ((OctetsFW)payloadRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.fieldsSet.set(8);
            return this;
        }

        public Builder payload(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder payloadRW = this.payload();
            payloadRW.set(buffer, offset, length);
            int newLimit = ((OctetsFW)payloadRW.build()).limit();
            int size$ = newLimit - this.limit();
            this.limit(this.dynamicOffsetLength);
            this.length(size$);
            this.limit(newLimit);
            this.fieldsSet.set(8);
            return this;
        }

        private OctetsFW.Builder extension() {
            this.checkFieldNotSet(9);
            if (!this.fieldsSet.get(8)) {
                this.payload((OctetsFW.Builder b) -> {});
                int limit = this.limit();
                this.limit(this.dynamicOffsetLength);
                this.length(-1);
                this.limit(limit);
            }
            this.checkFieldsSet(0, 9);
            return this.extensionRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder extension(OctetsFW value) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(value);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.fieldsSet.set(9);
            return this;
        }

        public Builder extension(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder extensionRW = this.extension();
            mutator.accept(extensionRW);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.fieldsSet.set(9);
            return this;
        }

        public Builder extension(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(buffer, offset, length);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.fieldsSet.set(9);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            this.fieldsSet.clear();
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        @Override
        public DataFW build() {
            if (!this.fieldsSet.get(9)) {
                this.extension((OctetsFW.Builder b) -> {});
            }
            this.checkFieldsSet(0, 10);
            this.fieldsSet.clear();
            return (DataFW)super.build();
        }

        private void checkFieldNotSet(int index) {
            if (this.fieldsSet.get(index)) {
                throw new IllegalStateException(String.format("Field \"%s\" has already been set", FIELD_NAMES[index]));
            }
        }

        private void checkFieldsSet(int fromIndex, int toIndex) {
            int fieldNotSet = fromIndex - 1;
            while ((fieldNotSet = this.fieldsSet.nextClearBit(fieldNotSet + 1)) < toIndex && FIELDS_WITH_DEFAULTS.get(fieldNotSet)) {
            }
            if (fieldNotSet < toIndex) {
                throw new IllegalStateException(String.format("Required field \"%s\" is not set", FIELD_NAMES[fieldNotSet]));
            }
        }
    }
}

