/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types.stream;

import java.util.BitSet;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;

public final class FrameFW
extends Flyweight {
    public static final int FIELD_OFFSET_STREAM_ID = 0;
    private static final int FIELD_SIZE_STREAM_ID = 8;
    public static final int FIELD_OFFSET_TIMESTAMP = 8;
    private static final int FIELD_SIZE_TIMESTAMP = 8;
    public static final int FIELD_OFFSET_TRACE = 16;
    private static final int FIELD_SIZE_TRACE = 8;

    public long streamId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public long timestamp() {
        return this.buffer().getLong(this.offset() + 8);
    }

    public long trace() {
        return this.buffer().getLong(this.offset() + 16);
    }

    @Override
    public FrameFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        FrameFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 16 + 8;
    }

    public String toString() {
        return String.format("FRAME [streamId=%d, timestamp=%d, trace=%d]", this.streamId(), this.timestamp(), this.trace());
    }

    public static final class Builder
    extends Flyweight.Builder<FrameFW> {
        private static final int INDEX_STREAM_ID = 0;
        private static final int INDEX_TIMESTAMP = 1;
        private static final long DEFAULT_TIMESTAMP = 0L;
        private static final int INDEX_TRACE = 2;
        private static final long DEFAULT_TRACE = 0L;
        private static final int FIELD_COUNT = 3;
        private static final BitSet FIELDS_WITH_DEFAULTS = new BitSet(3){
            {
                this.set(1);
                this.set(2);
            }
        };
        private static final String[] FIELD_NAMES = new String[]{"streamId", "timestamp", "trace"};
        private final BitSet fieldsSet = new BitSet(3);

        public Builder() {
            super(new FrameFW());
        }

        public Builder streamId(long value) {
            this.checkFieldNotSet(0);
            this.checkFieldsSet(0, 0);
            int newLimit = this.limit() + 8;
            FrameFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(0);
            this.limit(newLimit);
            return this;
        }

        public Builder timestamp(long value) {
            this.checkFieldNotSet(1);
            this.checkFieldsSet(0, 1);
            int newLimit = this.limit() + 8;
            FrameFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(1);
            this.limit(newLimit);
            return this;
        }

        public Builder trace(long value) {
            this.checkFieldNotSet(2);
            if (!this.fieldsSet.get(1)) {
                this.timestamp(0L);
            }
            this.checkFieldsSet(0, 2);
            int newLimit = this.limit() + 8;
            FrameFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(2);
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            this.fieldsSet.clear();
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        @Override
        public FrameFW build() {
            if (!this.fieldsSet.get(2)) {
                this.trace(0L);
            }
            this.checkFieldsSet(0, 3);
            this.fieldsSet.clear();
            return (FrameFW)super.build();
        }

        private void checkFieldNotSet(int index) {
            if (this.fieldsSet.get(index)) {
                throw new IllegalStateException(String.format("Field \"%s\" has already been set", FIELD_NAMES[index]));
            }
        }

        private void checkFieldsSet(int fromIndex, int toIndex) {
            int fieldNotSet = fromIndex - 1;
            while ((fieldNotSet = this.fieldsSet.nextClearBit(fieldNotSet + 1)) < toIndex && FIELDS_WITH_DEFAULTS.get(fieldNotSet)) {
            }
            if (fieldNotSet < toIndex) {
                throw new IllegalStateException(String.format("Required field \"%s\" is not set", FIELD_NAMES[fieldNotSet]));
            }
        }
    }
}

