/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types.stream;

import java.util.BitSet;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.OctetsFW;

public final class ResetFW
extends Flyweight {
    public static final int FIELD_OFFSET_STREAM_ID = 0;
    private static final int FIELD_SIZE_STREAM_ID = 8;
    public static final int FIELD_OFFSET_TIMESTAMP = 8;
    private static final int FIELD_SIZE_TIMESTAMP = 8;
    public static final int FIELD_OFFSET_TRACE = 16;
    private static final int FIELD_SIZE_TRACE = 8;
    public static final int FIELD_OFFSET_EXTENSION = 24;
    public static final int TYPE_ID = 0x40000001;
    private final OctetsFW extensionRO = new OctetsFW();

    public long streamId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public long timestamp() {
        return this.buffer().getLong(this.offset() + 8);
    }

    public long trace() {
        return this.buffer().getLong(this.offset() + 16);
    }

    public OctetsFW extension() {
        return this.extensionRO;
    }

    public int typeId() {
        return 0x40000001;
    }

    @Override
    public ResetFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.extensionRO.wrap(buffer, offset + 24, maxLimit);
        ResetFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.extensionRO.limit();
    }

    public String toString() {
        return String.format("RESET [streamId=%d, timestamp=%d, trace=%d, extension=%s]", this.streamId(), this.timestamp(), this.trace(), this.extension());
    }

    public static final class Builder
    extends Flyweight.Builder<ResetFW> {
        private static final int INDEX_STREAM_ID = 0;
        private static final int INDEX_TIMESTAMP = 1;
        private static final long DEFAULT_TIMESTAMP = 0L;
        private static final int INDEX_TRACE = 2;
        private static final long DEFAULT_TRACE = 0L;
        private static final int INDEX_EXTENSION = 3;
        private static final int FIELD_COUNT = 4;
        private static final BitSet FIELDS_WITH_DEFAULTS = new BitSet(4){
            {
                this.set(1);
                this.set(2);
                this.set(3);
            }
        };
        private static final String[] FIELD_NAMES = new String[]{"streamId", "timestamp", "trace", "extension"};
        private final OctetsFW.Builder extensionRW = new OctetsFW.Builder();
        private final BitSet fieldsSet = new BitSet(4);

        public Builder() {
            super(new ResetFW());
        }

        public Builder streamId(long value) {
            this.checkFieldNotSet(0);
            this.checkFieldsSet(0, 0);
            int newLimit = this.limit() + 8;
            ResetFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(0);
            this.limit(newLimit);
            return this;
        }

        public Builder timestamp(long value) {
            this.checkFieldNotSet(1);
            this.checkFieldsSet(0, 1);
            int newLimit = this.limit() + 8;
            ResetFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(1);
            this.limit(newLimit);
            return this;
        }

        public Builder trace(long value) {
            this.checkFieldNotSet(2);
            if (!this.fieldsSet.get(1)) {
                this.timestamp(0L);
            }
            this.checkFieldsSet(0, 2);
            int newLimit = this.limit() + 8;
            ResetFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(2);
            this.limit(newLimit);
            return this;
        }

        private OctetsFW.Builder extension() {
            this.checkFieldNotSet(3);
            if (!this.fieldsSet.get(2)) {
                this.trace(0L);
            }
            this.checkFieldsSet(0, 3);
            return this.extensionRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder extension(OctetsFW value) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(value);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.fieldsSet.set(3);
            return this;
        }

        public Builder extension(Consumer<OctetsFW.Builder> mutator) {
            OctetsFW.Builder extensionRW = this.extension();
            mutator.accept(extensionRW);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.fieldsSet.set(3);
            return this;
        }

        public Builder extension(DirectBuffer buffer, int offset, int length) {
            OctetsFW.Builder extensionRW = this.extension();
            extensionRW.set(buffer, offset, length);
            this.limit(((OctetsFW)extensionRW.build()).limit());
            this.fieldsSet.set(3);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            this.fieldsSet.clear();
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        @Override
        public ResetFW build() {
            if (!this.fieldsSet.get(3)) {
                this.extension((OctetsFW.Builder b) -> {});
            }
            this.checkFieldsSet(0, 4);
            this.fieldsSet.clear();
            return (ResetFW)super.build();
        }

        private void checkFieldNotSet(int index) {
            if (this.fieldsSet.get(index)) {
                throw new IllegalStateException(String.format("Field \"%s\" has already been set", FIELD_NAMES[index]));
            }
        }

        private void checkFieldsSet(int fromIndex, int toIndex) {
            int fieldNotSet = fromIndex - 1;
            while ((fieldNotSet = this.fieldsSet.nextClearBit(fieldNotSet + 1)) < toIndex && FIELDS_WITH_DEFAULTS.get(fieldNotSet)) {
            }
            if (fieldNotSet < toIndex) {
                throw new IllegalStateException(String.format("Required field \"%s\" is not set", FIELD_NAMES[fieldNotSet]));
            }
        }
    }
}

