/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types.stream;

import java.util.BitSet;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.TcpAddressFW;

public final class TcpBeginExFW
extends Flyweight {
    public static final int FIELD_OFFSET_LOCAL_ADDRESS = 0;
    public static final int FIELD_OFFSET_LOCAL_PORT = 0;
    private static final int FIELD_SIZE_LOCAL_PORT = 2;
    public static final int FIELD_OFFSET_REMOTE_ADDRESS = 2;
    public static final int FIELD_OFFSET_REMOTE_PORT = 0;
    private static final int FIELD_SIZE_REMOTE_PORT = 2;
    private final TcpAddressFW localAddressRO = new TcpAddressFW();
    private final TcpAddressFW remoteAddressRO = new TcpAddressFW();

    public TcpAddressFW localAddress() {
        return this.localAddressRO;
    }

    public int localPort() {
        return this.buffer().getShort(this.localAddressRO.limit() + 0) & 0xFFFF;
    }

    public TcpAddressFW remoteAddress() {
        return this.remoteAddressRO;
    }

    public int remotePort() {
        return this.buffer().getShort(this.remoteAddressRO.limit() + 0) & 0xFFFF;
    }

    @Override
    public TcpBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.localAddressRO.wrap(buffer, offset + 0, maxLimit);
        this.remoteAddressRO.wrap(buffer, this.localAddressRO.limit() + 2, maxLimit);
        TcpBeginExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.remoteAddressRO.limit() + 0 + 2;
    }

    public String toString() {
        return String.format("TCP_BEGIN_EX [localAddress=%s, localPort=%d, remoteAddress=%s, remotePort=%d]", this.localAddress(), this.localPort(), this.remoteAddress(), this.remotePort());
    }

    public static final class Builder
    extends Flyweight.Builder<TcpBeginExFW> {
        private static final int INDEX_LOCAL_ADDRESS = 0;
        private static final int INDEX_LOCAL_PORT = 1;
        private static final int INDEX_REMOTE_ADDRESS = 2;
        private static final int INDEX_REMOTE_PORT = 3;
        private static final int FIELD_COUNT = 4;
        private static final BitSet FIELDS_WITH_DEFAULTS = new BitSet(4){
            {
                this.set(0);
                this.set(2);
            }
        };
        private static final String[] FIELD_NAMES = new String[]{"localAddress", "localPort", "remoteAddress", "remotePort"};
        private final TcpAddressFW.Builder localAddressRW = new TcpAddressFW.Builder();
        private final TcpAddressFW.Builder remoteAddressRW = new TcpAddressFW.Builder();
        private final BitSet fieldsSet = new BitSet(4);

        public Builder() {
            super(new TcpBeginExFW());
        }

        public Builder localAddress(Consumer<TcpAddressFW.Builder> mutator) {
            this.checkFieldNotSet(0);
            this.checkFieldsSet(0, 0);
            TcpAddressFW.Builder localAddressRW = this.localAddressRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(localAddressRW);
            this.limit(((TcpAddressFW)localAddressRW.build()).limit());
            this.fieldsSet.set(0);
            return this;
        }

        public Builder localPort(int value) {
            this.checkFieldNotSet(1);
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"localPort\"", value));
            }
            if (value > 65535) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"localPort\"", value));
            }
            if (!this.fieldsSet.get(0)) {
                this.localAddress(b -> {});
            }
            this.checkFieldsSet(0, 1);
            int newLimit = this.limit() + 2;
            TcpBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putShort(this.limit(), (short)(value & 0xFFFF));
            this.fieldsSet.set(1);
            this.limit(newLimit);
            return this;
        }

        public Builder remoteAddress(Consumer<TcpAddressFW.Builder> mutator) {
            this.checkFieldNotSet(2);
            this.checkFieldsSet(0, 2);
            TcpAddressFW.Builder remoteAddressRW = this.remoteAddressRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(remoteAddressRW);
            this.limit(((TcpAddressFW)remoteAddressRW.build()).limit());
            this.fieldsSet.set(2);
            return this;
        }

        public Builder remotePort(int value) {
            this.checkFieldNotSet(3);
            if (value < 0) {
                throw new IllegalArgumentException(String.format("Value %d too low for field \"remotePort\"", value));
            }
            if (value > 65535) {
                throw new IllegalArgumentException(String.format("Value %d too high for field \"remotePort\"", value));
            }
            if (!this.fieldsSet.get(2)) {
                this.remoteAddress(b -> {});
            }
            this.checkFieldsSet(0, 3);
            int newLimit = this.limit() + 2;
            TcpBeginExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putShort(this.limit(), (short)(value & 0xFFFF));
            this.fieldsSet.set(3);
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            this.fieldsSet.clear();
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        @Override
        public TcpBeginExFW build() {
            this.checkFieldsSet(0, 4);
            this.fieldsSet.clear();
            return (TcpBeginExFW)super.build();
        }

        private void checkFieldNotSet(int index) {
            if (this.fieldsSet.get(index)) {
                throw new IllegalStateException(String.format("Field \"%s\" has already been set", FIELD_NAMES[index]));
            }
        }

        private void checkFieldsSet(int fromIndex, int toIndex) {
            int fieldNotSet = fromIndex - 1;
            while ((fieldNotSet = this.fieldsSet.nextClearBit(fieldNotSet + 1)) < toIndex && FIELDS_WITH_DEFAULTS.get(fieldNotSet)) {
            }
            if (fieldNotSet < toIndex) {
                throw new IllegalStateException(String.format("Required field \"%s\" is not set", FIELD_NAMES[fieldNotSet]));
            }
        }
    }
}

