/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal.types.stream;

import java.util.BitSet;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;

public final class WindowFW
extends Flyweight {
    public static final int FIELD_OFFSET_STREAM_ID = 0;
    private static final int FIELD_SIZE_STREAM_ID = 8;
    public static final int FIELD_OFFSET_TIMESTAMP = 8;
    private static final int FIELD_SIZE_TIMESTAMP = 8;
    public static final int FIELD_OFFSET_TRACE = 16;
    private static final int FIELD_SIZE_TRACE = 8;
    public static final int FIELD_OFFSET_CREDIT = 24;
    private static final int FIELD_SIZE_CREDIT = 4;
    public static final int FIELD_OFFSET_PADDING = 28;
    private static final int FIELD_SIZE_PADDING = 4;
    public static final int FIELD_OFFSET_GROUP_ID = 32;
    private static final int FIELD_SIZE_GROUP_ID = 8;
    public static final int TYPE_ID = 0x40000002;

    public long streamId() {
        return this.buffer().getLong(this.offset() + 0);
    }

    public long timestamp() {
        return this.buffer().getLong(this.offset() + 8);
    }

    public long trace() {
        return this.buffer().getLong(this.offset() + 16);
    }

    public int credit() {
        return this.buffer().getInt(this.offset() + 24);
    }

    public int padding() {
        return this.buffer().getInt(this.offset() + 28);
    }

    public long groupId() {
        return this.buffer().getLong(this.offset() + 32);
    }

    public int typeId() {
        return 0x40000002;
    }

    @Override
    public WindowFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        WindowFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 32 + 8;
    }

    public String toString() {
        return String.format("WINDOW [streamId=%d, timestamp=%d, trace=%d, credit=%d, padding=%d, groupId=%d]", this.streamId(), this.timestamp(), this.trace(), this.credit(), this.padding(), this.groupId());
    }

    public static final class Builder
    extends Flyweight.Builder<WindowFW> {
        private static final int INDEX_STREAM_ID = 0;
        private static final int INDEX_TIMESTAMP = 1;
        private static final long DEFAULT_TIMESTAMP = 0L;
        private static final int INDEX_TRACE = 2;
        private static final long DEFAULT_TRACE = 0L;
        private static final int INDEX_CREDIT = 3;
        private static final int INDEX_PADDING = 4;
        private static final int INDEX_GROUP_ID = 5;
        private static final int FIELD_COUNT = 6;
        private static final BitSet FIELDS_WITH_DEFAULTS = new BitSet(6){
            {
                this.set(1);
                this.set(2);
            }
        };
        private static final String[] FIELD_NAMES = new String[]{"streamId", "timestamp", "trace", "credit", "padding", "groupId"};
        private final BitSet fieldsSet = new BitSet(6);

        public Builder() {
            super(new WindowFW());
        }

        public Builder streamId(long value) {
            this.checkFieldNotSet(0);
            this.checkFieldsSet(0, 0);
            int newLimit = this.limit() + 8;
            WindowFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(0);
            this.limit(newLimit);
            return this;
        }

        public Builder timestamp(long value) {
            this.checkFieldNotSet(1);
            this.checkFieldsSet(0, 1);
            int newLimit = this.limit() + 8;
            WindowFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(1);
            this.limit(newLimit);
            return this;
        }

        public Builder trace(long value) {
            this.checkFieldNotSet(2);
            if (!this.fieldsSet.get(1)) {
                this.timestamp(0L);
            }
            this.checkFieldsSet(0, 2);
            int newLimit = this.limit() + 8;
            WindowFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(2);
            this.limit(newLimit);
            return this;
        }

        public Builder credit(int value) {
            this.checkFieldNotSet(3);
            if (!this.fieldsSet.get(2)) {
                this.trace(0L);
            }
            this.checkFieldsSet(0, 3);
            int newLimit = this.limit() + 4;
            WindowFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.fieldsSet.set(3);
            this.limit(newLimit);
            return this;
        }

        public Builder padding(int value) {
            this.checkFieldNotSet(4);
            this.checkFieldsSet(0, 4);
            int newLimit = this.limit() + 4;
            WindowFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.fieldsSet.set(4);
            this.limit(newLimit);
            return this;
        }

        public Builder groupId(long value) {
            this.checkFieldNotSet(5);
            this.checkFieldsSet(0, 5);
            int newLimit = this.limit() + 8;
            WindowFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putLong(this.limit(), value);
            this.fieldsSet.set(5);
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            this.fieldsSet.clear();
            super.wrap(buffer, offset, maxLimit);
            this.limit(offset);
            return this;
        }

        @Override
        public WindowFW build() {
            this.checkFieldsSet(0, 6);
            this.fieldsSet.clear();
            return (WindowFW)super.build();
        }

        private void checkFieldNotSet(int index) {
            if (this.fieldsSet.get(index)) {
                throw new IllegalStateException(String.format("Field \"%s\" has already been set", FIELD_NAMES[index]));
            }
        }

        private void checkFieldsSet(int fromIndex, int toIndex) {
            int fieldNotSet = fromIndex - 1;
            while ((fieldNotSet = this.fieldsSet.nextClearBit(fieldNotSet + 1)) < toIndex && FIELDS_WITH_DEFAULTS.get(fieldNotSet)) {
            }
            if (fieldNotSet < toIndex) {
                throw new IllegalStateException(String.format("Required field \"%s\" is not set", FIELD_NAMES[fieldNotSet]));
            }
        }
    }
}

