/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public class Configuration {
    @Deprecated
    public static final String DIRECTORY_PROPERTY_NAME = "reaktor.directory";
    @Deprecated
    public static final String MAXIMUM_STREAMS_COUNT_PROPERTY_NAME = "reaktor.maximum.streams.count";
    @Deprecated
    public static final String STREAMS_BUFFER_CAPACITY_PROPERTY_NAME = "reaktor.streams.buffer.capacity";
    @Deprecated
    public static final String THROTTLE_BUFFER_CAPACITY_PROPERTY_NAME = "reaktor.throttle.buffer.capacity";
    @Deprecated
    public static final String COMMAND_BUFFER_CAPACITY_PROPERTY_NAME = "reaktor.command.buffer.capacity";
    @Deprecated
    public static final String RESPONSE_BUFFER_CAPACITY_PROPERTY_NAME = "reaktor.response.buffer.capacity";
    @Deprecated
    public static final String COUNTERS_BUFFER_CAPACITY_PROPERTY_NAME = "reaktor.counters.buffer.capacity";
    @Deprecated
    public static final int MAXIMUM_STREAMS_COUNT_DEFAULT = 16384;
    @Deprecated
    public static final int STREAMS_BUFFER_CAPACITY_DEFAULT = 0x100000;
    @Deprecated
    public static final int THROTTLE_BUFFER_CAPACITY_DEFAULT = 65536;
    @Deprecated
    public static final int COMMAND_BUFFER_CAPACITY_DEFAULT = 0x100000;
    @Deprecated
    public static final int RESPONSE_BUFFER_CAPACITY_DEFAULT = 0x100000;
    @Deprecated
    public static final int COUNTERS_BUFFER_CAPACITY_DEFAULT = 0x100000;
    private final BiFunction<String, String, String> getProperty;
    private final BiFunction<String, String, String> getPropertyDefault;

    public Configuration() {
        this.getProperty = System::getProperty;
        this.getPropertyDefault = (p, d) -> d;
    }

    public Configuration(Properties properties) {
        Objects.requireNonNull(properties, "properties");
        this.getProperty = properties::getProperty;
        this.getPropertyDefault = (p, d) -> d;
    }

    protected Configuration(Configuration config) {
        this.getProperty = config.getProperty;
        this.getPropertyDefault = config.getPropertyDefault;
    }

    protected Configuration(Configuration config, Properties defaultOverrides) {
        this.getProperty = config.getProperty;
        this.getPropertyDefault = defaultOverrides::getProperty;
    }

    @Deprecated
    public Path directory() {
        return Paths.get(this.getProperty(DIRECTORY_PROPERTY_NAME, "."), new String[0]);
    }

    @Deprecated
    public int maximumStreamsCount() {
        return this.getInteger(MAXIMUM_STREAMS_COUNT_PROPERTY_NAME, 16384);
    }

    @Deprecated
    public int streamsBufferCapacity() {
        return this.getInteger(STREAMS_BUFFER_CAPACITY_PROPERTY_NAME, 0x100000);
    }

    @Deprecated
    public int throttleBufferCapacity() {
        return this.getInteger(THROTTLE_BUFFER_CAPACITY_PROPERTY_NAME, 65536);
    }

    @Deprecated
    public int commandBufferCapacity() {
        return this.getInteger(COMMAND_BUFFER_CAPACITY_PROPERTY_NAME, 0x100000);
    }

    @Deprecated
    public int responseBufferCapacity() {
        return this.getInteger(RESPONSE_BUFFER_CAPACITY_PROPERTY_NAME, 0x100000);
    }

    @Deprecated
    public int counterValuesBufferCapacity() {
        return this.getInteger(COUNTERS_BUFFER_CAPACITY_PROPERTY_NAME, 0x100000);
    }

    @Deprecated
    public int counterLabelsBufferCapacity() {
        return this.getInteger(COUNTERS_BUFFER_CAPACITY_PROPERTY_NAME, 0x100000) * 2;
    }

    protected final int getInteger(String key, int defaultValue) {
        String value = this.getProperty(key, (String)null);
        if (value == null) {
            return defaultValue;
        }
        return Integer.decode(value);
    }

    protected final long getLong(String key, long defaultValue) {
        String value = this.getProperty(key, (String)null);
        if (value == null) {
            return defaultValue;
        }
        return Long.decode(value);
    }

    protected final boolean getBoolean(String key, boolean defaultValue) {
        String value = this.getProperty(key, (String)null);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    protected final String getProperty(String key, Supplier<String> defaultValue) {
        String value = this.getProperty(key, (String)null);
        if (value == null) {
            return defaultValue.get();
        }
        return value;
    }

    protected final int getInteger(String key, IntSupplier defaultValue) {
        String value = this.getProperty(key, (String)null);
        if (value == null) {
            return defaultValue.getAsInt();
        }
        return Integer.decode(value);
    }

    protected final long getLong(String key, LongSupplier defaultValue) {
        String value = this.getProperty(key, (String)null);
        if (value == null) {
            return defaultValue.getAsLong();
        }
        return Long.decode(value);
    }

    protected final boolean getBoolean(String key, BooleanSupplier defaultValue) {
        String value = this.getProperty(key, (String)null);
        if (value == null) {
            return defaultValue.getAsBoolean();
        }
        return Boolean.valueOf(value);
    }

    protected String getProperty(String key, String defaultValue) {
        return this.getProperty.apply(key, this.getPropertyDefault.apply(key, defaultValue));
    }
}

