/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus;

import org.agrona.collections.ArrayUtil;

@FunctionalInterface
public interface Nukleus
extends AutoCloseable {
    public int process();

    @Override
    default public void close() throws Exception {
    }

    default public String name() {
        return null;
    }

    public static class Composite
    implements Nukleus {
        private Nukleus[] nuklei;

        protected Composite(Nukleus ... nuklei) {
            this.nuklei = nuklei;
        }

        @Override
        public int process() {
            int weight = 0;
            for (int i = 0; i < this.nuklei.length; ++i) {
                weight += this.nuklei[i].process();
            }
            return weight;
        }

        @Override
        public void close() throws Exception {
            Exception deferred = null;
            for (int i = 0; i < this.nuklei.length; ++i) {
                try {
                    this.nuklei[i].close();
                    continue;
                }
                catch (Exception ex) {
                    if (deferred == null) {
                        deferred = ex;
                        continue;
                    }
                    deferred.addSuppressed(ex);
                }
            }
            if (deferred != null) {
                throw deferred;
            }
        }

        public final String toString() {
            StringBuilder builder = new StringBuilder();
            this.deepToString(0, builder);
            return builder.toString();
        }

        protected void toString(StringBuilder builder) {
            builder.append(this.name());
        }

        protected final void deepToString(int level, StringBuilder builder) {
            this.toString(builder);
            if (this.nuklei.length != 0) {
                int nextLevel = level + 1;
                for (int i = 0; i < this.nuklei.length; ++i) {
                    builder.append('\n');
                    for (int j = 0; j < nextLevel; ++j) {
                        builder.append("  ");
                    }
                    Nukleus nukleus = this.nuklei[i];
                    if (nukleus instanceof Composite) {
                        ((Composite)nukleus).deepToString(nextLevel, builder);
                        continue;
                    }
                    builder.append(nukleus.toString());
                }
            }
        }

        protected final <T extends Nukleus> T include(T nukleus) {
            this.nuklei = ArrayUtil.add(this.nuklei, nukleus);
            return nukleus;
        }

        protected final <T extends Nukleus> T exclude(T nukleus) {
            this.nuklei = ArrayUtil.remove(this.nuklei, nukleus);
            return nukleus;
        }
    }
}

