/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.nukleus;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import org.reaktivity.nukleus.Configuration;
import org.reaktivity.nukleus.Nukleus;
import org.reaktivity.nukleus.NukleusBuilder;
import org.reaktivity.nukleus.NukleusFactorySpi;

public final class NukleusFactory {
    private final Map<String, NukleusFactorySpi> factorySpisByName;

    public static NukleusFactory instantiate() {
        return NukleusFactory.instantiate(ServiceLoader.load(NukleusFactorySpi.class));
    }

    public static NukleusFactory instantiate(ClassLoader classLoader) {
        return NukleusFactory.instantiate(ServiceLoader.load(NukleusFactorySpi.class, classLoader));
    }

    public Iterable<String> names() {
        return this.factorySpisByName.keySet();
    }

    public Nukleus create(String name, Configuration config, NukleusBuilder builder) {
        Objects.requireNonNull(name, "name");
        NukleusFactorySpi factorySpi = this.resolveFactory(name);
        return factorySpi.create(config, builder);
    }

    private NukleusFactorySpi resolveFactory(String name) {
        NukleusFactorySpi factorySpi = this.factorySpisByName.get(name);
        if (factorySpi == null) {
            throw new IllegalArgumentException("Unregonized nukleus name: " + name);
        }
        return factorySpi;
    }

    private static NukleusFactory instantiate(ServiceLoader<NukleusFactorySpi> factories) {
        HashMap factorySpisByName = new HashMap();
        factories.forEach(factorySpi -> factorySpisByName.put(factorySpi.name(), factorySpi));
        return new NukleusFactory(Collections.unmodifiableMap(factorySpisByName));
    }

    private NukleusFactory(Map<String, NukleusFactorySpi> factorySpisByName) {
        this.factorySpisByName = factorySpisByName;
    }
}

