// TODO: license
package org.reaktivity.command.log.internal.types.control.auth;

import java.nio.charset.StandardCharsets;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.StringFW;

public final class UnresolveFW extends Flyweight {
  public static final int FIELD_OFFSET_CORRELATION_ID = 0;

  private static final int FIELD_SIZE_CORRELATION_ID = BitUtil.SIZE_OF_LONG;

  public static final int FIELD_OFFSET_NUKLEUS = FIELD_OFFSET_CORRELATION_ID + FIELD_SIZE_CORRELATION_ID;

  public static final int FIELD_OFFSET_AUTHORIZATION = 0;

  private static final int FIELD_SIZE_AUTHORIZATION = BitUtil.SIZE_OF_LONG;

  public static final int TYPE_ID = 0x00000012;

  private final StringFW nukleusRO = new StringFW();

  public long correlationId() {
    return buffer().getLong(offset() + FIELD_OFFSET_CORRELATION_ID);
  }

  public StringFW nukleus() {
    return nukleusRO;
  }

  public long authorization() {
    return buffer().getLong(nukleusRO.limit() + FIELD_OFFSET_AUTHORIZATION);
  }

  public int typeId() {
    return TYPE_ID;
  }

  @Override
  public UnresolveFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    nukleusRO.wrap(buffer, offset + FIELD_OFFSET_NUKLEUS, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public UnresolveFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == nukleusRO.tryWrap(buffer, offset + FIELD_OFFSET_NUKLEUS, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return nukleusRO.limit() + FIELD_OFFSET_AUTHORIZATION + FIELD_SIZE_AUTHORIZATION;
  }

  @Override
  public String toString() {
    return String.format("UNRESOLVE [correlationId=%d, nukleus=%s, authorization=%d]", correlationId(), nukleusRO.asString(), authorization());
  }

  public static final class Builder extends Flyweight.Builder<UnresolveFW> {
    private static final int INDEX_CORRELATION_ID = 0;

    private static final int INDEX_NUKLEUS = 1;

    private static final int INDEX_AUTHORIZATION = 2;

    private static final int FIELD_COUNT = 3;

    private final StringFW.Builder nukleusRW = new StringFW.Builder();

    private int lastFieldSet = -1;

    public Builder() {
      super(new UnresolveFW());
    }

    public Builder correlationId(long value) {
      assert lastFieldSet == INDEX_CORRELATION_ID - 1;
      int newLimit = limit() + FIELD_SIZE_CORRELATION_ID;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_CORRELATION_ID;
      limit(newLimit);
      return this;
    }

    private StringFW.Builder nukleus() {
      assert lastFieldSet == INDEX_NUKLEUS - 1;
      return nukleusRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder nukleus(String value) {
      StringFW.Builder nukleusRW = nukleus();
      nukleusRW.set(value, StandardCharsets.UTF_8);
      lastFieldSet = INDEX_NUKLEUS;
      limit(nukleusRW.build().limit());
      return this;
    }

    public Builder nukleus(StringFW value) {
      StringFW.Builder nukleusRW = nukleus();
      nukleusRW.set(value);
      lastFieldSet = INDEX_NUKLEUS;
      limit(nukleusRW.build().limit());
      return this;
    }

    public Builder nukleus(DirectBuffer buffer, int offset, int length) {
      StringFW.Builder nukleusRW = nukleus();
      nukleusRW.set(buffer, offset, length);
      lastFieldSet = INDEX_NUKLEUS;
      limit(nukleusRW.build().limit());
      return this;
    }

    public Builder authorization(long value) {
      assert lastFieldSet == INDEX_AUTHORIZATION - 1;
      int newLimit = limit() + FIELD_SIZE_AUTHORIZATION;
      checkLimit(newLimit, maxLimit());
      buffer().putLong(limit(), value);
      lastFieldSet = INDEX_AUTHORIZATION;
      limit(newLimit);
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public UnresolveFW build() {
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
