// TODO: license
package org.reaktivity.command.log.internal.types.state;

import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.OctetsFW;

public final class RouteEntryFW extends Flyweight {
  public static final int FIELD_OFFSET_ROUTE_SIZE = 0;

  private static final int FIELD_SIZE_ROUTE_SIZE = BitUtil.SIZE_OF_INT;

  public static final int FIELD_OFFSET_ROUTE = FIELD_OFFSET_ROUTE_SIZE + FIELD_SIZE_ROUTE_SIZE;

  private final OctetsFW routeRO = new OctetsFW();

  public long routeSize() {
    return (long)(buffer().getInt(offset() + FIELD_OFFSET_ROUTE_SIZE) & 0xFFFF_FFFFL);
  }

  public OctetsFW route() {
    return routeRO;
  }

  @Override
  public RouteEntryFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    routeRO.wrap(buffer, offset + FIELD_OFFSET_ROUTE, offset + FIELD_OFFSET_ROUTE + (int) routeSize());
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public RouteEntryFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    int limit;
    limit = offset + FIELD_OFFSET_ROUTE + (int) routeSize();
    if (limit > maxLimit || null == routeRO.tryWrap(buffer, offset + FIELD_OFFSET_ROUTE, limit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return routeRO.limit();
  }

  @Override
  public String toString() {
    return String.format("ROUTE_ENTRY [routeSize=%d, route=%s]", routeSize(), route());
  }

  public static final class Builder extends Flyweight.Builder<RouteEntryFW> {
    private static final long DEFAULT_ROUTE_SIZE = 0;

    private static final int INDEX_ROUTE = 0;

    private static final int FIELD_COUNT = 1;

    private int dynamicOffsetRouteSize;

    private final OctetsFW.Builder routeRW = new OctetsFW.Builder();

    private int lastFieldSet = -1;

    public Builder() {
      super(new RouteEntryFW());
    }

    private Builder routeSize(long value) {
      if (value < 0) {
        throw new IllegalArgumentException(String.format("Value %d too low for field \"routeSize\"", value));
      }
      if (value > 0xFFFFFFFFL) {
        throw new IllegalArgumentException(String.format("Value %d too high for field \"routeSize\"", value));
      }
      int newLimit = limit() + FIELD_SIZE_ROUTE_SIZE;
      checkLimit(newLimit, maxLimit());
      buffer().putInt(limit(), (int)(value & 0xFFFF_FFFFL));
      dynamicOffsetRouteSize = limit();
      limit(newLimit);
      return this;
    }

    private OctetsFW.Builder route() {
      routeSize(DEFAULT_ROUTE_SIZE);
      assert lastFieldSet == INDEX_ROUTE - 1;
      return routeRW.wrap(buffer(), limit(), maxLimit());
    }

    public Builder route(OctetsFW value) {
      int size$;
      int newLimit;
      OctetsFW.Builder routeRW = route();
      if (value == null) {
        throw new IllegalArgumentException("value cannot be null for field \"route\" that does not default to null");
      }
      routeRW.set(value);
      newLimit = routeRW.build().limit();
      size$ = newLimit - limit();
      limit(dynamicOffsetRouteSize);
      routeSize(size$);
      limit(newLimit);
      lastFieldSet = INDEX_ROUTE;
      return this;
    }

    public Builder route(Consumer<OctetsFW.Builder> mutator) {
      OctetsFW.Builder routeRW = route();
      mutator.accept(routeRW);
      int newLimit = routeRW.build().limit();
      int size$ = newLimit - limit();
      limit(dynamicOffsetRouteSize);
      routeSize(size$);
      limit(newLimit);
      lastFieldSet = INDEX_ROUTE;
      return this;
    }

    public Builder route(DirectBuffer buffer, int offset, int length) {
      OctetsFW.Builder routeRW = route();
      routeRW.set(buffer, offset, length);
      int newLimit = routeRW.build().limit();
      int size$ = newLimit - limit();
      limit(dynamicOffsetRouteSize);
      routeSize(size$);
      limit(newLimit);
      lastFieldSet = INDEX_ROUTE;
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      dynamicOffsetRouteSize = -1;
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public RouteEntryFW build() {
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
