// TODO: license
package org.reaktivity.command.log.internal.types.state;

import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.ListFW;

public final class RouteTableFW extends Flyweight {
  public static final int FIELD_OFFSET_WRITE_LOCK_ACQUIRES = 0;

  private static final int FIELD_SIZE_WRITE_LOCK_ACQUIRES = BitUtil.SIZE_OF_INT;

  public static final int FIELD_OFFSET_WRITE_LOCK_RELEASES = FIELD_OFFSET_WRITE_LOCK_ACQUIRES + FIELD_SIZE_WRITE_LOCK_ACQUIRES;

  private static final int FIELD_SIZE_WRITE_LOCK_RELEASES = BitUtil.SIZE_OF_INT;

  public static final int FIELD_OFFSET_ROUTE_ENTRIES = FIELD_OFFSET_WRITE_LOCK_RELEASES + FIELD_SIZE_WRITE_LOCK_RELEASES;

  private final ListFW<RouteEntryFW> routeEntriesRO = new ListFW<RouteEntryFW>(new RouteEntryFW());

  public int writeLockAcquires() {
    return buffer().getInt(offset() + FIELD_OFFSET_WRITE_LOCK_ACQUIRES);
  }

  public int writeLockReleases() {
    return buffer().getInt(offset() + FIELD_OFFSET_WRITE_LOCK_RELEASES);
  }

  public ListFW<RouteEntryFW> routeEntries() {
    return routeEntriesRO;
  }

  @Override
  public RouteTableFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    routeEntriesRO.wrap(buffer, offset + FIELD_OFFSET_ROUTE_ENTRIES, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public RouteTableFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == routeEntriesRO.tryWrap(buffer, offset + FIELD_OFFSET_ROUTE_ENTRIES, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return routeEntriesRO.limit();
  }

  @Override
  public String toString() {
    return String.format("ROUTE_TABLE [writeLockAcquires=%d, writeLockReleases=%d, routeEntries=%s]", writeLockAcquires(), writeLockReleases(), routeEntries());
  }

  public static final class Builder extends Flyweight.Builder<RouteTableFW> {
    private static final int INDEX_WRITE_LOCK_ACQUIRES = 0;

    private static final int INDEX_WRITE_LOCK_RELEASES = 1;

    private static final int INDEX_ROUTE_ENTRIES = 2;

    private static final int FIELD_COUNT = 3;

    private final ListFW.Builder<RouteEntryFW.Builder, RouteEntryFW> routeEntriesRW = new ListFW.Builder<RouteEntryFW.Builder, RouteEntryFW>(new RouteEntryFW.Builder(), new RouteEntryFW());

    private int lastFieldSet = -1;

    public Builder() {
      super(new RouteTableFW());
    }

    public Builder writeLockAcquires(int value) {
      assert lastFieldSet == INDEX_WRITE_LOCK_ACQUIRES - 1;
      int newLimit = limit() + FIELD_SIZE_WRITE_LOCK_ACQUIRES;
      checkLimit(newLimit, maxLimit());
      buffer().putInt(limit(), value);
      lastFieldSet = INDEX_WRITE_LOCK_ACQUIRES;
      limit(newLimit);
      return this;
    }

    public Builder writeLockReleases(int value) {
      assert lastFieldSet == INDEX_WRITE_LOCK_RELEASES - 1;
      int newLimit = limit() + FIELD_SIZE_WRITE_LOCK_RELEASES;
      checkLimit(newLimit, maxLimit());
      buffer().putInt(limit(), value);
      lastFieldSet = INDEX_WRITE_LOCK_RELEASES;
      limit(newLimit);
      return this;
    }

    public Builder routeEntries(Consumer<ListFW.Builder<RouteEntryFW.Builder, RouteEntryFW>> mutator) {
      assert lastFieldSet == INDEX_ROUTE_ENTRIES - 1;
      ListFW.Builder<RouteEntryFW.Builder, RouteEntryFW> routeEntriesRW = this.routeEntriesRW.wrap(buffer(), limit(), maxLimit());
      mutator.accept(routeEntriesRW);
      limit(routeEntriesRW.build().limit());
      lastFieldSet = INDEX_ROUTE_ENTRIES;
      return this;
    }

    public Builder routeEntriesItem(Consumer<RouteEntryFW.Builder> mutator) {
      assert lastFieldSet >= INDEX_ROUTE_ENTRIES - 1;
      if (lastFieldSet < INDEX_ROUTE_ENTRIES) {
        routeEntriesRW.wrap(buffer(), limit(), maxLimit());
      }
      routeEntriesRW.item(mutator);
      limit(routeEntriesRW.build().limit());
      lastFieldSet = INDEX_ROUTE_ENTRIES;
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public RouteTableFW build() {
      if (lastFieldSet < INDEX_ROUTE_ENTRIES) {
        routeEntries(b -> { });
      }
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
