// TODO: license
package org.reaktivity.command.log.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.command.log.internal.types.Flyweight;
import org.reaktivity.command.log.internal.types.TcpAddressFW;

public final class TcpBeginExFW extends Flyweight {
  public static final int FIELD_OFFSET_LOCAL_ADDRESS = 0;

  public static final int FIELD_OFFSET_LOCAL_PORT = 0;

  private static final int FIELD_SIZE_LOCAL_PORT = BitUtil.SIZE_OF_SHORT;

  public static final int FIELD_OFFSET_REMOTE_ADDRESS = FIELD_OFFSET_LOCAL_PORT + FIELD_SIZE_LOCAL_PORT;

  public static final int FIELD_OFFSET_REMOTE_PORT = 0;

  private static final int FIELD_SIZE_REMOTE_PORT = BitUtil.SIZE_OF_SHORT;

  private final TcpAddressFW localAddressRO = new TcpAddressFW();

  private final TcpAddressFW remoteAddressRO = new TcpAddressFW();

  public TcpAddressFW localAddress() {
    return localAddressRO;
  }

  public int localPort() {
    return (int)(buffer().getShort(localAddressRO.limit() + FIELD_OFFSET_LOCAL_PORT) & 0xFFFF);
  }

  public TcpAddressFW remoteAddress() {
    return remoteAddressRO;
  }

  public int remotePort() {
    return (int)(buffer().getShort(remoteAddressRO.limit() + FIELD_OFFSET_REMOTE_PORT) & 0xFFFF);
  }

  @Override
  public TcpBeginExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
    super.wrap(buffer, offset, maxLimit);
    localAddressRO.wrap(buffer, offset + FIELD_OFFSET_LOCAL_ADDRESS, maxLimit);
    remoteAddressRO.wrap(buffer, localAddressRO.limit() + FIELD_OFFSET_REMOTE_ADDRESS, maxLimit);
    checkLimit(limit(), maxLimit);
    return this;
  }

  @Override
  public TcpBeginExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
    if (null == super.tryWrap(buffer, offset, maxLimit)) {
      return null;
    }
    if (null == localAddressRO.tryWrap(buffer, offset + FIELD_OFFSET_LOCAL_ADDRESS, maxLimit)) {
      return null;
    }
    if (null == remoteAddressRO.tryWrap(buffer, localAddressRO.limit() + FIELD_OFFSET_REMOTE_ADDRESS, maxLimit)) {
      return null;
    }
    if (limit() > maxLimit) {
      return null;
    }
    return this;
  }

  @Override
  public int limit() {
    return remoteAddressRO.limit() + FIELD_OFFSET_REMOTE_PORT + FIELD_SIZE_REMOTE_PORT;
  }

  @Override
  public String toString() {
    return String.format("TCP_BEGIN_EX [localAddress=%s, localPort=%d, remoteAddress=%s, remotePort=%d]", localAddress(), localPort(), remoteAddress(), remotePort());
  }

  public static final class Builder extends Flyweight.Builder<TcpBeginExFW> {
    private static final int INDEX_LOCAL_ADDRESS = 0;

    private static final int INDEX_LOCAL_PORT = 1;

    private static final int INDEX_REMOTE_ADDRESS = 2;

    private static final int INDEX_REMOTE_PORT = 3;

    private static final int FIELD_COUNT = 4;

    private final TcpAddressFW.Builder localAddressRW = new TcpAddressFW.Builder();

    private final TcpAddressFW.Builder remoteAddressRW = new TcpAddressFW.Builder();

    private int lastFieldSet = -1;

    public Builder() {
      super(new TcpBeginExFW());
    }

    public Builder localAddress(Consumer<TcpAddressFW.Builder> mutator) {
      assert lastFieldSet == INDEX_LOCAL_ADDRESS - 1;
      TcpAddressFW.Builder localAddressRW = this.localAddressRW.wrap(buffer(), limit(), maxLimit());
      mutator.accept(localAddressRW);
      limit(localAddressRW.build().limit());
      lastFieldSet = INDEX_LOCAL_ADDRESS;
      return this;
    }

    public Builder localPort(int value) {
      if (value < 0) {
        throw new IllegalArgumentException(String.format("Value %d too low for field \"localPort\"", value));
      }
      if (value > 0xFFFF) {
        throw new IllegalArgumentException(String.format("Value %d too high for field \"localPort\"", value));
      }
      if (lastFieldSet < INDEX_LOCAL_ADDRESS) {
        localAddress(b -> { });
      }
      assert lastFieldSet == INDEX_LOCAL_PORT - 1;
      int newLimit = limit() + FIELD_SIZE_LOCAL_PORT;
      checkLimit(newLimit, maxLimit());
      buffer().putShort(limit(), (short)(value & 0xFFFF));
      lastFieldSet = INDEX_LOCAL_PORT;
      limit(newLimit);
      return this;
    }

    public Builder remoteAddress(Consumer<TcpAddressFW.Builder> mutator) {
      assert lastFieldSet == INDEX_REMOTE_ADDRESS - 1;
      TcpAddressFW.Builder remoteAddressRW = this.remoteAddressRW.wrap(buffer(), limit(), maxLimit());
      mutator.accept(remoteAddressRW);
      limit(remoteAddressRW.build().limit());
      lastFieldSet = INDEX_REMOTE_ADDRESS;
      return this;
    }

    public Builder remotePort(int value) {
      if (value < 0) {
        throw new IllegalArgumentException(String.format("Value %d too low for field \"remotePort\"", value));
      }
      if (value > 0xFFFF) {
        throw new IllegalArgumentException(String.format("Value %d too high for field \"remotePort\"", value));
      }
      if (lastFieldSet < INDEX_REMOTE_ADDRESS) {
        remoteAddress(b -> { });
      }
      assert lastFieldSet == INDEX_REMOTE_PORT - 1;
      int newLimit = limit() + FIELD_SIZE_REMOTE_PORT;
      checkLimit(newLimit, maxLimit());
      buffer().putShort(limit(), (short)(value & 0xFFFF));
      lastFieldSet = INDEX_REMOTE_PORT;
      limit(newLimit);
      return this;
    }

    @Override
    public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
      super.wrap(buffer, offset, maxLimit);
      lastFieldSet = -1;
      super.wrap(buffer, offset, maxLimit);
      limit(offset);
      return this;
    }

    @Override
    public Builder rewrap() {
      super.rewrap();
      return this;
    }

    @Override
    public TcpBeginExFW build() {
      assert lastFieldSet == FIELD_COUNT - 1;
      lastFieldSet = -1;
      return super.build();
    }
  }
}
