/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.LongSupplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.agrona.LangUtil;
import org.agrona.concurrent.status.CountersReader;
import org.reaktivity.command.log.internal.Logger;
import org.reaktivity.command.log.internal.layouts.MetricsLayout;
import org.reaktivity.reaktor.ReaktorConfiguration;

public final class LogCountersCommand
implements Runnable {
    private static final Pattern METRICS_PATTERN = Pattern.compile("metrics(\\d+)");
    private final Path directory;
    private final boolean verbose;
    private final boolean separator;
    private final Logger out;
    private final Map<Path, CountersReader> countersByPath;
    private final Map<String, LongSupplier> valuesByName;

    LogCountersCommand(ReaktorConfiguration config, Logger out, boolean verbose, boolean separator) {
        this.directory = config.directory();
        this.verbose = verbose;
        this.separator = separator;
        this.out = out;
        this.countersByPath = new LinkedHashMap<Path, CountersReader>();
        this.valuesByName = new LinkedHashMap<String, LongSupplier>();
    }

    private boolean isMetricsFile(Path path) {
        return path.getNameCount() - this.directory.getNameCount() == 1 && METRICS_PATTERN.matcher(path.getName(path.getNameCount() - 1).toString()).matches() && Files.isRegularFile(path, new LinkOption[0]);
    }

    private void onDiscovered(Path path) {
        if (this.verbose) {
            this.out.printf("Discovered: %s\n", path);
        }
    }

    private CountersReader supplyCounters(Path metricsPath) {
        return this.countersByPath.computeIfAbsent(metricsPath, this::newCountersReader);
    }

    private CountersReader newCountersReader(Path metricsPath) {
        MetricsLayout layout = new MetricsLayout.Builder().path(metricsPath).readonly(true).build();
        return new CountersReader(layout.labelsBuffer(), layout.valuesBuffer());
    }

    private void supplyValuesByName(CountersReader reader) {
        reader.forEach((id, name) -> this.valuesByName.merge((String)name, () -> reader.getCounterValue(id), (v1, v2) -> () -> v1.getAsLong() + v2.getAsLong()));
    }

    private void counters() {
        String valueFormat = this.separator ? ",d" : "d";
        this.valuesByName.forEach((name, value) -> this.out.printf("{\"name\": \"%s\",\"value\":%" + valueFormat + "}\n", name, value.getAsLong()));
        this.out.printf("\n", new Object[0]);
    }

    @Override
    public void run() {
        this.valuesByName.clear();
        try (Stream<Path> files = Files.walk(this.directory, 1, new FileVisitOption[0]);){
            files.filter(this::isMetricsFile).peek(this::onDiscovered).map(this::supplyCounters).forEach(this::supplyValuesByName);
            this.counters();
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }
}

