/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.agrona.LangUtil;
import org.reaktivity.command.log.internal.Logger;
import org.reaktivity.command.log.internal.layouts.StreamsLayout;
import org.reaktivity.command.log.internal.spy.RingBufferSpy;
import org.reaktivity.reaktor.ReaktorConfiguration;

public final class LogQueueDepthCommand
implements Runnable {
    private static final Pattern STREAMS_PATTERN = Pattern.compile("data\\d+");
    private final Path directory;
    private final boolean verbose;
    private final boolean separator;
    private final Logger out;
    private final Map<Path, StreamsLayout> layoutsByPath;

    public LogQueueDepthCommand(ReaktorConfiguration config, Logger out, boolean verbose, boolean separator) {
        this.directory = config.directory();
        this.out = out;
        this.verbose = verbose;
        this.separator = separator;
        this.layoutsByPath = new LinkedHashMap<Path, StreamsLayout>();
    }

    private boolean isStreamsFile(Path path) {
        return path.getNameCount() - this.directory.getNameCount() == 1 && STREAMS_PATTERN.matcher(path.getName(path.getNameCount() - 1).toString()).matches() && Files.isRegularFile(path, new LinkOption[0]);
    }

    private void onDiscovered(Path path) {
        if (this.verbose) {
            this.out.printf("Discovered: %s\n", path);
        }
    }

    private void displayQueueDepth(Path path) {
        StreamsLayout layout = this.layoutsByPath.computeIfAbsent(path, this::newStreamsLayout);
        String name = path.getFileName().toString();
        this.displayQueueDepth(name, layout.streamsBuffer());
    }

    private StreamsLayout newStreamsLayout(Path path) {
        return new StreamsLayout.Builder().path(path).readonly(true).build();
    }

    private void displayQueueDepth(String name, RingBufferSpy buffer) {
        long consumerAt = buffer.consumerPosition();
        long producerAt = buffer.producerPosition();
        String valueFormat = this.separator ? ",d" : "d";
        this.out.printf("{\"name\":\"%s\", \"head\":%" + valueFormat + ", \"tail\":%" + valueFormat + ", \"depth\":%" + valueFormat + "}\n", name, consumerAt, producerAt, producerAt - consumerAt);
    }

    @Override
    public void run() {
        try (Stream<Path> files = Files.walk(this.directory, 3, new FileVisitOption[0]);){
            files.filter(this::isStreamsFile).peek(this::onDiscovered).forEach(this::displayQueueDepth);
            this.out.printf("\n", new Object[0]);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }
}

