/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.command.log.internal;

import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.reaktivity.command.log.internal.LoggableRoutes;
import org.reaktivity.command.log.internal.Logger;
import org.reaktivity.command.log.internal.layouts.RoutesLayout;
import org.reaktivity.nukleus.Configuration;

public class LogRoutesCommand
implements Runnable {
    private static final long MAX_PARK_NS = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final long MIN_PARK_NS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final int MAX_YIELDS = 300;
    private static final int MAX_SPINS = 200;
    private final LoggableRoutes logger;
    private final Logger out;

    LogRoutesCommand(Configuration config, Logger out, boolean verbose) {
        Path directory = config.directory();
        RoutesLayout layout = new RoutesLayout.Builder().routesPath(directory.resolve("routes")).build();
        BackoffIdleStrategy idleStrategy = new BackoffIdleStrategy(200L, 300L, MIN_PARK_NS, MAX_PARK_NS);
        this.logger = new LoggableRoutes(layout, out, idleStrategy);
        this.out = out;
    }

    @Override
    public void run() {
        this.logger.process();
        this.out.printf("\n", new Object[0]);
    }
}

